/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.logger;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import junit.framework.TestCase;

public class ScheduleLogEntryTest
extends TestCase {
    private ScheduleLogEntry entry;
    private static final RosettaMsg MSG = RosettaMsg.AGENT_CONNECTED;

    protected void setUp() throws Exception {
        super.setUp();
        this.entry = new ScheduleLogEntry();
    }

    protected void tearDown() throws Exception {
        this.entry = null;
        super.tearDown();
    }

    public void testToString() {
        this.entry.setId(1234L);
        this.entry.setTimestampUTC(12345678L);
        String string = "Id->1234 TimestampUTC->12345678 Msg-><null>";
        String string2 = this.entry.toString();
        ScheduleLogEntryTest.assertEquals((String)string, (String)string2);
        this.entry.setMessage(RosettaMsg.AGENT_CONNECTED);
        string = "Id->1234 TimestampUTC->12345678 Msg->AGENT_CONNECTED";
        string2 = this.entry.toString();
        ScheduleLogEntryTest.assertEquals((String)string, (String)string2);
    }

    public void testConstructorMessageLongLongLong() {
        this.entry = new ScheduleLogEntry(MSG, 1234L, 5678L, 91011L);
        ScheduleLogEntryTest.assertEquals((long)1234L, (long)this.entry.getAgentID());
        ScheduleLogEntryTest.assertEquals((long)5678L, (long)this.entry.getJobID());
        ScheduleLogEntryTest.assertEquals((long)91011L, (long)this.entry.getJobHistoryID());
    }

    public void testSetId() {
        this.entry.setId(1234L);
        ScheduleLogEntryTest.assertEquals((long)1234L, (long)this.entry.getId());
    }

    public void testSetTimestampUTC() {
        this.entry.setTimestampUTC(12345678L);
        ScheduleLogEntryTest.assertEquals((long)12345678L, (long)this.entry.getTimestampUTC());
    }

    public void testSetMessageText() {
        this.entry.setMessage(MSG);
        ScheduleLogEntryTest.assertEquals((String)RosettaMsg.getMsgText(MSG, null), (String)this.entry.getMessageText());
    }
}

