/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.logger;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.util.ArrayTokenizer;
import java.io.Serializable;

public class ScheduleLogEntry
implements Serializable {
    public static final long NO_FOREIGN_KEY = 0L;
    private long id = 0L;
    private long timestampUTC = System.currentTimeMillis();
    private RosettaMsg message;
    private String[] messageVariables;
    private long agentID = 0L;
    private long jobID = 0L;
    private long jobHistoryID = 0L;
    private long jobSuiteID = 0L;
    private long jobSuiteHistoryID = 0L;

    public ScheduleLogEntry() {
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg) {
        this();
        this.message = rosettaMsg;
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String string) {
        this();
        this.message = rosettaMsg;
        String[] stringArray = new String[]{string};
        this.messageVariables = stringArray;
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String[] stringArray) {
        this(rosettaMsg);
        this.messageVariables = stringArray;
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, long l, long l2, long l3) {
        this(rosettaMsg, null, l, l2, l3);
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String[] stringArray, long l) {
        this(rosettaMsg, stringArray, l, 0L, 0L);
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String[] stringArray, long l, long l2) {
        this(rosettaMsg, stringArray, l, l2, 0L);
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String[] stringArray, long l, long l2, long l3) {
        this(rosettaMsg, stringArray);
        this.setAgentID(l);
        this.setJobID(l2);
        this.setJobHistoryID(l3);
    }

    public ScheduleLogEntry(RosettaMsg rosettaMsg, String[] stringArray, long l, long l2, long l3, long l4, long l5) {
        this(rosettaMsg, stringArray, l, l2, l3);
        this.jobSuiteID = l4;
        this.jobSuiteHistoryID = l5;
    }

    public RosettaMsg getMessage() {
        return this.message;
    }

    public String getMessageText() {
        return RosettaMsg.getMsgText(this.message, this.messageVariables);
    }

    public void setMessageText(String string) {
        throw new RuntimeException("Setting message text as a Text is not supported!");
    }

    public String getMessageVarsString() {
        return ArrayTokenizer.tokenateArray(this.messageVariables);
    }

    public void setMessageVarsString(String string) {
        throw new RuntimeException("Setting message variables as a String is not supported!");
    }

    public String getMessageID() {
        return this.message.toString();
    }

    public void setMessageID(String string) {
        throw new RuntimeException("Setting message ID is not supported!");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Id->" + this.id);
        stringBuffer.append(" TimestampUTC->" + this.timestampUTC);
        stringBuffer.append(" Msg->");
        if (this.message == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(this.message.toString());
        }
        return stringBuffer.toString();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getTimestampUTC() {
        return this.timestampUTC;
    }

    public void setTimestampUTC(long l) {
        this.timestampUTC = l;
    }

    public void setMessage(RosettaMsg rosettaMsg) {
        this.message = rosettaMsg;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public void setAgentID(long l) {
        this.agentID = l;
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public long getJobHistoryID() {
        return this.jobHistoryID;
    }

    public void setJobHistoryID(long l) {
        this.jobHistoryID = l;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
    }

    public long getJobSuiteHistoryID() {
        return this.jobSuiteHistoryID;
    }

    public void setJobSuiteHistoryID(long l) {
        this.jobSuiteHistoryID = l;
    }
}

