/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableValue;
import junit.framework.TestCase;

public class SkybotVariableCommandTest
extends TestCase {
    private SkybotVariableCommand cmd;

    protected void setUp() throws Exception {
        super.setUp();
        this.cmd = new SkybotVariableCommand();
    }

    protected void tearDown() throws Exception {
        this.cmd = null;
        super.tearDown();
    }

    public void testConstructorWithParameter() {
        SkybotVariableCommand skybotVariableCommand = new SkybotVariableCommand(12345L);
        SkybotVariableCommandTest.assertEquals((long)12345L, (long)skybotVariableCommand.getRequestTimestamp());
    }

    public void testGetLogDescriptionHasTheGoods() throws Exception {
        String[] stringArray = new String[]{"-m", "GET", "@@VAR2"};
        this.cmd.parseParameters(stringArray);
        String string = this.cmd.getLogDescription();
        SkybotVariableCommandTest.assertTrue((boolean)string.contains("Mode: GET"));
        SkybotVariableCommandTest.assertTrue((boolean)string.contains("Variables: \"@@VAR2\""));
    }

    public void testGetCommandName() {
        SkybotVariableCommandTest.assertEquals((String)"ROVAR", (String)this.cmd.getCommandName());
    }

    public void testValidateRequiresMode() {
        try {
            this.cmd.validate();
            SkybotVariableCommandTest.fail((String)"validate() didn't require mode");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testValidateRequiresAtLeastOneVariable() {
        this.cmd.setMode("SET");
        try {
            this.cmd.validate();
            SkybotVariableCommandTest.fail((String)"validate() didn't require any variables");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testValidatePassesValidData() throws Exception {
        String[] stringArray = new String[]{"-m", "GET", "@@VAR1"};
        this.cmd.parseParameters(stringArray);
        this.cmd.validate();
    }

    public void testValidatePassesValidDataForSet() throws Exception {
        String[] stringArray = new String[]{"-m", "SET", "@@VAR1=VALUE1"};
        this.cmd.parseParameters(stringArray);
        this.cmd.validate();
    }

    public void testValidateRequiresValidMode() throws Exception {
        try {
            this.cmd.validate();
            SkybotVariableCommandTest.fail((String)"validate() allowed invalid mode");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testParseParametersRequiresModeBeforeVariable() throws Exception {
        String[] stringArray = new String[]{"@@BOGUS"};
        try {
            this.cmd.parseParameters(stringArray);
            SkybotVariableCommandTest.fail((String)"parseParameters() accepted a variable with no mode set");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetModeDisallowsNull() {
        try {
            this.cmd.setMode(null);
            SkybotVariableCommandTest.fail((String)"setMode() allowed null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSetModeDisallowsBadValue() {
        try {
            this.cmd.setMode("BOGUS");
            SkybotVariableCommandTest.fail((String)"setMode() allowed bogus value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMode() {
        this.cmd.setMode("GET");
        SkybotVariableCommandTest.assertEquals((String)"GET", (String)this.cmd.getMode());
        SkybotVariableCommandTest.assertTrue((boolean)this.cmd.isGetMode());
        SkybotVariableCommandTest.assertFalse((boolean)this.cmd.isSetMode());
        this.cmd.setMode("SET");
        SkybotVariableCommandTest.assertEquals((String)"SET", (String)this.cmd.getMode());
        SkybotVariableCommandTest.assertFalse((boolean)this.cmd.isGetMode());
        SkybotVariableCommandTest.assertTrue((boolean)this.cmd.isSetMode());
    }

    public void testGetReservedCmdVars() {
        SkybotVariableValue skybotVariableValue = new SkybotVariableValue();
        this.cmd.setSkybotVariableValue(skybotVariableValue);
        SkybotVariableValue skybotVariableValue2 = this.cmd.getSkybotVariableValue();
        SkybotVariableCommandTest.assertEquals((Object)((Object)skybotVariableValue), (Object)((Object)skybotVariableValue2));
    }

    public void testParseHandlesSetWithMissingVariableName() throws Exception {
        String[] stringArray = new String[]{"-m", "SET", "=23"};
        try {
            this.cmd.parseParameters(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseHandlesZeroLengthStringParameter() {
        String[] stringArray = new String[]{"-m", "SET", ""};
        try {
            this.cmd.parseParameters(stringArray);
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testParseHandlesMissingModeParameter() throws Exception {
        String[] stringArray = new String[]{"-m"};
        try {
            this.cmd.parseParameters(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

