/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;

public class GetAgentStatusData
extends EnterpriseVersionedObject
implements XMLSerializable {
    private static final long serialVersionUID = 8964334441543332094L;
    public static final int ACTIVE_CON_RETCODE = 0;
    public static final int ACTIVE_NO_CON_RETCODE = 10;
    public static final int ENDING_RETCODE = 20;
    public static final int INACTIVE_RETCODE = 30;
    private int agentStatus = 30;
    private String enterpriseServerName = "";
    private String enterpriseServerAddress = "";

    public GetAgentStatusData() {
        this.addDoNotInvoke("getConnectionText");
    }

    public int getAgentStatus() {
        return this.agentStatus;
    }

    public void setAgentStatus(int n) {
        if (n != 0 && n != 10 && n != 20 && n != 30) {
            throw new IllegalArgumentException("Invalid agent status: " + n);
        }
        this.agentStatus = n;
    }

    public String getEnterpriseServerName() {
        return this.enterpriseServerName;
    }

    public void setEnterpriseServerName(String string) {
        this.enterpriseServerName = string != null ? string.trim() : null;
    }

    public String getEnterpriseServerAddress() {
        return this.enterpriseServerAddress;
    }

    public void setEnterpriseServerAddress(String string) {
        this.enterpriseServerAddress = string != null ? string.trim() : null;
    }

    public String getConnectionText() {
        String string = this.getEntServerDescription();
        String string2 = "Error obtaining information.  AgentStatus is invalid.";
        switch (this.agentStatus) {
            case 30: {
                string2 = "Agent is inactive and not connected to Enterprise Server " + string + ".";
                break;
            }
            case 10: {
                string2 = "Agent is active, but not connected to Enterprise Server " + string + ".";
                break;
            }
            case 0: {
                string2 = "Agent is active and connected to Enterprise Server " + string + ".";
                break;
            }
            case 20: {
                string2 = "Agent is active and connected to Enterprise Server " + string + ", but preparing to shut down.";
            }
        }
        return string2;
    }

    private String getEntServerDescription() {
        String string = this.enterpriseServerName;
        String string2 = this.enterpriseServerAddress;
        if (string != null && string.equals(string2)) {
            string2 = null;
        }
        String string3 = null;
        if (string != null && string.length() > 0) {
            string3 = string;
        }
        if (string2 != null && string2.length() > 0) {
            string3 = string3 == null ? string2 : string3 + " (" + string2 + ")";
        }
        if (string3 != null) {
            return string3;
        }
        return "<- Enterprise Server Name is N/A ->";
    }
}

