/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.cmdlineobj;

import com.helpsystems.enterprise.core.cmdlineobj.AgentJobInfo;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import junit.framework.TestCase;

public class AgentJobInfoTest
extends TestCase {
    private AgentJobInfo info;

    protected void setUp() throws Exception {
        super.setUp();
        this.info = new AgentJobInfo();
    }

    protected void tearDown() throws Exception {
        this.info = null;
        super.tearDown();
    }

    public void testGetStartTime() {
        this.info.setStartTime(12345L);
        AgentJobInfoTest.assertEquals((long)12345L, (long)this.info.getStartTime());
    }

    public void testIsTerminating() {
        this.info.setTerminating(false);
        AgentJobInfoTest.assertFalse((boolean)this.info.isTerminating());
        this.info.setTerminating(true);
        AgentJobInfoTest.assertTrue((boolean)this.info.isTerminating());
    }

    public void testGetScheduleJobName() {
        this.info.setScheduleJobName("SOMENAME");
        AgentJobInfoTest.assertEquals((String)"SOMENAME", (String)this.info.getScheduleJobName());
    }

    public void testGetJobUser() {
        this.info.setJobUser("SOMEUSER");
        AgentJobInfoTest.assertEquals((String)"SOMEUSER", (String)this.info.getJobUser());
    }

    public void testConstructorWithParms() {
        JobTimer jobTimer = new JobTimer();
        jobTimer.setWhenStarted(12345L);
        jobTimer.setTerminating(false);
        ScheduleJob scheduleJob = new ScheduleJob();
        scheduleJob.setName("JOB_NAME");
        ExecutableJob executableJob = new ExecutableJob();
        executableJob.setScheduleJob(scheduleJob);
        executableJob.setJobUser("JOB_USER");
        AgentJobInfo agentJobInfo = new AgentJobInfo(jobTimer, executableJob);
        AgentJobInfoTest.assertEquals((long)12345L, (long)agentJobInfo.getStartTime());
        AgentJobInfoTest.assertFalse((boolean)agentJobInfo.isTerminating());
        AgentJobInfoTest.assertEquals((String)"JOB_NAME", (String)agentJobInfo.getScheduleJobName());
        AgentJobInfoTest.assertEquals((String)"JOB_USER", (String)agentJobInfo.getJobUser());
    }
}

