/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import java.util.HashMap;
import java.util.Map;

public class SAPLanguageKeys {
    private static Map<String, SAPLanguageKey> keyMap = new HashMap<String, SAPLanguageKey>();
    private static Map<String, SAPLanguageKey> codeMap;

    public static String getISOCodeForKey(String string) {
        return keyMap.get(string).isoCode;
    }

    public static String getKeyForISOCode(String string) {
        return codeMap.get(string).key;
    }

    static {
        for (SAPLanguageKey sAPLanguageKey : SAPLanguageKey.values()) {
            keyMap.put(sAPLanguageKey.key, sAPLanguageKey);
        }
        codeMap = new HashMap<String, SAPLanguageKey>();
        for (SAPLanguageKey sAPLanguageKey : SAPLanguageKey.values()) {
            codeMap.put(sAPLanguageKey.isoCode, sAPLanguageKey);
        }
    }

    public static enum SAPLanguageKey {
        Chinese("1", "ZH"),
        Thai("2", "TH"),
        Korean("3", "KO"),
        Romanian("4", "RO"),
        Slovene("5", "SL"),
        Croation("6", "HR"),
        Arabic("A", "AR"),
        Hebrew("B", "HE"),
        Czech("C", "CS"),
        German("D", "DE"),
        English("E", "EN"),
        French("F", "FR"),
        Greek("G", "EL"),
        Hungarian("H", "HU"),
        Italian("I", "IT"),
        Japanese("J", "JA"),
        Danish("K", "DA"),
        Polish("L", "PL"),
        Chinese_trad("M", "ZF"),
        Dutch("N", "NL"),
        Norwegian("O", "NO"),
        Portuguese("P", "PT"),
        Slovakian("Q", "SK"),
        Russian("R", "RU"),
        Spanish("S", "ES"),
        Turkish("T", "TR"),
        Finnish("U", "FI"),
        Swedish("V", "SV"),
        Bulgarian("W", "BG");

        private String key;
        private String isoCode;

        private SAPLanguageKey(String string2, String string3) {
            this.key = string2;
            this.isoCode = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getISOCode() {
            return this.isoCode;
        }
    }
}

