/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public enum SAPJobStatus implements PersistableEnum<String>
{
    ACTIVE("R"),
    INTERCEPTED("I"),
    READY("Y"),
    SCHEDULED("P"),
    RELEASED("S"),
    CANCELLED("A"),
    FINISHED("F"),
    DOES_NOT_EXIST("N"),
    SUSPENDED("Z"),
    UNKNOWN("");

    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, SAPJobStatus> map;

    private SAPJobStatus(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static SAPJobStatus persistanceCodeToEnum(String string) {
        SAPJobStatus sAPJobStatus = map.get(string);
        if (sAPJobStatus == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return sAPJobStatus;
    }

    public boolean isTerminal() {
        return this.equals(CANCELLED) || this.equals(FINISHED) || this.equals(DOES_NOT_EXIST);
    }

    public boolean isDeleted() {
        return this.equals(DOES_NOT_EXIST) || this.equals(UNKNOWN);
    }

    public boolean isIndicativeOfNewData() {
        return this.equals(ACTIVE) || this.equals(FINISHED) || this.equals(CANCELLED) || this.equals(RELEASED);
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])SAPJobStatus.values());
    }
}

