/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.sap.SAPField;
import com.helpsystems.enterprise.core.busobj.sap.SAPParameters;
import java.math.BigDecimal;
import java.security.InvalidParameterException;

public class SAPEventSelectParameters
extends SAPParameters {
    private static final long serialVersionUID = -1L;
    public static final String STRUCTURE_NAME = "BTCEVTHISTORY";
    public static final String FUNCTION_NAME = "BAPI_XBP_BTC_EVTHISTORY_GET";
    public static final String NEW = "N";
    public static final String CONFIRMED = "C";
    private String userName;
    private BigDecimal fromDate;
    private BigDecimal toDate;
    private String eventID;
    private String selectState;
    private String actionCode;
    private String params;

    public SAPEventSelectParameters(String string) {
        this.setField(EventSelectField.USERNAME, string);
    }

    public SAPEventSelectParameters(String string, String string2) {
        this.setField(EventSelectField.USERNAME, string);
        this.setField(EventSelectField.EVENTID, string2);
    }

    public SAPEventSelectParameters() {
    }

    public void setField(EventSelectField eventSelectField, Object object) {
        switch (eventSelectField) {
            case USERNAME: {
                this.setUserName(this.getStringFromValue(object, eventSelectField));
                break;
            }
            case FROMDATEUTC: {
                this.setFromDateUTC(this.getBigDecimalFromValue(object, eventSelectField));
                break;
            }
            case TODATEUTC: {
                this.setToDateUTC(this.getBigDecimalFromValue(object, eventSelectField));
                break;
            }
            case EVENTID: {
                this.setEventID(this.getStringFromValue(object, eventSelectField));
                break;
            }
            case SELECTSTATE: {
                this.setSelectState(this.getStringFromValue(object, eventSelectField));
                break;
            }
            case ACTIONCODE: {
                this.setActionCode(this.getStringFromValue(object, eventSelectField));
                break;
            }
            case PARAMS: {
                this.setParams(this.getStringFromValue(object, eventSelectField));
                break;
            }
            default: {
                throw new InvalidParameterException("The field " + eventSelectField + " is not a valid SAP Event Selected Parameter.");
            }
        }
    }

    @Override
    public String getBooleanFieldAsString(SAPField sAPField) {
        throw new IllegalArgumentException("The SAP structure BTCEVTHISTORY does not contain any boolean fields.");
    }

    @Override
    public Object getField(SAPField sAPField) {
        EventSelectField eventSelectField = (EventSelectField)sAPField;
        switch (eventSelectField) {
            case USERNAME: {
                return this.getUserName();
            }
            case FROMDATEUTC: {
                return this.getFromDateUTC();
            }
            case TODATEUTC: {
                return this.getToDateUTC();
            }
            case EVENTID: {
                return this.getEventID();
            }
            case SELECTSTATE: {
                return this.getSelectState();
            }
            case ACTIONCODE: {
                return this.getActionCode();
            }
            case PARAMS: {
                return this.getParams();
            }
        }
        return null;
    }

    private String getUserName() {
        return this.userName;
    }

    private void setUserName(String string) {
        this.userName = string;
    }

    private void setFromDateUTC(BigDecimal bigDecimal) {
        this.fromDate = bigDecimal;
    }

    private BigDecimal getFromDateUTC() {
        return this.fromDate;
    }

    private void setToDateUTC(BigDecimal bigDecimal) {
        this.toDate = bigDecimal;
    }

    private BigDecimal getToDateUTC() {
        return this.toDate;
    }

    private void setEventID(String string) {
        this.eventID = string;
    }

    private String getEventID() {
        return this.eventID;
    }

    private void setSelectState(String string) {
        this.selectState = string;
    }

    private String getSelectState() {
        return this.selectState;
    }

    private void setActionCode(String string) {
        this.actionCode = string;
    }

    private String getActionCode() {
        return this.actionCode;
    }

    private void setParams(String string) {
        this.params = string;
    }

    private String getParams() {
        return this.params;
    }

    public static enum EventSelectField implements SAPField
    {
        USERNAME(SAPField.ParameterType.STRING, 1, 16, ""),
        FROMDATEUTC(SAPField.ParameterType.BCD, 0, 15, ""),
        TODATEUTC(SAPField.ParameterType.BCD, 0, 15, ""),
        EVENTID(SAPField.ParameterType.STRING, 0, 32, ""),
        SELECTSTATE(SAPField.ParameterType.STRING, 0, 1, "N"),
        ACTIONCODE(SAPField.ParameterType.STRING, 0, 1, "C"),
        PARAMS(SAPField.ParameterType.STRING, 0, 64, "");

        private SAPField.ParameterType parameterType;
        private int maxValue;
        private int minValue;
        private Object defaultValue;

        private EventSelectField(SAPField.ParameterType parameterType, int n2, int n3, Object object) {
            this.parameterType = parameterType;
            this.minValue = n2;
            this.maxValue = n3;
            this.defaultValue = object;
        }

        @Override
        public SAPField.ParameterType getParameterType() {
            return this.parameterType;
        }

        @Override
        public int getMinValue() {
            return this.minValue;
        }

        @Override
        public int getMaxValue() {
            return this.maxValue;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return "Get SAP Event History";
        }
    }
}

