/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.DateObjectCache;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceDays;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceType;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SpecialInstance {
    private static final Logger logger = Logger.getLogger(SpecialInstance.class);
    private long id;
    private long parentID;
    private ParentType parentType;
    private String name;
    private String description;
    private SpecialInstanceType type;
    private long dateObjectID;
    private int endTime;
    private int startTime;
    private CalendarObject.DayType dayType;
    private SpecialInstanceDays[] specialInstanceDays;

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getParentId() {
        return this.parentID;
    }

    public void setParentID(long l) {
        this.parentID = l;
    }

    public ParentType getParentType() {
        return this.parentType;
    }

    public void setParentType(ParentType parentType) {
        this.parentType = parentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public SpecialInstanceType getType() {
        return this.type;
    }

    public void setType(SpecialInstanceType specialInstanceType) {
        this.type = specialInstanceType;
    }

    public SpecialInstanceDays[] getSpecialInstanceDays() {
        return this.specialInstanceDays;
    }

    public void setSpecialInstanceDays(SpecialInstanceDays[] specialInstanceDaysArray) {
        this.specialInstanceDays = specialInstanceDaysArray;
    }

    public long getDateObjectID() {
        return this.dateObjectID;
    }

    public void setDateObjectID(long l) {
        this.dateObjectID = l;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    public boolean isAcceptedTimestamp(Calendar calendar, long l, CalendarObject calendarObject) {
        return this.isAcceptedTimestamp(calendar, l, calendarObject, null);
    }

    public boolean isAcceptedTimestamp(Calendar calendar, long l, CalendarObject calendarObject, DateObjectCache dateObjectCache) {
        switch (this.type) {
            case DAY_OF_WEEK: {
                if (this.specialInstanceDays == null || this.specialInstanceDays.length == 0) {
                    return true;
                }
                for (int i = 0; i < this.specialInstanceDays.length; ++i) {
                    if (this.specialInstanceDays[i].isTimeAccepted(calendar, l, calendarObject)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Special instance timestamp (" + TimeHelper.formatDate(calendar) + ") accepted by: " + this.name + "." + this.specialInstanceDays[i].getId()));
                        }
                        return true;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Special instance timestamp (" + TimeHelper.formatDate(calendar) + ") was NOT accepted by: " + this.name + "." + this.specialInstanceDays[i].getId()));
                }
                return false;
            }
            case DATE_OBJECT: {
                boolean bl;
                boolean bl2;
                DateObject dateObject = null;
                try {
                    if (dateObjectCache != null) {
                        dateObject = dateObjectCache.getDateObject(this.dateObjectID);
                    } else {
                        DateObjectDM dateObjectDM = (DateObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.DateObjectDM");
                        dateObject = dateObjectDM.get(this.dateObjectID);
                    }
                }
                catch (NoDataException noDataException) {
                    logger.error((Object)("Date List not found for ID: " + this.dateObjectID), (Throwable)noDataException);
                    return false;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)("Error loading Date List for ID: " + this.dateObjectID), (Throwable)resourceUnavailableException);
                    return false;
                }
                int n = this.getYYYYMMDD(calendar);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Checking Date List Special Instance - YYYYMMDD = " + n + " startTime = " + this.startTime + " endTime = " + this.endTime + " actual = " + ScheduleLogger.formatTimeStampTZ(calendar)));
                }
                if (dateObject.contains(n) && (bl2 = TimeHelper.isWithinRange(calendar, l, n, this.startTime, this.endTime))) {
                    return true;
                }
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.setTimeInMillis(calendar.getTimeInMillis());
                calendar2.add(5, -1);
                n = this.getYYYYMMDD(calendar2);
                return dateObject.contains(n) && (bl = TimeHelper.isWithinRange(calendar, l, n, this.startTime, this.endTime));
            }
            case DAY_OF_PERIOD: {
                int n = this.specialInstanceDays.length;
                String string = TimeHelper.formatDate(calendar);
                if (this.specialInstanceDays == null || n == 0) {
                    return true;
                }
                for (int i = 0; i < n; ++i) {
                    StringBuilder stringBuilder;
                    SpecialInstanceDays specialInstanceDays = this.specialInstanceDays[i];
                    long l2 = specialInstanceDays.getId();
                    if (specialInstanceDays.isDayOfPeriodTimeAccepted(calendar, calendarObject, this.parentID, this.parentType, this.dayType)) {
                        if (logger.isTraceEnabled()) {
                            stringBuilder = new StringBuilder();
                            stringBuilder.append("Special instance timestamp (");
                            stringBuilder.append(string);
                            stringBuilder.append(") accepted by: ");
                            stringBuilder.append(this.name);
                            stringBuilder.append(". ");
                            stringBuilder.append(l2);
                            logger.trace((Object)stringBuilder.toString());
                        }
                        return true;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Special instance timestamp (");
                    stringBuilder.append(string);
                    stringBuilder.append(") was NOT accepted by: ");
                    stringBuilder.append(this.name);
                    stringBuilder.append(". ");
                    stringBuilder.append(l2);
                    logger.trace((Object)stringBuilder.toString());
                }
                return false;
            }
        }
        throw new IllegalStateException("Invalid Special Instance Type: " + this.type);
    }

    private int getYYYYMMDD(Calendar calendar) {
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID(" + this.id + ")");
        stringBuffer.append(".PARENT_ID(" + this.parentID + ")");
        stringBuffer.append(".PARENT_TYPE(" + this.parentType + ")");
        stringBuffer.append(".NAME(" + this.name + ")");
        stringBuffer.append(".DESCRIPTION(" + this.description + ")");
        stringBuffer.append(".TYPE(" + this.type + ")");
        stringBuffer.append(".DATE_OBJ_ID(" + this.dateObjectID + ")");
        stringBuffer.append(".START_TIME(" + this.startTime + ")");
        stringBuffer.append(".END_TIME(" + this.endTime + ")");
        if (this.specialInstanceDays != null && this.specialInstanceDays.length > 0) {
            for (int i = 0; i < this.specialInstanceDays.length; ++i) {
                stringBuffer.append(".DAYS_" + i + "(" + this.specialInstanceDays[i].toString() + ")");
            }
        }
        return stringBuffer.toString();
    }

    public CalendarObject.DayType getDayType() {
        return this.dayType;
    }

    public void setDayType(CalendarObject.DayType dayType) {
        this.dayType = dayType;
    }
}

