/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.SkybotVariableResolveException;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import junit.framework.TestCase;

public class SkybotVariableTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetName() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        String string = "newname";
        skybotVariable.setName(string);
        SkybotVariableTest.assertEquals((String)string, (String)skybotVariable.getName());
    }

    public void testSetValue() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 0, CalendarObject.DayType.ALL_DAYS, 1);
        String string = "newvalue";
        try {
            skybotVariable.setValue(string);
            SkybotVariableTest.fail((String)"Value should not be allowed for non-static variable.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        skybotVariable = new SkybotVariable(0L, "", "", true);
        skybotVariable.setValue(string);
    }

    public void testSetValueEmpty() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "oldvalue", true);
        String string = "";
        skybotVariable.setValue(string);
    }

    public void testSetValueBlank() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        String string = "";
        skybotVariable.setValue(string);
    }

    public void testSetValueNull() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        String string = null;
        try {
            skybotVariable.setValue(string);
            SkybotVariableTest.fail((String)"Value should not be allowed to be set null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetValueStatic() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        String string = "newvalue";
        skybotVariable.setValue(string);
        SkybotVariableTest.assertEquals((String)string, (String)skybotVariable.getValue());
    }

    public void testGetValueCannotGetStaticValueFromDynamicVariable() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 0, CalendarObject.DayType.ALL_DAYS, 1);
        try {
            skybotVariable.getValue();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetValueCannotGetDynamicValueFromStaticVariable() {
        Calendar calendar = Calendar.getInstance();
        CalendarObject calendarObject = new CalendarObject();
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        try {
            skybotVariable.getValue(calendarObject, calendar);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (SkybotVariableResolveException skybotVariableResolveException) {
            SkybotVariableTest.fail((String)skybotVariableResolveException.getLocalizedMessage());
        }
    }

    public void testGetValueDynamicDate() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 27);
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 0, CalendarObject.DayType.ALL_DAYS, 1);
        CalendarObject calendarObject = new CalendarObject();
        SkybotVariableTest.assertEquals((String)"2010-06-27", (String)skybotVariable.getValue(calendarObject, calendar));
    }

    public void testGetValueDynamicDateIncrement() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 27);
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 5, CalendarObject.DayType.ALL_DAYS, 1);
        SkybotVariableTest.assertEquals((String)"2010-07-02", (String)skybotVariable.getValue(new CalendarObject(), calendar));
    }

    public void testGetValueDynamicDateDecrement() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 27);
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -2, CalendarObject.DayType.ALL_DAYS, 1);
        SkybotVariableTest.assertEquals((String)"2010-06-25", (String)skybotVariable.getValue(new CalendarObject(), calendar));
    }

    public void testGetValueDynamicDateFormats() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 21);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 5, CalendarObject.DayType.WORKDAYS, 1);
        SkybotVariableTest.assertEquals((String)"2010-06-28", (String)skybotVariable.getValue(calendarObject, calendar));
        String[] stringArray = new String[]{"2010-06-28", "06/28/2010", "28.06.2010", "10628", "100628", "062810", "280610", "06282010", "28062010", "20100628"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : SkybotVariable.codedFormatString.keySet()) {
            skybotVariable.setDateFormat(n);
            try {
                arrayList.add(skybotVariable.getValue(calendarObject, calendar));
            }
            catch (Exception exception) {
                SkybotVariableTest.fail((String)("Could not perform date formatting for format " + SkybotVariable.codedFormatString.get(n)));
            }
        }
        Object[] objectArray = arrayList.toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            SkybotVariableTest.assertEquals((String)("String mismatch for format " + SkybotVariable.codedFormatString.get(i + 1)), (String)stringArray[i], (String)((String)objectArray[i]));
        }
    }

    public void testGetValueDynamicDateIncrementWD() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 21);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 5, CalendarObject.DayType.WORKDAYS, 1);
        SkybotVariableTest.assertEquals((String)"2010-06-28", (String)skybotVariable.getValue(calendarObject, calendar));
    }

    public void testGetValueDynamicDateDecrementWD() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 21);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -5, CalendarObject.DayType.WORKDAYS, 6);
        SkybotVariableTest.assertEquals((String)"061410", (String)skybotVariable.getValue(calendarObject, calendar));
    }

    public void testGetValueDynamicDateDecrementWDNoWD() {
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.allOf(CalendarObject.DayOfWeek.class));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -1, CalendarObject.DayType.WORKDAYS, 2);
        try {
            skybotVariable.getValue(calendarObject, Calendar.getInstance());
            SkybotVariableTest.fail((String)"Failed to throw exception for impossible dynamic date decrement");
        }
        catch (SkybotVariableResolveException skybotVariableResolveException) {
            // empty catch block
        }
    }

    public void testGetValueDynamicDateIncrementNWD() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 20);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), 2, CalendarObject.DayType.NON_WORKDAYS, 3);
        SkybotVariableTest.assertEquals((String)"27.06.2010", (String)skybotVariable.getValue(calendarObject, calendar));
    }

    public void testGetValueDynamicDateDecrementNWD() throws SkybotVariableResolveException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2010, 5, 27);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -4, CalendarObject.DayType.NON_WORKDAYS, 3);
        SkybotVariableTest.assertEquals((String)"13.06.2010", (String)skybotVariable.getValue(calendarObject, calendar));
    }

    public void testGetValueDynamicDateDecrementNWDNoNWD() {
        CalendarObject calendarObject = new CalendarObject();
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -1, CalendarObject.DayType.NON_WORKDAYS, 1);
        try {
            skybotVariable.getValue(calendarObject, Calendar.getInstance());
        }
        catch (SkybotVariableResolveException skybotVariableResolveException) {
            // empty catch block
        }
    }

    public void testSetOffsetDays() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -4, CalendarObject.DayType.NON_WORKDAYS, 3);
        SkybotVariableTest.assertEquals((int)-4, (int)skybotVariable.getOffsetDays());
        skybotVariable.setOffsetDays(3);
        SkybotVariableTest.assertEquals((int)3, (int)skybotVariable.getOffsetDays());
    }

    public void testCannotSetOffsetDaysForStatic() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        try {
            skybotVariable.setOffsetDays(2);
            SkybotVariableTest.fail((String)"Allowed setOffsetDays() for static SkybotVariable");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetOffsetType() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -4, CalendarObject.DayType.NON_WORKDAYS, 3);
        SkybotVariableTest.assertEquals((Object)CalendarObject.DayType.NON_WORKDAYS, (Object)skybotVariable.getOffsetDayType());
        skybotVariable.setOffsetDayType(CalendarObject.DayType.WORKDAYS);
        SkybotVariableTest.assertEquals((Object)CalendarObject.DayType.WORKDAYS, (Object)skybotVariable.getOffsetDayType());
    }

    public void testCannotSetOffsetTypeForStatic() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        try {
            skybotVariable.setOffsetDayType(CalendarObject.DayType.WORKDAYS);
            SkybotVariableTest.fail((String)"Allowed setOffsetDayType() for static SkybotVariable");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetDateFormat() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -4, CalendarObject.DayType.NON_WORKDAYS, 3);
        SkybotVariableTest.assertEquals((int)3, (int)skybotVariable.getDateFormat());
        skybotVariable.setDateFormat(7);
        SkybotVariableTest.assertEquals((int)7, (int)skybotVariable.getDateFormat());
        try {
            skybotVariable.setDateFormat(0);
            SkybotVariableTest.fail((String)"Date format should not be allowed to be null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCannotSetDateFormatForStatic() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        try {
            skybotVariable.setDateFormat(1);
            SkybotVariableTest.fail((String)"Allowed setDateFormat() for static SkybotVariable");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetCalendarObject() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", new Long(0L), -4, CalendarObject.DayType.NON_WORKDAYS, 3);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setID(1234L);
        skybotVariable.setCalendarObjectID(calendarObject.getID());
        SkybotVariableTest.assertEquals((Object)new Long(calendarObject.getID()), (Object)skybotVariable.getCalendarObjectID());
    }

    public void testCannotSetCalendarObjectForStatic() {
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setID(1234L);
        try {
            skybotVariable.setCalendarObjectID(calendarObject.getID());
            SkybotVariableTest.fail((String)"Allowed setCalendarObjectID() for static SkybotVariable");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDynamicNullName() {
        try {
            new SkybotVariable(0L, null, null, 0, null, 0);
            SkybotVariableTest.fail((String)"name should not be allowed to be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDynamicNullCalendarObject() {
        try {
            new SkybotVariable(0L, "", null, 0, null, 0);
            SkybotVariableTest.fail((String)"calendarObject should not be allowed to be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDynamicNullOffsetDayType() {
        try {
            new SkybotVariable(0L, "", new Long(0L), 0, null, 0);
            SkybotVariableTest.fail((String)"offsetDayType should not be allowed to be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDynamicNullDateFormat() {
        try {
            new SkybotVariable(0L, "", new Long(0L), 0, CalendarObject.DayType.ALL_DAYS, 0);
            SkybotVariableTest.fail((String)"dateFormat should not be allowed to be null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetOid() {
        long l = 884318283L;
        SkybotVariable skybotVariable = new SkybotVariable(0L, "", "", true);
        skybotVariable.setOid(l);
        SkybotVariableTest.assertEquals((long)l, (long)skybotVariable.getOid());
    }

    public void testResetOid() {
        long l = 884318283L;
        SkybotVariable skybotVariable = new SkybotVariable(l, "", "", true);
        skybotVariable.setOid(l + 1L);
        SkybotVariableTest.assertEquals((long)(l + 1L), (long)skybotVariable.getOid());
    }

    public void testSetAllowChangeByAPI() {
        long l = 12345L;
        String string = "var1";
        String string2 = "asdf";
        boolean bl = true;
        SkybotVariable skybotVariable = new SkybotVariable(l, string, string2, bl);
        SkybotVariableTest.assertTrue((boolean)skybotVariable.isAllowChangeByAPI());
        skybotVariable.setAllowChangeByAPI(false);
        SkybotVariableTest.assertFalse((boolean)skybotVariable.isAllowChangeByAPI());
        skybotVariable = new SkybotVariable(l, string, new Long(12345L), 3, CalendarObject.DayType.ALL_DAYS, 4);
        try {
            skybotVariable.setAllowChangeByAPI(true);
            SkybotVariableTest.fail((String)"Should not allow change by API if not static variable type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

