/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.RBECONFIGData;
import junit.framework.TestCase;

public class RBECONFIGDataTest
extends TestCase {
    private RBECONFIGData data;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new RBECONFIGData();
    }

    protected void tearDown() throws Exception {
        this.data = null;
        super.tearDown();
    }

    public void testConstructorSingleString() {
        String string = "-np 1234 -lp 2345 -ha 123.45.67.89 -hp 3456";
        this.data = new RBECONFIGData(string);
        RBECONFIGDataTest.assertEquals((int)1234, (int)this.data.getNotifyPort());
        RBECONFIGDataTest.assertEquals((int)2345, (int)this.data.getListenPort());
        RBECONFIGDataTest.assertEquals((String)"123.45.67.89", (String)this.data.getHostAddress());
        RBECONFIGDataTest.assertEquals((int)3456, (int)this.data.getHostPort());
    }

    public void testConstructorSingleStringWithPath() {
        String string = "-p path -np 1234 -lp 2345 -ha 123.45.67.89 -hp 3456";
        try {
            this.data = new RBECONFIGData(string);
            RBECONFIGDataTest.fail((String)"RBECONFIGData(parmString) accepted path parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorArrayOfString() {
        String[] stringArray = new String[]{"rbeconfig", "-p", "path", "-np", "1234", "-lp", "2345", "-ha", "123.45.67.89", "-hp", "3456"};
        this.data = new RBECONFIGData(stringArray);
        RBECONFIGDataTest.assertEquals((String)"path", (String)this.data.getPath());
        RBECONFIGDataTest.assertEquals((int)1234, (int)this.data.getNotifyPort());
        RBECONFIGDataTest.assertEquals((int)2345, (int)this.data.getListenPort());
        RBECONFIGDataTest.assertEquals((String)"123.45.67.89", (String)this.data.getHostAddress());
        RBECONFIGDataTest.assertEquals((int)3456, (int)this.data.getHostPort());
    }

    public void testParseParametersNull() {
        String[] stringArray = null;
        try {
            this.data.parseParameters(stringArray);
            RBECONFIGDataTest.fail((String)"parseParameters() accepted null parms");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseParametersNullParameter() {
        String[] stringArray = new String[]{"-p", null};
        try {
            this.data.parseParameters(stringArray);
            RBECONFIGDataTest.fail((String)"parseParameters() accepted null parms");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseParametersUnknownOption() {
        String[] stringArray = new String[]{"-invalid", "some_value"};
        try {
            this.data.parseParameters(stringArray);
            RBECONFIGDataTest.fail((String)"parseParameters() accepted unknown option");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseParametersMissingValue() {
        String[] stringArray = new String[]{"-p", "some_value", "-hp"};
        try {
            this.data.parseParameters(stringArray);
            RBECONFIGDataTest.fail((String)"parseParameters() accepted missing value for option");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseParametersBadNumericValue() {
        String[] stringArray = new String[]{"-p", "some_value", "-hp", "not_a_number"};
        try {
            this.data.parseParameters(stringArray);
            RBECONFIGDataTest.fail((String)"parseParameters() accepted bad value for numeric option");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseParametersAllValidOptions() {
        String[] stringArray = new String[]{"rbeconfig", "-p", "path", "-np", "1234", "-lp", "2345", "-ha", "123.45.67.89", "-hp", "3456"};
        this.data.parseParameters(stringArray);
        RBECONFIGDataTest.assertEquals((String)"path", (String)this.data.getPath());
        RBECONFIGDataTest.assertEquals((int)1234, (int)this.data.getNotifyPort());
        RBECONFIGDataTest.assertEquals((int)2345, (int)this.data.getListenPort());
        RBECONFIGDataTest.assertEquals((String)"123.45.67.89", (String)this.data.getHostAddress());
        RBECONFIGDataTest.assertEquals((int)3456, (int)this.data.getHostPort());
    }

    public void testSetPath() {
        this.data.setPath("some_path_value");
        RBECONFIGDataTest.assertEquals((String)"some_path_value", (String)this.data.getPath());
    }

    public void testSetListenPort() {
        this.data.setListenPort(12345);
        RBECONFIGDataTest.assertEquals((int)12345, (int)this.data.getListenPort());
    }

    public void testSetNotifyPort() {
        this.data.setNotifyPort(54321);
        RBECONFIGDataTest.assertEquals((int)54321, (int)this.data.getNotifyPort());
    }

    public void testSetHostAddress() {
        this.data.setHostAddress("host_address");
        RBECONFIGDataTest.assertEquals((String)"host_address", (String)this.data.getHostAddress());
    }

    public void testSetHostPort() {
        this.data.setHostPort(13579);
        RBECONFIGDataTest.assertEquals((int)13579, (int)this.data.getHostPort());
    }
}

