/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import java.util.Calendar;

public class JobMonitorEvent
extends CommonVersionedObject {
    private static final long serialVersionUID = 7652474073848984260L;
    public static final int TYPE_UNDERRUN = 1;
    public static final int TYPE_OVERRUN = 2;
    public static final int TYPE_LATESTART = 3;
    private static final String NAME_UNDERRUN = "Job Underrun";
    private static final String NAME_OVERRUN = "Job Overrun";
    private static final String NAME_LATE_START = "Job Late Start";
    public static final int ACTION_NONE = 0;
    public static final int ACTION_TRAP = 1;
    public static final int ACTION_EMAIL = 16;
    public static final int ACTION_END = 256;
    private long id = 0L;
    private int eventType = 0;
    private long jobRunID = 0L;
    private String jobName = "";
    private long jobID = 0L;
    private String agentName = "";
    private long agentID = 0L;
    private long timeDetected = 0L;
    private long notificationListID = 0L;
    private long scheduledTime = 0L;
    private int actions = 0;
    private String actionData = "";
    private long agentGroupOID = 0L;
    private String agentGroupName = "";
    private JobType jobType = JobType.JOB;
    private long jobSuiteHistoryID = 0L;
    private long jobSuiteMemberJobID = 0L;
    private String jobSuiteName = "";
    private long jobSuiteID = 0L;

    public JobMonitorEvent() {
        this.setTimeDetected(Calendar.getInstance().getTimeInMillis());
    }

    public JobMonitorEvent(JobMonitor jobMonitor) {
        this();
        this.setEventType(jobMonitor.getMonitorType().persistanceCode());
        this.setJobID(jobMonitor.getJobID());
        this.setJobRunID(jobMonitor.getJobHistoryID());
        this.setAgentID(jobMonitor.getAgentID());
        this.setScheduledTime(jobMonitor.getScheduledTime());
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getEventTypeDescription() {
        return JobMonitorEvent.getTypeDescription(this.eventType);
    }

    public static String getTypeDescription(int n) {
        switch (n) {
            case 1: {
                return NAME_UNDERRUN;
            }
            case 2: {
                return NAME_OVERRUN;
            }
            case 3: {
                return NAME_LATE_START;
            }
        }
        return "Unsupported type: " + new Integer(n);
    }

    public long getID() {
        return this.id;
    }

    public long getJobRunID() {
        return this.jobRunID;
    }

    public long getNotificationListID() {
        return this.notificationListID;
    }

    public String getRuntimeJobName() {
        return this.jobName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public long getJobID() {
        return this.jobID;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public long getTimeDetected() {
        return this.timeDetected;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setID(long l) {
        this.id = l;
    }

    public void setTimeDetected(long l) {
        this.timeDetected = l;
    }

    public void setScheduledTime(long l) {
        this.scheduledTime = l;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public void setAgentID(long l) {
        this.agentID = l;
    }

    public void setAgentName(String string) {
        ValidationHelper.checkForNull((String)"Agent name", (Object)string);
        this.agentName = string;
    }

    public void setRuntimeJobName(String string) {
        ValidationHelper.checkForNull((String)"Runtime job name", (Object)string);
        this.jobName = string;
    }

    public void setJobRunID(long l) {
        this.jobRunID = l;
    }

    public void setNotificationListID(long l) {
        this.notificationListID = l;
    }

    public void setEventType(int n) {
        if (!this.isEventTypeSupported(n)) {
            throw new IllegalArgumentException("The event type " + n + " not supported.");
        }
        this.eventType = n;
    }

    private boolean isEventTypeSupported(int n) {
        return n == JobMonitor.MonitorType.UNDERRUN.persistanceCode() || n == JobMonitor.MonitorType.LATESTART.persistanceCode() || n == JobMonitor.MonitorType.OVERRUN.persistanceCode();
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int n) {
        this.actions = n;
    }

    public boolean isActionEmail() {
        int n = this.actions;
        return (n & 0x10) == 16;
    }

    public boolean isActionEnd() {
        int n = this.actions;
        return (n & 0x100) == 256;
    }

    public boolean isActionTrap() {
        int n = this.actions;
        return (n & 1) == 1;
    }

    public String getActionData() {
        return this.actionData;
    }

    public void setActionData(String string) {
        this.actionData = string;
    }

    public void setAgentGroupOID(long l) {
        this.agentGroupOID = l;
    }

    public long getAgentGroupOID() {
        return this.agentGroupOID;
    }

    public void setAgentGroupName(String string) {
        this.agentGroupName = string;
    }

    public String getAgentGroupName() {
        return this.agentGroupName;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType_AsInt(int n) {
        this.jobType = JobType.persistanceCodeToEnum(n);
    }

    public int getJobType_AsInt() {
        if (this.jobType != null) {
            return this.jobType.persistanceCode();
        }
        return JobType.JOB.persistanceCode();
    }

    public long getJobSuiteHistoryID() {
        return this.jobSuiteHistoryID;
    }

    public void setJobSuiteHistoryID(long l) {
        this.jobSuiteHistoryID = l;
    }

    public long getJobSuiteMemberJobID() {
        return this.jobSuiteMemberJobID;
    }

    public void setJobSuiteMemberJobID(long l) {
        this.jobSuiteMemberJobID = l;
    }

    public String getJobSuiteName() {
        return this.jobSuiteName;
    }

    public void setJobSuiteName(String string) {
        this.jobSuiteName = string;
    }

    public long getJobSuiteID() {
        return this.jobSuiteID;
    }

    public void setJobSuiteID(long l) {
        this.jobSuiteID = l;
    }

    public PrereqEventType determinePrereqEventType() {
        switch (this.jobType) {
            case SUITE: {
                return PrereqEventType.JOB_SUITE_MONITOR_EVENT;
            }
            case SUITE_MEMBER: {
                return PrereqEventType.JOB_SUITE_MEMBER_MONITOR_EVENT;
            }
        }
        return PrereqEventType.JOB_MONITOR_EVENT;
    }
}

