/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.DirectoryEvent;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import junit.framework.TestCase;

public class DirectoryEventTest
extends TestCase {
    DirectoryEvent de;
    AgentEventFile aef;

    protected void setUp() throws Exception {
        super.setUp();
        this.de = new DirectoryEvent();
        this.aef = new AgentEventFile();
        this.aef.setFilePath("/some/test/dir");
    }

    protected void tearDown() throws Exception {
        this.de = null;
        this.aef = null;
        super.tearDown();
    }

    public void testCloneAgentEventMonitor() {
        this.de.setAgentEventFile(this.aef);
        this.de.setName("TESTNAME");
        this.de.setDescription("Test description");
        DirectoryEvent directoryEvent = new DirectoryEvent();
        directoryEvent.clone(this.de);
        DirectoryEventTest.assertEquals((Object)((Object)this.aef), (Object)((Object)directoryEvent.getAgentEventFile()));
    }

    public void testIsDifferentThan() {
        this.de.setTargetID(12345L);
        this.de.setName("Event1");
        this.de.setDescription("A test event");
        this.de.setProductIIDInt(9494);
        this.de.setDisabled(true);
        this.de.setCycle(666);
        this.de.setOID(58493L);
        this.de.setFromTime(1234);
        this.de.setToTime(2468);
        this.de.setAgentEventFile(this.aef);
        ManualEvent manualEvent = new ManualEvent();
        DirectoryEventTest.assertTrue((boolean)this.de.isDifferentThan(manualEvent));
        DirectoryEvent directoryEvent = new DirectoryEvent();
        DirectoryEventTest.assertTrue((boolean)this.de.isDifferentThan(directoryEvent));
        directoryEvent.setTargetID(12345L);
        directoryEvent.setName("Event1");
        directoryEvent.setDescription("A test event");
        directoryEvent.setProductIIDInt(9494);
        directoryEvent.setDisabled(true);
        directoryEvent.setCycle(666);
        directoryEvent.setOID(58493L);
        directoryEvent.setFromTime(1234);
        directoryEvent.setToTime(2468);
        directoryEvent.setAgentEventFile(this.aef);
        DirectoryEventTest.assertFalse((boolean)this.de.isDifferentThan(directoryEvent));
    }
}

