/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.util.LongConverter;
import java.util.Calendar;
import org.apache.log4j.Logger;

public abstract class DayOfWeekTimestampFilter {
    private static final Logger logger = Logger.getLogger(DayOfWeekTimestampFilter.class);
    private DayOption dayOptionMonday;
    private DayOption dayOptionTuesday;
    private DayOption dayOptionWednesday;
    private DayOption dayOptionThursday;
    private DayOption dayOptionFriday;
    private DayOption dayOptionSaturday;
    private DayOption dayOptionSunday;
    private int endTime;
    private int startTime;

    public DayOption getDayOption_Mon() {
        return this.dayOptionMonday;
    }

    public void setDayOption_Mon(DayOption dayOption) {
        this.dayOptionMonday = dayOption;
    }

    public DayOption getDayOption_Tue() {
        return this.dayOptionTuesday;
    }

    public void setDayOption_Tue(DayOption dayOption) {
        this.dayOptionTuesday = dayOption;
    }

    public DayOption getDayOption_Wed() {
        return this.dayOptionWednesday;
    }

    public void setDayOption_Wed(DayOption dayOption) {
        this.dayOptionWednesday = dayOption;
    }

    public DayOption getDayOption_Thu() {
        return this.dayOptionThursday;
    }

    public void setDayOption_Thu(DayOption dayOption) {
        this.dayOptionThursday = dayOption;
    }

    public DayOption getDayOption_Fri() {
        return this.dayOptionFriday;
    }

    public void setDayOption_Fri(DayOption dayOption) {
        this.dayOptionFriday = dayOption;
    }

    public DayOption getDayOption_Sat() {
        return this.dayOptionSaturday;
    }

    public void setDayOption_Sat(DayOption dayOption) {
        this.dayOptionSaturday = dayOption;
    }

    public DayOption getDayOption_Sun() {
        return this.dayOptionSunday;
    }

    public void setDayOption_Sun(DayOption dayOption) {
        this.dayOptionSunday = dayOption;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    public boolean isTimeAccepted(Calendar calendar, long l, CalendarObject calendarObject) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        DayOption[] dayOptionArray = new DayOption[]{this.dayOptionSunday, this.dayOptionMonday, this.dayOptionTuesday, this.dayOptionWednesday, this.dayOptionThursday, this.dayOptionFriday, this.dayOptionSaturday};
        if (calendarObject == null) {
            logger.debug((Object)"WARNING: Calendar object is null!");
            return true;
        }
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        if (l != 0L) {
            n5 = LongConverter.intValue(l / 100000000L);
            int n6 = LongConverter.intValue(l % 100000000L / 1000000L);
            n4 = LongConverter.intValue(l % 1000000L / 10000L);
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
            int n7 = calendar.get(14);
            calendar2.set(n5, n6 - 1, n4, n3, n2, n);
            calendar2.set(14, n7);
        } else {
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
        }
        n5 = calendarObject.weekOfMonth(calendar2);
        CalendarObject.DayOfWeek dayOfWeek = calendarObject.dayOfWeek(calendar2);
        n4 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar2);
        n3 = calendarObject.isLastWeekOfMonth(calendar2);
        n2 = this.processWeek(dayOptionArray, calendar, l, dayOfWeek, n5, n3 != 0, n4) ? 1 : 0;
        if (n2 != 0) {
            return true;
        }
        calendar2.add(5, -1);
        n = calendarObject.weekOfMonth(calendar2);
        CalendarObject.DayOfWeek dayOfWeek2 = calendarObject.dayOfWeek(calendar2);
        n4 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar2);
        boolean bl = calendarObject.isLastWeekOfMonth(calendar2);
        boolean bl2 = this.processWeek(dayOptionArray, calendar, l, dayOfWeek2, n, bl, n4);
        return bl2;
    }

    private boolean processWeek(DayOption[] dayOptionArray, Calendar calendar, long l, CalendarObject.DayOfWeek dayOfWeek, int n, boolean bl, int n2) {
        block4: for (int i = 0; i < dayOptionArray.length; ++i) {
            if (dayOptionArray[i] == null || dayOptionArray[i] == DayOption.NEVER) continue;
            switch (dayOptionArray[i]) {
                case FIRST: 
                case SECOND: 
                case THIRD: 
                case FOURTH: 
                case FIFTH: {
                    boolean bl2 = this.isSpecificDayAccepted(calendar, l, n2, dayOptionArray[i], i, dayOfWeek, n);
                    if (!bl2) continue block4;
                    return true;
                }
                case EVERY: 
                case LAST: {
                    boolean bl3 = this.isLastOrEveryDayAccepted(calendar, l, n2, dayOptionArray[i], i, dayOfWeek, bl);
                    if (!bl3) continue block4;
                    return true;
                }
                default: {
                    throw new IllegalStateException("Undefined DayOption (" + dayOptionArray[i] + ") for day " + (i + 1));
                }
            }
        }
        return false;
    }

    private boolean isSpecificDayAccepted(Calendar calendar, long l, int n, DayOption dayOption, int n2, CalendarObject.DayOfWeek dayOfWeek, int n3) {
        int n4;
        CalendarObject.DayOfWeek dayOfWeek2 = this.dayOfWeekMap(n2);
        if (dayOfWeek != dayOfWeek2) {
            return false;
        }
        switch (dayOption) {
            case FIRST: {
                n4 = 1;
                break;
            }
            case SECOND: {
                n4 = 2;
                break;
            }
            case THIRD: {
                n4 = 3;
                break;
            }
            case FOURTH: {
                n4 = 4;
                break;
            }
            case FIFTH: {
                n4 = 5;
                break;
            }
            default: {
                return false;
            }
        }
        if (n4 != n3) {
            return false;
        }
        return TimeHelper.isWithinRange(calendar, l, n, this.getStartTime(), this.getEndTime());
    }

    private boolean isLastOrEveryDayAccepted(Calendar calendar, long l, int n, DayOption dayOption, int n2, CalendarObject.DayOfWeek dayOfWeek, boolean bl) {
        if (dayOption == DayOption.LAST && !bl) {
            return false;
        }
        CalendarObject.DayOfWeek dayOfWeek2 = this.dayOfWeekMap(n2);
        if (dayOfWeek != dayOfWeek2) {
            return false;
        }
        return TimeHelper.isWithinRange(calendar, l, n, this.getStartTime(), this.getEndTime());
    }

    private CalendarObject.DayOfWeek dayOfWeekMap(int n) {
        switch (n) {
            case 0: {
                return CalendarObject.DayOfWeek.SUN;
            }
            case 1: {
                return CalendarObject.DayOfWeek.MON;
            }
            case 2: {
                return CalendarObject.DayOfWeek.TUE;
            }
            case 3: {
                return CalendarObject.DayOfWeek.WED;
            }
            case 4: {
                return CalendarObject.DayOfWeek.THU;
            }
            case 5: {
                return CalendarObject.DayOfWeek.FRI;
            }
            case 6: {
                return CalendarObject.DayOfWeek.SAT;
            }
        }
        throw new IllegalArgumentException("Undefined day of week: " + n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".MON[" + this.getDayOption_Mon() + "]");
        stringBuffer.append(".TUE[" + this.getDayOption_Tue() + "]");
        stringBuffer.append(".WED[" + this.getDayOption_Wed() + "]");
        stringBuffer.append(".THU[" + this.getDayOption_Thu() + "]");
        stringBuffer.append(".FRI[" + this.getDayOption_Fri() + "]");
        stringBuffer.append(".SAT[" + this.getDayOption_Sat() + "]");
        stringBuffer.append(".SUN[" + this.getDayOption_Sun() + "]");
        stringBuffer.append(".START_TIME[" + this.getStartTime() + "]");
        stringBuffer.append(".END_TIME[" + this.getEndTime() + "]");
        return stringBuffer.toString();
    }

    public static enum DayOption implements PersistableEnum<String>
    {
        NEVER(""),
        EVERY("Y"),
        FIRST("1"),
        SECOND("2"),
        THIRD("3"),
        FOURTH("4"),
        FIFTH("5"),
        LAST("L");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, DayOption> map;

        private DayOption(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static DayOption persistanceCodeToEnum(String string) {
            if (string == null || string.trim().length() == 0) {
                return NEVER;
            }
            DayOption dayOption = map.get(string);
            if (dayOption == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return dayOption;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])DayOption.values());
        }
    }
}

