/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.enums.CommandSetType;
import junit.framework.TestCase;

public class CommandSetTest
extends TestCase {
    private CommandSet commandSet;

    public CommandSetTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.commandSet = new CommandSet();
    }

    protected void tearDown() throws Exception {
        this.commandSet = null;
        super.tearDown();
    }

    public void testAdd() {
        CommandSetTest.assertEquals((int)0, (int)this.commandSet.getCommands().length);
        this.commandSet.addCommand(new CommandSetCommand());
        CommandSetTest.assertEquals((int)1, (int)this.commandSet.getCommands().length);
    }

    public void testAddAfter() {
        CommandSetTest.assertEquals((int)0, (int)this.commandSet.getCommands().length);
        this.commandSet.addCommand(this.createCommand("Cmd 1"));
        this.commandSet.addCommand(this.createCommand("Cmd 2"));
        this.commandSet.addCommand(this.createCommand("Cmd 3"));
        this.commandSet.addCommand(this.createCommand("Cmd 4"));
        CommandSetCommand[] commandSetCommandArray = this.commandSet.getCommands();
        CommandSetTest.assertEquals((int)4, (int)commandSetCommandArray.length);
        this.commandSet.addCommand(this.createCommand("Cmd 9"), 1);
        commandSetCommandArray = this.commandSet.getCommands();
        CommandSetTest.assertEquals((String)"Cmd 9", (String)commandSetCommandArray[2].getCommandString());
    }

    public void testHasCommands() {
        CommandSetTest.assertFalse((boolean)this.commandSet.hasCommands());
        this.commandSet.addCommand(this.createPersistentCommand("Cmd 1"));
        CommandSetTest.assertTrue((boolean)this.commandSet.hasCommands());
    }

    public void testSetOID() {
        this.commandSet.setOid(1234L);
        CommandSetTest.assertEquals((long)1234L, (long)this.commandSet.getOid());
        try {
            this.commandSet.setOid(5678L);
            CommandSetTest.fail((String)"setOid() allowed change to oid value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetType() {
        this.commandSet.setType(CommandSetType.PRIVATE.persistanceCode());
        int n = CommandSetType.PRIVATE.persistanceCode();
        CommandSetTest.assertEquals((int)n, (int)this.commandSet.getType());
        this.commandSet.setType(CommandSetType.SHARED.persistanceCode());
        int n2 = CommandSetType.SHARED.persistanceCode();
        CommandSetTest.assertEquals((int)n2, (int)this.commandSet.getType());
        try {
            this.commandSet.setType(23489);
            CommandSetTest.fail((String)"setType() allowed invalid type value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private CommandSetCommand createPersistentCommand(String string) {
        CommandSetCommand commandSetCommand = this.createCommand(string);
        commandSetCommand.setPersistent(true);
        return commandSetCommand;
    }

    private CommandSetCommand createCommand(String string) {
        CommandSetCommand commandSetCommand = new CommandSetCommand();
        commandSetCommand.setCommandString(string);
        return commandSetCommand;
    }
}

