/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.Agent;
import java.util.HashSet;
import junit.framework.TestCase;

public class AgentTest
extends TestCase {
    private Agent agent = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.agent = new Agent();
    }

    protected void tearDown() throws Exception {
        this.agent = null;
        super.tearDown();
    }

    public void testName_Valid() {
        this.agent.setName("VALID");
        AgentTest.assertEquals((String)"VALID", (String)this.agent.getName());
    }

    public void testDescription_Valid() {
        this.agent.setDescription("VALID DESCRIPTION");
        AgentTest.assertEquals((String)"VALID DESCRIPTION", (String)this.agent.getDescription());
    }

    public void testVersion_Valid() {
        this.agent.setVersion("R01M001070906");
        AgentTest.assertEquals((String)"R01M001070906", (String)this.agent.getVersion());
    }

    public void testCPUInfo_Valid() {
        this.agent.setCPUInfo("Valid CPU Info");
        AgentTest.assertEquals((String)"Valid CPU Info", (String)this.agent.getCPUInfo());
    }

    public void testJobShell_Valid() {
        this.agent.setJobShell("Valid Job Shell");
        AgentTest.assertEquals((String)"Valid Job Shell", (String)this.agent.getJobShell());
    }

    public void testOid() {
        this.agent.setOid(1234L);
        AgentTest.assertEquals((long)1234L, (long)this.agent.getOid());
    }

    public void testSetTimeZone() {
        this.agent.setTimeZone("time_zone");
        AgentTest.assertEquals((String)"time_zone", (String)this.agent.getTimeZone());
    }

    public void testSetLimitActiveJobs() {
        this.agent.setLimitActiveJobs(false);
        AgentTest.assertFalse((boolean)this.agent.isLimitActiveJobs());
        AgentTest.assertFalse((boolean)this.agent.getLimitActiveJobs());
        this.agent.setLimitActiveJobs(true);
        AgentTest.assertTrue((boolean)this.agent.isLimitActiveJobs());
        AgentTest.assertTrue((boolean)this.agent.getLimitActiveJobs());
    }

    public void testSetNotificationListId() {
        this.agent.setNotificationListID(1234L);
        AgentTest.assertEquals((long)1234L, (long)this.agent.getNotificationListID());
    }

    public void testSetSendSMTPEmail() {
        this.agent.setSendSMTPEmail(false);
        AgentTest.assertFalse((boolean)this.agent.isSendSMTPEmail());
        AgentTest.assertFalse((boolean)this.agent.getSendSMTPEmail());
        this.agent.setSendSMTPEmail(true);
        AgentTest.assertTrue((boolean)this.agent.isSendSMTPEmail());
        AgentTest.assertTrue((boolean)this.agent.getSendSMTPEmail());
    }

    public void testSetSendSNMPTrap() {
        this.agent.setSendSNMPTrap(false);
        AgentTest.assertFalse((boolean)this.agent.isSendSNMPTrap());
        AgentTest.assertFalse((boolean)this.agent.getSendSNMPTrap());
        this.agent.setSendSNMPTrap(true);
        AgentTest.assertTrue((boolean)this.agent.isSendSNMPTrap());
        AgentTest.assertTrue((boolean)this.agent.getSendSNMPTrap());
    }

    public void testOperatingSystem_ValidValueAccepted() {
        this.agent.setOperatingSystem("Klumpf");
        AgentTest.assertEquals((String)"Klumpf", (String)this.agent.getOperatingSystem());
        this.agent.setOperatingSystem("   ");
        AgentTest.assertEquals((String)"   ", (String)this.agent.getOperatingSystem());
        this.agent.setOperatingSystem(null);
        AgentTest.assertEquals(null, (String)this.agent.getOperatingSystem());
    }

    public void testRuntimeState_ActiveIsValid() {
        this.agent.setRuntimeState(1);
        AgentTest.assertEquals((int)1, (int)this.agent.getRuntimeState());
    }

    public void testRuntimeState_InactiveIsValid() {
        this.agent.setRuntimeState(2);
        AgentTest.assertEquals((int)2, (int)this.agent.getRuntimeState());
    }

    public void testRuntimeState_FailedIsValid() {
        this.agent.setRuntimeState(3);
        AgentTest.assertEquals((int)3, (int)this.agent.getRuntimeState());
    }

    public void testHardwareKey_NullAccepted() {
        this.agent.setHardwareKey(null);
        AgentTest.assertEquals(null, (String)this.agent.getHardwareKey());
    }

    public void testHardwareKey_ValueAccepted() {
        this.agent.setHardwareKey("SomeHardwareKeyValue");
        AgentTest.assertEquals((String)"SomeHardwareKeyValue", (String)this.agent.getHardwareKey());
    }

    public void testIPAddress_ValidValueAccepted() {
        this.agent.setIPAddress("192.168.124.110");
        AgentTest.assertEquals((String)"192.168.124.110", (String)this.agent.getIPAddress());
        this.agent.setIPAddress(null);
        AgentTest.assertEquals(null, (String)this.agent.getIPAddress());
        this.agent.setIPAddress("");
        AgentTest.assertEquals((String)"", (String)this.agent.getIPAddress());
    }

    public void testPort_SetterGetter() {
        this.agent.setPort(23);
        AgentTest.assertEquals((int)23, (int)this.agent.getPort());
    }

    public void testLicensePoints_SetterGetter() {
        this.agent.setLicensePoints(39283);
        AgentTest.assertEquals((int)39283, (int)this.agent.getLicensePoints());
    }

    public void testHardwareHash_ValidValueAccepted() {
        this.agent.setHardwareHash("AT8OEC5CHT");
        AgentTest.assertEquals((String)"AT8OEC5CHT", (String)this.agent.getHardwareHash());
    }

    public void testHashcode() {
        this.agent.setOid(12345L);
        HashSet<Agent> hashSet = new HashSet<Agent>();
        AgentTest.assertFalse((boolean)hashSet.contains((Object)this.agent));
        hashSet.add(this.agent);
        AgentTest.assertTrue((boolean)hashSet.contains((Object)this.agent));
    }

    public void testInstanceIdentifier() {
        String string = "ue09euig0h";
        this.agent.setInstanceIdentifier(string);
        AgentTest.assertEquals((String)string, (String)this.agent.getInstanceIdentifier());
    }

    public void testEquals_NonAgentObject() {
        AgentTest.assertFalse((boolean)this.agent.equals(new Object()));
    }

    public void testEquals_AnotherAgent() {
        Agent agent = new Agent();
        this.agent.setOperatingSystem("Klumpf");
        this.agent.setName("My Name");
        this.agent.setHardwareKey("Some particular key");
        this.agent.setHardwareHash("ATE2CHN9AR");
        this.agent.setVersion("2.0.0");
        this.agent.setLicensePoints(23948378);
        agent.setOperatingSystem("Krumpf");
        agent.setName("My Name");
        agent.setHardwareKey("Some particular key");
        agent.setHardwareHash("ATE2CHN9AR");
        agent.setVersion("2.0.0");
        agent.setLicensePoints(23948378);
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setOperatingSystem("Klumpf");
        agent.setName("Other name");
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setName("My Name");
        agent.setHardwareKey("Another key");
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setHardwareKey("Some particular key");
        agent.setHardwareHash("XXXXXXXXXX");
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setHardwareHash("ATE2CHN9AR");
        agent.setVersion("1.5.5");
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setVersion("2.0.0");
        agent.setLicensePoints(99999);
        AgentTest.assertFalse((boolean)this.agent.equals((Object)agent));
        agent.setLicensePoints(23948378);
        AgentTest.assertTrue((boolean)this.agent.equals((Object)agent));
    }
}

