/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AgentJobQueue
extends JobQueue {
    private Set<Long> runningJobsSet = new HashSet<Long>();
    private boolean agentAvailable = true;
    private boolean agentLocked = false;

    @Override
    public synchronized int getActiveJobsCount() {
        return this.runningJobsSet.size();
    }

    @Override
    public JobHistory poll() {
        if (this.agentLocked) {
            return null;
        }
        return super.poll();
    }

    @Override
    public String toString() {
        String string = "The raw AgentJobQueue(" + this.actualJobQueue.hashCode() + ") (size = " + this.actualJobQueue.size() + "):";
        Iterator iterator = this.actualJobQueue.iterator();
        while (iterator.hasNext()) {
            string = string + "\n" + ((JobHistory)((Object)iterator.next())).getId();
        }
        return string;
    }

    @Override
    public boolean setAgentAvailable(long l) {
        this.agentAvailable = true;
        return true;
    }

    @Override
    public void setAgentUnavailable(long l) {
        this.agentAvailable = false;
    }

    @Override
    public boolean isAgentLocked(long l) {
        return this.getTargetID() == l && this.agentLocked;
    }

    @Override
    public void setAgentLocked(long l) {
        if (this.getTargetID() == l) {
            this.agentLocked = true;
        }
    }

    @Override
    public boolean setAgentUnlocked(long l) {
        if (this.getTargetID() == l) {
            this.agentLocked = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAgentAvailable(long l) {
        return this.agentAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean incrementActiveJobs(JobHistory jobHistory) {
        boolean bl = false;
        if (this.getTargetID() == jobHistory.getAgentID()) {
            Set<Long> set = this.runningJobsSet;
            synchronized (set) {
                bl = this.runningJobsSet.add(jobHistory.getId());
            }
            if (this.isLimiterEnabled() && jobHistory.getJobPriority() >= this.getLimiterMinimumPriority()) {
                this.incrementPriorityLimitActiveJobs();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decrementActiveJobs(JobHistory jobHistory) {
        boolean bl = false;
        if (this.getTargetID() == jobHistory.getAgentID()) {
            Set<Long> set = this.runningJobsSet;
            synchronized (set) {
                bl = this.runningJobsSet.remove(jobHistory.getId());
            }
            if (this.isLimiterEnabled() && jobHistory.getJobPriority() >= this.getLimiterMinimumPriority()) {
                this.decrementPriorityLimitActiveJobs();
            }
            return bl;
        }
        return false;
    }

    @Override
    public synchronized Long[] getAllActiveJobHistoryIDs() {
        return this.runningJobsSet.toArray(new Long[this.runningJobsSet.size()]);
    }
}

