/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import java.util.Date;
import junit.framework.TestCase;

public class AgentEventHistoryInfoTest
extends TestCase {
    AgentEventHistoryInfo info;

    protected void setUp() throws Exception {
        super.setUp();
        this.info = new AgentEventHistoryInfo();
    }

    protected void tearDown() throws Exception {
        this.info = null;
        super.tearDown();
    }

    public void testConstructor() {
        AgentEventHistory agentEventHistory = new AgentEventHistory();
        agentEventHistory.setEventOID(12345L);
        agentEventHistory.setAgentOID(34567L);
        agentEventHistory.setAgentTimeStamp(12345678L);
        agentEventHistory.setStatus('F');
        agentEventHistory.setEventData("event_data");
        AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo(agentEventHistory);
        AgentEventHistoryInfoTest.assertEquals((long)12345L, (long)agentEventHistoryInfo.getEventOID());
        AgentEventHistoryInfoTest.assertEquals((long)34567L, (long)agentEventHistoryInfo.getAgentOID());
        AgentEventHistoryInfoTest.assertEquals((long)12345678L, (long)agentEventHistoryInfo.getAgentTimeStamp());
        AgentEventHistoryInfoTest.assertEquals((char)'F', (char)agentEventHistoryInfo.getStatus());
        AgentEventHistoryInfoTest.assertEquals((String)"event_data", (String)agentEventHistoryInfo.getEventData());
    }

    public void testSetEventOID() {
        this.info.setEventOID(1234L);
        AgentEventHistoryInfoTest.assertEquals((long)1234L, (long)this.info.getEventOID());
    }

    public void testSetAgentOID() {
        this.info.setAgentOID(9876L);
        AgentEventHistoryInfoTest.assertEquals((long)9876L, (long)this.info.getAgentOID());
    }

    public void testSetAgentTimeStamp() {
        long l = System.currentTimeMillis();
        this.info.setAgentTimeStamp(l);
        AgentEventHistoryInfoTest.assertEquals((long)l, (long)this.info.getAgentTimeStamp());
    }

    public void testSetStatus() {
        this.info.setStatus('*');
        AgentEventHistoryInfoTest.assertEquals((char)'*', (char)this.info.getStatus());
    }

    public void testSetEventData() {
        this.info.setEventData("event data");
        AgentEventHistoryInfoTest.assertEquals((String)"event data", (String)this.info.getEventData());
    }

    public void testSetOID() {
        this.info.setOID(19283784L);
        AgentEventHistoryInfoTest.assertEquals((long)19283784L, (long)this.info.getOID());
    }

    public void testSetServerTimeStamp() {
        Date date = new Date();
        this.info.setServerTimeStamp(date.getTime());
        AgentEventHistoryInfoTest.assertEquals((long)date.getTime(), (long)this.info.getServerTimeStamp());
    }

    public void testSetEventType() {
        this.info.setEventType(101);
        AgentEventHistoryInfoTest.assertEquals((int)101, (int)this.info.getEventType());
    }

    public void testSetErrorStatus() {
        this.info.setErrorStatus(0);
        AgentEventHistoryInfoTest.assertEquals((int)0, (int)this.info.getErrorStatus());
        this.info.setErrorStatus(1);
        AgentEventHistoryInfoTest.assertEquals((int)1, (int)this.info.getErrorStatus());
        this.info.setErrorStatus(2);
        AgentEventHistoryInfoTest.assertEquals((int)2, (int)this.info.getErrorStatus());
        this.info.setErrorStatus(3);
        AgentEventHistoryInfoTest.assertEquals((int)3, (int)this.info.getErrorStatus());
        this.info.setErrorStatus(4);
        AgentEventHistoryInfoTest.assertEquals((int)4, (int)this.info.getErrorStatus());
    }

    public void testGetErrorDescription() {
        AgentEventHistoryInfoTest.assertEquals((String)"", (String)AgentEventHistoryInfo.getErrorDescription(0));
        AgentEventHistoryInfoTest.assertEquals((String)"Invalid OID", (String)AgentEventHistoryInfo.getErrorDescription(1));
        AgentEventHistoryInfoTest.assertEquals((String)"Invalid Agent", (String)AgentEventHistoryInfo.getErrorDescription(2));
        AgentEventHistoryInfoTest.assertEquals((String)"Invalid Time Range", (String)AgentEventHistoryInfo.getErrorDescription(3));
        AgentEventHistoryInfoTest.assertEquals((String)"Event was held", (String)AgentEventHistoryInfo.getErrorDescription(4));
        AgentEventHistoryInfoTest.assertEquals((String)"Code: -1", (String)AgentEventHistoryInfo.getErrorDescription(-1));
    }

    public void testSetEventMonitorName() {
        this.info.setEventMonitorName("MON1234");
        AgentEventHistoryInfoTest.assertEquals((String)"MON1234", (String)this.info.getEventMonitorName());
    }

    public void testSetAgentName() {
        this.info.setAgentName("MINNEAPOLIS");
        AgentEventHistoryInfoTest.assertEquals((String)"MINNEAPOLIS", (String)this.info.getAgentName());
    }

    public void testEncodeEventData() {
        BasicProcessInfo basicProcessInfo = new BasicProcessInfo();
        basicProcessInfo.setPid("12345");
        basicProcessInfo.setUser("user");
        basicProcessInfo.setCommand("command");
        String string = AgentEventHistoryInfo.encodeEventData(basicProcessInfo);
        AgentEventHistoryInfoTest.assertEquals((String)"12345\tuser\tcommand", (String)string);
    }

    public void testDecodeProcessEventData() {
        this.info.setEventData("12345\tuser\tcommand");
        BasicProcessInfo basicProcessInfo = this.info.decodeProcessEventData();
        AgentEventHistoryInfoTest.assertEquals((String)"12345", (String)basicProcessInfo.getPid());
        AgentEventHistoryInfoTest.assertEquals((String)"user", (String)basicProcessInfo.getUser());
        AgentEventHistoryInfoTest.assertEquals((String)"command", (String)basicProcessInfo.getCommand());
    }
}

