/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import java.util.HashMap;
import java.util.Map;

public class AgentEventHistoryInfo
extends EnterpriseProxy {
    private static final long serialVersionUID = 8342736358019238213L;
    public static final int MAX_EVENT_DATA_LENGTH = 9000;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_BAD_EVENT_OID = 1;
    public static final int ERROR_BAD_AGENT = 2;
    public static final int ERROR_TIME_RANGE = 3;
    public static final int ERROR_EVENT_HELD = 4;
    private static final String processEventDataSubfieldDelimiter = "\t";
    private static final String VAR_NAME_PREFIX = "SKYBOT";
    private static final String VAR_NAME_SUFFIX = "DATA";
    private static final String VAR_NAME_FILE_SUFFIX = "FILE";
    private static final String VAR_NAME_PATH_SUFFIX = "PATH";
    private static final String VAR_NAME_DELIMITER = "_";
    private static HashMap<Integer, String> errorCodeDesc = null;
    private long oid;
    private long eventOID;
    private long agentOID;
    private int eventType;
    private long agentTimeStamp;
    private long serverTimeStamp;
    private char status;
    private String eventData;
    private int errorStatus;
    private String eventMonitorName;
    private String agentName;
    private String agentTimezone;
    private String timezoneType;
    private SendStatusEvent sendStatusEvent = null;
    private long agentGroupOID = 0L;
    private String agentGroupName = "";

    public AgentEventHistoryInfo() {
    }

    public AgentEventHistoryInfo(AgentEventHistory agentEventHistory) {
        this.setErrorStatus(0);
        this.setEventOID(agentEventHistory.getEventOID());
        this.setAgentOID(agentEventHistory.getAgentOID());
        this.setAgentTimeStamp(agentEventHistory.getAgentTimeStamp());
        this.setStatus(agentEventHistory.getStatus());
        this.setEventData(agentEventHistory.getEventData());
        this.setSendStatusEvent(agentEventHistory.getSendStatusEvent());
    }

    public static String getErrorDescription(int n) {
        AgentEventHistoryInfo.loadErrorCodeDesc();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return errorCodeDesc.get(1);
            }
            case 2: {
                return errorCodeDesc.get(2);
            }
            case 3: {
                return errorCodeDesc.get(3);
            }
            case 4: {
                return errorCodeDesc.get(4);
            }
        }
        return "Code: " + n;
    }

    public long getEventOID() {
        return this.eventOID;
    }

    public void setEventOID(long l) {
        this.eventOID = l;
    }

    public long getAgentOID() {
        return this.agentOID;
    }

    public void setAgentOID(long l) {
        this.agentOID = l;
    }

    public long getAgentTimeStamp() {
        return this.agentTimeStamp;
    }

    public void setAgentTimeStamp(long l) {
        this.agentTimeStamp = l;
    }

    public char getStatus() {
        return this.status;
    }

    public void setStatus(char c) {
        this.status = c;
    }

    public String getEventData() {
        if (this.eventData == null) {
            return "";
        }
        return this.eventData;
    }

    public void setEventData(String string) {
        this.eventData = string != null && string.length() > 9000 ? string.substring(0, 9000) : string;
    }

    public long getOID() {
        return this.oid;
    }

    public void setOID(long l) {
        this.oid = l;
    }

    public long getServerTimeStamp() {
        return this.serverTimeStamp;
    }

    public void setServerTimeStamp(long l) {
        this.serverTimeStamp = l;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int n) {
        this.eventType = n;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void setErrorStatus(int n) {
        this.errorStatus = n;
    }

    public String getEventMonitorName() {
        return this.eventMonitorName;
    }

    public void setEventMonitorName(String string) {
        this.eventMonitorName = string;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public long getAgentGroupOID() {
        return this.agentGroupOID;
    }

    public void setAgentGroupOID(long l) {
        this.agentGroupOID = l;
    }

    public String getAgentGroupName() {
        return this.agentGroupName;
    }

    public void setAgentGroupName(String string) {
        this.agentGroupName = string;
    }

    public String getAgentTimezone() {
        return this.agentTimezone;
    }

    public void setAgentTimezone(String string) {
        this.agentTimezone = string;
    }

    public String getTimezoneType() {
        return this.timezoneType;
    }

    public void setTimezoneType(String string) {
        this.timezoneType = string;
    }

    public static String encodeEventData(BasicProcessInfo basicProcessInfo) {
        return basicProcessInfo.getPid() + processEventDataSubfieldDelimiter + basicProcessInfo.getUser() + processEventDataSubfieldDelimiter + basicProcessInfo.getCommand();
    }

    public BasicProcessInfo decodeProcessEventData() {
        BasicProcessInfo basicProcessInfo = new BasicProcessInfo();
        String[] stringArray = this.getEventData().split(processEventDataSubfieldDelimiter);
        switch (stringArray.length) {
            case 3: {
                basicProcessInfo.setCommand(stringArray[2]);
            }
            case 2: {
                basicProcessInfo.setUser(stringArray[1]);
            }
            case 1: {
                basicProcessInfo.setPid(stringArray[0]);
            }
        }
        return basicProcessInfo;
    }

    public SendStatusEvent getSendStatusEvent() {
        return this.sendStatusEvent;
    }

    public void setSendStatusEvent(SendStatusEvent sendStatusEvent) {
        this.sendStatusEvent = sendStatusEvent;
    }

    public HashMap<String, String> getEnvironmentVariables() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string = this.getEventData();
        if (string != null && string.trim().length() > 0) {
            hashMap.put(VAR_NAME_SUFFIX, string);
            int n = this.getEventType();
            if (AgentEventMonitorProxy.getTypeCategory(n) == 3) {
                String string2 = this.decodeProcessEventData();
                hashMap.put("PID", string2.getPid());
                hashMap.put("USER", string2.getUser());
                hashMap.put("COMMAND", string2.getCommand());
            }
            if (AgentEventMonitorProxy.getTypeCategory(n) == 1) {
                int n2 = string.lastIndexOf("/");
                if (n2 < 0) {
                    n2 = string.lastIndexOf("\\");
                }
                n2 = n2 < 0 ? string.length() - 1 : n2;
                hashMap.put(VAR_NAME_FILE_SUFFIX, string.substring(n2 + 1));
                hashMap.put(VAR_NAME_PATH_SUFFIX, string.substring(0, n2));
            }
        }
        for (String string2 : hashMap.keySet()) {
            String string3 = (String)hashMap.get(string2);
            if (string3 == null || string3.trim().equals("")) continue;
            String string4 = VAR_NAME_PREFIX;
            string4 = string4 + VAR_NAME_DELIMITER;
            string4 = string4 + this.getEventMonitorName().trim();
            string4 = string4 + VAR_NAME_DELIMITER;
            string4 = string4 + string2;
            hashMap2.put(string4, string3);
        }
        return hashMap2;
    }

    private static void loadErrorCodeDesc() {
        if (errorCodeDesc != null) {
            return;
        }
        errorCodeDesc = new HashMap();
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
        errorCodeDesc.put(1, translationDM.getTranslation("agent_event_history.index.missing_event_oid"));
        errorCodeDesc.put(2, translationDM.getTranslation("agent_event_history.index.missing_agent"));
        errorCodeDesc.put(3, translationDM.getTranslation("agent_event_history.index.time_range_scope"));
        errorCodeDesc.put(4, translationDM.getTranslation("agent_event_history.index.event_held"));
    }

    public static void main(String[] stringArray) {
        AgentEventHistoryInfo.testGetEnvironmentVariables(null, 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("\\", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("\\\\", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("/", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("//", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("a", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("a/b", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("a\\b", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("a/b/c", 101);
        AgentEventHistoryInfo.testGetEnvironmentVariables("a\\b\\c", 101);
    }

    private static void testGetEnvironmentVariables(String string, int n) {
        System.out.println("=======================================================");
        System.out.println("Testing data: " + string);
        try {
            AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo();
            agentEventHistoryInfo.setEventMonitorName("temp");
            agentEventHistoryInfo.setEventData(string);
            agentEventHistoryInfo.setEventType(n);
            HashMap<String, String> hashMap = agentEventHistoryInfo.getEnvironmentVariables();
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                System.out.println("  Entry: " + entry.getKey() + "=" + entry.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

