/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.webservice;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestParametersDM;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestPropertyDM;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestsDM;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WebServiceRequestsDMJdbc
extends AbstractHelpingDatabaseManager
implements WebServiceRequestsDM {
    private static Logger logger = Logger.getLogger(WebServiceRequestsDMJdbc.class);
    private static final String objDesc = "Web Service Requests";
    private static final String WEB_SERVICE_REQUESTS_TABLE = "web_service_commands";
    private static final String WEB_SERVICE_VARIABLES_TABLE = "web_service_variables";
    private String webServiceRequestsTable;
    private String webServiceVariablesTable;
    private WebServiceRequestPropertyDM webServiceRequestPropertyDM;
    private WebServiceRequestParametersDM webServiceRequestParameterDM;

    public WebServiceRequestsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, WebServiceRequestPropertyDM webServiceRequestPropertyDM, WebServiceRequestParametersDM webServiceRequestParametersDM) {
        super(string, string2, sQLManagerHelper);
        this.webServiceRequestPropertyDM = webServiceRequestPropertyDM;
        this.webServiceRequestParameterDM = webServiceRequestParametersDM;
        this.setName("ENTERPRISE.WebServiceRequestsDM");
        this.webServiceRequestsTable = string2 + "." + WEB_SERVICE_REQUESTS_TABLE;
        this.webServiceVariablesTable = string2 + "." + WEB_SERVICE_VARIABLES_TABLE;
    }

    @Override
    public long getWebServiceCRIDViaCommandID(long l) throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            logger.debug((Object)("About to get WebServiceCRID for command ID: " + l));
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id FROM " + this.webServiceRequestsTable + " WHERE command_id=?";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            long l2 = resultSet.getLong("id");
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return l2;
        }
        try {
            try {
                throw new NoDataException("Web Service Requests not found with command ID: " + l);
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public WebServiceRequest getWebServiceRequest(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id, command_id, web_server_definition_id, app_url, request_method, message_body, string_body, file_body, output_type,  output_to_file, output_file_name, url_encode, output_headers_to_file, output_headers_file_name  FROM " + this.webServiceRequestsTable + " WHERE id=?";
            WebServiceRequestGenerator webServiceRequestGenerator = new WebServiceRequestGenerator(14);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            WebServiceRequest webServiceRequest = (WebServiceRequest)webServiceRequestGenerator.generateObject(resultSet);
            this.setWebServiceRequestEnv(webServiceRequest);
            WebServiceRequest webServiceRequest2 = webServiceRequest;
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return webServiceRequest2;
        }
        try {
            try {
                throw new NoDataException("Web Service Requests not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private void setWebServiceRequestEnv(WebServiceRequest webServiceRequest) throws NoDataException, ResourceUnavailableException, BadDataException {
        String string = "SELECT name FROM " + this.webServiceVariablesTable + " WHERE web_service_command_id=? ";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, webServiceRequest.getOID());
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("name"));
            }
            webServiceRequest.setEnvVars(arrayList.toArray(new String[arrayList.size()]));
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for Web Service Variable id {1}.", (Object[])new Object[]{objDesc, Long.toString(webServiceRequest.getOID())});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    @Override
    public WebServiceRequest getByCommand(long l, String string) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            String string2 = "SELECT id, command_id, web_server_definition_id, app_url, request_method, message_body, string_body, file_body, output_type,  output_to_file, output_file_name, url_encode, output_headers_to_file, output_headers_file_name  FROM " + this.webServiceRequestsTable + " WHERE command_id=?";
            wrappedConnection = super.getConnectionOrFail();
            WebServiceRequestGenerator webServiceRequestGenerator = new WebServiceRequestGenerator(14);
            preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            WebServiceRequest webServiceRequest = (WebServiceRequest)webServiceRequestGenerator.generateObject(resultSet);
            webServiceRequest.setDescription(string);
            this.setWebServiceRequestEnv(webServiceRequest);
            WebServiceRequest webServiceRequest2 = webServiceRequest;
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return webServiceRequest2;
        }
        try {
            try {
                throw new NoDataException("Web Service Requests not found.");
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            WebServiceRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class WebServiceRequestGenerator
    extends AbstractBusObjGenerator {
        public WebServiceRequestGenerator(int n) {
            super(n, WebServiceRequestsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new WebServiceRequest();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            WebServiceRequest webServiceRequest = (WebServiceRequest)object;
            switch (n) {
                case 1: {
                    webServiceRequest.setOID(resultSet.getLong("id"));
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        WebServiceRequestsDMJdbc.this.webServiceRequestPropertyDM.loadWebServiceRequestProperty(webServiceRequest, connection);
                    }
                    catch (Exception exception) {
                        String string = "Error while retrieving the Web Service Request Properties for Request ID " + webServiceRequest.getOID();
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                    try {
                        WebServiceRequestsDMJdbc.this.webServiceRequestParameterDM.loadWebServiceRequestParameters(webServiceRequest, connection);
                        break;
                    }
                    catch (Exception exception) {
                        String string = "Error while retrieving the Web Service Request Parameters for Request ID " + webServiceRequest.getOID();
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                }
                case 2: {
                    webServiceRequest.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    webServiceRequest.setWebServiceDefinitionID(resultSet.getLong("web_server_definition_id"));
                    break;
                }
                case 4: {
                    String string = resultSet.getString("app_url");
                    if (string == null) break;
                    webServiceRequest.setAppUrl(string);
                    break;
                }
                case 5: {
                    webServiceRequest.setRequestMethod(resultSet.getInt("request_method"));
                    break;
                }
                case 6: {
                    webServiceRequest.setMessageBody(resultSet.getInt("message_body"));
                    break;
                }
                case 7: {
                    webServiceRequest.setStringBody(resultSet.getString("string_body"));
                    break;
                }
                case 8: {
                    webServiceRequest.setFileBody(resultSet.getString("file_body"));
                    break;
                }
                case 9: {
                    webServiceRequest.setOutputType(resultSet.getInt("output_type"));
                    break;
                }
                case 10: {
                    webServiceRequest.setOutputToFile(resultSet.getBoolean("output_to_file"));
                    break;
                }
                case 11: {
                    webServiceRequest.setOutputFileName(resultSet.getString("output_file_name"));
                    break;
                }
                case 12: {
                    webServiceRequest.setUrlEncode(resultSet.getBoolean("url_encode"));
                    if (!webServiceRequest.getUrlEncode()) break;
                    boolean bl = false;
                    WebServiceRequestProperty[] webServiceRequestPropertyArray = webServiceRequest.getProperties();
                    for (int i = 0; i < webServiceRequestPropertyArray.length; ++i) {
                        WebServiceRequestProperty webServiceRequestProperty = webServiceRequestPropertyArray[i];
                        if (!webServiceRequestProperty.getName().equals("Content-Type")) continue;
                        bl = true;
                    }
                    if (!webServiceRequest.getUrlEncode() || bl) break;
                    WebServiceRequestProperty webServiceRequestProperty = new WebServiceRequestProperty();
                    webServiceRequestProperty.setName("Content-Type");
                    webServiceRequestProperty.setValue("application/x-www-form-urlencoded; charset=UTF-8");
                    webServiceRequest.addProperty(webServiceRequestProperty);
                    break;
                }
                case 13: {
                    webServiceRequest.setOutputHeadersToFile(resultSet.getBoolean("output_headers_to_file"));
                    break;
                }
                case 14: {
                    webServiceRequest.setOutputHeadersFilename(resultSet.getString("output_headers_file_name"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

