/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteConditionsList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PrerequisiteConditionsListJdbc
implements PrerequisiteConditionsList {
    private static final Logger logger = Logger.getLogger(PrerequisiteConditionsListJdbc.class);
    private Connection con;
    private PreparedStatement jobStmt;
    private PreparedStatement eventStmt;
    private ResultSet rs;

    PrerequisiteConditionsListJdbc(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Job Prepared Statement", (Object)preparedStatement);
        ValidationHelper.checkForNull((String)"Event Prepared Statement", (Object)preparedStatement2);
        this.jobStmt = preparedStatement;
        this.eventStmt = preparedStatement2;
        this.con = this.extractConnectionFromStmt();
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public PrerequisiteConditionsList.PrereqConjunction getConjunction() throws ResourceUnavailableException {
        try {
            return PrerequisiteConditionsList.PrereqConjunction.persistanceCodeToEnum(Convert.trimR((String)this.rs.getString("conjunction")));
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public String getReactToStatus() throws ResourceUnavailableException {
        try {
            return this.rs.getString("react_to_status");
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public String getLastStatus() throws ResourceUnavailableException {
        try {
            return this.rs.getString("last_status");
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public int getOid() throws ResourceUnavailableException {
        try {
            return this.rs.getInt("prqsts_oid");
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("", (Throwable)sQLException);
        }
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.jobStmt != null) {
            try {
                this.jobStmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.eventStmt != null) {
            try {
                this.eventStmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    PreparedStatement getEventStmt() {
        return this.eventStmt;
    }

    PreparedStatement getJobStmt() {
        return this.jobStmt;
    }

    Connection getConnection() {
        return this.con;
    }

    void runQuery(PreparedStatement preparedStatement) throws SQLException {
        this.rs = preparedStatement.executeQuery();
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.jobStmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.jobStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }
}

