/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventMonitor;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventMonitorProxy;
import com.helpsystems.enterprise.core.dm.sap.SAPEventMonitorDM;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SAPEventMonitorDMJdbc
extends AbstractDatabaseManager
implements SAPEventMonitorDM {
    private static final String objDesc = "SAP Event Monitor";
    private static Logger logger = Logger.getLogger(SAPEventMonitorDMJdbc.class);
    private static final String SAP_EVENT_MONITOR_TABLE = "sap_event_monitors";
    private static final String SAP_EVENT_MONITOR_FILTER_TABLE = "sap_event_filters";
    private String sapEventMonitorTable;
    private String sapEventMonitorFilterTable;

    public SAPEventMonitorDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.setName("ENTERPRISE.SAPEventMonitorDM");
        this.sapEventMonitorTable = string2 + "." + SAP_EVENT_MONITOR_TABLE;
        this.sapEventMonitorFilterTable = string2 + "." + SAP_EVENT_MONITOR_FILTER_TABLE;
    }

    @Override
    public SAPEventMonitor[] getList(boolean bl) throws ResourceUnavailableException, DataException {
        SAPEventMonitor[] sAPEventMonitorArray = new SAPEventMonitor[]{};
        String string = "SELECT id, name, description, send_email, notification_list_id, from_time, to_time, disabled, days_to_retain, system_defaults_for_event_log_purge, sap_system_definition_id FROM " + this.sapEventMonitorTable;
        if (!bl) {
            string = string + " WHERE disabled = false";
        }
        SAPEventMonitorGenerator sAPEventMonitorGenerator = new SAPEventMonitorGenerator();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            resultSet = preparedStatement.executeQuery();
            ArrayList<SAPEventMonitor> arrayList = new ArrayList<SAPEventMonitor>();
            while (resultSet.next()) {
                SAPEventMonitor sAPEventMonitor = (SAPEventMonitor)((Object)sAPEventMonitorGenerator.generateObject(resultSet));
                arrayList.add(sAPEventMonitor);
            }
            sAPEventMonitorArray = arrayList.toArray(new SAPEventMonitor[arrayList.size()]);
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("SQL error while retrieving SAP Event Monitors.", throwable);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
        return sAPEventMonitorArray;
    }

    @Override
    public SAPEventMonitorProxy[] getProxyList() throws ResourceUnavailableException, DataException {
        SAPEventMonitorProxy[] sAPEventMonitorProxyArray = new SAPEventMonitorProxy[]{};
        SAPEventMonitorProxyGenerator sAPEventMonitorProxyGenerator = new SAPEventMonitorProxyGenerator();
        String string = "SELECT id, name, description, days_to_retain, system_defaults_for_event_log_purge FROM " + this.sapEventMonitorTable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            resultSet = preparedStatement.executeQuery();
            ArrayList<SAPEventMonitorProxy> arrayList = new ArrayList<SAPEventMonitorProxy>();
            while (resultSet.next()) {
                SAPEventMonitorProxy sAPEventMonitorProxy = (SAPEventMonitorProxy)((Object)sAPEventMonitorProxyGenerator.generateObject(resultSet));
                arrayList.add(sAPEventMonitorProxy);
            }
            sAPEventMonitorProxyArray = arrayList.toArray(new SAPEventMonitorProxy[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving SAP Event Monitors.", (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
        return sAPEventMonitorProxyArray;
    }

    public SAPEventMonitor get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public SAPEventMonitor get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        boolean bl;
        block9: {
            SAPEventMonitor sAPEventMonitor;
            block11: {
                block10: {
                    SAPEventMonitor sAPEventMonitor2;
                    bl = false;
                    connection2 = null;
                    SAPEventMonitorGenerator sAPEventMonitorGenerator = new SAPEventMonitorGenerator();
                    String string = "SELECT id, name, description, send_email, notification_list_id, from_time, to_time, disabled, days_to_retain, system_defaults_for_event_log_purge, sap_system_definition_id FROM " + this.sapEventMonitorTable + " WHERE id=?";
                    preparedStatement = null;
                    resultSet = null;
                    if (connection == null) {
                        connection2 = this.getConnection();
                    } else {
                        connection2 = connection;
                        bl = true;
                    }
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    sAPEventMonitor = sAPEventMonitor2 = (SAPEventMonitor)((Object)sAPEventMonitorGenerator.generateObject(resultSet));
                    if (bl) break block10;
                    SAPEventMonitorDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block11;
                }
                SAPEventMonitorDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return sAPEventMonitor;
        }
        try {
            try {
                throw new NoDataException("SAP Event Monitor not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            if (!bl) {
                SAPEventMonitorDMJdbc.closeEm((Connection)connection2, preparedStatement, resultSet);
            } else {
                SAPEventMonitorDMJdbc.closeEm(null, preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    private void loadDataFilter(SAPEventMonitor sAPEventMonitor, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, sap_event_monitor_id, event_name, condition, value FROM " + this.sapEventMonitorFilterTable + " WHERE sap_event_monitor_id=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            preparedStatement.setLong(1, sAPEventMonitor.getID());
            resultSet = preparedStatement.executeQuery();
            DataFilter dataFilter = new DataFilter();
            dataFilter.setDataFilterName(sAPEventMonitor.getName());
            dataFilter.setConjunction(0);
            while (resultSet.next()) {
                try {
                    String string2 = resultSet.getString("event_name");
                    int n = resultSet.getInt("condition");
                    String string3 = resultSet.getString("value");
                    FilterCriteria filterCriteria = new FilterCriteria(string2, (Serializable)((Object)string3), n);
                    dataFilter.addCriteria(filterCriteria);
                }
                catch (Exception exception) {
                    String string4 = "Error while retrieving the data filter.";
                    logger.debug((Object)string4, (Throwable)exception);
                }
            }
            sAPEventMonitor.setDataFilter(dataFilter);
        }
        catch (Exception exception) {
            try {
                String string5 = "Error while retrieving the data filter.";
                logger.debug((Object)string5, (Throwable)exception);
                throw new RuntimeException(string5, exception);
            }
            catch (Throwable throwable) {
                SAPEventMonitorDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPEventMonitorDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    @Override
    public SAPEventMonitor[] getListByServerID(long l, boolean bl) throws ResourceUnavailableException, DataException {
        SAPEventMonitor[] sAPEventMonitorArray = new SAPEventMonitor[]{};
        String string = "SELECT id, name, description, send_email, notification_list_id, from_time, to_time, disabled, days_to_retain, system_defaults_for_event_log_purge, sap_system_definition_id FROM " + this.sapEventMonitorTable + " WHERE sap_system_definition_id = ?";
        if (!bl) {
            string = string + " AND disabled = false";
        }
        SAPEventMonitorGenerator sAPEventMonitorGenerator = new SAPEventMonitorGenerator();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<SAPEventMonitor> arrayList = new ArrayList<SAPEventMonitor>();
            while (resultSet.next()) {
                SAPEventMonitor sAPEventMonitor = (SAPEventMonitor)((Object)sAPEventMonitorGenerator.generateObject(resultSet));
                arrayList.add(sAPEventMonitor);
            }
            sAPEventMonitorArray = arrayList.toArray(new SAPEventMonitor[arrayList.size()]);
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("SQL error while retrieving SAP Event Monitors.", throwable);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
        return sAPEventMonitorArray;
    }

    private class SAPEventMonitorProxyGenerator
    extends AbstractBusObjGenerator {
        public SAPEventMonitorProxyGenerator() {
            super(5, SAPEventMonitorDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPEventMonitorProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPEventMonitorProxy sAPEventMonitorProxy = (SAPEventMonitorProxy)((Object)object);
            switch (n) {
                case 1: {
                    sAPEventMonitorProxy.setID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPEventMonitorProxy.setName(resultSet.getString("name"));
                    break;
                }
                case 3: {
                    sAPEventMonitorProxy.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    sAPEventMonitorProxy.setDaysToRetainHistory(resultSet.getInt("days_to_retain"));
                    break;
                }
                case 5: {
                    sAPEventMonitorProxy.setUseDefaultsForHistoryPurge(resultSet.getBoolean("system_defaults_for_event_log_purge"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class SAPEventMonitorGenerator
    extends AbstractBusObjGenerator {
        public SAPEventMonitorGenerator() {
            super(12, SAPEventMonitorDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPEventMonitor();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPEventMonitor sAPEventMonitor = (SAPEventMonitor)((Object)object);
            switch (n) {
                case 1: {
                    sAPEventMonitor.setID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPEventMonitor.setName(resultSet.getString("name"));
                    break;
                }
                case 3: {
                    sAPEventMonitor.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    sAPEventMonitor.setSendEmail(resultSet.getBoolean("send_email"));
                    break;
                }
                case 5: {
                    sAPEventMonitor.setNotificationListID(resultSet.getLong("notification_list_id"));
                    break;
                }
                case 6: {
                    sAPEventMonitor.setFromTime(resultSet.getInt("from_time"));
                    break;
                }
                case 7: {
                    sAPEventMonitor.setToTime(resultSet.getInt("to_time"));
                    break;
                }
                case 8: {
                    sAPEventMonitor.setDisabled(resultSet.getBoolean("disabled"));
                    break;
                }
                case 9: {
                    sAPEventMonitor.setDaysToRetainHistory(resultSet.getInt("days_to_retain"));
                    break;
                }
                case 10: {
                    sAPEventMonitor.setUseDefaultsForHistoryPurge(resultSet.getBoolean("system_defaults_for_event_log_purge"));
                    break;
                }
                case 11: {
                    sAPEventMonitor.setSAPSystemDefinitionID(resultSet.getLong("sap_system_definition_id"));
                    break;
                }
                case 12: {
                    Connection connection = resultSet.getStatement().getConnection();
                    SAPEventMonitorDMJdbc.this.loadDataFilter(sAPEventMonitor, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

