/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPLanguageKeys;
import com.helpsystems.enterprise.core.dm.sap.SAPABAPStepSetsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SAPABAPStepSetsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPABAPStepSetsDM {
    private static Logger logger = Logger.getLogger(SAPABAPStepSetsDMJdbc.class);
    private static final String objDesc = "SAP ABAP Step Set";
    private static final String SAP_ABAP_STEP_SETS_TABLE = "sap_abap_step_sets";
    private String sapABAPStepSetsTable;
    private static final String SAP_ABAP_STEPS_TABLE = "sap_abap_steps";
    private String sapABAPStepsTable;
    private static final String SAP_PRINT_PARAMETERS_TABLE = "sap_print_parameters";
    private String languageCodesTable;
    private static final String LANGUAGE_CODES_TABLE = "language_codes";
    private String sapPrintParametersTable;

    public SAPABAPStepSetsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPABAPStepSetsDM");
        this.sapABAPStepSetsTable = string2 + "." + SAP_ABAP_STEP_SETS_TABLE;
        this.sapABAPStepsTable = string2 + "." + SAP_ABAP_STEPS_TABLE;
        this.sapPrintParametersTable = string2 + "." + SAP_PRINT_PARAMETERS_TABLE;
        this.languageCodesTable = string2 + "." + LANGUAGE_CODES_TABLE;
    }

    /*
     * Loose catch block
     */
    @Override
    public SAPABAPStepSet get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block9: {
            SAPABAPStepSet sAPABAPStepSet;
            block11: {
                block10: {
                    SAPABAPStepSet sAPABAPStepSet2;
                    connection2 = connection;
                    preparedStatement = null;
                    resultSet = null;
                    if (connection2 == null) {
                        connection2 = super.getConnectionOrFail();
                    }
                    SAPABAPStepSetGenerator sAPABAPStepSetGenerator = new SAPABAPStepSetGenerator();
                    String string = "SELECT id, name, description, sap_abap_set_type FROM " + this.sapABAPStepSetsTable + " WHERE id=?";
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    sAPABAPStepSet = sAPABAPStepSet2 = (SAPABAPStepSet)sAPABAPStepSetGenerator.generateObject(resultSet);
                    if (connection != null) break block10;
                    SAPABAPStepSetsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block11;
                }
                SAPABAPStepSetsDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return sAPABAPStepSet;
        }
        try {
            throw new NoDataException("SAP ABAP Step Set not found.");
            {
                catch (SQLException sQLException) {
                    String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                    throw new ResourceUnavailableException(string, (Throwable)sQLException);
                }
            }
        }
        catch (Throwable throwable) {
            if (connection == null) {
                SAPABAPStepSetsDMJdbc.closeEm((Connection)connection2, preparedStatement, resultSet);
            } else {
                SAPABAPStepSetsDMJdbc.closeEm(null, preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    private void loadSAPABAPSteps(SAPABAPStepSet sAPABAPStepSet, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT t1.id, t1.line_number, t1.sap_abap_program_name, t1.language_code_id, t1.sap_program_variant_name, t1.sap_user_name, t2.id AS sap_print_parameter_id, t3.code FROM " + this.sapABAPStepsTable + " t1 LEFT OUTER JOIN " + this.sapPrintParametersTable + " t2 " + "ON t1.id = t2.sap_abap_step_id " + "LEFT OUTER JOIN " + this.languageCodesTable + " t3 ON t1.language_code_id = t3.id " + "WHERE t1.sap_abap_step_set_id=? ORDER BY t1.line_number";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            preparedStatement.setLong(1, sAPABAPStepSet.getOID());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPABAPStep sAPABAPStep = new SAPABAPStep();
                sAPABAPStep.setOID(resultSet.getLong("id"));
                sAPABAPStep.setLineNumber(resultSet.getInt("line_number"));
                sAPABAPStep.setAbapProgramName(resultSet.getString("sap_abap_program_name"));
                sAPABAPStep.setLanguageCodeID(resultSet.getLong("language_code_id"));
                String string2 = resultSet.getString("code");
                logger.debug((Object)("Found language code: " + string2));
                String string3 = SAPLanguageKeys.getKeyForISOCode(string2);
                logger.debug((Object)("Converted to one char key: " + string3));
                sAPABAPStep.setLanguageCode(string3);
                sAPABAPStep.setAbapProgramVariantName(resultSet.getString("sap_program_variant_name"));
                sAPABAPStep.setSapUserName(resultSet.getString("sap_user_name"));
                sAPABAPStep.setPrintParametersID(resultSet.getLong("sap_print_parameter_id"));
                sAPABAPStepSet.addStep(sAPABAPStep);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = "Error while retrieving the SAP ABAP Steps.";
                logger.debug((Object)string4, (Throwable)exception);
                throw new RuntimeException(string4, exception);
            }
            catch (Throwable throwable) {
                SAPABAPStepSetsDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPABAPStepSetsDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private class SAPABAPStepSetGenerator
    extends AbstractBusObjGenerator {
        public SAPABAPStepSetGenerator() {
            super(5, SAPABAPStepSetsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPABAPStepSet();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPABAPStepSet sAPABAPStepSet = (SAPABAPStepSet)object;
            switch (n) {
                case 1: {
                    sAPABAPStepSet.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    sAPABAPStepSet.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    sAPABAPStepSet.setDescription(string);
                    break;
                }
                case 4: {
                    int n2 = resultSet.getInt("sap_abap_set_type");
                    SAPABAPStepSet.SAPABAPStepSetType sAPABAPStepSetType = SAPABAPStepSet.SAPABAPStepSetType.persistanceCodeToEnum(n2);
                    sAPABAPStepSet.setStepSetType(sAPABAPStepSetType);
                    break;
                }
                case 5: {
                    Connection connection = resultSet.getStatement().getConnection();
                    SAPABAPStepSetsDMJdbc.this.loadSAPABAPSteps(sAPABAPStepSet, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

