/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.oracle;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.oracle.OracleConcurrentRequest;
import com.helpsystems.enterprise.core.busobj.oracle.WaitOption;
import com.helpsystems.enterprise.core.dm.oracle.OracleCRParametersDM;
import com.helpsystems.enterprise.core.dm.oracle.OracleConcurrentRequestsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class OracleConcurrentRequestsDMJdbc
extends AbstractHelpingDatabaseManager
implements OracleConcurrentRequestsDM {
    private static Logger logger = Logger.getLogger(OracleConcurrentRequestsDMJdbc.class);
    private static final String objDesc = "Oracle Concurrent Request";
    private static final String ORACLE_CONCURRENT_REQUESTS_TABLE = "oracle_concurrent_requests";
    private static final String COMMON_SQL_SELECT;
    private String oracleConcurrentRequestsTable;
    private OracleCRParametersDM oracleCRParametersDM;

    public OracleConcurrentRequestsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, OracleCRParametersDM oracleCRParametersDM) {
        super(string, string2, sQLManagerHelper);
        this.oracleCRParametersDM = oracleCRParametersDM;
        this.setName("ENTERPRISE.OracleConcurrentRequestsDM");
        this.oracleConcurrentRequestsTable = string2 + "." + ORACLE_CONCURRENT_REQUESTS_TABLE;
    }

    @Override
    public OracleConcurrentRequest getOracleConcurrentRequest(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            OracleConcurrentRequest oracleConcurrentRequest;
            wrappedConnection = super.getConnectionOrFail();
            String string = COMMON_SQL_SELECT + " FROM " + this.oracleConcurrentRequestsTable + " WHERE id=?";
            OracleConcurrentRequestGenerator oracleConcurrentRequestGenerator = new OracleConcurrentRequestGenerator(NUMBER_OF_FIELDS);
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            OracleConcurrentRequest oracleConcurrentRequest2 = oracleConcurrentRequest = (OracleConcurrentRequest)oracleConcurrentRequestGenerator.generateObject(resultSet);
            OracleConcurrentRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return oracleConcurrentRequest2;
        }
        try {
            try {
                throw new NoDataException("Oracle Concurrent Request not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            OracleConcurrentRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public long getOracleCRIDViaCommandID(long l) throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            logger.debug((Object)("About to get OracleCRID for command ID: " + l));
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT id FROM " + this.oracleConcurrentRequestsTable + " WHERE command_id=?";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            long l2 = resultSet.getLong("id");
            OracleConcurrentRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return l2;
        }
        try {
            try {
                throw new NoDataException("Oracle Concurrent Request not found with command ID: " + l);
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            OracleConcurrentRequestsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    static {
        String string = "SELECT ";
        boolean bl = false;
        for (int i = 0; i < TABLE_COLUMNS.length; ++i) {
            if (bl) {
                string = string + ", ";
            }
            string = string + TABLE_COLUMNS[i];
            bl = true;
        }
        COMMON_SQL_SELECT = string;
    }

    private class OracleConcurrentRequestGenerator
    extends AbstractBusObjGenerator {
        public OracleConcurrentRequestGenerator(int n) {
            super(n, OracleConcurrentRequestsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new OracleConcurrentRequest();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            OracleConcurrentRequest oracleConcurrentRequest = (OracleConcurrentRequest)object;
            switch (n) {
                case 1: {
                    oracleConcurrentRequest.setOID(resultSet.getLong("id"));
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        OracleConcurrentRequestsDMJdbc.this.oracleCRParametersDM.loadOracleParametersForRequest(oracleConcurrentRequest, connection);
                        break;
                    }
                    catch (Exception exception) {
                        String string = "Error while retrieving the Oracle Parameters for Request ID " + oracleConcurrentRequest.getOID();
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                }
                case 2: {
                    oracleConcurrentRequest.setCommandID(resultSet.getLong("command_id"));
                    break;
                }
                case 3: {
                    oracleConcurrentRequest.setOracleSystemDefinitionID(resultSet.getLong("oracle_system_definition_id"));
                    break;
                }
                case 4: {
                    oracleConcurrentRequest.setWaitOption(WaitOption.valueOf(resultSet.getString("wait_option").toUpperCase()));
                    break;
                }
                case 5: {
                    oracleConcurrentRequest.setProgramApplicationShortname(resultSet.getString("prog_appl_shortname"));
                    break;
                }
                case 6: {
                    oracleConcurrentRequest.setConcurrentProgram(resultSet.getString("concurrent_program"));
                    break;
                }
                case 7: {
                    oracleConcurrentRequest.setProgramName(resultSet.getString("program_name"));
                    break;
                }
                case 8: {
                    oracleConcurrentRequest.setPrinterName(resultSet.getString("printer_name"));
                    break;
                }
                case 9: {
                    oracleConcurrentRequest.setNumberOfCopies(resultSet.getInt("number_of_copies"));
                    break;
                }
                case 10: {
                    oracleConcurrentRequest.setPrintStyle(resultSet.getString("print_style"));
                    break;
                }
                case 11: {
                    oracleConcurrentRequest.setLanguage(resultSet.getString("language"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

