/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentJobQueue;
import com.helpsystems.enterprise.core.busobj.CrossAgentJobQueue;
import com.helpsystems.enterprise.core.busobj.JobQueue;
import com.helpsystems.enterprise.core.busobj.JobQueueProxy;
import com.helpsystems.enterprise.core.busobj.JobQueueScheduleEntry;
import com.helpsystems.enterprise.core.busobj.JobQueueType;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JobQueuesDMJdbc
extends AbstractHelpingDatabaseManager
implements JobQueuesDM {
    private static Logger logger = Logger.getLogger(JobQueuesDMJdbc.class);
    private static final String objDesc = "Job Queue";
    private static final String JOB_QUEUES_TABLE = "job_queues";
    private static final String COMMON_SQL_SELECT;
    private String jobQueuesTable;

    public JobQueuesDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobQueuesDM");
        this.jobQueuesTable = string2 + "." + JOB_QUEUES_TABLE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long createDefault(long l, String string) throws Exception {
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            long l2;
            String string2 = "The default queue for " + string;
            wrappedConnection = null;
            String string3 = null;
            preparedStatement = null;
            try {
                string3 = "INSERT INTO " + this.jobQueuesTable + " (target_id, name, description, job_queue_type) values (?, ?, ?, ?)";
                wrappedConnection = this.getConnectionOrFail();
                preparedStatement = wrappedConnection.prepareStatement(string3, 1);
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, "Default");
                preparedStatement.setString(3, string2);
                preparedStatement.setInt(4, JobQueueType.AGENT.persistanceCode());
                preparedStatement.executeUpdate();
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                if (!resultSet.next()) break block5;
                l2 = resultSet.getLong(1);
                if (wrappedConnection == null) return l2;
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                try {
                    throw new Exception("Error Getting Connection ", resourceUnavailableException);
                    catch (SQLException sQLException) {
                        throw new Exception("Error Inserting to " + this.jobQueuesTable + " table ", sQLException);
                    }
                }
                catch (Throwable throwable) {
                    if (wrappedConnection == null) throw throwable;
                    JobQueuesDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            return l2;
        }
        if (wrappedConnection == null) return 0L;
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return 0L;
    }

    @Override
    public long getJobQueueID(long l, String string) throws ResourceUnavailableException, BadDataException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            wrappedConnection = super.getConnectionOrFail();
            String string2 = "SELECT id FROM " + this.jobQueuesTable + " WHERE target_id=? AND name=?";
            preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            long l2 = resultSet.getLong("id");
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return l2;
        }
        try {
            try {
                throw new NoDataException("Job Queue not found for target_id " + l + " and name '" + string + "'.");
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for target_id {1} and name {2}.", (Object[])new Object[]{objDesc, Long.toString(l), string});
                logger.error((Object)string3, (Throwable)sQLException);
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public String getJobQueueName(long l) throws ResourceUnavailableException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT name FROM " + this.jobQueuesTable + " WHERE id=?";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString("name");
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return string2;
        }
        try {
            try {
                throw new NoDataException("Job Queue name not found for id " + l + ".");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} name for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                logger.error((Object)string, (Throwable)sQLException);
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public JobQueueType getJobQueueType(long l) throws ResourceUnavailableException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            wrappedConnection = super.getConnectionOrFail();
            String string = "SELECT job_queue_type FROM " + this.jobQueuesTable + " WHERE id=?";
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            resultSet = null;
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            JobQueueType jobQueueType = JobQueueType.persistanceCodeToEnum(resultSet.getInt("job_queue_type"));
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return jobQueueType;
        }
        try {
            try {
                throw new NoDataException("Job Queue type not found for id " + l + ".");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} type for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                logger.error((Object)string, (Throwable)sQLException);
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public JobQueue getJobQueue(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        return this.getJobQueue(l, null);
    }

    @Override
    public JobQueue getJobQueue(long l, Connection connection) throws NoDataException, ResourceUnavailableException, BadDataException {
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = super.getConnectionOrFail();
        }
        String string = COMMON_SQL_SELECT + " FROM " + this.jobQueuesTable + " WHERE id=?";
        AbstractBusObjGenerator abstractBusObjGenerator = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JobQueue jobQueue;
                JobQueueType jobQueueType = JobQueueType.persistanceCodeToEnum(resultSet.getInt("job_queue_type"));
                switch (jobQueueType) {
                    case AGENT: {
                        abstractBusObjGenerator = new JobQueueGenerator(JobQueuesDM.NUMBER_OF_FIELDS);
                        break;
                    }
                    case CROSS_AGENT: {
                        abstractBusObjGenerator = new CrossAgentJobQueueGenerator(JobQueuesDM.NUMBER_OF_FIELDS);
                    }
                }
                JobQueue jobQueue2 = jobQueue = (JobQueue)((Object)abstractBusObjGenerator.generateObject(resultSet));
                return jobQueue2;
            }
            try {
                throw new NoDataException("Job Queue not found for ID " + l + ".");
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                logger.error((Object)string2, (Throwable)sQLException);
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            if (connection == null) {
                JobQueuesDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHold(long l, boolean bl) {
        String string = "update " + this.jobQueuesTable + " set on_hold=? where id=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                logger.error((Object)"Error updating the job queue's hold state.", (Throwable)exception);
            }
            catch (Throwable throwable) {
                JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
            JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public JobQueueProxy[] getJobQueuesWithSchedules(long l) throws ResourceUnavailableException {
        ArrayList<JobQueueProxy> arrayList = new ArrayList<JobQueueProxy>();
        String string = "select distinct job_queue_id from job_queue_schedule_entries where enabled = true";
        String string2 = "select * from job_queues where ((next_scheduled_update_utc is null) or (next_scheduled_update_utc < ?)) and id in (" + string + ")";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            JobQueueProxyGenerator jobQueueProxyGenerator = null;
            jobQueueProxyGenerator = new JobQueueProxyGenerator(JobQueuesDM.NUMBER_OF_FIELDS);
            while (resultSet.next()) {
                try {
                    JobQueueProxy jobQueueProxy = (JobQueueProxy)((Object)jobQueueProxyGenerator.generateObject(resultSet));
                    arrayList.add(jobQueueProxy);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error loading job queue.", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            try {
                String string3 = "Error loading the job queue list.";
                throw new ResourceUnavailableException(string3, (Throwable)exception);
            }
            catch (Throwable throwable) {
                JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return arrayList.toArray(new JobQueueProxy[arrayList.size()]);
    }

    @Override
    public JobQueueProxy[] getByHoldStatus(boolean bl) throws ResourceUnavailableException {
        ArrayList<JobQueueProxy> arrayList = new ArrayList<JobQueueProxy>();
        String string = "select * from job_queues where on_hold = ?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            resultSet = preparedStatement.executeQuery();
            JobQueueProxyGenerator jobQueueProxyGenerator = null;
            jobQueueProxyGenerator = new JobQueueProxyGenerator(JobQueuesDM.NUMBER_OF_FIELDS);
            while (resultSet.next()) {
                try {
                    JobQueueProxy jobQueueProxy = (JobQueueProxy)((Object)jobQueueProxyGenerator.generateObject(resultSet));
                    arrayList.add(jobQueueProxy);
                }
                catch (Exception exception) {
                    logger.error((Object)"Error loading job queue.", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            try {
                String string2 = "Error loading the job queue list.";
                throw new ResourceUnavailableException(string2, (Throwable)exception);
            }
            catch (Throwable throwable) {
                JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return arrayList.toArray(new JobQueueProxy[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobQueueFromScheduleEntry(JobQueueScheduleEntry jobQueueScheduleEntry, long l, long l2) throws ResourceUnavailableException {
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block6: {
            if (jobQueueScheduleEntry == null) {
                throw new NullPointerException("JobQueueScheduleEntry is null in JobQueuesDMJdbc.updateJobQueueFromScheduleEntry.");
            }
            logger.debug((Object)("Updating Job Queue with ID " + jobQueueScheduleEntry.getJobQueueID() + " using Job Queue Schedule Entry '" + jobQueueScheduleEntry.getName() + "'."));
            if (!jobQueueScheduleEntry.isEnabled()) {
                logger.debug((Object)("Job Queue update ignored. Job Queue Schedule Entry '" + jobQueueScheduleEntry.getName() + "' is disabled."));
            }
            String string = "update job_queues set limit_active_jobs=?, max_active_jobs=?, limiter_enabled=?, limiter_minimum_priority=?, limiter_max_active=?, limit_active_per_agent=?, max_active_per_agent=?, hold_on_failure=?, last_updated_utc=?, last_updated_info=?, next_scheduled_update_utc=? where id=?";
            wrappedConnection = null;
            preparedStatement = null;
            try {
                wrappedConnection = this.getConnection();
                preparedStatement = wrappedConnection.prepareStatement(string);
                preparedStatement.setBoolean(1, jobQueueScheduleEntry.isLimitActiveJobs());
                preparedStatement.setInt(2, jobQueueScheduleEntry.getMaxActiveJobs());
                preparedStatement.setBoolean(3, jobQueueScheduleEntry.isLimiterEnabled());
                preparedStatement.setInt(4, jobQueueScheduleEntry.getLimiterMinimumPriority());
                preparedStatement.setInt(5, jobQueueScheduleEntry.getLimiterMaximumActive());
                preparedStatement.setBoolean(6, jobQueueScheduleEntry.isLimitActivePerAgent());
                preparedStatement.setInt(7, jobQueueScheduleEntry.getMaxActivePerAgent());
                preparedStatement.setBoolean(8, jobQueueScheduleEntry.isHoldOnFailure());
                preparedStatement.setLong(9, l);
                preparedStatement.setString(10, jobQueueScheduleEntry.getName());
                preparedStatement.setLong(11, l2);
                preparedStatement.setLong(12, jobQueueScheduleEntry.getJobQueueID());
                int n = preparedStatement.executeUpdate();
                if (n != 0) break block6;
                throw new NoDataException("No records we updated for a Job Queue with ID " + jobQueueScheduleEntry.getId() + " for Job Queue Schedule Entry '" + jobQueueScheduleEntry.getName() + "'.");
            }
            catch (Exception exception) {
                try {
                    String string2 = "Error updating the job queue based on the Job Queue Schedule Entry.";
                    logger.error((Object)string2, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
                JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            }
        }
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobQueueNextScheduleTime(long l, long l2) throws ResourceUnavailableException {
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating Job Queue with ID " + l + " with next scheduled update time: " + ScheduleLogger.formatTimeStampSecs(l2)));
            }
            String string = "update job_queues set next_scheduled_update_utc=? where id=?";
            wrappedConnection = null;
            preparedStatement = null;
            try {
                wrappedConnection = this.getConnection();
                preparedStatement = wrappedConnection.prepareStatement(string);
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                int n = preparedStatement.executeUpdate();
                if (n != 0) break block5;
                throw new NoDataException("No records we updated for a Job Queue with ID " + l + ".");
            }
            catch (Exception exception) {
                try {
                    String string2 = "Error updating the Job Queue next scheduled update timestamp.";
                    logger.error((Object)string2, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
                JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            }
        }
        JobQueuesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    static {
        String string = "SELECT ";
        boolean bl = false;
        for (int i = 0; i < TABLE_COLUMNS.length; ++i) {
            if (bl) {
                string = string + ", ";
            }
            string = string + TABLE_COLUMNS[i];
            bl = true;
        }
        COMMON_SQL_SELECT = string;
    }

    private class CrossAgentJobQueueGenerator
    extends AbstractBusObjGenerator {
        public CrossAgentJobQueueGenerator(int n) {
            super(n, JobQueuesDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new CrossAgentJobQueue();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobQueueProxy jobQueueProxy = (JobQueueProxy)((Object)object);
            switch (n) {
                case 1: {
                    jobQueueProxy.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setDescription(string);
                    break;
                }
                case 4: {
                    jobQueueProxy.setJobQueueType(JobQueueType.persistanceCodeToEnum(resultSet.getInt("job_queue_type")));
                    break;
                }
                case 5: {
                    jobQueueProxy.setTargetID(resultSet.getLong("target_id"));
                    break;
                }
                case 6: {
                    jobQueueProxy.setLimitActiveJobs(resultSet.getBoolean("limit_active_jobs"));
                    break;
                }
                case 7: {
                    jobQueueProxy.setMaxActiveJobs(resultSet.getInt("max_active_jobs"));
                    break;
                }
                case 8: {
                    jobQueueProxy.setOnHold(resultSet.getBoolean("on_hold"));
                    break;
                }
                case 9: {
                    jobQueueProxy.setLimiterEnabled(resultSet.getBoolean("limiter_enabled"));
                    break;
                }
                case 10: {
                    jobQueueProxy.setLimiterMinimumPriority(resultSet.getInt("limiter_minimum_priority"));
                    break;
                }
                case 11: {
                    jobQueueProxy.setLimiterMaxActive(resultSet.getInt("limiter_max_active"));
                    break;
                }
                case 12: {
                    jobQueueProxy.setLimitActivePerAgent(resultSet.getBoolean("limit_active_per_agent"));
                    break;
                }
                case 13: {
                    jobQueueProxy.setMaxActivePerAgent(resultSet.getInt("max_active_per_agent"));
                    break;
                }
                case 14: {
                    jobQueueProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 15: {
                    jobQueueProxy.setLastUpdatedUTC(resultSet.getLong("last_updated_utc"));
                    break;
                }
                case 16: {
                    jobQueueProxy.setLastUpdatedInfo(resultSet.getString("last_updated_info"));
                    break;
                }
                case 17: {
                    jobQueueProxy.setNextScheduledUpdateUTC(resultSet.getLong("next_scheduled_update_utc"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class JobQueueGenerator
    extends AbstractBusObjGenerator {
        public JobQueueGenerator(int n) {
            super(n, JobQueuesDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new AgentJobQueue();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobQueueProxy jobQueueProxy = (JobQueueProxy)((Object)object);
            switch (n) {
                case 1: {
                    jobQueueProxy.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setDescription(string);
                    break;
                }
                case 4: {
                    jobQueueProxy.setJobQueueType(JobQueueType.persistanceCodeToEnum(resultSet.getInt("job_queue_type")));
                    break;
                }
                case 5: {
                    jobQueueProxy.setTargetID(resultSet.getLong("target_id"));
                    break;
                }
                case 6: {
                    jobQueueProxy.setLimitActiveJobs(resultSet.getBoolean("limit_active_jobs"));
                    break;
                }
                case 7: {
                    jobQueueProxy.setMaxActiveJobs(resultSet.getInt("max_active_jobs"));
                    break;
                }
                case 8: {
                    jobQueueProxy.setOnHold(resultSet.getBoolean("on_hold"));
                    break;
                }
                case 9: {
                    jobQueueProxy.setLimiterEnabled(resultSet.getBoolean("limiter_enabled"));
                    break;
                }
                case 10: {
                    jobQueueProxy.setLimiterMinimumPriority(resultSet.getInt("limiter_minimum_priority"));
                    break;
                }
                case 11: {
                    jobQueueProxy.setLimiterMaxActive(resultSet.getInt("limiter_max_active"));
                    break;
                }
                case 12: {
                    jobQueueProxy.setLimitActivePerAgent(resultSet.getBoolean("limit_active_per_agent"));
                    break;
                }
                case 13: {
                    jobQueueProxy.setMaxActivePerAgent(resultSet.getInt("max_active_per_agent"));
                    break;
                }
                case 14: {
                    jobQueueProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 15: {
                    jobQueueProxy.setLastUpdatedUTC(resultSet.getLong("last_updated_utc"));
                    break;
                }
                case 16: {
                    jobQueueProxy.setLastUpdatedInfo(resultSet.getString("last_updated_info"));
                    break;
                }
                case 17: {
                    jobQueueProxy.setNextScheduledUpdateUTC(resultSet.getLong("next_scheduled_update_utc"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class JobQueueProxyGenerator
    extends AbstractBusObjGenerator {
        public JobQueueProxyGenerator(int n) {
            super(n, JobQueuesDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new JobQueueProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobQueueProxy jobQueueProxy = (JobQueueProxy)((Object)object);
            switch (n) {
                case 1: {
                    jobQueueProxy.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    jobQueueProxy.setDescription(string);
                    break;
                }
                case 4: {
                    jobQueueProxy.setJobQueueType(JobQueueType.persistanceCodeToEnum(resultSet.getInt("job_queue_type")));
                    break;
                }
                case 5: {
                    jobQueueProxy.setTargetID(resultSet.getLong("target_id"));
                    break;
                }
                case 6: {
                    jobQueueProxy.setLimitActiveJobs(resultSet.getBoolean("limit_active_jobs"));
                    break;
                }
                case 7: {
                    jobQueueProxy.setMaxActiveJobs(resultSet.getInt("max_active_jobs"));
                    break;
                }
                case 8: {
                    jobQueueProxy.setOnHold(resultSet.getBoolean("on_hold"));
                    break;
                }
                case 9: {
                    jobQueueProxy.setLimiterEnabled(resultSet.getBoolean("limiter_enabled"));
                    break;
                }
                case 10: {
                    jobQueueProxy.setLimiterMinimumPriority(resultSet.getInt("limiter_minimum_priority"));
                    break;
                }
                case 11: {
                    jobQueueProxy.setLimiterMaxActive(resultSet.getInt("limiter_max_active"));
                    break;
                }
                case 12: {
                    jobQueueProxy.setLimitActivePerAgent(resultSet.getBoolean("limit_active_per_agent"));
                    break;
                }
                case 13: {
                    jobQueueProxy.setMaxActivePerAgent(resultSet.getInt("max_active_per_agent"));
                    break;
                }
                case 14: {
                    jobQueueProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 15: {
                    jobQueueProxy.setLastUpdatedUTC(resultSet.getLong("last_updated_utc"));
                    break;
                }
                case 16: {
                    jobQueueProxy.setLastUpdatedInfo(resultSet.getString("last_updated_info"));
                    break;
                }
                case 17: {
                    jobQueueProxy.setNextScheduledUpdateUTC(resultSet.getLong("next_scheduled_update_utc"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

