/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.JobQueueScheduleEntry;
import com.helpsystems.enterprise.core.dm.JobQueueScheduleEntryDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JobQueueScheduleEntryDMJdbc
extends AbstractHelpingDatabaseManager
implements JobQueueScheduleEntryDM {
    private static final Logger logger = Logger.getLogger(JobQueueScheduleEntryDMJdbc.class);
    private static final String TABLE = "job_queue_schedule_entries";

    public JobQueueScheduleEntryDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobQueueScheduleEntryDM");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobQueueScheduleEntry[] getEntriesForQueue(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<JobQueueScheduleEntry> arrayList = new ArrayList<JobQueueScheduleEntry>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading Job Queue Schedule Entries for Job Queue ID: " + l));
            }
            String string = "SELECT * FROM job_queue_schedule_entries WHERE job_queue_id = ?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Running Query: " + string));
            }
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("id");
                String string2 = resultSet.getString("name");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading Job Queue Schedule Entry: " + string2 + "(" + l2 + ")"));
                }
                JobQueueScheduleEntry jobQueueScheduleEntry = new JobQueueScheduleEntry();
                jobQueueScheduleEntry.setId(l2);
                jobQueueScheduleEntry.setName(string2);
                jobQueueScheduleEntry.setDescription(resultSet.getString("description"));
                jobQueueScheduleEntry.setJobQueueID(resultSet.getLong("job_queue_id"));
                jobQueueScheduleEntry.setEnabled(resultSet.getBoolean("enabled"));
                jobQueueScheduleEntry.setStartTime(resultSet.getInt("start_time"));
                jobQueueScheduleEntry.setValidMonday(resultSet.getBoolean("valid_monday"));
                jobQueueScheduleEntry.setValidTuesday(resultSet.getBoolean("valid_tuesday"));
                jobQueueScheduleEntry.setValidWednesday(resultSet.getBoolean("valid_wednesday"));
                jobQueueScheduleEntry.setValidThursday(resultSet.getBoolean("valid_thursday"));
                jobQueueScheduleEntry.setValidFriday(resultSet.getBoolean("valid_friday"));
                jobQueueScheduleEntry.setValidSaturday(resultSet.getBoolean("valid_saturday"));
                jobQueueScheduleEntry.setValidSunday(resultSet.getBoolean("valid_sunday"));
                jobQueueScheduleEntry.setLimitActiveJobs(resultSet.getBoolean("limit_active_jobs"));
                jobQueueScheduleEntry.setMaxActiveJobs(resultSet.getInt("max_active_jobs"));
                jobQueueScheduleEntry.setLimiterEnabled(resultSet.getBoolean("limiter_enabled"));
                jobQueueScheduleEntry.setLimiterMinimumPriority(resultSet.getInt("limiter_minimum_priority"));
                jobQueueScheduleEntry.setLimiterMaximumActive(resultSet.getInt("limiter_max_active"));
                jobQueueScheduleEntry.setLimitActivePerAgent(resultSet.getBoolean("limit_active_per_agent"));
                jobQueueScheduleEntry.setMaxActivePerAgent(resultSet.getInt("max_active_per_agent"));
                jobQueueScheduleEntry.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                arrayList.add(jobQueueScheduleEntry);
            }
            if (wrappedConnection == null) return arrayList.toArray(new JobQueueScheduleEntry[arrayList.size()]);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            try {
                throw resourceUnavailableException;
                catch (SQLException sQLException) {
                    throw new ResourceUnavailableException("SQL Error loading Job Queue Schedule Entry.", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                if (wrappedConnection == null) throw throwable;
                JobQueueScheduleEntryDMJdbc.closeEm(wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        JobQueueScheduleEntryDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList.toArray(new JobQueueScheduleEntry[arrayList.size()]);
    }
}

