/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.FileTransferSystem;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionR02M03;
import com.helpsystems.enterprise.core.busobj.JobConditionType;
import com.helpsystems.enterprise.core.dm.JobConditionDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class JobConditionDMJdbc
extends AbstractHelpingDatabaseManager
implements JobConditionDM {
    private static final String objDesc = "Job Condition";
    private static final String TABLE = "job_conditions";
    private static final String FILE_TRANSFER_SYSTEMS_TABLE = "file_transfer_systems";
    private static final Logger logger = Logger.getLogger(JobConditionDMJdbc.class);
    JobConditionGenerator jobConditionGenerator = new JobConditionGenerator();
    JobConditionR02M03Generator jobConditionR02M03Generator = new JobConditionR02M03Generator();

    public JobConditionDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobConditionDM");
    }

    @Override
    public JobCondition[] getList(long l, JobCondition jobCondition) throws ResourceUnavailableException, DataException {
        String string = this.getSqlStatement(l);
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        ResultSet resultSet = null;
        if (wrappedConnection == null) {
            wrappedConnection = super.getConnectionOrFail();
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        try {
            resultSet = preparedStatement.executeQuery();
            if (jobCondition instanceof JobConditionR02M03) {
                JobCondition[] jobConditionArray = (JobConditionR02M03[])this.jobConditionR02M03Generator.generateObjectArray(resultSet);
                return jobConditionArray;
            }
            JobCondition[] jobConditionArray = (JobCondition[])this.jobConditionGenerator.generateObjectArray(resultSet);
            return jobConditionArray;
        }
        catch (SQLException sQLException) {
            String string2 = "Unable to retrieve the list of Job Conditions.";
            logger.debug((Object)"Error Selecting Job Conditions", (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            JobConditionDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        }
    }

    @Override
    public void fillJobConditionFromFTS(JobConditionR02M03 jobConditionR02M03) throws ResourceUnavailableException, DataException {
        FileTransferSystem fileTransferSystem = this.loadFTSById(jobConditionR02M03.getConditionVar1());
        jobConditionR02M03.setFileSystemName(fileTransferSystem.getName());
        jobConditionR02M03.setConditionData(fileTransferSystem.getSystemName());
        jobConditionR02M03.setConditionVar1(fileTransferSystem.getPort());
        jobConditionR02M03.setConditionData1(fileTransferSystem.getUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileTransferSystem loadFTSById(long l) throws ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        FileTransferSystem fileTransferSystem = new FileTransferSystem();
        String string = "SELECT id, name, description, transfer_type, system_name, port FROM file_transfer_systems WHERE id = ?";
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                try {
                    fileTransferSystem.setName(resultSet.getString("name"));
                    fileTransferSystem.setDescription(resultSet.getString("description"));
                    fileTransferSystem.setTransferType(resultSet.getInt("transfer_type"));
                    fileTransferSystem.setSystemName(resultSet.getString("system_name"));
                    fileTransferSystem.setPort(resultSet.getInt("port"));
                }
                catch (Exception exception) {
                    String string2 = "Error while retrieving the File Transfer System.";
                    logger.debug((Object)string2, (Throwable)exception);
                }
            }
            if (wrappedConnection == null) return fileTransferSystem;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Error getting connection.", (Throwable)resourceUnavailableException);
            return fileTransferSystem;
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("Error loading the File Transfer System for specified ID: " + l), (Throwable)sQLException);
            if (wrappedConnection == null) return fileTransferSystem;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            JobConditionDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return fileTransferSystem;
        }
        finally {
            if (wrappedConnection != null) {
                JobConditionDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            }
        }
        JobConditionDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return fileTransferSystem;
    }

    private String getSqlStatement(long l) {
        return "SELECT id, job_id, sequence_number, condition_type, condition_data, condition_var1, condition_var2, condition_choice, conjunction, condition_data1 FROM job_conditions WHERE job_id = " + l;
    }

    private class JobConditionR02M03Generator
    extends AbstractBusObjGenerator {
        public JobConditionR02M03Generator() {
            super(10, JobConditionDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new JobConditionR02M03();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobConditionR02M03 jobConditionR02M03 = (JobConditionR02M03)((Object)object);
            switch (n) {
                case 1: {
                    jobConditionR02M03.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    jobConditionR02M03.setJobId(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    jobConditionR02M03.setSequenceNumber(resultSet.getInt("sequence_number"));
                    break;
                }
                case 4: {
                    jobConditionR02M03.setConditionType(JobConditionType.persistanceCodeToEnum((int)resultSet.getLong("condition_type")));
                    break;
                }
                case 5: {
                    jobConditionR02M03.setConditionData(resultSet.getString("condition_data"));
                    break;
                }
                case 6: {
                    jobConditionR02M03.setConditionVar1(resultSet.getInt("condition_var1"));
                    break;
                }
                case 7: {
                    jobConditionR02M03.setConditionVar2(resultSet.getInt("condition_var2"));
                    break;
                }
                case 8: {
                    jobConditionR02M03.setConditionChoice(resultSet.getBoolean("condition_choice"));
                    break;
                }
                case 9: {
                    jobConditionR02M03.setConjunction(resultSet.getString("conjunction"));
                    break;
                }
                case 10: {
                    jobConditionR02M03.setConditionData1(resultSet.getString("condition_data1"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class JobConditionGenerator
    extends AbstractBusObjGenerator {
        public JobConditionGenerator() {
            super(10, JobConditionDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new JobCondition();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobCondition jobCondition = (JobCondition)((Object)object);
            switch (n) {
                case 1: {
                    jobCondition.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    jobCondition.setJobId(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    jobCondition.setSequenceNumber(resultSet.getInt("sequence_number"));
                    break;
                }
                case 4: {
                    jobCondition.setConditionType(JobConditionType.persistanceCodeToEnum((int)resultSet.getLong("condition_type")));
                    break;
                }
                case 5: {
                    jobCondition.setConditionData(resultSet.getString("condition_data"));
                    break;
                }
                case 6: {
                    jobCondition.setConditionVar1(resultSet.getInt("condition_var1"));
                    break;
                }
                case 7: {
                    jobCondition.setConditionVar2(resultSet.getInt("condition_var2"));
                    break;
                }
                case 8: {
                    jobCondition.setConditionChoice(resultSet.getBoolean("condition_choice"));
                    break;
                }
                case 9: {
                    jobCondition.setConjunction(resultSet.getString("conjunction"));
                    break;
                }
                case 10: {
                    jobCondition.setConditionData1(resultSet.getString("condition_data1"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

