/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.encryption.AESUtils;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.FileTransfer;
import com.helpsystems.enterprise.core.busobj.FileTransferSystem;
import com.helpsystems.enterprise.core.busobj.SqlServerJob;
import com.helpsystems.enterprise.core.busobj.SqlServerSystem;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPARequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskCommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskRequestComposite;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudCommand;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudServer;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaRepository;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Parameter;
import com.helpsystems.enterprise.core.dm.AgentReturnCodeDM;
import com.helpsystems.enterprise.core.dm.CommandSetDM;
import com.helpsystems.enterprise.core.dm.automate.AutoMateBPACommandsDM;
import com.helpsystems.enterprise.core.dm.automate.AutoMateCommandsDM;
import com.helpsystems.enterprise.core.dm.automate.AutoMateSystemDefinitionsDM;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaCloudCommandsDM;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaCloudServersDM;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaRepositoriesDM;
import com.helpsystems.enterprise.core.dm.informatica.InformaticaWorkflowCommandsDM;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceRequestsDM;
import com.helpsystems.enterprise.core.dm.webservices.WebServiceServerDM;
import com.helpsystems.enterprise.core.enums.CommandSetType;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommand;
import com.helpsystems.enterprise.core.uc.UniversalConnectorCommandDM;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class CommandSetDMJdbc
extends AbstractDatabaseManager
implements CommandSetDM {
    private static final String objDesc = "Command Set";
    private static Logger logger = Logger.getLogger(CommandSetDMJdbc.class);
    private static final String COMMAND_SETS_TABLE = "command_sets";
    private String commandSetsTable;
    private static final String COMMANDS_TABLE = "commands";
    private String commandsTable;
    private static final String FILE_TRANSFERS_TABLE = "file_transfers";
    private String fileTransfersTable;
    private static final String FILE_TRANSFER_SYSTEMS_TABLE = "file_transfer_systems";
    private String fileTransferSystemsTable;
    private static final String SQL_SERVER_COMMANDS_TABLE = "sql_server_commands";
    private String _sqlServerCommandsTable;
    private static final String SQL_SERVER_DEFINITIONS_TABLE = "sql_server_definitions";
    private String _sqlServerDefinitionsTable;
    private AgentReturnCodeDM agentReturnCodeDM;
    private static final String INFA_WF_CMD_TABLE = "informatica_workflow_commands";
    private String infaWfCmdTable;
    private static final String INFA_REPO_TABLE = "informatica_repositories";
    private String infaRepoTable;

    public CommandSetDMJdbc(String string, String string2, AgentReturnCodeDM agentReturnCodeDM) {
        super(string);
        this.setName("ENTERPRISE.CommandSetDM");
        this.commandSetsTable = string2 + "." + COMMAND_SETS_TABLE;
        this.commandsTable = string2 + "." + COMMANDS_TABLE;
        this.fileTransfersTable = string2 + "." + FILE_TRANSFERS_TABLE;
        this.fileTransferSystemsTable = string2 + "." + FILE_TRANSFER_SYSTEMS_TABLE;
        this._sqlServerCommandsTable = string2 + "." + SQL_SERVER_COMMANDS_TABLE;
        this._sqlServerDefinitionsTable = string2 + "." + SQL_SERVER_DEFINITIONS_TABLE;
        this.infaWfCmdTable = string2 + "." + INFA_WF_CMD_TABLE;
        this.infaRepoTable = string2 + "." + INFA_REPO_TABLE;
        this.agentReturnCodeDM = agentReturnCodeDM;
    }

    @Override
    public CommandSet get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        CommandSetGenerator commandSetGenerator = new CommandSetGenerator();
        String string = "SELECT id, name, description, command_set_type FROM " + this.commandSetsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                CommandSet commandSet = (CommandSet)((Object)commandSetGenerator.generateObject(resultSet));
                return commandSet;
            }
            throw new NoDataException("Command not found.");
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommands(CommandSet commandSet, Connection connection) throws SQLException, ResourceUnavailableException {
        AgentReturnCode agentReturnCode = null;
        String string = "SELECT id, line_number, command_string, error_handling, return_code_id, command_type, wait, retries_count, wait_count, error_handling_retry FROM " + this.commandsTable + " WHERE command_set_id=? " + " ORDER BY line_number";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            Object object;
            preparedStatement.setLong(1, commandSet.getOid());
            resultSet = preparedStatement.executeQuery();
            boolean bl = false;
            agentReturnCode = this.agentReturnCodeDM.getStandard(connection);
            while (resultSet.next()) {
                object = new CommandSetCommand();
                try {
                    String string2 = resultSet.getString("command_string");
                    int n = resultSet.getInt("command_type");
                    ((CommandSetCommand)((Object)object)).setCommandType(n);
                    if (string2 == null) {
                        string2 = "";
                    }
                    ((CommandSetCommand)((Object)object)).setCommandString(string2);
                    ((CommandSetCommand)((Object)object)).setOid(resultSet.getInt("id"));
                    ((CommandSetCommand)((Object)object)).setLineNumber(resultSet.getInt("line_number"));
                    ((CommandSetCommand)((Object)object)).setCancelOnError(resultSet.getBoolean("error_handling"));
                    ((CommandSetCommand)((Object)object)).setErrorHandlingRetry(resultSet.getBoolean("error_handling_retry"));
                    int n2 = resultSet.getInt("retries_count");
                    if (n2 == 0) {
                        ((CommandSetCommand)((Object)object)).setErrorHandlingRetry(false);
                    }
                    ((CommandSetCommand)((Object)object)).setRetriesCount(resultSet.getInt("retries_count"));
                    ((CommandSetCommand)((Object)object)).setWaitCount(resultSet.getInt("wait_count"));
                    ((CommandSetCommand)((Object)object)).setWaitOnGui(resultSet.getBoolean("wait"));
                    long l = resultSet.getLong("return_code_id");
                    AgentReturnCode agentReturnCode2 = null;
                    if (l == 0L || l == agentReturnCode.getOid()) {
                        ((CommandSetCommand)((Object)object)).setReturnCode(agentReturnCode);
                    } else {
                        agentReturnCode2 = this.getReturnCode(l, connection);
                        ((CommandSetCommand)((Object)object)).setReturnCode(agentReturnCode2);
                    }
                    if (n == 1) {
                        this.loadFileTransfers((CommandSetCommand)((Object)object), connection);
                    } else if (n == 2) {
                        this.loadSqlJob((CommandSetCommand)((Object)object), connection);
                    } else if (n == 8) {
                        this.loadInfaWfCmd((CommandSetCommand)((Object)object));
                    } else if (n == 10) {
                        this.loadWebServiceCmd((CommandSetCommand)((Object)object));
                    } else if (n == 12) {
                        this.loadInfaCloudCmd((CommandSetCommand)((Object)object));
                    } else if (n == 13) {
                        this.loadAutoMateTaskCommand((CommandSetCommand)((Object)object));
                    } else if (n == 14) {
                        this.loadAutoMateBPACommand((CommandSetCommand)((Object)object));
                    } else if (n == 15) {
                        this.loadUniversalConnectorCommand((CommandSetCommand)((Object)object), connection);
                    }
                }
                catch (Exception exception) {
                    bl = true;
                    String string3 = "Error while retrieving the commands.";
                    logger.debug((Object)string3, (Throwable)exception);
                }
                finally {
                    ((AbstractBusinessObject)((Object)object)).setPersistent(true);
                }
                commandSet.addCommand((CommandSetCommand)((Object)object));
            }
            if (bl) {
                object = "One or more errors ocurred while retrieving the commands. Please see the error log for details.";
                throw new IllegalStateException((String)object);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = "Error while retrieving the commands.";
                logger.debug((Object)string4, (Throwable)exception);
                throw new RuntimeException(string4, exception);
            }
            catch (Throwable throwable) {
                CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private void loadAutoMateBPACommand(CommandSetCommand commandSetCommand) throws Exception {
        AutoMateBPARequestComposite autoMateBPARequestComposite = new AutoMateBPARequestComposite();
        long l = commandSetCommand.getOid();
        AutoMateBPACommandsDM autoMateBPACommandsDM = (AutoMateBPACommandsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AutoMateBPACommandsDM");
        try {
            AutoMateBPACommand autoMateBPACommand = autoMateBPACommandsDM.getAutoMateBPACommandViaCommandID(l);
            autoMateBPARequestComposite.setAutoMateBPACommand(autoMateBPACommand);
            AutoMateSystemDefinitionsDM autoMateSystemDefinitionsDM = (AutoMateSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AutoMateSystemDefinitionsDM");
            AutoMateSystemDefinition autoMateSystemDefinition = autoMateSystemDefinitionsDM.getAutoMateSystemDefinition(autoMateBPACommand.getAutoMateSystemDefinitionID());
            autoMateBPARequestComposite.setAutoMateSystemDefinition(autoMateSystemDefinition);
            commandSetCommand.setAutoMateBPARequest(autoMateBPARequestComposite);
        }
        catch (Exception exception) {
            throw new Exception("Error retrieving AutoMate BPA Command.", exception);
        }
    }

    private void loadAutoMateTaskCommand(CommandSetCommand commandSetCommand) throws Exception {
        AutoMateTaskRequestComposite autoMateTaskRequestComposite = new AutoMateTaskRequestComposite();
        long l = commandSetCommand.getOid();
        AutoMateCommandsDM autoMateCommandsDM = (AutoMateCommandsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AutoMateCommandsDM");
        AutoMateSystemDefinitionsDM autoMateSystemDefinitionsDM = (AutoMateSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AutoMateSystemDefinitionsDM");
        try {
            AutoMateTaskCommand autoMateTaskCommand = autoMateCommandsDM.getAutoMateTaskCommandViaCommandID(l);
            autoMateTaskRequestComposite.setAutoMateTaskCommand(autoMateTaskCommand);
            AutoMateSystemDefinition autoMateSystemDefinition = autoMateSystemDefinitionsDM.getAutoMateSystemDefinition(autoMateTaskCommand.getAutoMateSystemDefinitionID());
            autoMateTaskRequestComposite.setAutoMateSystemDefinition(autoMateSystemDefinition);
            commandSetCommand.setAutoMateTaskRequest(autoMateTaskRequestComposite);
        }
        catch (Exception exception) {
            throw new Exception("Error retrieving AutoMate Task Command.", exception);
        }
    }

    private void loadSqlJob(CommandSetCommand commandSetCommand, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, command_id, sql_server_definition_id, name, verbose_output FROM " + this._sqlServerCommandsTable + " " + "WHERE command_id = ? ";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, commandSetCommand.getOid());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new Exception("No SQL Server Job data returned from database!");
            }
            SqlServerJob sqlServerJob = new SqlServerJob();
            sqlServerJob.setOid(resultSet.getInt("id"));
            SqlServerSystem sqlServerSystem = new SqlServerSystem();
            sqlServerSystem.setOid(resultSet.getInt("sql_server_definition_id"));
            sqlServerJob.set_sqlServerSystem(sqlServerSystem);
            this.loadSqlServerSystem(sqlServerJob, connection);
            sqlServerJob.setUniqueCommandIndentifier(UUID.randomUUID().toString().replace("-", "").toUpperCase());
            sqlServerJob.set_jobName(resultSet.getString("name"));
            sqlServerJob.set_verboseOutput(resultSet.getBoolean("verbose_output"));
            this.secureJobCommand(commandSetCommand, sqlServerJob);
            commandSetCommand.set_sqlServerJob(sqlServerJob);
        }
        catch (Exception exception) {
            try {
                String string2 = "Error while retrieving the SQL Server Jobs.";
                logger.debug((Object)string2, (Throwable)exception);
                throw new RuntimeException(string2, exception);
            }
            catch (Throwable throwable) {
                CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private void secureJobCommand(CommandSetCommand commandSetCommand, SqlServerJob sqlServerJob) throws Exception {
        sqlServerJob.setSecurityToken(CommandSetDMJdbc.createSecurityToken(sqlServerJob).toUpperCase());
        String string = "";
        String string2 = sqlServerJob.get_sqlServerSystem().get_encrypted_password();
        if (!string2.equals("")) {
            string = this.decryptDbPassword(sqlServerJob.get_sqlServerSystem().get_encrypted_password(), sqlServerJob.get_sqlServerSystem().get_password_salt());
        }
        String string3 = sqlServerJob.getUniqueCommandIndentifier().substring(0, 15) + string;
        String string4 = sqlServerJob.get_jobName() + sqlServerJob.getUniqueCommandIndentifier();
        AESUtils aESUtils = AESUtils.init((String)string4);
        String string5 = aESUtils.encodeBinaryToBase64(string3.getBytes());
        sqlServerJob.get_sqlServerSystem().set_encrypted_password(string5);
    }

    private String decryptDbPassword(String string, String string2) throws ResourceUnavailableException {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = UnacodeMash.unMash(string);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string4 = "Can't decrypt password";
            System.out.println(string4);
            throw resourceUnavailableException;
        }
        String string5 = string3.replace(string2, "");
        return string5;
    }

    private static String createSecurityToken(SqlServerJob sqlServerJob) throws NoSuchAlgorithmException {
        return MD5.hashText((String)(sqlServerJob.get_jobName() + sqlServerJob.getUniqueCommandIndentifier() + sqlServerJob.get_jobName() + "D8E6BCC66ED042EDAED58B6B4E9048B9".toUpperCase()));
    }

    private void loadSqlServerSystem(SqlServerJob sqlServerJob, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, name, server_instance_name, server_name, description, trusted_connection, user_id, encrypted_password, password_salt, shared FROM " + this._sqlServerDefinitionsTable + " " + "WHERE id = ?";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            SqlServerSystem sqlServerSystem = sqlServerJob.get_sqlServerSystem();
            preparedStatement.setLong(1, sqlServerSystem.getOid());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new Exception("No SQL Server Definition data returned from server!");
            }
            sqlServerSystem.setName(resultSet.getString("name"));
            sqlServerSystem.setDescription(resultSet.getString("description"));
            String string2 = resultSet.getString("server_instance_name");
            String string3 = resultSet.getString("server_name");
            String string4 = CommandSetDMJdbc.getServerInstanceCommandValue(string2, string3);
            sqlServerSystem.set_serverInstanceName(string4);
            sqlServerSystem.set_userId(resultSet.getString("user_id"));
            sqlServerSystem.set_encrypted_password(this.getNullableStringAsEmptyFromResultset(resultSet, "encrypted_password"));
            sqlServerSystem.set_password_salt(this.getNullableStringAsEmptyFromResultset(resultSet, "password_salt"));
            sqlServerSystem.set_useTrustedConnection(resultSet.getBoolean("trusted_connection"));
            sqlServerSystem.set_shared(resultSet.getBoolean("shared"));
        }
        catch (Exception exception) {
            try {
                String string5 = "Error while retrieving the SqlServerDefinition.";
                logger.debug((Object)string5, (Throwable)exception);
                throw new RuntimeException(string5, exception);
            }
            catch (Throwable throwable) {
                CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private static String getServerInstanceCommandValue(String string, String string2) throws Exception {
        boolean bl;
        String string3 = null;
        boolean bl2 = bl = string != null && string.trim().length() > 0;
        string3 = string2 != null && string2.trim().length() > 0 ? (bl ? string2 + "\\" + string : string2) : (bl ? ".\\" + string : ".");
        return string3;
    }

    private String getNullableStringAsEmptyFromResultset(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        if (resultSet.wasNull()) {
            string2 = "";
        }
        return string2;
    }

    private void loadFileTransfers(CommandSetCommand commandSetCommand, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id,file_transfer_system_id,direction,remote_file_name,agent_file_name,replace_existing_target_file,transfer_type,site_command,delete_source_file_after_transfer FROM " + this.fileTransfersTable + " WHERE command_id=?  ORDER BY transfer_type";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            Object object;
            preparedStatement.setLong(1, commandSetCommand.getOid());
            resultSet = preparedStatement.executeQuery();
            boolean bl = false;
            while (resultSet.next()) {
                object = new FileTransfer();
                try {
                    ((FileTransfer)((Object)object)).setOid(resultSet.getInt("id"));
                    FileTransferSystem fileTransferSystem = new FileTransferSystem();
                    fileTransferSystem.setOid(resultSet.getInt("file_transfer_system_id"));
                    ((FileTransfer)((Object)object)).setFileTransferSystem(fileTransferSystem);
                    this.loadFileTransferSystem((FileTransfer)((Object)object), connection);
                    ((FileTransfer)((Object)object)).setDirection(resultSet.getInt("direction"));
                    ((FileTransfer)((Object)object)).setRemoteFileName(resultSet.getString("remote_file_name"));
                    ((FileTransfer)((Object)object)).setAgentFileName(resultSet.getString("agent_file_name"));
                    ((FileTransfer)((Object)object)).setReplaceExistingTargetFile(resultSet.getBoolean("replace_existing_target_file"));
                    ((FileTransfer)((Object)object)).setTransferType(resultSet.getInt("transfer_type"));
                    ((FileTransfer)((Object)object)).setSiteCommand(resultSet.getString("site_command"));
                    ((FileTransfer)((Object)object)).setDeleteAfterTransfer(resultSet.getBoolean("delete_source_file_after_transfer"));
                }
                catch (Exception exception) {
                    bl = true;
                    String string2 = "Error while retrieving the commands.";
                    logger.debug((Object)string2, (Throwable)exception);
                }
                commandSetCommand.setFileTransfer((FileTransfer)((Object)object));
            }
            if (bl) {
                object = "One or more errors ocurred while retrieving the fileTransfer. Please see the error log for details.";
                throw new IllegalStateException((String)object);
            }
        }
        catch (Exception exception) {
            try {
                String string3 = "Error while retrieving the fileTransfers.";
                logger.debug((Object)string3, (Throwable)exception);
                throw new RuntimeException(string3, exception);
            }
            catch (Throwable throwable) {
                CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private void loadFileTransferSystem(FileTransfer fileTransfer, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id,name,description,transfer_type,system_name,file_transfer_systems.user,encrypted_password,password_salt,port,unknown_host_challenge,use_implicit_ftps,authentication_type,private_key_path FROM " + this.fileTransferSystemsTable + " WHERE id=?";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            FileTransferSystem fileTransferSystem = fileTransfer.getFileTransferSystem();
            preparedStatement.setLong(1, fileTransferSystem.getOid());
            resultSet = preparedStatement.executeQuery();
            boolean bl = false;
            if (resultSet.next()) {
                try {
                    fileTransferSystem.setName(resultSet.getString("name"));
                    fileTransferSystem.setDescription(resultSet.getString("description"));
                    fileTransferSystem.setTransferType(resultSet.getInt("transfer_type"));
                    fileTransferSystem.setSystemName(resultSet.getString("system_name"));
                    fileTransferSystem.setUser(resultSet.getString("user"));
                    fileTransferSystem.setEncryptedPassword(resultSet.getString("encrypted_password"));
                    fileTransferSystem.setPasswordSalt(resultSet.getString("password_salt"));
                    fileTransferSystem.setPort(resultSet.getInt("port"));
                    fileTransferSystem.setUnknownHostChallenge(resultSet.getBoolean("unknown_host_challenge"));
                    fileTransferSystem.setUseImplicitFtps(resultSet.getBoolean("use_implicit_ftps"));
                    fileTransferSystem.setAuthenticationType(resultSet.getInt("authentication_type"));
                    fileTransferSystem.setPrivateKeyPath(resultSet.getString("private_key_path"));
                }
                catch (Exception exception) {
                    bl = true;
                    String string2 = "Error while retrieving the commands.";
                    logger.debug((Object)string2, (Throwable)exception);
                }
            }
            if (bl) {
                String string3 = "One or more errors ocurred while retrieving the fileTransferSystem. Please see the error log for details.";
                throw new IllegalStateException(string3);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = "Error while retrieving the fileTransferSystem.";
                logger.debug((Object)string4, (Throwable)exception);
                throw new RuntimeException(string4, exception);
            }
            catch (Throwable throwable) {
                CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        CommandSetDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private void loadInfaWfCmd(CommandSetCommand commandSetCommand) {
        InformaticaWorkflowCommandsDM informaticaWorkflowCommandsDM = (InformaticaWorkflowCommandsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.InformaticaCommandsDM");
        try {
            List<InformaticaWorkflowCommand> list = informaticaWorkflowCommandsDM.getByCmdID(commandSetCommand.getOid());
            for (InformaticaWorkflowCommand informaticaWorkflowCommand : list) {
                this.loadInfRepo(informaticaWorkflowCommand);
                this.loadWorkflowParameters(informaticaWorkflowCommand);
                commandSetCommand.setInfaWorkflowCmd(informaticaWorkflowCommand);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error while retrieving Informatica Workflow Command.", (Throwable)exception);
        }
    }

    private void loadInfRepo(InformaticaWorkflowCommand informaticaWorkflowCommand) {
        InformaticaRepositoriesDM informaticaRepositoriesDM = (InformaticaRepositoriesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.InformaticaRepositoriesDM");
        try {
            InformaticaRepository informaticaRepository = informaticaRepositoriesDM.get(informaticaWorkflowCommand.getInfaRepoID());
            informaticaWorkflowCommand.setInfaRepo(informaticaRepository);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while retrieving Informatica Repository.", (Throwable)exception);
        }
    }

    private void loadUniversalConnectorCommand(CommandSetCommand commandSetCommand, Connection connection) {
        UniversalConnectorCommandDM universalConnectorCommandDM = (UniversalConnectorCommandDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.UniversalConnectorCommandDM");
        long l = commandSetCommand.getOid();
        try {
            UniversalConnectorCommand universalConnectorCommand = universalConnectorCommandDM.get(l, connection);
            commandSetCommand.setUniversalConnectorCommand(universalConnectorCommand);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error retrieving Universal Connector Command.", exception);
        }
    }

    private void loadWorkflowParameters(InformaticaWorkflowCommand informaticaWorkflowCommand) {
        InformaticaWorkflowCommandsDM informaticaWorkflowCommandsDM = (InformaticaWorkflowCommandsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.InformaticaCommandsDM");
        try {
            List<Parameter> list = informaticaWorkflowCommandsDM.getParameterListByCmdID(informaticaWorkflowCommand.getOID());
            informaticaWorkflowCommand.setParameterList(list);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while retrieving Informatica Workflow Parameters.", (Throwable)exception);
        }
    }

    private void loadWebServiceCmd(CommandSetCommand commandSetCommand) {
        WebServiceServerDM webServiceServerDM = (WebServiceServerDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.WebServiceServerDM");
        WebServiceRequestsDM webServiceRequestsDM = (WebServiceRequestsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.WebServiceRequestsDM");
        try {
            WebServiceRequest webServiceRequest = webServiceRequestsDM.getByCommand(commandSetCommand.getOid(), commandSetCommand.getCommandString());
            long l = webServiceRequest.getWebServiceDefinitionID();
            WebServiceServer webServiceServer = webServiceServerDM.get(l);
            WebServiceRequestComposite webServiceRequestComposite = new WebServiceRequestComposite();
            webServiceRequestComposite.setWebServiceRequest(webServiceRequest);
            webServiceRequestComposite.setWebServiceServer(webServiceServer);
            commandSetCommand.setWebServiceCmd(webServiceRequestComposite);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while loading the Web Service Command.", (Throwable)exception);
        }
    }

    private void loadInfaCloudCmd(CommandSetCommand commandSetCommand) {
        InformaticaCloudCommandsDM informaticaCloudCommandsDM = (InformaticaCloudCommandsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.InformaticaCloudCommandsDM");
        try {
            List<InformaticaCloudCommand> list = informaticaCloudCommandsDM.getByCmdID(commandSetCommand.getOid());
            for (InformaticaCloudCommand informaticaCloudCommand : list) {
                this.loadInfaCloudServers(informaticaCloudCommand);
                commandSetCommand.setInfaCloudCmd(informaticaCloudCommand);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error while retrieving Informatica Workflow Command.", (Throwable)exception);
        }
    }

    private void loadInfaCloudServers(InformaticaCloudCommand informaticaCloudCommand) {
        InformaticaCloudServersDM informaticaCloudServersDM = (InformaticaCloudServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.InformaticaCloudServersDM");
        try {
            InformaticaCloudServer informaticaCloudServer = informaticaCloudServersDM.get(informaticaCloudCommand.getCloudServerID());
            informaticaCloudCommand.setInfaCloudserver(informaticaCloudServer);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while retrieving Informatica Cloud Server.", (Throwable)exception);
        }
    }

    private AgentReturnCode getReturnCode(long l, Connection connection) throws SQLException, DataException, ResourceUnavailableException {
        return this.agentReturnCodeDM.get(l, connection);
    }

    private class CommandSetGenerator
    extends AbstractBusObjGenerator {
        public CommandSetGenerator() {
            super(5, CommandSetDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new CommandSet();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            CommandSet commandSet = (CommandSet)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    commandSet.setName(string);
                    break;
                }
                case 2: {
                    commandSet.setOid(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    commandSet.setDescription(string);
                    break;
                }
                case 4: {
                    int n2 = resultSet.getInt("command_set_type");
                    CommandSetType.persistanceCodeToEnum(n2);
                    commandSet.setType(n2);
                    break;
                }
                case 5: {
                    Connection connection = resultSet.getStatement().getConnection();
                    CommandSetDMJdbc.this.loadCommands(commandSet, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

