/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateRange;
import com.helpsystems.enterprise.core.scheduler.FiscalCalendar;
import com.helpsystems.enterprise.core.scheduler.FiscalYear;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TimeZone;

public class CalendarObjectDMJdbc
extends AbstractDatabaseManager
implements CalendarObjectDM {
    private static final String TABLE = "calendars";
    private static final String HOLIDAY_TABLE = "holidays";
    private static final String OTHER_NON_WORK_TABLE = "nonworking_days";
    private static final String FISCAL_YEAR_TABLE = "fiscal_years";
    private String table;
    private String holidayTable;
    private String otherNonWorkTable;
    private String fiscalYearTable;

    public CalendarObjectDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.table = string2 + "." + TABLE;
        this.holidayTable = string2 + "." + HOLIDAY_TABLE;
        this.otherNonWorkTable = string2 + "." + OTHER_NON_WORK_TABLE;
        this.fiscalYearTable = string2 + "." + FISCAL_YEAR_TABLE;
        this.setName(string3);
    }

    @Override
    public CalendarObject get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        String string = "SELECT id, name, description, workday_mon, workday_tue, workday_wed, workday_thu, workday_fri, workday_sat, workday_sun, fiscal, notify_before_expiration FROM " + this.table + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                CalendarObject calendarObject = this.getDataFromRS(resultSet);
                return calendarObject;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"Calendar Object (id = {0}) not found.", (Object[])new Object[]{l});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the Calendar Object for id {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public CalendarObject[] getList() throws NoDataException, BadDataException, ResourceUnavailableException {
        CalendarObject[] calendarObjectArray = new CalendarObject[]{};
        String string = "SELECT id, name, description, workday_mon, workday_tue, workday_wed, workday_thu, workday_fri, workday_sat, workday_sun, fiscal, notify_before_expiration FROM " + this.table;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<CalendarObject> arrayList = new ArrayList<CalendarObject>();
            while (resultSet.next()) {
                CalendarObject calendarObject = this.getDataFromRS(resultSet);
                arrayList.add(calendarObject);
            }
            calendarObjectArray = arrayList.toArray(new CalendarObject[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving Calendar Objects.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return calendarObjectArray;
    }

    @Override
    public CalendarObject getStandardCalendar() throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(1L);
    }

    private CalendarObject getDataFromRS(ResultSet resultSet) throws SQLException, BadDataException, ResourceUnavailableException {
        boolean bl = resultSet.getBoolean("fiscal");
        CalendarObject calendarObject = bl ? new FiscalCalendar() : new CalendarObject();
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        for (int i = 1; i <= 8; ++i) {
            try {
                this.getDataFromRS(resultSet, calendarObject, i);
                continue;
            }
            catch (RuntimeException runtimeException) {
                exceptionErrorList.addException((Exception)runtimeException);
            }
        }
        try {
            calendarObject.validate();
        }
        catch (RuntimeException runtimeException) {
            exceptionErrorList.addException((Exception)runtimeException);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            String string = MessageUtil.formatMsg((String)"One or more errors occurred while retrieving the Calendar Object {0}. Please see the error log for details.", (Object[])new Object[]{this.getCalendarIdentifierForMessage(calendarObject)});
            throw new BadDataException(string, (Object)calendarObject, (ErrorList)exceptionErrorList);
        }
        return calendarObject;
    }

    private void getDataFromRS(ResultSet resultSet, CalendarObject calendarObject, int n) throws SQLException, ResourceUnavailableException {
        Connection connection = null;
        switch (n) {
            case 1: {
                calendarObject.setID(resultSet.getLong("id"));
                break;
            }
            case 2: {
                calendarObject.setName(Convert.trimR((String)resultSet.getString("name")));
                break;
            }
            case 3: {
                calendarObject.setDescription(Convert.trimR((String)resultSet.getString("description")));
                break;
            }
            case 4: {
                EnumSet<CalendarObject.DayOfWeek> enumSet = this.loadNonWorkdaysByDayOfWeek(resultSet);
                calendarObject.setNonWorkdayByDOW(enumSet);
                break;
            }
            case 5: {
                connection = resultSet.getStatement().getConnection();
                int[] nArray = this.loadHolidays(calendarObject.getID(), connection);
                calendarObject.setHolidays(nArray);
                break;
            }
            case 6: {
                connection = resultSet.getStatement().getConnection();
                int[] nArray = this.loadNonWorkdates(calendarObject.getID(), connection);
                calendarObject.setOtherNonWorkdates(nArray);
                break;
            }
            case 7: {
                if (!(calendarObject instanceof FiscalCalendar)) break;
                connection = resultSet.getStatement().getConnection();
                FiscalYear[] fiscalYearArray = this.loadFiscalYears(calendarObject.getID(), connection);
                ((FiscalCalendar)calendarObject).setYears(fiscalYearArray);
                break;
            }
            case 8: {
                calendarObject.setNotifyBeforeExpiration(resultSet.getBoolean("notify_before_expiration"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Pass number argument exceeds maximum.");
            }
        }
    }

    private String getCalendarIdentifierForMessage(CalendarObject calendarObject) {
        String string = calendarObject.getName();
        if (string.length() == 0) {
            string = MessageUtil.formatMsg((String)"(ID = {0})", (Object[])new Object[]{calendarObject.getID()});
        }
        return string;
    }

    private int[] loadHolidays(long l, Connection connection) throws SQLException, ResourceUnavailableException {
        HashSet<Date> hashSet = new HashSet<Date>();
        String string = "SELECT holiday FROM " + this.holidayTable + " WHERE calendar_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        while (resultSet.next()) {
            Date date = resultSet.getDate("holiday", (Calendar)gregorianCalendar);
            hashSet.add(date);
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (java.util.Date date : hashSet) {
            gregorianCalendar.setTime(date);
            nArray[n++] = CalendarObjectDMJdbc.yyyymmdd(gregorianCalendar);
        }
        return nArray;
    }

    private int[] loadNonWorkdates(long l, Connection connection) throws SQLException, ResourceUnavailableException {
        HashSet<Date> hashSet = new HashSet<Date>();
        String string = "SELECT nonwork_date FROM " + this.otherNonWorkTable + " WHERE calendar_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        while (resultSet.next()) {
            Date date = resultSet.getDate("nonwork_date", (Calendar)gregorianCalendar);
            hashSet.add(date);
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (java.util.Date date : hashSet) {
            gregorianCalendar.setTime(date);
            nArray[n++] = CalendarObjectDMJdbc.yyyymmdd(gregorianCalendar);
        }
        return nArray;
    }

    private FiscalYear[] loadFiscalYears(long l, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT year_number, year_begins, end_of_month_1, end_of_month_2, end_of_month_3, end_of_month_4, end_of_month_5, end_of_month_6, end_of_month_7, end_of_month_8, end_of_month_9, end_of_month_10, end_of_month_11, end_of_month_12, end_of_month_13 FROM " + this.fiscalYearTable + " WHERE calendar_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.clear();
        ArrayList<FiscalYear> arrayList = new ArrayList<FiscalYear>();
        while (resultSet.next()) {
            arrayList.add(this.constructFiscalYear(resultSet, gregorianCalendar));
        }
        FiscalYear[] fiscalYearArray = new FiscalYear[arrayList.size()];
        return arrayList.toArray(fiscalYearArray);
    }

    /*
     * WARNING - void declaration
     */
    private FiscalYear constructFiscalYear(ResultSet resultSet, Calendar calendar) throws SQLException {
        void var11_15;
        Object object3;
        Date date = resultSet.getDate("year_begins", calendar);
        calendar.setTime(date);
        int n = CalendarObjectDMJdbc.yyyymmdd(calendar);
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        for (int i = 3; i < 16; ++i) {
            object3 = resultSet.getDate(i, calendar);
            if (object3 == null) continue;
            arrayList.add((Integer[])object3);
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (java.util.Date object22 : arrayList) {
            calendar.setTime(object22);
            calendar.add(5, 1);
            linkedList.add(CalendarObjectDMJdbc.yyyymmdd(calendar));
        }
        linkedList.removeLast();
        linkedList.addFirst(n);
        object3 = new Integer[linkedList.size()];
        linkedList.toArray((T[])object3);
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        for (java.util.Date object : arrayList) {
            calendar.setTime(object);
            nArray[n2++] = CalendarObjectDMJdbc.yyyymmdd(calendar);
        }
        DateRange[] dateRangeArray = new DateRange[nArray.length];
        boolean bl = false;
        while (var11_15 < dateRangeArray.length) {
            dateRangeArray[var11_15] = new DateRange(object3[var11_15], nArray[var11_15]);
            ++var11_15;
        }
        int n3 = nArray[nArray.length - 1];
        FiscalYear fiscalYear = new FiscalYear(n, n3);
        fiscalYear.setYear(resultSet.getInt("year_number"));
        fiscalYear.setMonths(dateRangeArray);
        return fiscalYear;
    }

    private EnumSet<CalendarObject.DayOfWeek> loadNonWorkdaysByDayOfWeek(ResultSet resultSet) throws SQLException, ResourceUnavailableException {
        EnumSet<CalendarObject.DayOfWeek> enumSet = EnumSet.noneOf(CalendarObject.DayOfWeek.class);
        if (!resultSet.getBoolean("workday_mon")) {
            enumSet.add(CalendarObject.DayOfWeek.MON);
        }
        if (!resultSet.getBoolean("workday_tue")) {
            enumSet.add(CalendarObject.DayOfWeek.TUE);
        }
        if (!resultSet.getBoolean("workday_wed")) {
            enumSet.add(CalendarObject.DayOfWeek.WED);
        }
        if (!resultSet.getBoolean("workday_thu")) {
            enumSet.add(CalendarObject.DayOfWeek.THU);
        }
        if (!resultSet.getBoolean("workday_fri")) {
            enumSet.add(CalendarObject.DayOfWeek.FRI);
        }
        if (!resultSet.getBoolean("workday_sat")) {
            enumSet.add(CalendarObject.DayOfWeek.SAT);
        }
        if (!resultSet.getBoolean("workday_sun")) {
            enumSet.add(CalendarObject.DayOfWeek.SUN);
        }
        return enumSet;
    }

    private static int yyyymmdd(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        return n * 10000 + n2 * 100 + n3;
    }
}

