/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.forecast;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.forecast.ForecastPrerequisiteStatus;
import com.helpsystems.enterprise.core.forecast.ForecastPrerequisitesDM;
import com.helpsystems.enterprise.core.forecast.ForecastSpecificInstance;
import com.helpsystems.enterprise.core.scheduler.DependencyEntry;
import com.helpsystems.enterprise.core.scheduler.DependentObject;
import com.helpsystems.enterprise.core.scheduler.MemberDependencyType;
import com.helpsystems.enterprise.core.scheduler.MemberRequiredPrereqs;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteConditionsList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ForecastPrerequisitesDMJdbc
extends AbstractDatabaseManager
implements ForecastPrerequisitesDM {
    private static final Logger logger = Logger.getLogger(ForecastPrerequisitesDMJdbc.class);
    private static final String TABLE = "dependencies";
    private static final String PRQSTS_TABLE = "prerequisite_statuses";
    private static final String SUITE_DEPENDENCIES_TABLE = "job_suite_dependencies";
    private static final String SUITE_MEMBERS_TABLE = "job_suite_member_jobs";
    private static final String JOBS_TABLE = "jobs";
    private String table;
    private String prereqStatusTable;
    private String suiteDependenciesTable;
    private String suiteMembersTable;
    private String jobsTable;
    SpecialInstanceDM specialInstanceDM = null;

    public ForecastPrerequisitesDMJdbc(String string, String string2, String string3, SpecialInstanceDM specialInstanceDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"SpecialInstanceDM", (Object)specialInstanceDM);
        this.specialInstanceDM = specialInstanceDM;
        this.table = string2 + "." + TABLE;
        this.prereqStatusTable = string2 + "." + PRQSTS_TABLE;
        this.suiteDependenciesTable = string2 + "." + SUITE_DEPENDENCIES_TABLE;
        this.suiteMembersTable = string2 + "." + SUITE_MEMBERS_TABLE;
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.setName(string3);
    }

    @Override
    public ForecastPrerequisiteStatus[] retrieveAllNonBlankPrerequisiteStatuses() throws ResourceUnavailableException {
        String string = "SELECT dependent_job_id, job_type, prereq_object_id, dep.prereq_type, sequence_number, react_to_status, dep_agent_id, prereq_agent_id, last_status, status_time_utc FROM " + this.prereqStatusTable + " JOIN " + this.table + " dep ON dependency_id = dep.id JOIN " + this.jobsTable + " job ON dependent_job_id = job.id WHERE last_status<>''";
        ArrayList<ForecastPrerequisiteStatus> arrayList = new ArrayList<ForecastPrerequisiteStatus>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastPrerequisitesDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ForecastPrerequisiteStatus forecastPrerequisiteStatus = new ForecastPrerequisiteStatus();
                DependentObject dependentObject = new DependentObject();
                dependentObject.setId(resultSet.getLong("dependent_job_id"));
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                dependentObject.setType(DependentObject.DependentObjectType.jobTypeToEnum(jobType));
                forecastPrerequisiteStatus.setDependentObject(dependentObject);
                forecastPrerequisiteStatus.setDependentAgentID(resultSet.getLong("dep_agent_id"));
                forecastPrerequisiteStatus.setPrereqObjectID(resultSet.getLong("prereq_object_id"));
                forecastPrerequisiteStatus.setPrereqObjectType(PrereqEventType.persistanceCodeToEnum(resultSet.getInt("prereq_type")));
                forecastPrerequisiteStatus.setPrereqAgentID(resultSet.getLong("prereq_agent_id"));
                forecastPrerequisiteStatus.setSequenceNumber(resultSet.getInt("sequence_number"));
                forecastPrerequisiteStatus.setReactToStatus(PrereqStatusType.persistanceCodeToEnum(resultSet.getString("react_to_status")));
                forecastPrerequisiteStatus.setLastStatus(PrereqStatusType.persistanceCodeToEnum(resultSet.getString("last_status")));
                forecastPrerequisiteStatus.setStatusTime(resultSet.getLong("status_time_utc"));
                arrayList.add(forecastPrerequisiteStatus);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the non-blank prerequisite statuses.", (Throwable)sQLException);
        }
        finally {
            ForecastPrerequisitesDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, (ResultSet)resultSet);
        }
        return arrayList.toArray(new ForecastPrerequisiteStatus[arrayList.size()]);
    }

    @Override
    public DependencyEntry[] retrieveDependencyEntriesForDependentObjects(List<DependentObject> list) throws ResourceUnavailableException {
        ArrayList<DependencyEntry> arrayList;
        if (list.size() == 0) {
            return null;
        }
        boolean bl = true;
        block8: for (DependentObject object : list) {
            switch (object.getType()) {
                case JOB: 
                case JOB_SUITE: {
                    continue block8;
                }
                case MEMBER_JOB: 
                case REACTIVE_EVENT: {
                    bl = false;
                    continue block8;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: DependentObject Type {0} is not supported by this method.", (Object[])new Object[]{object.getType()}));
        }
        if (bl) {
            arrayList = this.retrieveDependencyEntriesForDependentJobsOrSuites(list);
        } else {
            arrayList = new ArrayList<DependencyEntry>();
            block9: for (DependentObject dependentObject : list) {
                switch (dependentObject.getType()) {
                    case JOB: 
                    case JOB_SUITE: {
                        ArrayList<DependentObject> arrayList2 = new ArrayList<DependentObject>();
                        arrayList2.add(dependentObject);
                        arrayList.addAll(this.retrieveDependencyEntriesForDependentJobsOrSuites(arrayList2));
                        continue block9;
                    }
                    case MEMBER_JOB: {
                        arrayList.addAll(this.retrieveDependencyEntriesForMember(dependentObject));
                        continue block9;
                    }
                }
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: DependentObject Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
            }
        }
        return arrayList.toArray(new DependencyEntry[arrayList.size()]);
    }

    private PrerequisiteConditionsList.PrereqConjunction conjunction(int n, long l) {
        try {
            MemberRequiredPrereqs memberRequiredPrereqs = MemberRequiredPrereqs.persistanceCodeToEnum(n);
            switch (memberRequiredPrereqs) {
                case ALL: {
                    return PrerequisiteConditionsList.PrereqConjunction.AND;
                }
                case ANY: {
                    return PrerequisiteConditionsList.PrereqConjunction.OR;
                }
                case FIRST: {
                    return PrerequisiteConditionsList.PrereqConjunction.OR;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Required Prereqs {0} is not supported by this method.", (Object[])new Object[]{memberRequiredPrereqs}));
        }
        catch (Exception exception) {
            PrerequisiteConditionsList.PrereqConjunction prereqConjunction = PrerequisiteConditionsList.PrereqConjunction.AND;
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to interpret the required prereqs code ({0}) associated with suite member ID {1}. Defaulting to {2}.", (Object[])new Object[]{n, l, prereqConjunction}), (Throwable)exception);
            return prereqConjunction;
        }
    }

    private DependencyEntry createDependencyEntryForInitialMember(DependentObject dependentObject) throws ResourceUnavailableException {
        long l = dependentObject.getID();
        DependencyEntry dependencyEntry = new DependencyEntry();
        dependencyEntry.setDependentObject((DependentObject)dependentObject.clone());
        dependencyEntry.setPrerequisiteID(this.getSuiteID(l));
        dependencyEntry.setPrerequisiteType(PrereqEventType.JOB_SUITE_STATUS_CHANGE);
        dependencyEntry.setSequenceNumber(1);
        dependencyEntry.setConjunction(PrerequisiteConditionsList.PrereqConjunction.AND);
        dependencyEntry.setReactToStatus(PrereqStatusType.RUNNING);
        return dependencyEntry;
    }

    private DependentObject.DependentObjectType dependentObjectType(long l, List<DependentObject> list) {
        for (DependentObject dependentObject : list) {
            if (dependentObject.getID() != l) continue;
            return dependentObject.getType();
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: ID {0} not found in the list of Dependent Objects provided.", (Object[])new Object[]{l}));
    }

    private long getSuiteID(long l) throws ResourceUnavailableException {
        String string = "SELECT job_suite_id FROM " + this.suiteMembersTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("job_suite_id");
                return l2;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Suite member ID {0} not found.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error retrieving the suite ID for suite member ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private PrereqStatusType reactToStatus(int n, long l) {
        try {
            MemberDependencyType memberDependencyType = MemberDependencyType.persistanceCodeToEnum(n);
            switch (memberDependencyType) {
                case COMPLETED: {
                    return PrereqStatusType.COMPLETED;
                }
                case FAILED: {
                    return PrereqStatusType.FAILED;
                }
                case COMPLETED_OR_FAILED: {
                    return PrereqStatusType.ENDED;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Dependency Type {0} is not supported by this method.", (Object[])new Object[]{memberDependencyType}));
        }
        catch (Exception exception) {
            PrereqStatusType prereqStatusType = PrereqStatusType.COMPLETED;
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to interpret the dependency type code ({0}) associated with suite member ID {1}. Defaulting to {2}.", (Object[])new Object[]{n, l, prereqStatusType}), (Throwable)exception);
            return prereqStatusType;
        }
    }

    private List<DependencyEntry> retrieveDependencyEntriesForDependentJobsOrSuites(List<DependentObject> list) throws ResourceUnavailableException {
        Object object;
        DependentObject dependentObject2;
        String string = null;
        for (DependentObject dependentObject2 : list) {
            if (dependentObject2.getType() != DependentObject.DependentObjectType.JOB && dependentObject2.getType() != DependentObject.DependentObjectType.JOB_SUITE) {
                throw new IllegalStateException("Program error: The retrieveDependencyEntriesForDependentObjects method can only handle JOB and JOB SUITE dependent object types.");
            }
            object = Long.toString(dependentObject2.getID());
            if (string == null) {
                string = "IN (" + (String)object;
                continue;
            }
            string = string + "," + (String)object;
        }
        string = string + ")";
        String string2 = "SELECT dependent_job_id, prereq_object_id, prereq_type, sequence_number, conjunction, react_to_status, special_instance_id FROM " + this.table + " WHERE dependent_job_id " + string;
        dependentObject2 = this.getConnectionOrFail();
        object = null;
        ResultSet resultSet = null;
        try {
            object = dependentObject2.createStatement();
        }
        catch (SQLException sQLException) {
            ForecastPrerequisitesDMJdbc.closeEm((Connection)((Object)dependentObject2), null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        ArrayList<DependencyEntry> arrayList = new ArrayList<DependencyEntry>();
        try {
            resultSet = object.executeQuery(string2);
            while (resultSet.next()) {
                long l = resultSet.getLong("dependent_job_id");
                DependentObject.DependentObjectType dependentObjectType = this.dependentObjectType(l, list);
                DependentObject dependentObject3 = new DependentObject(l, dependentObjectType);
                DependencyEntry dependencyEntry = new DependencyEntry();
                dependencyEntry.setDependentObject(dependentObject3);
                dependencyEntry.setPrerequisiteID(resultSet.getLong("prereq_object_id"));
                dependencyEntry.setPrerequisiteType(PrereqEventType.persistanceCodeToEnum(resultSet.getInt("prereq_type")));
                dependencyEntry.setSequenceNumber(resultSet.getInt("sequence_number"));
                dependencyEntry.setConjunction(PrerequisiteConditionsList.PrereqConjunction.persistanceCodeToEnum(resultSet.getString("conjunction")));
                dependencyEntry.setReactToStatus(PrereqStatusType.persistanceCodeToEnum(resultSet.getString("react_to_status")));
                long l2 = resultSet.getLong("special_instance_id");
                if (l2 != 0L) {
                    SpecialInstance specialInstance = null;
                    try {
                        specialInstance = this.specialInstanceDM.get(l2);
                        dependencyEntry.setSpecificInstance(new ForecastSpecificInstance(specialInstance));
                    }
                    catch (Exception exception) {
                        throw new ResourceUnavailableException("Error.", (Throwable)exception);
                    }
                }
                arrayList.add(dependencyEntry);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error retrieving the dependency entries for dependent jobs or suites.", (Throwable)sQLException);
        }
        finally {
            ForecastPrerequisitesDMJdbc.closeEm((Connection)((Object)dependentObject2), (Statement)object, (ResultSet)resultSet);
        }
        return arrayList;
    }

    private List<DependencyEntry> retrieveDependencyEntriesForMember(DependentObject dependentObject) throws ResourceUnavailableException {
        if (dependentObject.getType() != DependentObject.DependentObjectType.MEMBER_JOB) {
            throw new IllegalArgumentException("Program error: The retrieveDependencyEntriesForMember method can only handle a MEMBER_JOB dependent object type.");
        }
        ArrayList<DependencyEntry> arrayList = new ArrayList<DependencyEntry>();
        long l = dependentObject.getID();
        int n = 1;
        String string = "SELECT prereq_member_id, dependency_type, required_prereqs FROM " + this.suiteDependenciesTable + " JOIN " + this.suiteMembersTable + " m ON dependent_member_id = m.id" + " WHERE dependent_member_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DependencyEntry dependencyEntry = new DependencyEntry();
                dependencyEntry.setDependentObject((DependentObject)dependentObject.clone());
                dependencyEntry.setPrerequisiteID(resultSet.getLong("prereq_member_id"));
                dependencyEntry.setPrerequisiteType(PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE);
                dependencyEntry.setSequenceNumber(n++);
                dependencyEntry.setConjunction(this.conjunction(resultSet.getInt("required_prereqs"), l));
                dependencyEntry.setReactToStatus(this.reactToStatus(resultSet.getInt("dependency_type"), l));
                arrayList.add(dependencyEntry);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error retrieving the dependency entries for suite member ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this.createDependencyEntryForInitialMember(dependentObject));
        }
        return arrayList;
    }
}

