/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.module;

import com.helpsystems.common.tl.module.GenericJarModule;
import com.helpsystems.common.tl.module.Module;
import com.helpsystems.common.tl.module.ModuleInfo;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ModuleClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(ModuleClassLoader.class);
    public static final String PROPERTY_BYPASS_CL = "bypass.module.cl";
    static final boolean bypassEnabled = "true".equalsIgnoreCase(System.getProperty("bypass.module.cl"));
    private JarFile jarFile;
    protected Hashtable commandToProcessorMap;
    private Hashtable<String, Class> classTable;
    private GenericJarModule jarModule;

    public ModuleClassLoader(GenericJarModule genericJarModule, String string) throws IOException {
        super(new URL[]{new URL("file://" + string)});
        this.jarModule = genericJarModule;
        this.jarFile = new JarFile(string);
        this.classTable = new Hashtable();
        this.commandToProcessorMap = new Hashtable();
        this.searchForProcessors();
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (bypassEnabled) {
            return this.getClass().getClassLoader().getResourceAsStream(string);
        }
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        try {
            return this.prepareInputStream(string);
        }
        catch (IOException iOException) {
            logger.debug((Object)("Found an entry for " + string + " in jar file " + this.jarFile.getName() + " but could not open an InputStream for the resource."), (Throwable)iOException);
            return null;
        }
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        if (bypassEnabled) {
            return this.getClass().getClassLoader().loadClass(string);
        }
        String string2 = this.fixClassname(string);
        Class<?> clazz = this.classTable.get(string2);
        if (clazz != null) {
            return clazz;
        }
        byte[] byArray = null;
        try {
            byArray = this.loadClassData(string2);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string2, iOException);
        }
        clazz = this.defineClass(string2, byArray, 0, byArray.length);
        this.classTable.put(string2, clazz);
        return clazz;
    }

    public Processor getProcessor(Processable processable) {
        if (processable == null) {
            throw new NullPointerException("The command passed in is null.");
        }
        return this.getProcessor(processable.getClass());
    }

    public Processor getProcessor(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("The class passed in is null.");
        }
        return (Processor)this.commandToProcessorMap.get(clazz.getName());
    }

    public boolean containsClass(String string) {
        String string2 = this.fixClassname(string);
        try {
            String string3 = string2.replace('.', '/') + ".class";
            JarEntry jarEntry = this.jarFile.getJarEntry(string3);
            return jarEntry != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private byte[] loadClassData(String string) throws IOException {
        String string2 = this.fixClassname(string);
        String string3 = string2.replace('.', '/') + ".class";
        JarEntry jarEntry = this.jarFile.getJarEntry(string3);
        if (jarEntry == null) {
            throw new FileNotFoundException("Object " + string3 + " not found.");
        }
        InputStream inputStream = this.prepareInputStream(jarEntry.getName());
        int n = (int)jarEntry.getSize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, n2, n - n2)) >= 0) {
        }
        inputStream.close();
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Please enter the full name of the class to be loaded from the module.jar");
            System.out.println("This program assumes that module.jar is in the current directory.");
            return;
        }
        Logger.getRootLogger().setLevel(Level.DEBUG);
        while (true) {
            ModuleClassLoader moduleClassLoader;
            Class<?> clazz;
            if ((clazz = (moduleClassLoader = new ModuleClassLoader(null, "module.jar")).loadClass(stringArray[0], true)) == null) break;
            logger.trace((Object)("Found class " + clazz.getName()));
            Object obj = clazz.newInstance();
            if (obj instanceof Module) {
                Module module = (Module)obj;
                module.processEnvelope(null, null);
            }
            System.out.print("Sleeping for 5 seconds and reloading the class...\r");
            Thread.sleep(5000L);
        }
        System.out.println("Class not found.");
    }

    protected InputStream prepareInputStream(String string) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.jarFile.getName())));
        while ((zipEntry = zipInputStream.getNextEntry()) != null && !zipEntry.getName().equals(string)) {
        }
        if (zipEntry == null) {
            throw new IOException("File not found within Jar: " + string);
        }
        return zipInputStream;
    }

    private void registerProcessor(Class clazz, Hashtable<String, Processor> hashtable) throws InstantiationException, IllegalAccessException {
        Processor processor = (Processor)clazz.newInstance();
        String[] stringArray = processor.listCommands();
        for (int i = 0; i < stringArray.length; ++i) {
            Processor processor2 = hashtable.get(stringArray[i]);
            if (processor2 != null) {
                throw new RuntimeException("The Processors " + processor2.getClass().getName() + " and " + processor.getClass().getName() + " both handle Command " + stringArray[i]);
            }
            logger.trace((Object)("\tProcessor " + clazz.getName() + " will handle " + stringArray[i]));
            hashtable.put(stringArray[i], processor);
        }
    }

    protected void searchForProcessors() {
        Hashtable<String, Processor> hashtable = new Hashtable<String, Processor>();
        ModuleInfo moduleInfo = null;
        if (this.jarModule != null) {
            moduleInfo = this.jarModule.getInfo();
        }
        try {
            Class<Processor> clazz = Processor.class;
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || (string = zipEntry.getName()).indexOf("Proc") <= -1 || !string.endsWith(".class")) continue;
                logger.trace((Object)("maybe a processor: " + string));
                String string2 = string.substring(0, string.length() - 6);
                string2 = string2.replace('/', '.');
                if (moduleInfo != null && moduleInfo.isNotAProcessor(string2)) continue;
                Class<?> clazz2 = null;
                try {
                    clazz2 = bypassEnabled ? this.getClass().getClassLoader().loadClass(string2) : this.loadClass(string2);
                }
                catch (Throwable throwable) {
                    logger.debug((Object)("Unable to load class " + string2 + " in module " + this.jarFile.getName()), throwable);
                    continue;
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    boolean bl;
                    int n = clazz2.getModifiers();
                    boolean bl2 = bl = (n & 0x400) > 0;
                    if (clazz2.isInterface() || bl) {
                        logger.trace((Object)"Skipping - interface or abtract");
                        continue;
                    }
                    logger.trace((Object)("Found Processor: " + string2));
                    this.registerProcessor(clazz2, hashtable);
                    continue;
                }
                logger.trace((Object)("Not really a processor: " + clazz2.getName()));
            }
            this.commandToProcessorMap = hashtable;
        }
        catch (Exception exception) {
            logger.warn((Object)"Error scanning the jar file for Processors", (Throwable)exception);
            this.commandToProcessorMap.clear();
        }
    }

    protected String fixClassname(String string) {
        int n = string.indexOf("[L");
        if (n > -1) {
            return string.substring(n + 2, string.length() - 1);
        }
        return string;
    }

    static {
        if (bypassEnabled) {
            logger.trace((Object)"The property bypass.module.cl has been set to 'true', thus the Module Clasloader will be bypassed.");
        }
    }
}

