/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.SSLSocketAdjust;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;

public class SecureServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    private static final Logger logger = Logger.getLogger(SecureServerSocketFactory.class);
    public static final String SKYBOT_USE_LEGACY_PEERKEY_PROPERTY = "skybot.legacy.peerkey";
    public static final String PEERKEYS_PATH = "com/helpsystems/common/tl/";
    public static final String PEERKEYS_RESOURCE1 = "com/helpsystems/common/tl/peerkeys";
    public static final String PEERKEYS_RESOURCE2 = "com/helpsystems/common/tl/peerkeys2";
    private static boolean kmfFirstTime = true;
    private static boolean sslFirstTime = true;

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        Object object;
        logger.trace((Object)("Preparing a Secure Server Socket for port " + n));
        SSLServerSocketFactory sSLServerSocketFactory = null;
        SSLContext sSLContext = SecureServerSocketFactory.findSSLContext();
        KeyManagerFactory keyManagerFactory = SecureServerSocketFactory.findKeyManagerFactory();
        char[] cArray = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        boolean bl = false;
        String string = PEERKEYS_RESOURCE2;
        try {
            object = System.getProperty(SKYBOT_USE_LEGACY_PEERKEY_PROPERTY);
            if (object != null && "true".equalsIgnoreCase(((String)object).trim())) {
                string = PEERKEYS_RESOURCE1;
                logger.debug((Object)"Using legacy peer key override.");
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Error checking legacy peer key override.", (Throwable)exception);
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try {
                inputStream = new FileInputStream("sslkeys");
                bl = true;
            }
            catch (Exception exception) {
                logger.trace((Object)"No 'sslkeys' SSL certificate was found, using default certificate.");
            }
            if (inputStream != null) {
                logger.trace((Object)"Using 'sslkeys' SSL certificate.");
                try {
                    inputStream2 = new FileInputStream("sslpassphrase");
                    if (inputStream2 != null) {
                        logger.debug((Object)"Using 'sslpassphrase' for SSL certificate.");
                    }
                    inputStreamReader = new InputStreamReader(inputStream2);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    object = bufferedReader.readLine();
                    cArray = ((String)object).toCharArray();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Unable to use 'sslpassphrase', using default passphrase.");
                    cArray = "secret1".toCharArray();
                }
            }
            if (inputStream == null) {
                cArray = "favorite0robot".toCharArray();
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    throw new IOException("The file " + string + " could not be found. This file should be in the" + " same JAR file as the SecurePeer.class.");
                }
            }
            try {
                keyStore.load(inputStream, cArray);
            }
            catch (Exception exception) {
                if (bl) {
                    logger.debug((Object)"Can not use 'sslkeys', using default certificate.");
                    inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                    cArray = "favorite0robot".toCharArray();
                    keyStore.load(inputStream, cArray);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                IOException iOException = new IOException("Unable to load keystore for Secure Socket Factory.");
                iOException.initCause(exception);
                throw iOException;
            }
            keyManagerFactory.init(keyStore, cArray);
            object = keyManagerFactory.getKeyManagers();
            sSLContext.init((KeyManager[])object, null, null);
            sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException("Unable to create a Secure Socket Factory.");
            iOException.initCause(exception);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        object = null;
        object = Peer.USE_LOCAL_IP_ONLY ? sSLServerSocketFactory.createServerSocket(n, 0, InetAddress.getByName("127.0.0.1")) : sSLServerSocketFactory.createServerSocket(n);
        this.adjustCiphers((SSLServerSocket)object);
        return object;
    }

    private static KeyManagerFactory findKeyManagerFactory() throws IOException {
        KeyManagerFactory keyManagerFactory = null;
        String string = System.getProperty("kmfa");
        String string2 = System.getProperty("kmfp");
        if (string != null || string2 != null) {
            if (kmfFirstTime && logger.isTraceEnabled()) {
                logger.trace((Object)"Using user specified KMF parameters:");
                logger.trace((Object)("\tKMF Protocol (kmfa) = " + string));
                logger.trace((Object)("\tKMF Provider (kmfp) = " + string2));
            }
            if (string == null) {
                string = "SunX509";
            }
            try {
                keyManagerFactory = string2 == null ? KeyManagerFactory.getInstance(string) : KeyManagerFactory.getInstance(string, string2);
                SecureServerSocketFactory.logKeyManagerFactory(keyManagerFactory);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                return keyManagerFactory2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                IOException iOException = new IOException("Unable to use KMF Algorithm: " + string);
                iOException.initCause(noSuchAlgorithmException);
                throw iOException;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                IOException iOException = new IOException("Unable to use KMF Provider: " + string2);
                iOException.initCause(noSuchProviderException);
                throw iOException;
            }
            finally {
                kmfFirstTime = false;
            }
        }
        String[] stringArray = new String[]{"SunJSSE", "IBMJSSE", "IBMJSSE2"};
        String[] stringArray2 = new String[]{"SunX509", "IbmX509", "IbmX509"};
        SecureServerSocketFactory.flipArraysForIBM(stringArray, stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            string = stringArray2[i];
            try {
                keyManagerFactory = KeyManagerFactory.getInstance(string, string2);
                SecureServerSocketFactory.logKeyManagerFactory(keyManagerFactory);
                kmfFirstTime = false;
                return keyManagerFactory;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!kmfFirstTime) continue;
                logger.trace((Object)("Unable to use KMF Algorithm: " + string2 + "/" + string), (Throwable)noSuchAlgorithmException);
                continue;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (!kmfFirstTime) continue;
                logger.trace((Object)("Unable to use KMF Provider: " + string2), (Throwable)noSuchProviderException);
            }
        }
        kmfFirstTime = false;
        throw new IOException("Unable to find a usuable KMF implementation.");
    }

    static SSLContext findSSLContext() throws IOException {
        SSLContext sSLContext = null;
        String string = System.getProperty("ssla");
        String string2 = System.getProperty("sslp");
        if (string != null || string2 != null) {
            if (sslFirstTime && logger.isTraceEnabled()) {
                logger.trace((Object)"Using user specified SSL parameters:");
                logger.trace((Object)("\tSSL Protocol (ssla) = " + string));
                logger.trace((Object)("\tSSL Provider (sslp) = " + string2));
            }
            if (string == null) {
                string = "TLS";
            }
            try {
                sSLContext = string2 == null ? SSLContext.getInstance(string) : SSLContext.getInstance(string, string2);
                SecureServerSocketFactory.logSSLContext(sSLContext);
                SSLContext sSLContext2 = sSLContext;
                return sSLContext2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                IOException iOException = new IOException("Unable to use SSL Protocol: " + string);
                iOException.initCause(noSuchAlgorithmException);
                throw iOException;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                IOException iOException = new IOException("Unable to use SSL Provider: " + string2);
                iOException.initCause(noSuchProviderException);
                throw iOException;
            }
            finally {
                sslFirstTime = false;
            }
        }
        String[] stringArray = new String[]{"SunJSSE", "IBMJSSE", "IBMJSSE2"};
        String[] stringArray2 = new String[]{"TLS", "SSL_TLS", "SSL_TLS"};
        SecureServerSocketFactory.flipArraysForIBM(stringArray, stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            string = stringArray2[i];
            try {
                sSLContext = SSLContext.getInstance(string, string2);
                SecureServerSocketFactory.logSSLContext(sSLContext);
                sslFirstTime = false;
                return sSLContext;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!sslFirstTime) continue;
                logger.trace((Object)("Unable to use Algorithm: " + string2 + "/" + string), (Throwable)noSuchAlgorithmException);
                continue;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (!sslFirstTime) continue;
                logger.trace((Object)("Unable to use Provider: " + string2), (Throwable)noSuchProviderException);
            }
        }
        sslFirstTime = false;
        throw new IOException("Unable to find a usable SSL implementation.");
    }

    private static void logSSLContext(SSLContext sSLContext) {
        if (sslFirstTime && logger.isTraceEnabled()) {
            logger.trace((Object)("Using an SSL Context with provider " + sSLContext.getProvider() + " and protocol " + sSLContext.getProtocol()));
        }
    }

    private static void logKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        if (kmfFirstTime && logger.isTraceEnabled()) {
            logger.trace((Object)("Using a KeyManagerFactory with provider " + keyManagerFactory.getProvider() + " and algorithm " + keyManagerFactory.getAlgorithm()));
        }
    }

    private static void flipArraysForIBM(String[] ... stringArray) {
        String string = System.getProperty("java.vendor");
        if (string == null) {
            return;
        }
        if ((string = string.toUpperCase()).startsWith("IBM")) {
            for (String[] stringArray2 : stringArray) {
                for (int i = 0; i < stringArray2.length / 2; ++i) {
                    String string2 = stringArray2[i];
                    stringArray2[i] = stringArray2[stringArray2.length - 1];
                    stringArray2[stringArray2.length - 1] = string2;
                }
            }
        }
    }

    private void adjustCiphers(SSLServerSocket sSLServerSocket) {
        SSLSocketAdjust.adjustSSLServerSocketProtocols(sSLServerSocket);
        String[] stringArray = sSLServerSocket.getEnabledCipherSuites();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.indexOf("AES") > -1 || string.indexOf("3DES") > -1) {
                arrayList.add(string);
                logger.debug((Object)("Allowing SSL cipher: " + string));
                continue;
            }
            logger.debug((Object)("Disallowing SSL cipher: " + string));
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        sSLServerSocket.setEnabledCipherSuites(stringArray2);
    }
}

