/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;

public class SSLSocketAdjust {
    private static final Logger logger = Logger.getLogger(SSLSocketAdjust.class);
    public static String tlsV = "TLSv";
    private static final boolean adjustmentEnabled = true;

    private SSLSocketAdjust() {
    }

    protected static void adjustSSLSocketProtocols(SSLSocket sSLSocket) {
        String[] stringArray = SSLSocketAdjust.getFilteredProtocols(sSLSocket.getEnabledProtocols());
        if (stringArray != null && stringArray.length > 0) {
            sSLSocket.setEnabledProtocols(stringArray);
        } else {
            logger.warn((Object)"Adjusted SSL Socket protocols are null or empty.  Protocols will not be restricted.");
        }
    }

    protected static void adjustSSLServerSocketProtocols(SSLServerSocket sSLServerSocket) {
        String[] stringArray = SSLSocketAdjust.getFilteredProtocols(sSLServerSocket.getEnabledProtocols());
        if (stringArray != null && stringArray.length > 0) {
            sSLServerSocket.setEnabledProtocols(stringArray);
        } else {
            logger.warn((Object)"Adjusted SSL Server Socket protocols are null or empty.  Protocols will not be restricted.");
        }
        if (logger.isTraceEnabled()) {
            for (String string : stringArray = sSLServerSocket.getEnabledProtocols()) {
                logger.trace((Object)("Protocol enabled: " + string));
            }
        }
    }

    private static String[] getFilteredProtocols(String[] stringArray) {
        if (stringArray == null) {
            logger.warn((Object)"Protocol list is null.");
            return null;
        }
        String string = System.getProperty("java.specification.version");
        logger.trace((Object)("Local Java Version: " + string));
        JAVA_VERSION jAVA_VERSION = (JAVA_VERSION)((Object)JAVA_VERSION.specMap.get(string));
        List list = jAVA_VERSION.disallowedProtocols;
        for (String string2 : list) {
            logger.trace((Object)("Disallowed Protocol: " + string2));
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (list.contains(string3)) {
                logger.trace((Object)("Disabling Protocol: " + string3));
                continue;
            }
            logger.trace((Object)("Enabling Protocol: " + string3));
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    protected static void setProtocolsForJavaVersion(SSLSocket sSLSocket) {
        String[] stringArray;
        String string = System.getProperty("java.specification.version");
        logger.trace((Object)("Local Java Version: " + string));
        JAVA_VERSION jAVA_VERSION = (JAVA_VERSION)((Object)JAVA_VERSION.specMap.get(string));
        if (jAVA_VERSION == null) {
            logger.trace((Object)("No enum and SSL protocol adjustment for Java Version: " + string));
            return;
        }
        switch (jAVA_VERSION) {
            case JAVA_1_7: 
            case JAVA_1_8: {
                stringArray = (String[])jAVA_VERSION.allowedProtocols.toArray();
                sSLSocket.setEnabledProtocols(stringArray);
                logger.debug((Object)"SSL protocols have been adjusted.");
                break;
            }
            default: {
                logger.debug((Object)("No SSL protocol adjustment for known Java Version: " + (Object)((Object)jAVA_VERSION)));
            }
        }
        if (logger.isTraceEnabled()) {
            String[] stringArray2 = stringArray = sSLSocket.getEnabledProtocols();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                logger.trace((Object)("*** Protocol enabled: " + string2));
            }
            for (String string3 : stringArray2 = sSLSocket.getEnabledCipherSuites()) {
                logger.trace((Object)("* SSL cipher Allowed: " + string3));
            }
        }
    }

    private static enum JAVA_VERSION {
        JAVA_1_6("1.6", Arrays.asList("SSLv2Hello", "SSLv3", "TLSv1"), null),
        JAVA_1_7("1.7", Arrays.asList("SSLv2Hello", "SSLv3"), Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2")),
        JAVA_1_8("1.8", Arrays.asList("SSLv2Hello", "SSLv3"), Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));

        private String specString;
        private List<String> disallowedProtocols;
        private List<String> allowedProtocols;
        private static Map<String, JAVA_VERSION> specMap;

        private JAVA_VERSION(String string2, List<String> list, List<String> list2) {
            this.specString = string2;
            this.disallowedProtocols = list;
            this.allowedProtocols = list2;
        }

        static {
            specMap = new HashMap<String, JAVA_VERSION>();
            for (JAVA_VERSION jAVA_VERSION : JAVA_VERSION.values()) {
                specMap.put(jAVA_VERSION.specString, jAVA_VERSION);
            }
        }
    }
}

