/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler.executors;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.scheduler.executors.AuditPurgeRunner;
import com.helpsystems.enterprise.scheduler.executors.CleanupExecutor;
import com.helpsystems.enterprise.scheduler.executors.ScheduledRunner;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class DailyCleanupExecutor
extends CleanupExecutor {
    int hour = 0;
    int mins = 5;

    public DailyCleanupExecutor(int n, int n2) {
        this.setThreadName("Daily Cleanup Thread");
        this.setLogMessages(RosettaMsg.DAILY_CLEANUP_NEXT_WAKEUP, RosettaMsg.NO_DAILY_CLEANUP_RUNNERS, RosettaMsg.DAILY_CLEANUP_RUNNERS_ERROR_ENCOUNTERED);
        this.mins = n == 0 && n2 == 0 ? 5 : n2;
        this.hour = n;
        this.scheduleService();
    }

    public void setNewWakeTime(int n, int n2, boolean bl) {
        this.mins = n == 0 && n2 == 0 ? 5 : n2;
        this.hour = n;
        ScheduledRunner scheduledRunner = this.getService();
        if (!scheduledRunner.isShutdown()) {
            scheduledRunner.shutdown();
            try {
                scheduledRunner.awaitTermination(3L);
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)"Interrupted waiting for cleanup process to end.", (Throwable)interruptedException);
            }
            this.setService(new ScheduledRunner());
        }
        this.scheduleService();
        if (bl) {
            this.run();
        }
    }

    @Override
    protected long getNextWakeupTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, this.hour);
        gregorianCalendar.set(12, this.mins);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (date.getTime() >= gregorianCalendar.getTimeInMillis()) {
            gregorianCalendar.add(6, 1);
        }
        return gregorianCalendar.getTimeInMillis();
    }

    public boolean haveValuesChanged(int n, int n2) {
        return this.hour != n || this.mins != n2;
    }

    @Override
    protected long getWaitTime() {
        return 86400L;
    }

    public static final void main(String[] stringArray) {
        DailyCleanupExecutor dailyCleanupExecutor = new DailyCleanupExecutor(0, 5);
        AuditPurgeRunner auditPurgeRunner = new AuditPurgeRunner();
        dailyCleanupExecutor.addRunner(auditPurgeRunner);
        dailyCleanupExecutor.run();
        dailyCleanupExecutor.setNewWakeTime(0, 6, true);
        dailyCleanupExecutor.setupCancel();
        dailyCleanupExecutor.bazinga();
    }

    private void setupCancel() {
        ScheduledRunner scheduledRunner = new ScheduledRunner();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.out.println("Cancel thread starting at - " + new Date());
                System.exit(0);
            }
        };
        scheduledRunner.scheduleAtFixedRate(runnable, 300L, 0L, "Cancel Thread");
    }

    private void bazinga() {
        ScheduledRunner scheduledRunner = new ScheduledRunner();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.out.println("Bazinga! - " + new Date());
            }
        };
        scheduledRunner.scheduleAtFixedRate(runnable, 5L, 5L, "Test Runner");
    }

    @Override
    protected boolean isServerLogEnabled() {
        return true;
    }

    static {
        logger = Logger.getLogger(DailyCleanupExecutor.class);
    }
}

