/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import com.helpsystems.enterprise.peer.SkybotJobPeerException;
import java.io.Serializable;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SkybotCommandPeer
extends SimplePeer {
    private PeerID agentPeerID;

    private SkybotCommandPeer(String string, SimpleConfig simpleConfig) throws PeerStartupException {
        super(string, simpleConfig, 10);
    }

    public PeerID getAgentPeerID() {
        return this.agentPeerID;
    }

    public void startup() throws PeerStartupException {
        super.startup();
        this.addListener(new SimpleEventListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void serviceEvent(GenericEvent genericEvent) {
                try {
                    PeerDescriptor peerDescriptor;
                    if (SkybotCommandPeer.this.agentPeerID == null) {
                        return;
                    }
                    if (!(genericEvent instanceof PeerDisconnectEvent)) return;
                    PeerID peerID = ((PeerDisconnectEvent)genericEvent).getPeerID();
                    if (peerID.equals((Object)SkybotCommandPeer.this.agentPeerID)) {
                        // empty if block
                    }
                    if ((peerDescriptor = peerID.getPeerDescriptor()).getType() != 6) return;
                }
                catch (Throwable throwable) {
                    System.out.println("Error servicing event: " + genericEvent.getClass().getName());
                    throwable.printStackTrace(System.out);
                }
            }
        });
    }

    public static SkybotCommandPeer connectToAgentPeer(int n, String string) throws SkybotJobPeerException {
        SimpleConfig simpleConfig = new SimpleConfig();
        simpleConfig.setListenPort(-1234);
        SkybotCommandPeer skybotCommandPeer = null;
        try {
            skybotCommandPeer = new SkybotCommandPeer(string, simpleConfig);
            skybotCommandPeer.startup();
        }
        catch (Exception exception) {
            throw new SkybotJobPeerException(7, "Unable to start the peer.", exception);
        }
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.addAddress("localhost");
        peerDescriptor.setPort(n);
        peerDescriptor.setType(4);
        try {
            skybotCommandPeer.agentPeerID = skybotCommandPeer.connectToPeer(peerDescriptor, (Serializable)((Object)new NotificationCredentials()));
            ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)skybotCommandPeer));
            return skybotCommandPeer;
        }
        catch (Exception exception) {
            throw new SkybotJobPeerException(3, "Unable to connect to the Agent.", exception);
        }
    }

    private static void exit(int n, String string) {
        SkybotCommandPeer.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    public static void captureSignal(String string) {
        Signal signal = new Signal(string);
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
            }
        };
        Signal.handle(signal, signalHandler);
    }

    static {
        try {
            SkybotCommandPeer.captureSignal("HUP");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

