/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.enterprise.core.busobj.ServicePeerDefinition;
import com.helpsystems.enterprise.peer.ReportRunner;
import com.helpsystems.enterprise.peer.SAPEventMonitorProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ServicePeers
extends CommonVersionedObject
implements XMLSerializable {
    private ArrayList<ServicePeerDefinition> list = new ArrayList();
    private static Logger logger = Logger.getLogger(ServicePeers.class);
    private static final String FILE_NAME = "service_peers.xml";

    public static ServicePeers getDefaultServicePeers() {
        ServicePeers servicePeers = new ServicePeers();
        servicePeers.addPeerDefinition(ReportRunner.getServicePeerDefinition());
        servicePeers.addPeerDefinition(SAPEventMonitorProcess.getServicePeerDefinition());
        return servicePeers;
    }

    public Exception[] save() throws IOException {
        File file = new File(FILE_NAME);
        if (!file.exists()) {
            logger.debug((Object)"File service_peers.xml does not exist, creating file...");
            file.createNewFile();
        }
        return XMLUtil.writeObjectToFile((XMLSerializable)this, (String)FILE_NAME);
    }

    public ServicePeers load() throws IOException {
        File file = new File(FILE_NAME);
        if (!file.exists()) {
            throw new IOException("File service_peers.xml does not exist.");
        }
        Object object = XMLUtil.loadObjectFromFile((String)FILE_NAME);
        if (object instanceof ServicePeers) {
            return (ServicePeers)((Object)object);
        }
        return null;
    }

    public ArrayList<ServicePeerDefinition> getList() {
        return this.list;
    }

    public void setList(ArrayList<ServicePeerDefinition> arrayList) {
        this.list = arrayList;
    }

    private void addPeerDefinition(ServicePeerDefinition servicePeerDefinition) {
        this.list.add(servicePeerDefinition);
    }

    public String[] doNotInvoke() {
        String[] stringArray = new String[]{"save", "load", "getDefaultServicePeers"};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        ServicePeers servicePeers = ServicePeers.getDefaultServicePeers();
        Exception[] exceptionArray = null;
        try {
            exceptionArray = servicePeers.save();
        }
        catch (IOException iOException) {
            logger.debug((Object)"Unable to save the service peers.", (Throwable)iOException);
            System.exit(1);
        }
        if (exceptionArray != null && exceptionArray.length > 0) {
            for (int i = 0; i < exceptionArray.length; ++i) {
                System.out.println("Error:" + i + ": " + exceptionArray[i].getLocalizedMessage());
            }
        }
        try {
            servicePeers = servicePeers.load();
        }
        catch (IOException iOException) {
            logger.debug((Object)"Unable to load the service peers.", (Throwable)iOException);
            System.exit(2);
        }
        for (int i = 0; i < servicePeers.getList().size(); ++i) {
            ServicePeerDefinition servicePeerDefinition = servicePeers.getList().get(i);
            System.out.println("Service (" + i + ") Name: " + servicePeerDefinition.getName());
        }
        System.exit(0);
    }
}

