/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.enterprise.peer.MulticastMessage;
import junit.framework.TestCase;

public class MulticastMessageTest
extends TestCase {
    static final String SEP = "_#_";
    MulticastMessage msg;

    protected void setUp() throws Exception {
        super.setUp();
        this.msg = new MulticastMessage();
    }

    protected void tearDown() throws Exception {
        this.msg = null;
        super.tearDown();
    }

    public void testGetSource() {
        this.msg.setSource("Some source");
        MulticastMessageTest.assertEquals((String)"Some source", (String)this.msg.getSource());
    }

    public void testBlankSourceIsInvalid() {
        try {
            this.msg.setSource("   ");
            MulticastMessageTest.fail((String)"setSource() allowed blank value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullSourceIsInvalid() {
        try {
            this.msg.setSource(null);
            MulticastMessageTest.fail((String)"setSource() allowed null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetDestination() {
        this.msg.setDestination("Some destination");
        MulticastMessageTest.assertEquals((String)"Some destination", (String)this.msg.getDestination());
    }

    public void testBlankDestinationSetToNull() {
        this.msg.setDestination("  ");
        MulticastMessageTest.assertNull((Object)this.msg.getDestination());
    }

    public void testGetMessage() {
        this.msg.setMessage("Some message");
        MulticastMessageTest.assertEquals((String)"Some message", (String)this.msg.getMessage());
    }

    public void testBlankMessageIsInvalid() {
        try {
            this.msg.setMessage("   ");
            MulticastMessageTest.fail((String)"setMessage() allowed blank value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullMessageIsInvalid() {
        try {
            this.msg.setMessage(null);
            MulticastMessageTest.fail((String)"setMessage() allowed null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToString() {
        this.msg.setSource("Source");
        this.msg.setDestination("Dest");
        this.msg.setMessage("Message");
        MulticastMessageTest.assertEquals((String)"Source_#_Dest_#_Message", (String)this.msg.toString());
    }

    public void testToStringThrowsExceptionOnNullSource() {
        MulticastMessageTest.assertNull((String)"Test set-up not correct!", (Object)this.msg.getSource());
        try {
            this.msg.toString();
            MulticastMessageTest.fail((String)"toString() should fail when source is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToStringThrowsExceptionOnNullMessage() {
        this.msg.setSource("Source");
        MulticastMessageTest.assertNull((String)"Test set-up not correct!", (Object)this.msg.getMessage());
        try {
            this.msg.toString();
            MulticastMessageTest.fail((String)"toString() should fail when message is null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testParse() {
        String string = "Source_#_Dest_#_Message";
        this.msg = MulticastMessage.parse(string);
        MulticastMessageTest.assertEquals((String)"Source", (String)this.msg.getSource());
        MulticastMessageTest.assertEquals((String)"Dest", (String)this.msg.getDestination());
        MulticastMessageTest.assertEquals((String)"Message", (String)this.msg.getMessage());
    }

    public void testParseRequiresThreeSegments() {
        String string = "SourceDest_#_Message";
        try {
            this.msg = MulticastMessage.parse(string);
            MulticastMessageTest.fail((String)"parse() accepted an invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseWhereMessageContainsSeparator() {
        String string = "Source_#_Dest_#_Message_#_Bonus";
        this.msg = MulticastMessage.parse(string);
        MulticastMessageTest.assertEquals((String)"Source", (String)this.msg.getSource());
        MulticastMessageTest.assertEquals((String)"Dest", (String)this.msg.getDestination());
        MulticastMessageTest.assertEquals((String)"Message_#_Bonus", (String)this.msg.getMessage());
    }
}

