/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.MulticastMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class MulticastHandler {
    private static final Logger logger = Logger.getLogger(MulticastHandler.class);
    private MulticastSocket multicastSocket;
    private InetAddress multicastGroup;
    private String multicastIdentifier;

    MulticastHandler(AgentPeerConfig agentPeerConfig) throws IOException {
        this(agentPeerConfig.getMulticastAddress(), agentPeerConfig.getMulticastPort(), agentPeerConfig.getMulticastIdentifier());
    }

    public MulticastHandler(String string, int n, String string2) throws IOException {
        this.multicastIdentifier = string2;
        this.multicastGroup = InetAddress.getByName(string);
        this.multicastSocket = new MulticastSocket(n);
        this.multicastSocket.setTimeToLive(0);
        this.multicastSocket.joinGroup(this.multicastGroup);
        if (logger.isTraceEnabled()) {
            InetAddress inetAddress = null;
            boolean bl = true;
            try {
                inetAddress = this.multicastSocket.getInterface();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                bl = this.multicastSocket.getBroadcast();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            logger.trace((Object)("Multicast Handler created, Group: " + this.multicastGroup + " Socket local: " + this.multicastSocket.getLocalPort() + "\n" + "  multicast:" + this.multicastSocket.getPort() + " InetAddress: " + inetAddress + "  broadcast enabled: " + bl));
            if (!bl) {
                logger.trace((Object)"Multicast likely will not work until broadcast is enabled.");
            }
        }
    }

    public void send(String string, String string2) throws IOException {
        MulticastMessage multicastMessage = new MulticastMessage(this.multicastIdentifier, string, string2);
        String string3 = multicastMessage.toString();
        DatagramPacket datagramPacket = new DatagramPacket(string3.getBytes(), string3.length(), this.multicastGroup, this.multicastSocket.getLocalPort());
        this.multicastSocket.send(datagramPacket);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Multicast Handler sending: " + string3 + " to port:" + this.multicastSocket.getLocalPort()));
        }
    }

    public MulticastMessage receive() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Multicast Handler receive() is looking for a DataGramPacket on port: " + this.multicastSocket.getLocalPort()));
        }
        if (this.multicastSocket == null) {
            throw new IOException("Socket not open");
        }
        byte[] byArray = new byte[1000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.multicastSocket.receive(datagramPacket);
        String string = new String(byArray, 0, datagramPacket.getLength());
        string = string.trim();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Multicast Handler recieved: " + string));
        }
        return MulticastMessage.parse(string);
    }

    public String getIdentifier() {
        return this.multicastIdentifier;
    }
}

