/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.server.file.BasicFileAM;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionType;
import com.helpsystems.enterprise.core.util.JobConditionMessageGenerator;
import com.helpsystems.enterprise.peer.AgentConditionsAMImpl;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import com.helpsystems.enterprise.peer.preconditions.JobConditionsExecutor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class JobConditionsPeer
extends SimplePeer {
    private static final int INVALID_PATH_CODE = 8;
    private PeerID agentPeerID;

    private JobConditionsPeer(String string, SimpleConfig simpleConfig) throws PeerStartupException {
        super(string, simpleConfig);
    }

    public void startup() throws PeerStartupException {
        super.startup();
        BasicFileAM basicFileAM = new BasicFileAM();
        basicFileAM.setName("COMMON.RemoteFileAM");
        ManagerRegistry.registerManager((IAbstractManager)basicFileAM);
        this.addListener(new SimpleEventListener(){

            public void serviceEvent(GenericEvent genericEvent) {
                if (JobConditionsPeer.this.agentPeerID == null) {
                    return;
                }
                if (genericEvent instanceof PeerDisconnectEvent) {
                    PeerDescriptor peerDescriptor;
                    PeerID peerID = ((PeerDisconnectEvent)genericEvent).getPeerID();
                    if (peerID.equals((Object)JobConditionsPeer.this.agentPeerID)) {
                        JobConditionsPeer.exit(4, "Agent " + JobConditionsPeer.this.agentPeerID.getPeerDescriptor().findName() + " is no longer available.");
                    }
                    if ((peerDescriptor = peerID.getPeerDescriptor()).getType() == 6) {
                        JobConditionsPeer.exit(5, "Enterprise Server " + peerDescriptor + " is no longer available.");
                    }
                }
            }
        });
        ManagerRegistry.registerManager((IAbstractManager)new AgentConditionsAMImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Logger.getRootLogger().setLevel(Level.OFF);
        JobConditionsPeer jobConditionsPeer = null;
        try {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            String[] stringArray2 = new String[2];
            JobCondition jobCondition = JobConditionsPeer.parseParameters(stringArray, stringArray2);
            JobConditionsPeer.validatePath(jobCondition);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(stringArray2[0]);
            }
            catch (Exception exception) {
                JobConditionsPeer.exit(2, "Invalid port specified: " + stringArray[0]);
            }
            SimpleConfig simpleConfig = new SimpleConfig();
            simpleConfig.setListenPort(-1234);
            try {
                jobConditionsPeer = new JobConditionsPeer(stringArray2[1], simpleConfig);
                jobConditionsPeer.startup();
            }
            catch (Exception exception) {
                JobConditionsPeer.exit(7, "Unable to start the peer", exception);
            }
            PeerDescriptor peerDescriptor = new PeerDescriptor();
            peerDescriptor.addAddress("localhost");
            peerDescriptor.setPort(n2);
            peerDescriptor.setType(4);
            try {
                jobConditionsPeer.agentPeerID = jobConditionsPeer.connectToPeer(peerDescriptor, (Serializable)((Object)new NotificationCredentials()));
                System.out.println("Connecting to Agent Peer ID " + jobConditionsPeer.agentPeerID);
                ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)jobConditionsPeer));
            }
            catch (Exception exception) {
                jobConditionsPeer.disconnectAll();
                JobConditionsPeer.exit(3, "Unable to connect to the Agent.", exception);
            }
            JobConditionsExecutor jobConditionsExecutor = new JobConditionsExecutor(jobConditionsPeer.agentPeerID);
            boolean bl = jobConditionsExecutor.checkCondition(jobCondition);
            if (bl) {
                String string = "Condition passed: " + JobConditionMessageGenerator.getConditionMessage((JobCondition)jobCondition);
                JobConditionsPeer.exit(0, string);
            } else {
                String string = "Condition failed: " + JobConditionMessageGenerator.getConditionFailedMessage((JobCondition)jobCondition) + ".";
                JobConditionsPeer.exit(1, string);
            }
        }
        catch (Throwable throwable) {
            JobConditionsPeer.exit(1, "Condition check failed", throwable);
        }
        finally {
            if (jobConditionsPeer != null) {
                jobConditionsPeer.disconnectAll();
            }
        }
    }

    private static void exit(int n, String string) {
        JobConditionsPeer.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    public static void captureSignal(String string) {
        Signal signal = new Signal(string);
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
            }
        };
        Signal.handle(signal, signalHandler);
    }

    public static JobCondition parseParameters(String[] stringArray, String[] stringArray2) throws ActionFailedException {
        JobCondition jobCondition = new JobCondition();
        String string = null;
        String string2 = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray[i].split(":");
            int n2 = stringArray3.length;
            if (n2 > 0) {
                string = stringArray3[0].trim().toLowerCase();
            }
            string2 = null;
            if (n2 == 2) {
                string2 = stringArray3[1];
            } else if (n2 > 2) {
                String string3;
                string2 = string3 = stringArray[i].substring(stringArray3[0].length() + 1);
            }
            try {
                if (string.equals("-u")) {
                    stringArray2[0] = string2;
                    continue;
                }
                if (string.equals("-q")) {
                    stringArray2[1] = string2;
                    continue;
                }
                if (string.equals("-i")) {
                    jobCondition.setOid(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("-j")) {
                    jobCondition.setJobId(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("-s")) {
                    jobCondition.setSequenceNumber(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("-t")) {
                    jobCondition.setConditionType(JobConditionType.persistanceCodeToEnum((int)Integer.parseInt(string2)));
                    continue;
                }
                if (string.equals("-d")) {
                    System.out.println("Option:" + string + " Value:" + string2);
                    jobCondition.setConditionData(string2);
                    continue;
                }
                if (string.equals("-y")) {
                    if (string2 != null && !string2.isEmpty()) {
                        System.out.println("Option:" + string + " Value:" + string2);
                        jobCondition.setConditionData1(string2);
                    }
                    continue;
                }
                if (string.equals("-n")) {
                    System.out.println("Option:" + string + " Value:" + string2);
                    jobCondition.setConditionVar1(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("-m")) {
                    System.out.println("Option:" + string + " Value:" + string2);
                    jobCondition.setConditionVar2(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("-c")) {
                    if ("yes".equals(string2)) {
                        jobCondition.setConditionChoice(true);
                        continue;
                    }
                    if (!"no".equals(string2)) continue;
                    jobCondition.setConditionChoice(false);
                    continue;
                }
                if (string.equals("-o")) {
                    jobCondition.setConjunction(string2);
                    continue;
                }
                throw new ActionFailedException("Invalid option parameter: " + string + " full parm: " + stringArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        if (jobCondition.getConditionData() != null && jobCondition.getConditionType() == JobConditionType.PROCESS) {
            String string4 = jobCondition.getConditionData();
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                string4 = new String(bASE64Decoder.decodeBuffer(string4));
            }
            catch (IOException iOException) {
                throw new ActionFailedException("Invalid option parameter: condition proce name");
            }
            jobCondition.setConditionData(string4);
        }
        return jobCondition;
    }

    private static void validatePath(JobCondition jobCondition) {
        String string;
        if (!(jobCondition.getConditionType() != JobConditionType.FILE && jobCondition.getConditionType() != JobConditionType.FOLDER || JobConditionsPeer.isFullPath(string = jobCondition.getConditionData()))) {
            JobConditionsPeer.exit(8, string);
        }
    }

    private static boolean isFullPath(String string) {
        boolean bl = true;
        if (string == null) {
            bl = false;
        } else {
            File file = new File(string);
            bl = file.isAbsolute();
        }
        return bl;
    }

    static {
        try {
            JobConditionsPeer.captureSignal("HUP");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            System.out.println("Unable to capture HUP signals");
            exception.printStackTrace(System.out);
        }
    }
}

