/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.ImportCronException;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.ImportCronAM;
import com.helpsystems.enterprise.core.dm.ImportFileDM;
import org.apache.log4j.Logger;

public class ImportCronAMImpl
extends AbstractManager
implements ImportCronAM {
    private static final Logger logger = Logger.getLogger(ImportCronAMImpl.class);

    public ImportCronAMImpl() {
        this.setName("ENTERPRISE.ImportCronAM");
    }

    public void importCronFile(BasicIdentifier basicIdentifier, PeerID peerID, String string, byte[] byArray) throws ImportCronException {
        try {
            ImportFileDM importFileDM = (ImportFileDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)basicIdentifier, (String)"ENTERPRISE.ImportFileDM");
            importFileDM.saveFileToDB(string, byArray, "cron", this.getAgentId(basicIdentifier, peerID));
            logger.info((Object)("Crontab file " + string + " uploaded to the enterprise server."));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ImportCronException("Problem with db ", (Exception)((Object)resourceUnavailableException));
        }
        catch (DataException dataException) {
            throw new ImportCronException("Problem with db ", (Exception)((Object)dataException));
        }
    }

    private long getAgentId(BasicIdentifier basicIdentifier, PeerID peerID) throws ResourceUnavailableException, DataException {
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)basicIdentifier, (String)"ENTERPRISE.AgentDM");
        Agent agent = agentDM.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), peerID.getInstanceIdentifier().toString());
        return agent.getOid();
    }
}

