/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.RoutableEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.message.MessageEventListener;
import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.CollectedExceptions;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.actions.ActionEvent;
import com.helpsystems.enterprise.core.busobj.actions.AgentReplaceEvent;
import com.helpsystems.enterprise.core.busobj.actions.AgentStopEvent;
import com.helpsystems.enterprise.core.busobj.actions.AgentStopRestartEvent;
import com.helpsystems.enterprise.core.busobj.actions.SetAgentLoggingLevelEvent;
import com.helpsystems.enterprise.core.busobj.actions.TerminateJobEvent;
import com.helpsystems.enterprise.core.dm.AgentAM;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.logger.CrossAppenderLogger;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.ReportRunnerWatcher;
import com.helpsystems.enterprise.peer.StandbyBackupFileTransferRunner;
import com.helpsystems.enterprise.peer.ha.StandbyServerListener;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.w3c.dom.Document;

public class EnterpriseServerDriver
implements Runnable,
InterruptibleProcess {
    private static Logger logger = Logger.getLogger(EnterpriseServerDriver.class);
    public static final String THREAD_NAME = EnterpriseServerDriver.class.getSimpleName();
    private static final int STANDBY_BACKUP_FILE_TRANSFER_RUNNER_COUNT = 4;
    private AgentPeer serverPeer;
    private String serverPath = null;
    private AgentPeerConfig config = null;
    private ReportRunnerWatcher reportRunnerWatcher = null;
    private StandbyBackupFileTransferRunner[] standbyBackupFileTransferRunnerArray = null;
    private ThreadGroup standbyFileTransferRunnerThreadGroup = null;
    private boolean standbyFileRunnersReady = false;

    public EnterpriseServerDriver(String string) {
        this.serverPath = string;
        if (this.serverPath == null) {
            logger.trace((Object)"Enterprise Server Setup was not specified...using default values!");
            this.config = AgentPeerConfig.getDefaultServerPeer();
        } else {
            logger.trace((Object)("Loading Enterprise Server Setup file: " + string));
            File file = new File(string);
            if (file.exists()) {
                try {
                    Document document = XMLUtil.loadXML((String)file.getAbsolutePath());
                    this.config = (AgentPeerConfig)((Object)XMLReflector.readObject((Document)document));
                    logger.trace((Object)("Using file " + string + "..."));
                }
                catch (Exception exception) {
                    logger.trace((Object)"Error loading Enterprise Server Setup file...using default values!", (Throwable)exception);
                    this.config = AgentPeerConfig.getDefaultServerPeer();
                }
            } else {
                logger.trace((Object)"Enterprise Server Setup file does not exist...using default values!");
                this.config = AgentPeerConfig.getDefaultServerPeer();
            }
        }
    }

    @Override
    public void run() {
        MDC.put((String)"MDC_LOG_ID", (String)Log4jID.SERVER.getMDCKeyValue());
        logger.info((Object)("Starting the " + Thread.currentThread().getName() + " Thread..."));
        try {
            String string = System.getProperty("os.name");
            int n = AgentPeer.DEFAULT_SERVER_PORT;
            n = this.config.getListenPort();
            if (n == 0) {
                n = AgentPeer.DEFAULT_SERVER_PORT;
            }
            int n2 = 6;
            if (this.isStandby()) {
                n2 = 9;
            }
            PeerDescriptor peerDescriptor = new PeerDescriptor("localhost", n, n2, string);
            this.serverPeer = new AgentPeer(peerDescriptor, this.config);
            this.serverPeer.setConfigPath(this.serverPath);
            if (!this.isStandby()) {
                boolean bl = string.toLowerCase().contains("windows");
                this.createReportRunnerServiceWatcherThread(bl, n);
            }
            this.serverPeer.startup();
            if (!this.isStandby()) {
                this.createStandbyBackupFileTransferRunnerThreadGroup();
                this.serverPeer.addListener((SimpleEventListener)new StandbyServerListener(this));
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"The Enterprise Server Driver ended in error.", throwable);
            try {
                if (this.reportRunnerWatcher != null) {
                    this.reportRunnerWatcher.shutdown();
                }
                if (this.standbyFileTransferRunnerThreadGroup != null) {
                    this.standbyFileTransferRunnerThreadGroup.interrupt();
                }
                this.serverPeer.shutdown();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    private void createReportRunnerServiceWatcherThread(boolean bl, int n) {
        if (this.reportRunnerWatcher == null) {
            this.reportRunnerWatcher = new ReportRunnerWatcher(this.serverPeer, bl, n);
        }
    }

    public ReportRunnerWatcher getReportRunnerWatcher() {
        return this.reportRunnerWatcher;
    }

    private void createStandbyBackupFileTransferRunnerThreadGroup() {
        this.standbyBackupFileTransferRunnerArray = new StandbyBackupFileTransferRunner[4];
        this.standbyFileTransferRunnerThreadGroup = new ThreadGroup("The StandbyBackupFileTransferRunnerThreads");
        Thread thread = null;
        long l = SkybotStackSize.getStackSize();
        for (int i = 0; i < 4; ++i) {
            StandbyBackupFileTransferRunner standbyBackupFileTransferRunner = new StandbyBackupFileTransferRunner(this.serverPeer);
            thread = l != 0L ? new Thread(this.standbyFileTransferRunnerThreadGroup, standbyBackupFileTransferRunner, "Standby backup file transfer runner thread", l) : new Thread(this.standbyFileTransferRunnerThreadGroup, standbyBackupFileTransferRunner, "Standby backup file transfer runner thread");
            this.standbyBackupFileTransferRunnerArray[i] = standbyBackupFileTransferRunner;
            thread.start();
        }
        this.standbyFileTransferRunnerThreadGroup.setDaemon(true);
        this.standbyFileRunnersReady = true;
    }

    public ThreadGroup getStandbyBackupFileTransferRunnerThreadGroup() {
        return this.standbyFileTransferRunnerThreadGroup;
    }

    public void interrupt() {
        if (this.serverPeer != null && !this.serverPeer.isShutdownRequested()) {
            if (this.reportRunnerWatcher != null) {
                this.reportRunnerWatcher.shutdown();
            }
            if (this.standbyFileTransferRunnerThreadGroup != null && this.standbyBackupFileTransferRunnerArray != null) {
                for (StandbyBackupFileTransferRunner standbyBackupFileTransferRunner : this.standbyBackupFileTransferRunnerArray) {
                    standbyBackupFileTransferRunner.shutdown();
                }
                this.standbyFileTransferRunnerThreadGroup.interrupt();
            }
            this.serverPeer.shutdownServer();
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        return this.serverPeer.isShutdownRequested();
    }

    public boolean isStartupComplete() {
        if (this.serverPeer != null) {
            if (this.isStandby()) {
                return this.serverPeer.isStartupComplete();
            }
            return this.getReportRunnerWatcher() != null && this.standbyFileRunnersReady && this.serverPeer.isStartupComplete();
        }
        return false;
    }

    public String getStatus() {
        if (this.serverPeer != null) {
            return this.serverPeer.getHtmlSection("general");
        }
        return "Shutting down...";
    }

    public AgentPeerConfig getAgentPeerConfig() {
        return this.serverPeer.getAgentConfig();
    }

    public boolean isHoldScheduler() {
        return this.config.getHoldScheduler();
    }

    public boolean isHoldAllAgents() {
        return this.config.getHoldAgents();
    }

    public void saveConfig() throws IOException {
        this.serverPeer.saveConfig();
    }

    public void serviceAgentRequestDirectly(ActionEvent actionEvent, MessageEventListener messageEventListener) throws Exception {
        if (actionEvent instanceof AgentStopRestartEvent) {
            String string = "Restart Agent command processing.  Press Refresh to see results.";
            try {
                this.processStopRestart((AgentStopEvent)actionEvent, true);
            }
            catch (Exception exception) {
                string = "Unable to execute restart command.  " + exception.getMessage();
                throw exception;
            }
            finally {
                messageEventListener.serviceMessageEvent((RoutableEvent)actionEvent, string);
            }
        } else if (actionEvent instanceof AgentReplaceEvent) {
            this.processAgentReplacement((AgentReplaceEvent)actionEvent);
        } else if (actionEvent instanceof AgentStopEvent) {
            String string = "Stop Agent command processing.";
            try {
                this.processStopRestart((AgentStopEvent)actionEvent, false);
            }
            catch (Exception exception) {
                string = "Unable to execute stop command.  " + exception.getMessage();
                throw exception;
            }
            finally {
                messageEventListener.serviceMessageEvent((RoutableEvent)actionEvent, string);
            }
        } else {
            logger.debug((Object)("Unable to process command: " + actionEvent.toString()));
            return;
        }
    }

    private void processAgentReplacement(AgentReplaceEvent agentReplaceEvent) throws Exception {
        try {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
            ScheduleLogEntry scheduleLogEntry = null;
            long l = agentReplaceEvent.getAgentOid()[0];
            Agent agent = agentDM.get(l);
            Agent agent2 = agentDM.get((long)agentReplaceEvent.getOldAgentOid());
            String[] stringArray = new String[]{agent2.getName(), String.valueOf(agent2.getPort()), agent.getName(), String.valueOf(agent.getPort()), agentReplaceEvent.getUser()};
            scheduleLogEntry = RosettaMsg.AGENT_REPLACED_BY_USER.newLogEntry(stringArray);
            logger.info((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseServerAM");
            enterpriseServerAM.agentInfoUpdated(agent2.getOid());
        }
        catch (Exception exception) {
            logger.error((Object)"Error processing Agent replacement.", (Throwable)exception);
        }
        this.processStopRestart((AgentStopEvent)agentReplaceEvent, true);
    }

    public int serviceTerminateJobRequestDirectly(TerminateJobEvent terminateJobEvent, MessageEventListener messageEventListener) {
        logger.trace((Object)"*** inside serviceTerminateJobRequestDirectly");
        JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
        try {
            try {
                jobTrackerAM.terminateJob(terminateJobEvent.getJobHistoryOID(), terminateJobEvent.getGUID(), terminateJobEvent.getUser(), terminateJobEvent.getJobStatusCode());
                logger.trace((Object)"serviceTerminateJobRequestDirectly is returning 0");
                return 0;
            }
            catch (ActionFailedException actionFailedException) {
                logger.trace((Object)"serviceTerminateJobRequestDirectly is returning 1");
                return 1;
            }
            catch (EndJobException endJobException) {
                if (endJobException.getRootException() instanceof InvalidStateException) {
                    logger.trace((Object)"serviceTerminateJobRequestDirectly is returning 2");
                    String string = "Unable to terminate job. " + endJobException.getLocalizedMessage();
                    messageEventListener.serviceMessageEvent((RoutableEvent)terminateJobEvent, string);
                    return 2;
                }
                throw endJobException;
            }
        }
        catch (Exception exception) {
            logger.trace((Object)"serviceTerminateJobRequestDirectly is returning 3");
            String string = "Unable to terminate job. " + exception.getLocalizedMessage();
            messageEventListener.serviceMessageEvent((RoutableEvent)terminateJobEvent, string);
            return 3;
        }
    }

    public void serviceAgentRequest(ActionEvent actionEvent, MessageEventListener messageEventListener) {
        if (!(actionEvent instanceof SetAgentLoggingLevelEvent)) {
            logger.debug((Object)("Unable to process command: " + actionEvent.toString()));
            return;
        }
        this.processSetLoggingLevel((SetAgentLoggingLevelEvent)actionEvent);
    }

    private AgentAM getAgentAM(long l) {
        try {
            Agent agent = MRHelper.getAgentDM().get(l);
            AgentAM agentAM = (AgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"ENTERPRISE.AgentAM");
            logger.debug((Object)("Getting AM for agent " + agent.getName()));
            return agentAM;
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to process find the agent action manager.", (Throwable)exception);
            return null;
        }
    }

    public String getAgentFileEncoding(long l) {
        Agent agent;
        try {
            agent = MRHelper.getAgentDM().get(l);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to retrieve the file encoding.", (Throwable)exception);
            return null;
        }
        RemoteFileAM remoteFileAM = (RemoteFileAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"COMMON.RemoteFileAM");
        if (remoteFileAM != null) {
            logger.debug((Object)("Getting file encoding for Agent:  " + agent.getName()));
            return remoteFileAM.getDefaultEncoding();
        }
        logger.debug((Object)"Unable to retrieve the file encoding.");
        return null;
    }

    public int getAgentLoggingLevel(long l) {
        Agent agent;
        try {
            agent = MRHelper.getAgentDM().get(l);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to retrieve the logging level.", (Throwable)exception);
            return -1;
        }
        IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"PEER.PeerInfoManager");
        if (iPeerInfoManager != null) {
            logger.debug((Object)("Getting logging level for Agent:  " + agent.getName()));
            return iPeerInfoManager.getLoggingLevel();
        }
        logger.debug((Object)"Unable to retrieve the logging level.");
        return -1;
    }

    private void processSetLoggingLevel(SetAgentLoggingLevelEvent setAgentLoggingLevelEvent) {
        Agent agent;
        long l = setAgentLoggingLevelEvent.getAgentOID();
        try {
            agent = MRHelper.getAgentDM().get(l);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to retrieve the logging level.", (Throwable)exception);
            return;
        }
        IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"PEER.PeerInfoManager");
        if (iPeerInfoManager != null) {
            logger.debug((Object)("Setting logging level of Agent " + agent.getName() + " to level " + Level.toLevel((int)setAgentLoggingLevelEvent.getLevel())));
            try {
                iPeerInfoManager.setLoggingLevel(setAgentLoggingLevelEvent.getLevel());
                return;
            }
            catch (IOException iOException) {
                logger.debug((Object)("Unable to process command: " + setAgentLoggingLevelEvent.toString()), (Throwable)iOException);
            }
        }
        logger.debug((Object)("Unable to process command: " + setAgentLoggingLevelEvent.toString()));
    }

    private void processStopRestart(AgentStopEvent agentStopEvent, boolean bl) throws Exception {
        CollectedExceptions collectedExceptions = new CollectedExceptions();
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        long[] lArray = agentStopEvent.getAgentOid();
        for (int i = 0; i < lArray.length; ++i) {
            try {
                SystemMessage systemMessage;
                AgentAM agentAM = this.getAgentAM(lArray[i]);
                logger.debug((Object)("After getAgentAM(" + lArray[i] + ")"));
                if (agentAM == null) {
                    throw new ActionFailedException("Agent is not available.");
                }
                agentAM.stop(bl);
                String string = agentDM.get(lArray[i]).getName();
                String[] stringArray = new String[]{string, agentStopEvent.getUser()};
                ScheduleLogEntry scheduleLogEntry = null;
                if (bl) {
                    scheduleLogEntry = RosettaMsg.AGENT_RESTARTED_BY_USER.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.AGENT_RESTARTED_BY_USER.newSystemMessage(stringArray);
                    SystemMessageQueue.write((SystemMessage)systemMessage);
                } else {
                    scheduleLogEntry = RosettaMsg.AGENT_STOPPED_BY_USER.newLogEntry(stringArray);
                    systemMessage = RosettaMsg.AGENT_STOPPED_BY_USER.newSystemMessage(stringArray);
                    SystemMessage systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_SERVER_NOTICE_AGENT_STOPPED_BY_USER.newSystemMessage(stringArray);
                    SystemMessageQueue.write((SystemMessage)systemMessage, (SystemMessage)systemMessage2);
                }
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                continue;
            }
            catch (Exception exception) {
                collectedExceptions.add(exception);
            }
        }
        if (!collectedExceptions.isEmpty()) {
            throw collectedExceptions;
        }
    }

    public int getLoggingLevel() {
        IPeerInfoManager iPeerInfoManager;
        if (this.serverPeer != null && (iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManager((String)"PEER.PeerInfoManager")) != null) {
            return iPeerInfoManager.getLoggingLevel();
        }
        return -1;
    }

    public void setLoggingLevel(int n, String string) {
        if (this.serverPeer != null) {
            Level level = this.getLevel(n);
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManager((String)"PEER.PeerInfoManager");
            if (iPeerInfoManager != null) {
                try {
                    int n2 = iPeerInfoManager.getLoggingLevel();
                    if (n2 != n) {
                        iPeerInfoManager.setLoggingLevel(n);
                        String string2 = "The logging level was set to " + level.toString() + " by User " + string + ".";
                        CrossAppenderLogger.logMessage((Log4jID)Log4jID.SERVER, (String)string2);
                        CrossAppenderLogger.logMessage((Log4jID)Log4jID.SCHEDULER, (String)string2);
                    }
                }
                catch (IOException iOException) {
                    logger.info((Object)"Could not save the Logging Level change.  No configuration file is present.");
                    logger.info((Object)("The logging level was set to " + level.toString() + " by User " + string + ", but level could not be saved."));
                    logger.info((Object)"The logging level will revert to the default the next time it starts..");
                }
            } else {
                logger.debug((Object)("Unable to set logging level to " + level.toString() + "."));
            }
        }
    }

    private Level getLevel(int n) {
        switch (n) {
            case 5000: {
                return Level.TRACE;
            }
            case 10000: {
                return Level.DEBUG;
            }
        }
        return Level.INFO;
    }

    public String getServerAddressAndPort() {
        if (this.serverPeer != null && this.serverPeer.isServer() && this.serverPeer.getPeerDescriptor() != null) {
            this.serverPeer.getPeerDescriptor();
            String string = PeerDescriptor.getLocalHostname();
            int n = this.serverPeer.getPeerDescriptor().getPort();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(":");
            stringBuffer.append(n);
            return stringBuffer.toString();
        }
        return "Server Info not found.";
    }

    public String getReportRunnerAddressAndPort() {
        if (this.serverPeer != null && this.serverPeer.isServer() && this.serverPeer.getPeerDescriptor() != null) {
            this.serverPeer.getPeerDescriptor();
            String string = PeerDescriptor.getLocalHostname();
            int n = this.reportRunnerWatcher.port;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(":");
            stringBuffer.append(n);
            return stringBuffer.toString();
        }
        return "Report Runner Info not found.";
    }

    public AgentPeer getServerPeer() {
        return this.serverPeer;
    }

    private boolean isStandby() {
        return AgentPeerConfig.AgentMode.STANDBY.equals((Object)this.config.getMode());
    }

    public void updateCurrentStatuses() {
        EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseServerAM");
        enterpriseServerAM.updateCurrentStatuses();
    }
}

