/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ChangeConfig {
    private ChangeConfig() {
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            ChangeConfig.showHelp();
            return;
        }
        if (stringArray.length == 1 && ("--help".equals(object3 = stringArray[0]) || "-help".equals(object3) || "-h".equals(object3) || "/h".equals(object3))) {
            ChangeConfig.showHelp();
            return;
        }
        object3 = null;
        Map<String, List<String>> map = AgentControl.parseArgs(stringArray);
        List<String> list = map.remove("f");
        if (list == null || list.size() == 0) {
            list = new ArrayList<String>();
            list.add("agent.xml");
        }
        if (list.size() > 1) {
            AgentControl.finished("This utility can only use one config file.", null, -1);
        }
        String string = list.get(0);
        File file = new File(string);
        if (AgentControl.isWindows() && !file.exists() && string.indexOf("/") == -1 && string.indexOf("\\") == -1) {
            string = DefaultConfigPath.getDefaultPath() + File.separator + string;
            file = new File(string);
        }
        if (file.isDirectory()) {
            AgentControl.finished("The filename " + file.getAbsolutePath() + " is a directory.", null, -1);
        }
        if (file.exists()) {
            try {
                object2 = XMLUtil.loadXML((String)file.getAbsolutePath());
                object3 = (AgentPeerConfig)((Object)XMLReflector.readObject((Document)object2));
            }
            catch (Exception exception) {
                AgentControl.finished("Unable to parse the content of the configuration file " + string, exception, -1);
            }
        } else {
            object3 = new AgentPeerConfig();
            ((AgentPeerConfig)((Object)object3)).setMode(AgentPeerConfig.AgentMode.CLIENT);
        }
        object2 = ChangeConfig.getSingleString(map, "lp");
        if (object2 != null) {
            object3.setListenPort(ChangeConfig.parsePortOrFail((String)object2));
        }
        if ((object2 = ChangeConfig.getSingleString(map, "sa")) != null) {
            object = ((AgentPeerConfig)((Object)object3)).getMaster();
            if (object == null) {
                object = new PeerDescriptor();
            }
            object.clearAddresses();
            object.addAddress((String)object2);
            ((AgentPeerConfig)((Object)object3)).setMaster((PeerDescriptor)object);
        }
        if ((object2 = ChangeConfig.getSingleString(map, "sp")) != null) {
            object = ((AgentPeerConfig)((Object)object3)).getMaster();
            if (object == null) {
                object = new PeerDescriptor();
            }
            object.setPort(ChangeConfig.parsePortOrFail((String)object2));
            ((AgentPeerConfig)((Object)object3)).setMaster((PeerDescriptor)object);
        }
        if ((object2 = ChangeConfig.getSingleString(map, "xm")) != null) {
            object2 = ((String)object2).toUpperCase();
            ((AgentPeerConfig)((Object)object3)).setModeAsString((String)object2);
        }
        try {
            object = IBMiAgent.getPropertyValue((IBMiAgent.AgentProperty)IBMiAgent.AgentProperty.PRODLIB);
            String string2 = IBMiAgent.getPropertyValue((IBMiAgent.AgentProperty)IBMiAgent.AgentProperty.ASPGRP);
            if (object != null && ((String)object).trim().length() > 0) {
                object = ((String)object).trim().toUpperCase();
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string3 = inetAddress.getHostName();
                string3 = string3 != null && string3.trim().length() > 0 ? string3.trim().toUpperCase() : "UNKNOWN";
                string2 = string2 != null && string2.trim().length() > 0 ? string2.trim().toUpperCase() : "UNKNOWN";
                String string4 = string3.split("\\.")[0];
                if (!string2.startsWith("*SYSBAS")) {
                    string4 = string4 + "_" + string2;
                }
                string4 = string4 + "_" + (String)object;
                ((AgentPeerConfig)((Object)object3)).setSpecifiedAgentName(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string2 : map.keySet()) {
            System.out.println("Ignoring unknown setting: " + string2);
        }
        try {
            XMLUtil.writeXML((Document)XMLReflector.writeObject((XMLSerializable)object3), (String)file.getAbsolutePath());
        }
        catch (Exception exception) {
            AgentControl.finished("Unable to write the configuration file " + string, exception, -1);
        }
    }

    static int parsePortOrFail(String string) {
        if (string == null || string.trim().length() == 0) {
            AgentControl.finished("Please specify a port number.", null, -1);
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            AgentControl.finished("Invalid port number: " + string, null, -1);
        }
        if (n < 1 || n > 65535) {
            AgentControl.finished("Invalid port number: " + string + ". The number must be between 1 and 65535.", null, -1);
        }
        return n;
    }

    private static String getSingleString(Map<String, List<String>> map, String string) {
        List<String> list = map.remove(string);
        if (list == null) {
            return null;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static void showHelp() {
        System.out.println("Changes an Agent's configuration.");
        System.out.println("  -f      Specifies the name of the config file, like agent.xml.");
        System.out.println("  -lp     Sets the number for the listen port.");
        System.out.println("  -sa     Sets the server address to which this Agent should connect.");
        System.out.println("  -sp     Sets the server port to which this Agent should connect.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRubyEnvironment(File file, boolean bl) throws IOException {
        Object object;
        File file2 = new File(file.getParentFile(), "environment.rb");
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        try {
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).trim().startsWith("SKYBOT_STANDBY")) {
                    object = "SKYBOT_STANDBY = " + bl;
                }
                arrayList.add((String)object);
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        object = new PrintWriter(file2);
        try {
            for (String string : arrayList) {
                ((PrintWriter)object).println(string);
            }
        }
        finally {
            try {
                ((PrintWriter)object).close();
            }
            catch (Exception exception) {}
        }
    }
}

