/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.access.MultipleMatchesException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.license.AgentLicenseTier;
import com.helpsystems.common.core.license.AgentLicenseVersion;
import com.helpsystems.common.core.license.InvalidLicenseVersionException;
import com.helpsystems.common.core.util.DaemonThreadFactory;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.server.access.basic.BasicEncryptUtilAM;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.common.tl.event.ServerSocketClosedEvent;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.PeerConnectException;
import com.helpsystems.common.tl.ex.PeerRedirectException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.module.GenericJarModule;
import com.helpsystems.common.tl.module.Module;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.common.tl.module.ModuleInfo;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentLicenseStatus;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo_Validated;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import com.helpsystems.enterprise.core.busobj.traps.AgentConnectionSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseServerSNMPTrap;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommandReply;
import com.helpsystems.enterprise.core.cmdlineobj.AgentEndingCommand;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferInfo;
import com.helpsystems.enterprise.core.dm.AgentCommandAM;
import com.helpsystems.enterprise.core.dm.AgentConfigAM;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.core.dm.AgentWorkManagerAM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.IBMiJobExecDM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.SchedulerAM;
import com.helpsystems.enterprise.core.dm.SkybotCommandDM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.core.dm.sap.SAPServerHelperAM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobTimer;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import com.helpsystems.enterprise.peer.AgentCommandProcessor;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.AgentCredentials;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.peer.AgentUpdater;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.peer.FileTransferInfoAMImpl;
import com.helpsystems.enterprise.peer.FileTransferInfoFetcher;
import com.helpsystems.enterprise.peer.LocalAgentAM;
import com.helpsystems.enterprise.peer.MulticastHandler;
import com.helpsystems.enterprise.peer.MulticastMessage;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import com.helpsystems.enterprise.peer.WindowsAgentAM;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class AgentPeer
extends HeavyweightPeer {
    public static int DEFAULT_SERVER_PORT = 7472;
    private static final String AGENT_LOG4J_FILENAME_KEY = "log4j.appender.R.File";
    private static final String logFilePropertyKey = "agentLog";
    private static final Logger logger = Logger.getLogger(AgentPeer.class);
    public static final String PRODUCT_NAME = "schent-mp";
    private static final int REASON_AGENT_UNAVAILABLE = 1;
    private static final int REASON_AGENT_FAILED = 2;
    private static final int REASON_AGENT_ENDED = 3;
    public static final String SHUTDOWN_STD_OUT = "Shutdown Request: ";
    public static final int RESTART_EXIT_VALUE = 99;
    public static final int UPDATE_EXIT_VALUE = 97;
    static final String QUERY = "V2_QUERY";
    private static final String JOB_LOG_URL = "joblog";
    private static final String UPDATE_LOG_URL = "update_log";
    public static final String CMD_JVMDUMP = "dump";
    private boolean firstMasterConnectFailure;
    private boolean firstStandbyConnectFailure;
    private MulticastHandler multicastHandler;
    private TreeMap<String, String> localAgentClientMap;
    private InitialAgentNotifier initialAgentNotifier;
    private boolean readyForConnections;
    private Thread shutdownThread;
    private boolean gracefulShutdown;
    private int restartAfterShutdown;
    private AgentConnector connector;
    private HashMap<PeerID, AgentLicenseStatus> licensedAgentMap;
    private ArrayList<PeerID> peerConnectList;
    private ArrayList<PeerID> endingAgentsList = new ArrayList();
    private Set<PeerID> agentsThatAreEnding = new HashSet<PeerID>();
    private boolean ignoreAgentDisconnect = false;
    private long lastErrorTime = 0L;
    private String shutdownCommand;
    private boolean startupComplete = false;
    private boolean serverShutdownStarted = false;
    private AgentLicenseInfo cachedAgentLicenseInfo;
    private JobQueuesDM jobQueuesDM;

    public AgentPeer(PeerDescriptor peerDescriptor, AgentPeerConfig agentPeerConfig) throws PeerStartupException {
        super(peerDescriptor, (Serializable)((Object)AgentPeer.buildInstanceIdentifier(agentPeerConfig)), (HeavyweightPeerConfig)agentPeerConfig);
        ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)this));
        this.peerConnectList = new ArrayList();
    }

    private static String buildInstanceIdentifier(AgentPeerConfig agentPeerConfig) throws PeerStartupException {
        int n = agentPeerConfig.getListenPort();
        if (n > 0) {
            if (agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.SERVER || agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.STANDBY) {
                return "s" + n;
            }
            if (agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.CLIENT) {
                return "a" + n;
            }
            if (agentPeerConfig.getMode() == AgentPeerConfig.AgentMode.SERVICE) {
                return "v" + n;
            }
        }
        return "c" + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void checkCredentials(ConnectRequest connectRequest) throws PeerConnectException, InvalidCredentialsException {
        block27: {
            if (!this.readyForConnections) {
                throw new PeerConnectException("The server is starting up, and is not yet capable of accepting connections.");
            }
            PeerID peerID = connectRequest.getPeerID();
            PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
            Serializable serializable = connectRequest.getCredentials();
            if (this.isClient()) {
                if (serializable instanceof NotificationCredentials) {
                    return;
                }
                if (peerDescriptor.getType() == 4) {
                    return;
                }
                throw new PeerConnectException("Connection initiated by " + peerDescriptor + " has been refused.");
            }
            if (this.isServer() && serializable instanceof NotificationCredentials && peerDescriptor.getType() == 8) {
                return;
            }
            if (this.isStandby() && peerDescriptor.getType() == 4) {
                String string = "Connection initiated by " + peerDescriptor + " has been refused - agents may not connect to Standby Server.";
                if (serializable != null && serializable instanceof AgentCredentials && ((AgentCredentials)((Object)serializable)).getSchentRelMod() != null && ((AgentCredentials)((Object)serializable)).getSchentRelMod().getRelease() >= 3) {
                    throw new PeerRedirectException(string, this.getAgentConfig().getMaster());
                }
                throw new PeerConnectException(string);
            }
            if (peerDescriptor.getType() == 3) {
                return;
            }
            if (peerDescriptor.getType() != 4 && peerDescriptor.getType() != 9) {
                throw new PeerConnectException("Connection initiated by " + peerDescriptor + " has been refused.");
            }
            if (serializable == null) {
                throw new InvalidCredentialsException("Credentials are missing.");
            }
            if (!(serializable instanceof AgentCredentials)) {
                throw new InvalidCredentialsException("Invalid credentials: " + serializable.getClass().getName());
            }
            if (peerDescriptor.getType() == 4) {
                ScheduleLogEntry scheduleLogEntry;
                String[] stringArray;
                String string;
                Agent agent = null;
                Agent agent2 = null;
                String string2 = null;
                try {
                    agent2 = this.getAgent(peerID, (AgentCredentials)((Object)serializable), peerDescriptor);
                    if (agent2 != null) {
                        string = agent2.getHardwareHash() + "-" + agent2.getInstanceIdentifier();
                        stringArray = agent2.getHardwareKey() + "-" + agent2.getInstanceIdentifier();
                        scheduleLogEntry = this.getConnectedAgents();
                        for (int i = 0; i < ((PeerID[])scheduleLogEntry).length; ++i) {
                            PeerID peerID2 = scheduleLogEntry[i];
                            String string3 = peerID2.getHardwareHash() + "-" + peerID2.getInstanceIdentifier();
                            String string4 = peerID2.getHardwareKey() + "-" + peerID2.getInstanceIdentifier();
                            if (string3.equals(string)) {
                                String string5 = "Agent connection error. Agent " + agent2.getName() + " is already connected with hardware Hash-ID: " + string3;
                                logger.info((Object)string5);
                                throw new PeerConnectException(string5);
                            }
                            if (!string4.equals(stringArray)) continue;
                            String string6 = "Agent connection error. Agent " + agent2.getName() + " is already connected with hardware Key-ID: " + string4;
                            logger.info((Object)string6);
                            throw new PeerConnectException(string6);
                        }
                    }
                    if (agent2 != null) {
                        string2 = agent2.getTimeZone();
                    }
                    agent = this.registerAgent(peerID, (AgentCredentials)((Object)serializable), connectRequest.getOriginInetAddress(), agent2);
                }
                catch (Exception exception) {
                    String string7 = "Unable to register agent " + peerDescriptor + " into the database.";
                    logger.debug((Object)string7, (Throwable)exception);
                    throw new PeerConnectException(string7, (Throwable)exception);
                }
                if (string2 != null && agent.getTimeZone() != null && !agent.getTimeZone().equals(string2)) {
                    string = (SchedulerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SchedulerAM");
                    string.agentTimeZoneChange(agent.getOid(), string2, agent.getTimeZone());
                    if (agent.getTimeZone() != null) {
                        stringArray = new String[]{agent.getName(), string2, agent.getTimeZone()};
                        scheduleLogEntry = RosettaMsg.AGENT_TIME_ZONE_CHANGED.newLogEntry(stringArray, agent.getOid());
                        scheduleLogEntry.setAgentID(agent.getOid());
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    }
                }
                try {
                    long l = System.currentTimeMillis();
                    scheduleLogEntry = this.getAgentLicenseInfo(l);
                    HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
                    synchronized (hashMap) {
                        this.checkAgentLicensing(agent, (AgentCredentials)((Object)serializable), peerID, (AgentLicenseInfo)scheduleLogEntry);
                        this.peerConnectList.add(peerID);
                        break block27;
                    }
                }
                catch (PeerConnectException peerConnectException) {
                    logger.warn((Object)peerConnectException.getMessage(), (Throwable)peerConnectException);
                    throw peerConnectException;
                }
                catch (Exception exception) {
                    stringArray = "Unable to determine if agent " + agent.getName() + " is licensed.";
                    logger.debug((Object)stringArray, (Throwable)exception);
                    throw new PeerConnectException((String)stringArray, (Throwable)exception);
                }
            }
            if (peerDescriptor.getType() == 9) {
                this.sendLicenseWarning(peerID);
                logger.debug((Object)(peerDescriptor.toString() + " has connected."));
            }
        }
    }

    public PeerID searchForAgent(AgentProxy agentProxy) {
        PeerID[] peerIDArray = this.searchRoutingTableFor(agentProxy.getHardwareHash(), (Serializable)((Object)agentProxy.getInstanceIdentifier()));
        if (peerIDArray.length == 0) {
            return null;
        }
        for (PeerID peerID : peerIDArray) {
            if (peerID.getPeerDescriptor().getType() != 4) continue;
            return peerID;
        }
        return null;
    }

    public boolean isStartupComplete() {
        return this.startupComplete;
    }

    public boolean isAgentEnding(PeerID peerID) {
        return this.agentsThatAreEnding.contains(peerID);
    }

    public boolean isLicensedAndOnline(AgentProxy agentProxy) {
        PeerID peerID = this.searchForAgent(agentProxy);
        if (peerID == null) {
            return false;
        }
        return this.isLicensedAndOnline(peerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLicensedAndOnline(PeerID peerID) {
        HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
        synchronized (hashMap) {
            AgentLicenseStatus agentLicenseStatus = this.licensedAgentMap.get(peerID);
            if (agentLicenseStatus == null) {
                return false;
            }
            if (agentLicenseStatus.getLicenseState() == 3 || agentLicenseStatus.getLicenseState() == 2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentLicenseStatus getAgentLicenseStatus(PeerID peerID) {
        HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
        synchronized (hashMap) {
            AgentLicenseStatus agentLicenseStatus = this.licensedAgentMap.get(peerID);
            if (agentLicenseStatus != null) {
                agentLicenseStatus = agentLicenseStatus.copy();
            }
            return agentLicenseStatus;
        }
    }

    public int getDefaultLicenseState(boolean bl) {
        int n = 0;
        try {
            long l = System.currentTimeMillis();
            AgentLicenseInfo agentLicenseInfo = this.getAgentLicenseInfo(l, bl);
            n = 1;
            if (agentLicenseInfo.version.equals((Object)AgentLicenseVersion.NONE) && agentLicenseInfo.getLicensePoints() == 999999) {
                n = 3;
            } else if (agentLicenseInfo.isTempAvailable()) {
                n = 2;
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to retrieve default license information.", (Throwable)exception);
        }
        return n;
    }

    private Agent getAgent(PeerID peerID, AgentCredentials agentCredentials, PeerDescriptor peerDescriptor) throws DataException, ResourceUnavailableException {
        AgentDM agentDM = this.getAgentDM();
        Agent agent = agentDM.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), peerID.getInstanceIdentifier().toString());
        if (agent == null) {
            agent = agentDM.getByHardwareKeyAndInstanceIdentifier(peerID.getHardwareKey(), peerID.getInstanceIdentifier().toString());
        }
        String string = this.constructAgentName(agentCredentials, peerDescriptor);
        if (agent == null && string != null && string.trim().length() > 0) {
            try {
                agent = agentDM.getByAgentName(string);
            }
            catch (MultipleMatchesException multipleMatchesException) {
                logger.warn((Object)("Multiple Agent definitions were found for matching name: " + string));
            }
            if (agent != null) {
                if (agent.getConnectionMatchType() != 1) {
                    logger.info((Object)("Agent matching name '" + string + "' does not support name matching agent connections."));
                    agent = null;
                } else {
                    logger.info((Object)("Connecting agent matched existing agent definition with name: " + string));
                }
            } else {
                logger.info((Object)("No agent match for agent connecting with name: " + string));
            }
        }
        return agent;
    }

    private Agent registerAgent(PeerID peerID, AgentCredentials agentCredentials, InetAddress inetAddress, Agent agent) throws ResourceUnavailableException, DataException {
        String string;
        Object object;
        Agent agent2 = agent;
        boolean bl = false;
        if (agent2 == null) {
            agent2 = new Agent();
            object = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            string = ((DateFormat)object).format(new Date());
            agent2.setDescription("Registered " + string);
            agent2.setLicenseAllocated(false);
            bl = true;
        }
        object = peerID.getPeerDescriptor();
        agent2.setOperatingSystem(object.getOSName());
        agent2.setPort(object.getPort());
        agent2.setHardwareHash(peerID.getHardwareHash());
        agent2.setHardwareKey(peerID.getHardwareKey());
        agent2.setInstanceIdentifier(peerID.getInstanceIdentifier().toString());
        agent2.setTimeZone(agentCredentials.getAgentTZ());
        string = this.constructAgentName(agentCredentials, (PeerDescriptor)object);
        agent2.setName(string);
        if (inetAddress != null) {
            agent2.setIPAddress(inetAddress.getHostAddress());
        } else {
            agent2.setIPAddress(object.findIPAddress());
        }
        RelMod relMod = agentCredentials.getSchentRelMod();
        if (relMod == null) {
            agent2.setVersion("unknown");
        } else {
            agent2.setVersion(relMod.toString());
        }
        String string2 = agentCredentials.getProperty("os.arch");
        if (string2 != null && string2.contains("amd")) {
            string2 = string2.equals("amd") ? "x86" : (string2.endsWith("amd") ? string2.replaceAll("amd", "x86") : string2.replaceAll("amd", "x86_"));
        }
        agent2.setCPUInfo(string2);
        this.getAgentDM().save(agent2);
        if (bl) {
            logger.trace((Object)("Creating default job queue for Agent: " + agent2.getName()));
            try {
                long l = this.getJobQueuesDM().createDefault(agent2.getOid(), agent2.getName());
                logger.trace((Object)("Created default job queue for Agent: " + agent2.getName() + " with ID: " + l));
                this.getAgentDM().updateDefaultJobQueueID(l, agent2.getOid());
                logger.trace((Object)("Updated Agent: " + agent2.getName() + " with default job queue ID: " + l));
            }
            catch (Exception exception) {
                logger.error((Object)("Error creating or setting default job queue for Agent: " + agent2.getName()), (Throwable)exception);
            }
        }
        return agent2;
    }

    private JobQueuesDM getJobQueuesDM() {
        if (this.jobQueuesDM == null) {
            this.jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
        }
        return this.jobQueuesDM;
    }

    private String constructAgentName(AgentCredentials agentCredentials, PeerDescriptor peerDescriptor) {
        String string = agentCredentials.getAgentSpecifiedName();
        if (string == null || string.trim().length() == 0) {
            string = peerDescriptor.getComputerName();
        }
        if (string == null || string.trim().length() == 0) {
            string = peerDescriptor.findPrintableAddress();
        }
        if ((string = string.split("\\.")[0].toUpperCase()) != null && string.length() > 50) {
            string = string.substring(0, 50);
        }
        return string;
    }

    public RelMod getRelMod() {
        Module[] moduleArray;
        for (Module module : moduleArray = this.listModules()) {
            ModuleDescriptor moduleDescriptor = module.getDescriptor();
            if (!PRODUCT_NAME.equals(moduleDescriptor.getProductName())) continue;
            ModuleInfo moduleInfo = null;
            if (!(module instanceof GenericJarModule)) continue;
            GenericJarModule genericJarModule = (GenericJarModule)module;
            moduleInfo = genericJarModule.getInfo();
            return RelMod.parse((String)moduleInfo.getVersion());
        }
        return null;
    }

    static AgentPeer createAgent(AgentPeerConfig agentPeerConfig, String string) throws PeerStartupException {
        String string2;
        Object object;
        String string3;
        int n = agentPeerConfig.getListenPort();
        if (n == 0) {
            n = DEFAULT_SERVER_PORT;
            agentPeerConfig.setListenPort(n);
        }
        int n2 = 4;
        if (AgentPeerConfig.AgentMode.SERVER.equals((Object)agentPeerConfig.getMode())) {
            n2 = 6;
            try {
                AgentPeer.initLogDir();
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to create JobLog directory.", (Throwable)exception);
            }
        } else if (AgentPeerConfig.AgentMode.SERVICE.equals((Object)agentPeerConfig.getMode())) {
            n2 = 8;
        } else if (AgentPeerConfig.AgentMode.STANDBY.equals((Object)agentPeerConfig.getMode())) {
            n2 = 9;
        }
        if (AgentPeerConfig.AgentMode.CLIENT.equals((Object)agentPeerConfig.getMode())) {
            string3 = System.getProperty(logFilePropertyKey);
            object = "\\";
            string2 = System.getProperty("os.name");
            if (string2 != null && string2.toLowerCase().indexOf("os/400") > -1) {
                object = "/";
            }
            if (string3 == null || string3.trim().length() == 0) {
                try {
                    string3 = string.trim();
                    int n3 = string3.lastIndexOf((String)object);
                    n3 = n3 < 0 ? 0 : ++n3;
                    int n4 = string3.length();
                    String string4 = ".xml";
                    if (string3.toLowerCase().endsWith(string4)) {
                        n4 -= string4.length();
                    }
                    string3 = string3.substring(n3, n4) + ".log";
                }
                catch (Throwable throwable) {
                    logger.warn((Object)"Error re-configuring log file name.", throwable);
                }
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = String.valueOf(n) + "_agent.log";
                }
                System.setProperty(logFilePropertyKey, "logs" + (String)object + string3);
            }
        }
        string3 = PeerDescriptor.createLocalPeerDescriptor((int)n, (int)n2);
        object = new AgentPeer((PeerDescriptor)string3, agentPeerConfig);
        object.setConfigPath(string);
        try {
            string2 = UnacodeMash.getForDataManagers();
            object.useEncryption((EncryptUtil)string2);
            ManagerRegistry.registerManager((IAbstractManager)new BasicEncryptUtilAM((EncryptUtil)string2));
        }
        catch (Exception exception) {
            throw new PeerStartupException("Unable to start up encryption.", (Throwable)exception);
        }
        ((AgentPeer)((Object)object)).startup();
        return object;
    }

    public void updateEndingAgents(PeerID peerID) {
        this.endingAgentsList.add(peerID);
        if (peerID != null) {
            this.agentsThatAreEnding.add(peerID);
        }
    }

    private static void initLogDir() {
        File file = new File(DefaultConfigPath.getJobLogDirectory());
        file.mkdirs();
    }

    public PeerID[] getConnectedServicePeers() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(8);
        PeerID[] peerIDArray = this.searchRoutingTableFor(peerDescriptor);
        if (peerIDArray.length == 0) {
            return new PeerID[0];
        }
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        for (PeerID peerID : peerIDArray) {
            if (peerID.equals((Object)this.getRemotePeerID())) continue;
            hashSet.add(peerID);
        }
        peerIDArray = new PeerID[hashSet.size()];
        hashSet.toArray(peerIDArray);
        return peerIDArray;
    }

    public PeerID[] getConnectedStandbyServer() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(9);
        PeerID[] peerIDArray = this.searchRoutingTableFor(peerDescriptor);
        if (peerIDArray.length == 0) {
            return new PeerID[0];
        }
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        for (PeerID peerID : peerIDArray) {
            if (peerID.equals((Object)this.getRemotePeerID())) continue;
            hashSet.add(peerID);
        }
        peerIDArray = new PeerID[hashSet.size()];
        hashSet.toArray(peerIDArray);
        return peerIDArray;
    }

    public PeerID[] getConnectedAgents() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(4);
        PeerID[] peerIDArray = this.searchRoutingTableFor(peerDescriptor);
        if (peerIDArray.length == 0) {
            return new PeerID[0];
        }
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        for (PeerID peerID : peerIDArray) {
            if (peerID.equals((Object)this.getRemotePeerID())) continue;
            hashSet.add(peerID);
        }
        peerIDArray = new PeerID[hashSet.size()];
        hashSet.toArray(peerIDArray);
        return peerIDArray;
    }

    public int getNumberOfDays(long l) {
        long l2;
        long l3 = 86400L;
        long l4 = 3600L;
        long l5 = 60L;
        long l6 = 1000L;
        if (l < l6) {
            if (l < 0L) {
                throw new IllegalArgumentException("Time in milliSeconds must be a positive number or 0.");
            }
            if (l == 0L || l < l6) {
                return -1;
            }
        }
        if ((l2 = l / l6) < l5) {
            return -1;
        }
        if (l2 < l3) {
            return 0;
        }
        double d = (double)l3 / 1.0;
        double d2 = (double)l2 / d + 0.99;
        int n = (int)d2;
        if (n < Integer.MAX_VALUE) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    protected String getHtmlSection(String string) {
        if ("general".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.getHtmlSection(string));
            if ((this.isServer() || this.isClient()) && !this.readyForConnections) {
                stringBuffer.append("<table><tr><td><b>Not yet ready for connections</b></td><td> - This server is still starting up.</td></tr></table>\n");
            }
            if (this.isShutdownRequested()) {
                stringBuffer.append("<table><tr><td><font color=\"red\"><b>Shutdown in progress</b></font></td><td> - No new jobs will start.</td></tr></table>\n");
            }
            stringBuffer.append("<table><tr><td><b>Local Time:</b></td><td>" + new Date() + "</td></tr></table>\n");
            if (this.isServer()) {
                stringBuffer.append("<br>" + this.getServerInfo());
            } else if (this.isClient()) {
                stringBuffer.append(this.getClientInfo());
            }
            return stringBuffer.toString();
        }
        if ("log".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<h2>Log:</h2>\n");
            String string2 = null;
            if (this.isServer()) {
                string2 = Log4jID.ROOT.getLogFilePath();
            } else {
                Properties properties = this.config.getLog4jProperties();
                string2 = properties.getProperty(AGENT_LOG4J_FILENAME_KEY);
            }
            stringBuffer.append(AgentPeer.getLogTail((String)string2, (int)5000));
            return stringBuffer.toString();
        }
        if (string.startsWith(JOB_LOG_URL)) {
            if (string.length() == JOB_LOG_URL.length()) {
                return "Missing Job Run-ID";
            }
            String string3 = string.substring(JOB_LOG_URL.length());
            try {
                long l = Long.parseLong(string3);
                JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobExecDM");
                String string4 = jobExecDM.getJobLogFilename(l);
                File file = null;
                if (string4 != null) {
                    file = new File(string4);
                }
                if (file == null || !file.exists() || file.length() == 0L) {
                    return "Job Log " + string3 + " not found or is no longer available.";
                }
                return AgentPeer.getLogTail((String)string4, (int)5000);
            }
            catch (Exception exception) {
                String string5 = "Unable to retrieve job log: " + string3;
                logger.debug((Object)string5, (Throwable)exception);
                return string5;
            }
        }
        if (string.startsWith(UPDATE_LOG_URL)) {
            try {
                String string6 = "update.log";
                String string7 = AgentUpdater.resolveTempDir();
                File file = new File(string7, string6);
                if (file == null || !file.exists() || file.length() == 0L) {
                    return "Update Log " + file.getAbsolutePath() + " not found or is no longer available.";
                }
                String string8 = AgentPeer.getLogTail((String)file.getAbsolutePath(), (int)5000);
                if (string8.contains("exited with code: 22")) {
                    string8.replace("exited with code: 22", "exited with code: 22 - A file or folder is locked by a running application");
                    return string8;
                }
                return AgentPeer.getLogTail((String)file.getAbsolutePath(), (int)5000);
            }
            catch (Exception exception) {
                String string9 = "Unable to retrieve update log.";
                logger.debug((Object)string9, (Throwable)exception);
                return string9;
            }
        }
        return super.getHtmlSection(string);
    }

    private String getServerInfo() {
        Comparator<PeerID> comparator = new Comparator<PeerID>(){

            @Override
            public int compare(PeerID peerID, PeerID peerID2) {
                String string;
                String string2 = peerID.getPeerDescriptor().getComputerName();
                if (string2 == null) {
                    string2 = peerID.getPeerDescriptor().findPrintableAddress();
                }
                if ((string = peerID2.getPeerDescriptor().getComputerName()) == null) {
                    string = peerID.getPeerDescriptor().findPrintableAddress();
                }
                return string2.toUpperCase().compareTo(string.toUpperCase());
            }
        };
        StringBuilder stringBuilder = new StringBuilder();
        PeerID[] peerIDArray = this.getConnectedServicePeers();
        stringBuilder.append("<h2>Connected Automate Schedule Services:</h2>\n");
        Arrays.sort(peerIDArray, comparator);
        if (peerIDArray.length == 0) {
            stringBuilder.append("None connected.\n");
        } else {
            stringBuilder.append("<table>");
            for (PeerID peerID : peerIDArray) {
                if (peerID.equals((Object)this.getRemotePeerID())) continue;
                stringBuilder.append("<tr><td>");
                stringBuilder.append(this.makeLink(peerID.getPeerDescriptor()));
                stringBuilder.append("</td></tr>");
            }
        }
        stringBuilder.append("<h2>Connected Automate Schedule Agents:</h2>\n");
        PeerID[] peerIDArray2 = (PeerID[])ManagerRegistry.getManager((String)"ENTERPRISE.JobCompletionDM");
        peerIDArray = this.getConnectedAgents();
        Arrays.sort(peerIDArray, comparator);
        if (peerIDArray.length == 0) {
            stringBuilder.append("None connected.\n");
        } else {
            stringBuilder.append("<table border=\"1\">");
            stringBuilder.append("<th>Agent</th>");
            stringBuilder.append("<th>License</th>");
            stringBuilder.append("<th>Jobs Running</th>");
            stringBuilder.append("<th>Jobs on the Queue</th>");
            for (PeerID peerID : peerIDArray) {
                ExecutableJob[] executableJobArray;
                if (peerID.equals((Object)this.getRemotePeerID())) continue;
                stringBuilder.append("<tr><td valign=\"top\">");
                stringBuilder.append(this.makeLink(peerID.getPeerDescriptor()));
                stringBuilder.append("</td><td valign=\"top\">");
                AgentLicenseStatus agentLicenseStatus = this.getAgentLicenseStatus(peerID);
                String string = null;
                if (agentLicenseStatus == null) {
                    string = "License info missing";
                } else {
                    switch (agentLicenseStatus.getLicenseState()) {
                        case 2: {
                            string = "Trial";
                            break;
                        }
                        case 1: {
                            string = "None/Disabled";
                            break;
                        }
                        case 3: {
                            executableJobArray = String.valueOf(agentLicenseStatus.getPointsInUse());
                            if (EnterpriseProductLicense.isTierKeyVersion((AgentLicenseVersion)agentLicenseStatus.getAgentLicenseVersion())) {
                                executableJobArray = EnterpriseProductLicense.skybotNameForTier((AgentLicenseTier)agentLicenseStatus.getTierInUse());
                            }
                            string = "Perm (" + (String)executableJobArray + ")";
                            break;
                        }
                        default: {
                            string = "Unknown";
                        }
                    }
                }
                stringBuilder.append(string);
                stringBuilder.append("</td><td valign=\"top\">");
                executableJobArray = peerIDArray2.getWaitingSockets(peerID.getHardwareHash(), peerID.getInstanceIdentifier().toString());
                int n = executableJobArray.length;
                if (n == 0) {
                    stringBuilder.append("None");
                } else if (n == 1) {
                    stringBuilder.append("One: ");
                    stringBuilder.append(executableJobArray[0].getScheduleJob().getName());
                    stringBuilder.append("(" + executableJobArray[0].getEventID() + ")");
                } else {
                    stringBuilder.append(n + ": ");
                    stringBuilder.append("<br>");
                    for (ExecutableJob executableJob : executableJobArray) {
                        stringBuilder.append("-&nbsp;");
                        stringBuilder.append(executableJob.getScheduleJob().getName());
                        stringBuilder.append("(" + executableJob.getEventID() + ")");
                        stringBuilder.append("<br>");
                    }
                }
                stringBuilder.append("</td><td valign=\"top\">");
                try {
                    ExecutableJob[] executableJobArray2 = (ExecutableJob[])ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseServerAM");
                    int n2 = executableJobArray2.getAgentJobQueueCount((RoutableBasicIdentifier)peerID);
                    String string2 = "";
                    string2 = n2 == 0 ? "None" : (n2 == 1 ? "One" : (n2 == -1 ? "Unknown" : String.valueOf(n2)));
                    stringBuilder.append(string2);
                }
                catch (Exception exception) {
                    logger.error((Object)("Error getting Agent Job Queue Count for PeerID(" + peerID + "). "), (Throwable)exception);
                    stringBuilder.append("Error obtaining job queue count.");
                }
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table>");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getClientInfo() {
        AgentEventMonitor[] agentEventMonitorArray;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        block31: {
            Object object2;
            AgentEventMonitorAM agentEventMonitorAM;
            stringBuilder3 = new StringBuilder();
            stringBuilder3.append("<h2>Automate Schedule Agents currently running on this system:</h2>");
            try {
                this.multicastHandler.send(null, QUERY);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to send multicast query.", (Throwable)exception);
                stringBuilder3.append("Automate Schedule Agent discovery is not working.<br>");
            }
            FileTransferInfoFetcher fileTransferInfoFetcher = new FileTransferInfoFetcher((Peer)this);
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append("<table><tr><td><b>Automate Schedule Server:</b></td><td>\n");
            PeerDescriptor peerDescriptor = this.getAgentConfig().getMaster();
            if (peerDescriptor == null) {
                stringBuilder2.append("Not defined.");
            } else {
                stringBuilder2.append(this.makeLink(peerDescriptor));
                stringBuilder2.append(" - ");
                if (this.getConnectedAgentServer() == null) {
                    stringBuilder2.append("Not connected");
                } else {
                    stringBuilder2.append("Connected");
                }
            }
            stringBuilder2.append("</td></tr></table><br>\n");
            stringBuilder = new StringBuilder();
            stringBuilder.append("<h2>Jobs currently running:</h2>\n");
            JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobExecDM");
            Map map = null;
            if (jobExecDM != null) {
                map = jobExecDM.listJobs();
            }
            if (map == null || map.size() == 0) {
                stringBuilder.append("None.\n");
            } else {
                stringBuilder.append("<table border=\"1\"><tr><td>Job Duration</td><td>Job Name</td></tr>");
                agentEventMonitorAM = new JobTimer[map.size()];
                map.keySet().toArray((T[])agentEventMonitorAM);
                Arrays.sort((Object[])agentEventMonitorAM);
                long l = System.currentTimeMillis();
                for (int i = ((AgentEventMonitorAM)agentEventMonitorAM).length - 1; i > -1; --i) {
                    AgentEventMonitorAM agentEventMonitorAM2 = agentEventMonitorAM[i];
                    long l2 = agentEventMonitorAM2.getWhenStarted();
                    object2 = (ExecutableJob)map.get(agentEventMonitorAM2);
                    stringBuilder.append("<tr><td>");
                    stringBuilder.append(DateTranslator.formatElapsedTime((long)(l - l2)));
                    if (agentEventMonitorAM2.isTerminating()) {
                        stringBuilder.append(" - Terminating");
                    }
                    stringBuilder.append("</td><td>");
                    stringBuilder.append("<a href=\"/x/");
                    stringBuilder.append(JOB_LOG_URL);
                    stringBuilder.append(l2);
                    stringBuilder.append("\">");
                    stringBuilder.append(object2.getScheduleJob().getName() + " - " + object2.getEventID());
                    stringBuilder.append("</a></td></tr>");
                }
                stringBuilder.append("</table>");
            }
            stringBuilder.append("<br><h2>Agent Event Monitors:</h2>\n");
            agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorAM");
            if (agentEventMonitorAM == null) {
                stringBuilder.append("Unable to retrieve this information.\n");
            } else {
                AgentEventMonitor[] agentEventMonitorArray2 = agentEventMonitorAM.getMonitors();
                if (agentEventMonitorArray2.length == 0) {
                    stringBuilder.append("None present.\n");
                } else {
                    if (this.isShutdownRequested() && agentEventMonitorAM.isTransferringData()) {
                        stringBuilder.append("<b>Shutdown is waiting:</b> This agent is transferring Agent Event Monitor history data to the Enterprise Server.<br>");
                    }
                    Arrays.sort(agentEventMonitorArray2, agentEventMonitorArray2[0].getComparator((SortField)new GenericSortField(10101, 0)));
                    stringBuilder.append("<table border=\"1\"><tr><th>Name</th><th>Description</th><th>Type</th><th>Poll interval</th></tr>");
                    for (AgentEventMonitor agentEventMonitor : agentEventMonitorArray2) {
                        void object3;
                        stringBuilder.append("<tr><td>");
                        stringBuilder.append(agentEventMonitor.getName());
                        stringBuilder.append("</td><td>");
                        stringBuilder.append(agentEventMonitor.getDescription());
                        stringBuilder.append("</td><td>");
                        stringBuilder.append(agentEventMonitor.getTypeDescription());
                        stringBuilder.append("</td><td>");
                        Object var14_28 = null;
                        if (agentEventMonitor instanceof ManualEvent) {
                            String string = "Manually fired";
                        } else {
                            String string = agentEventMonitor.getCycle() + " seconds";
                        }
                        if (agentEventMonitor.getDisabled()) {
                            String string = "Disabled";
                        }
                        stringBuilder.append((String)object3);
                        stringBuilder.append("</td></tr>");
                    }
                    stringBuilder.append("</table>");
                }
            }
            FileTransferInfo[] fileTransferInfoArray = fileTransferInfoFetcher.get(this);
            agentEventMonitorArray = new StringBuilder();
            agentEventMonitorArray.append("<h2>Agent Output File Transfers:</h2>\n");
            if (fileTransferInfoArray.length == 0) {
                agentEventMonitorArray.append("None.\n");
            } else {
                agentEventMonitorArray.append("<table border=\"1\"><tr><td>Remote Peer</td><td>File Name</td><td>Size</td><td>% copied</td></tr>");
                for (FileTransferInfo fileTransferInfo : fileTransferInfoArray) {
                    agentEventMonitorArray.append("<tr><td>");
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append(fileTransferInfo.getRemotePeerName());
                    agentEventMonitorArray.append("</td><td>");
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append(fileTransferInfo.getFileName());
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append("</td><td>");
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append(fileTransferInfo.getFileSize());
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append("</td><td>");
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append(fileTransferInfo.getPercentComplete());
                    agentEventMonitorArray.append("&nbsp;");
                    agentEventMonitorArray.append("</td></tr>");
                }
                agentEventMonitorArray.append("</table>");
            }
            agentEventMonitorArray.append("<br>");
            try {
                Thread.sleep(1000L);
                PeerDescriptor peerDescriptor2 = (PeerDescriptor)this.getRemotePeerID().getPeerDescriptor().clone();
                int n = peerDescriptor2.getPort();
                InetAddress inetAddress = peerDescriptor2.getPreferredInetAddress();
                Socket socket = this.getCurrentHttpSocket();
                if (socket != null) {
                    inetAddress = socket.getLocalAddress();
                }
                object2 = null;
                object2 = inetAddress == null ? peerDescriptor2.getComputerName() : inetAddress.getHostAddress();
                if (this.localAgentClientMap.isEmpty()) {
                    stringBuilder3.append("Unable to process Automate Schedule Agent responses.");
                    stringBuilder3.append("<br>A firewall may be blocking Multicast UPD packets.");
                    break block31;
                }
                for (String string : this.localAgentClientMap.keySet()) {
                    String string2 = this.localAgentClientMap.get(string);
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    peerDescriptor2.setPort(n2);
                    peerDescriptor2.setComputerName(string2);
                    stringBuilder3.append(this.makeLink((String)object2, peerDescriptor2.getPort(), peerDescriptor2.toString()));
                    if (n == peerDescriptor2.getPort()) {
                        stringBuilder3.append(" - This Automate Schedule Agent");
                    }
                    stringBuilder3.append("<br>");
                }
            }
            catch (InterruptedException interruptedException) {
                stringBuilder3.append("Unable to wait for Automate Schedule Agent responses.");
            }
        }
        return stringBuilder2.toString() + stringBuilder3.toString() + stringBuilder.toString() + agentEventMonitorArray.toString();
    }

    public String getShutdownCommand() {
        return this.shutdownCommand;
    }

    public boolean isShutdownRequested() {
        if (this.isServer()) {
            return this.serverShutdownStarted;
        }
        return this.shutdownThread != null;
    }

    public boolean isReadyForConnections() {
        return this.readyForConnections;
    }

    private synchronized void prepareShutdownThread(boolean bl, int n) {
        this.restartAfterShutdown = n;
        if (this.shutdownThread != null) {
            if (this.gracefulShutdown && !bl) {
                this.gracefulShutdown = false;
            }
            return;
        }
        this.gracefulShutdown = bl;
        this.shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!AgentPeer.this.checkIfShutdownReady()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.shutdownThread.setName("Shutdown Monitor");
        this.shutdownThread.setDaemon(true);
    }

    public void startShutdown(boolean bl, int n) {
        this.startShutdown(bl, n, false);
        try {
            this.shutdownThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finishShutdown(false);
    }

    public synchronized void startShutdown(boolean bl, int n, boolean bl2) {
        if (this.shutdownThread != null) {
            if (!this.shutdownThread.isAlive()) {
                this.ignoreAgentDisconnect = true;
                try {
                    this.shutdownThread.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    logger.debug((Object)"Failed to start shutdownThread.  Continue anyway. ", (Throwable)illegalThreadStateException);
                }
                this.ignoreAgentDisconnect = false;
            }
            return;
        }
        logger.warn((Object)"A request has been made to Shutdown. No new jobs will start.");
        if (this.isServer()) {
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.ENTERPRISE_SERVER_SHUTDOWN.newLogEntry();
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            EnterpriseServerSNMPTrap enterpriseServerSNMPTrap = new EnterpriseServerSNMPTrap();
            enterpriseServerSNMPTrap.setText(scheduleLogEntry.getMessageText());
            enterpriseServerSNMPTrap.setSeverity("WR");
            this.sendSNMPTrap((EnterpriseSNMPTrap)enterpriseServerSNMPTrap, true);
        }
        this.prepareShutdownThread(bl, n);
        this.ignoreAgentDisconnect = true;
        this.shutdownThread.start();
        this.ignoreAgentDisconnect = false;
    }

    private void finishShutdown(boolean bl) {
        if (this.isServer() && !this.isStandby()) {
            try {
                this.updateAgentsOffline();
            }
            catch (Exception exception) {
                logger.debug((Object)"Error updating active Agents states to off-line.", (Throwable)exception);
            }
        }
        super.shutdown();
        if (this.isServer()) {
            logger.debug((Object)"Enterprise Server shutdown completed.");
        } else if (this.isStandby()) {
            logger.debug((Object)"Enterprise Standby Server shutdown completed.");
        } else {
            this.shutdownAgentManagers();
            logger.fatal((Object)"Agent Shutdown completed.");
            if (this.restartAfterShutdown == 1) {
                logger.fatal((Object)"Attempting to restart.");
                System.exit(99);
            }
            if (this.restartAfterShutdown == 2) {
                logger.fatal((Object)"Attempting to update and restart.");
                System.exit(97);
            }
            System.exit(0);
        }
    }

    private void shutdownAgentManagers() {
        try {
            logger.debug((Object)"Closing shared Informatica Cloud web server connections.");
            SkybotCommandDM skybotCommandDM = (SkybotCommandDM)ManagerRegistry.getManager((String)"ENTERPRISE.SkybotCommandDM");
            if (skybotCommandDM != null) {
                skybotCommandDM.releaseConnections();
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)"Error closing shared Informatica Cloud web server connections.", throwable);
        }
    }

    public boolean checkIfShutdownReady() {
        if (!this.isShutdownRequested()) {
            return false;
        }
        if (!this.isServer()) {
            Object object;
            JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobExecDM");
            if (!(jobExecDM instanceof IBMiJobExecDM)) {
                int n = jobExecDM.listJobs().size();
                logger.debug((Object)("AgentPeer.checkIfShutdownReady: jobExecDM shows " + n + " job(s) still running."));
                if (n > 0) {
                    if (this.gracefulShutdown) {
                        return false;
                    }
                    object = jobExecDM.listJobs();
                    for (PeerID peerID2 : object.values()) {
                        jobExecDM.endJob(peerID2.getEventID());
                    }
                }
            }
            if (!this.gracefulShutdown) {
                return true;
            }
            PeerID peerID = this.getConnectedAgentServer();
            if (peerID != null) {
                object = (AgentEventMonitorAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorAM");
                if (object.isTransferringData()) {
                    return false;
                }
                if (jobExecDM instanceof IBMiJobExecDM) {
                    return true;
                }
                try {
                    PeerID peerID2;
                    JobCompletionDM jobCompletionDM = (JobCompletionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.JobCompletionDM");
                    peerID2 = this.getRemotePeerID();
                    int n = jobCompletionDM.countWaitingSockets(peerID2.getHardwareHash(), peerID2.getInstanceIdentifier().toString());
                    if (n > 0) {
                        if (logger.isDebugEnabled()) {
                            String string = "jobs";
                            if (n == 1) {
                                string = "job";
                            }
                            logger.debug((Object)("Job Completion is still processing " + n + " " + string + "."));
                        }
                        return false;
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"Unable to contact Enterprise Server to determine if there are jobs waiting on this agent.", (Throwable)exception);
                }
            }
        }
        return true;
    }

    public void switchServer(String string, int n, boolean bl) throws PeerConnectException {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.addAddress(string);
        peerDescriptor.setPort(n);
        this.switchServer(peerDescriptor, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchServer(PeerDescriptor peerDescriptor, boolean bl) throws PeerConnectException {
        PeerDescriptor peerDescriptor2 = this.getAgentConfig().getMaster();
        if (peerDescriptor.equals((Object)peerDescriptor2)) {
            return;
        }
        if (this.isClient()) {
            peerDescriptor.setType(6);
        }
        boolean bl2 = false;
        PeerID peerID = this.getConnectedAgentServer();
        if (peerID != null) {
            try {
                PeerID peerID2 = this.getRemotePeerID();
                AgentEndingCommand agentEndingCommand = new AgentEndingCommand();
                AgentCommandAM agentCommandAM = (AgentCommandAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentCommandAM");
                AgentCommandReply agentCommandReply = agentCommandAM.executeCommand((AgentCommand)agentEndingCommand, peerID2);
                logger.trace((Object)("Agent switching reply: " + agentCommandReply.getReplyText()));
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error notifying enterprise server of pending disconnection.", throwable);
            }
            this.disconnectFromPeer(peerID);
        }
        this.getAgentConfig().setMaster(peerDescriptor);
        try {
            this.connector.doConnect();
            this.firstMasterConnectFailure = true;
            bl2 = true;
        }
        finally {
            if (!bl2 && bl) {
                this.getAgentConfig().setMaster(peerDescriptor2);
            }
            if (bl2 || !bl) {
                try {
                    this.saveConfig();
                }
                catch (IOException iOException) {
                    logger.debug((Object)("Switched the master to " + peerDescriptor.findPrintableAddress() + ":" + peerDescriptor.getPort() + ", but unable to save the config file."), (Throwable)iOException);
                }
            }
        }
    }

    public AgentPeerConfig getAgentConfig() {
        return (AgentPeerConfig)this.getConfig();
    }

    public boolean isServer() {
        return AgentPeerConfig.AgentMode.SERVER.equals((Object)this.getAgentConfig().getMode()) || AgentPeerConfig.AgentMode.STANDBY.equals((Object)this.getAgentConfig().getMode());
    }

    public boolean isStandby() {
        return AgentPeerConfig.AgentMode.STANDBY.equals((Object)this.getAgentConfig().getMode());
    }

    public boolean isClient() {
        return AgentPeerConfig.AgentMode.CLIENT.equals((Object)this.getAgentConfig().getMode());
    }

    public PeerID getConnectedAgentServer() {
        if (!this.isClient() && !this.isStandby()) {
            return null;
        }
        for (PeerID peerID : this.getPeersFromRoutingTable()) {
            if (peerID.getPeerDescriptor().getType() != 6) continue;
            return peerID;
        }
        return null;
    }

    protected void initLog4j() {
        if (!this.isServer()) {
            String string;
            Properties properties = this.config.getLog4jProperties();
            if (properties.size() == 0) {
                properties.setProperty("log4j.rootLogger", "INFO,R");
                properties.setProperty("log4j.appender.R.Append", "true");
                properties.setProperty("log4j.appender.R", "org.apache.log4j.RollingFileAppender");
                properties.setProperty("log4j.appender.R.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] - %m%n");
                properties.setProperty("log4j.appender.R.MaxBackupIndex", "5");
                string = "agent";
                if (this.isServer()) {
                    string = "server";
                }
                properties.setProperty(AGENT_LOG4J_FILENAME_KEY, "logs/" + string + ".log");
                properties.setProperty("log4j.appender.R.MaxFileSize", "4096KB");
                properties.setProperty("log4j.appender.R.layout", "org.apache.log4j.PatternLayout");
            }
            if ((string = System.getProperty(logFilePropertyKey)) != null && string.length() > 0) {
                properties.setProperty(AGENT_LOG4J_FILENAME_KEY, string);
            }
            super.initLog4j();
            Logger logger = Logger.getRootLogger();
            Enumeration enumeration = logger.getAllAppenders();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof RollingFileAppender)) continue;
                RollingFileAppender rollingFileAppender = (RollingFileAppender)e;
                rollingFileAppender.rollOver();
            }
        }
    }

    public void startup() throws PeerStartupException {
        DaemonThreadFactory daemonThreadFactory;
        AgentPeerConfig agentPeerConfig = this.getAgentConfig();
        Object var2_2 = null;
        super.setAllowDiagnosticRequests(agentPeerConfig.getAllowDiagnosticRequests());
        ModuleDescriptor[] moduleDescriptorArray = agentPeerConfig.getModuleDescriptorsForProduct(PRODUCT_NAME);
        ModuleDescriptor moduleDescriptor = null;
        if (moduleDescriptorArray.length > 0) {
            moduleDescriptor = moduleDescriptorArray[0];
        } else {
            moduleDescriptor = new ModuleDescriptor();
            moduleDescriptor.setProductName(PRODUCT_NAME);
            agentPeerConfig.addModuleDescriptor(moduleDescriptor);
        }
        if (!this.isClient() && !this.isStandby()) {
            this.licensedAgentMap = new HashMap();
        }
        this.ignoreAgentDisconnect = true;
        super.startup();
        this.ignoreAgentDisconnect = false;
        boolean bl = false;
        for (Module object2 : this.listModules()) {
            ModuleDescriptor moduleDescriptor2 = object2.getDescriptor();
            if (!PRODUCT_NAME.equals(moduleDescriptor2.getProductName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new PeerStartupException("The 'schent-mp' module failed to start. Please check the log for details.");
        }
        if (this.isClient()) {
            daemonThreadFactory = new LocalAgentAMImpl();
            daemonThreadFactory.setName("ENTERPRISE.LocalAgentAM");
            ManagerRegistry.registerManager((IAbstractManager)daemonThreadFactory);
            ManagerRegistry.registerManager((IAbstractManager)new FileTransferInfoAMImpl((Peer)this));
            if (!System.getProperty("os.name").startsWith("Windows")) {
                try {
                    Signal signal = new Signal("HUP");
                    Signal.handle(signal, new SignalHandler((LocalAgentAMImpl)daemonThreadFactory){
                        final /* synthetic */ LocalAgentAMImpl val$mgr;
                        {
                            this.val$mgr = localAgentAMImpl;
                        }

                        @Override
                        public void handle(Signal signal) {
                            try {
                                this.val$mgr.saveDiagnostics();
                            }
                            catch (ActionFailedException actionFailedException) {
                                logger.debug((Object)"Unable to save diagnostic info", (Throwable)actionFailedException);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    logger.debug((Object)"Unable to register diagnostic signal handler", (Throwable)exception);
                }
            } else {
                SignalHandler signalHandler = new SignalHandler(){

                    @Override
                    public void handle(Signal signal) {
                        String string = signal.getName() + " caught, exiting.";
                        logger.fatal((Object)string);
                        System.out.println(string);
                        System.out.flush();
                        System.exit(0);
                    }
                };
                Signal.handle(new Signal("INT"), signalHandler);
                Signal.handle(new Signal("TERM"), signalHandler);
                Signal.handle(new Signal("ABRT"), signalHandler);
            }
        }
        this.firstMasterConnectFailure = true;
        daemonThreadFactory = new DaemonThreadFactory("AgentConnectorThread");
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)daemonThreadFactory);
        this.connector = new AgentConnector();
        scheduledExecutorService.scheduleWithFixedDelay(this.connector, 0L, 60L, TimeUnit.SECONDS);
        if (this.isClient()) {
            this.localAgentClientMap = new TreeMap();
            try {
                String string = this.getRemotePeerID().getHardwareHash() + ":" + Math.random();
                this.getAgentConfig().setMulticastIdentifier(string);
                this.shutdownCommand = Double.toString(Math.random());
                this.writeShutdownCommand();
                this.multicastHandler = new MulticastHandler(this.getAgentConfig());
                this.saveConfig();
                Thread thread = new Thread(new MulticastWorker());
                thread.setName("MulticastListener listening on port " + this.getAgentConfig().getMulticastPort() + " as " + this.getAgentConfig().getMulticastAddress());
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException iOException) {
                logger.debug((Object)"Unable to start the multicast broadcast port.", (Throwable)iOException);
            }
        } else if (!this.isStandby()) {
            try {
                this.updateAgentsOffline();
            }
            catch (Exception exception) {
                logger.debug((Object)"Error updating active Agents states to off-line.", (Throwable)exception);
            }
            this.addListener((SimpleEventListener)new AgentStateListener());
            this.initialAgentNotifier = new InitialAgentNotifier();
            Thread thread = new Thread(this.initialAgentNotifier);
            thread.setDaemon(true);
            thread.setName("InitialAgentNotifier");
            thread.start();
            this.toggleAllSkybotTypeRemoteServersFromActiveToFailed();
            this.addListener((SimpleEventListener)new RemoteServerStateListener());
            Thread thread2 = new Thread(new OfflineRemoteServerNotifier());
            thread2.setDaemon(true);
            thread2.setName("OfflineRemoteServerNotifier");
            thread2.start();
        }
        this.addListener((SimpleEventListener)new ServerSocketListener());
        try {
            if (var2_2 != null) {
                var2_2.setServerAcceptingTraffic(true);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to update the status data area with Server running data.", (Throwable)exception);
        }
        if (!this.isClient()) {
            try {
                AgentPeer.initLogDir();
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to create JobLog directory.", (Throwable)exception);
            }
        }
        this.readyForConnections = true;
    }

    public void setStartupComplete(boolean bl) {
        this.startupComplete = bl;
    }

    public void shutdownAndRestart() {
        this.startShutdown(true, 1);
    }

    public void shutdownAndRestartNow() {
        this.startShutdown(false, 1);
    }

    public void shutdownAndHalt() {
        if (this.isServer()) {
            this.shutdownServer();
        } else {
            this.startShutdown(true, 0);
        }
    }

    public void shutdownServer() {
        if (!this.isServer()) {
            throw new IllegalStateException("shutdownServer can only be used for a Server.");
        }
        this.serverShutdownStarted = true;
        if (!this.isStandby()) {
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.ENTERPRISE_SERVER_SHUTDOWN.newLogEntry();
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            EnterpriseServerSNMPTrap enterpriseServerSNMPTrap = new EnterpriseServerSNMPTrap();
            enterpriseServerSNMPTrap.setText(scheduleLogEntry.getMessageText());
            enterpriseServerSNMPTrap.setSeverity("WR");
            this.sendSNMPTrap((EnterpriseSNMPTrap)enterpriseServerSNMPTrap, true);
        }
        this.ignoreAgentDisconnect = true;
        this.checkIfShutdownReady();
        this.finishShutdown(true);
    }

    private AgentDM getAgentDM() {
        return (AgentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.AgentDM");
    }

    private void updateAgentsOffline() throws ResourceUnavailableException, DataException {
        Agent[] agentArray;
        AgentDM agentDM = this.getAgentDM();
        for (Agent agent : agentArray = agentDM.getByState(1)) {
            logger.debug((Object)("Updating the agent status to failed for agent " + agent.getName() + "."));
            agentDM.updateRuntimeState(agent.getOid(), 3);
        }
    }

    private void doAgentConnectNotification(Agent agent) {
        if (agent.isSendSNMPTrap()) {
            AgentConnectionSNMPTrap agentConnectionSNMPTrap = new AgentConnectionSNMPTrap(false);
            agentConnectionSNMPTrap.setAgentID(agent.getOid());
            agentConnectionSNMPTrap.setAgentName(agent.getName());
            agentConnectionSNMPTrap.setText(agent.getName() + " has connected.");
            agentConnectionSNMPTrap.setSeverity("IN");
            this.sendSNMPTrap((EnterpriseSNMPTrap)agentConnectionSNMPTrap, false);
        }
    }

    private void doAgentDisconnectNotification(Agent agent, int n) {
        AgentConnectionSNMPTrap agentConnectionSNMPTrap;
        if (this.initialAgentNotifier != null && this.initialAgentNotifier.isRunning) {
            this.initialAgentNotifier.agentSet.add(agent);
        }
        String string = this.prepAgentOfflineMsg(agent, n);
        logger.warn((Object)string);
        if (agent.isSendSMTPEmail() && agent.getNotificationListID() > 0L && n != 3) {
            agentConnectionSNMPTrap = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
            String[] stringArray = null;
            try {
                stringArray = agentConnectionSNMPTrap.get(agent.getNotificationListID()).getListOfUniqueEmails();
            }
            catch (Exception exception) {
                logger.error((Object)"Error retrieving Agent Notification Options.", (Throwable)exception);
            }
            if (stringArray != null && stringArray.length > 0) {
                String string2 = n == 1 ? string : RosettaMsg.getMsgText((RosettaMsg)RosettaMsg.SKYBOT_SCHEDULER_AGENT_DISCONNECT_NOTICE, (Object[])new String[]{agent.getName()});
                this.sendEmail(stringArray, string2, string);
            }
        }
        if (agent.isSendSNMPTrap()) {
            agentConnectionSNMPTrap = new AgentConnectionSNMPTrap(true);
            agentConnectionSNMPTrap.setAgentID(agent.getOid());
            agentConnectionSNMPTrap.setAgentName(agent.getName());
            agentConnectionSNMPTrap.setText(string);
            agentConnectionSNMPTrap.setEndCode(Integer.toString(n));
            if (n == 3) {
                agentConnectionSNMPTrap.setSeverity("WR");
            } else {
                agentConnectionSNMPTrap.setSeverity("AT");
            }
            this.sendSNMPTrap((EnterpriseSNMPTrap)agentConnectionSNMPTrap, false);
        }
    }

    private String prepAgentOfflineMsg(Agent agent, int n) {
        switch (n) {
            case 1: {
                return "The Automate Schedule Server was unable to connect to Agent " + agent.getName() + ".";
            }
            case 3: {
                return "The Automate Schedule Agent " + agent.getName() + " was ended.";
            }
            case 2: {
                return "The Automate Schedule Server has lost the connection to Agent " + agent.getName() + ".";
            }
        }
        throw new IllegalStateException("Invalid offline code: " + n);
    }

    private void fixWindowsBitDepth(AgentCredentials agentCredentials) {
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.contains("win")) {
            return;
        }
        WindowsAgentAM windowsAgentAM = (WindowsAgentAM)ManagerRegistry.getManager((String)"ENTERPRISE.WindowsAgentAM");
        if (windowsAgentAM.is64BitWindowsOS()) {
            agentCredentials.setProperty("sun.arch.data.model", "64");
        }
    }

    private void evaluateAgent(String string, String string2, AgentProxy agentProxy, AgentLicenseVersion agentLicenseVersion) {
        String string3;
        boolean bl = false;
        ArchType archType = ArchType.ARCH_UNKNOWN;
        if (string != null && string.contains("64")) {
            bl = true;
        }
        if (string2 != null) {
            string3 = string2.toLowerCase();
            if (string3.contains("64")) {
                bl = true;
            }
            if (string3.contains("86") || string3.contains("amd")) {
                archType = ArchType.valueOf(ArchType.ARCH_86.value);
            } else if (string3.contains("ppc") || string3.contains("powerpc")) {
                archType = ArchType.valueOf(ArchType.ARCH_PPC.value);
            } else if (string3.contains("sparc")) {
                archType = ArchType.valueOf(ArchType.ARCH_SPARC.value);
            } else if (string3.startsWith("ia")) {
                archType = ArchType.valueOf(ArchType.ARCH_ITANIUM.value);
            } else if (string3.contains("pa_risc")) {
                archType = ArchType.valueOf(ArchType.ARCH_PA_RISC.value);
            } else if (string3.contains("s390")) {
                archType = ArchType.valueOf(ArchType.ARCH_S390.value);
            }
        }
        string3 = agentProxy.getOperatingSystem();
        OSType oSType = OSType.OS_UNKNOWN;
        if (string3 != null) {
            if ((string3 = string3.toLowerCase()).contains("win")) {
                oSType = OSType.valueOf(OSType.OS_WIN.value);
            } else if (string3.contains("mac os x")) {
                oSType = OSType.valueOf(OSType.OS_MAC.value);
            } else if (string3.contains("linux")) {
                oSType = OSType.valueOf(OSType.OS_LINUX.value);
            } else if (string3.contains("bsd") || string3.contains("sco")) {
                oSType = OSType.valueOf(OSType.OS_UNIX.value);
            } else if (string3.contains("aix")) {
                oSType = OSType.valueOf(OSType.OS_AIX.value);
            } else if (string3.contains("hp-ux")) {
                oSType = OSType.valueOf(OSType.OS_HP_UX.value);
            } else if (string3.contains("solaris") || string3.contains("sunos")) {
                oSType = OSType.valueOf(OSType.OS_SOLARIS.value);
            } else if (string3.contains("400")) {
                oSType = OSType.valueOf(OSType.OS_400.value);
            }
        }
        switch (agentLicenseVersion) {
            case NONE: {
                agentProxy.setLicensePoints(this.getPoints(archType, oSType));
                this.evaluateAgentTier(agentProxy, archType, oSType, bl, AgentLicenseVersion.getLatest());
                break;
            }
            case ONE: {
                this.evaluateAgentTier(agentProxy, archType, oSType, bl, agentLicenseVersion);
            }
        }
    }

    private int getPoints(ArchType archType, OSType oSType) {
        int n = 0;
        block0 : switch (archType) {
            case ARCH_86: {
                n = 20;
                break;
            }
            case ARCH_PPC: {
                switch (oSType) {
                    case OS_400: {
                        n = 700;
                        break block0;
                    }
                }
                n = 400;
                break;
            }
            case ARCH_SPARC: {
                n = 400;
                break;
            }
            case ARCH_ITANIUM: {
                switch (oSType) {
                    case OS_WIN: {
                        n = 20;
                        break block0;
                    }
                }
                n = 400;
                break;
            }
            case ARCH_PA_RISC: {
                n = 400;
                break;
            }
            case ARCH_S390: {
                n = 400;
                break;
            }
            case ARCH_UNKNOWN: {
                n = 1000;
            }
        }
        return n;
    }

    private void evaluateAgentTier(AgentProxy agentProxy, ArchType archType, OSType oSType, boolean bl, AgentLicenseVersion agentLicenseVersion) {
        AgentLicenseTier agentLicenseTier = AgentLicenseTier.UNDEFINED;
        int n = ArchType.getWeightForVersion(agentLicenseVersion, archType);
        int n2 = OSType.getWeightForVersion(agentLicenseVersion, oSType);
        int n3 = n * n2;
        agentLicenseTier = AgentLicenseTier.getTier((int)n3);
        agentProxy.setLicenseTier(agentLicenseTier.integerCode().intValue());
    }

    private void checkAgentLicensing(Agent agent, AgentCredentials agentCredentials, PeerID peerID, AgentLicenseInfo agentLicenseInfo) throws PeerConnectException, ResourceUnavailableException, DataException, ActionFailedException {
        int n = agent.getLicensePoints();
        AgentLicenseTier agentLicenseTier = AgentLicenseTier.getTier((int)agent.getLicenseTier());
        if (n < 0) {
            n = 0;
        }
        AgentLicenseVersion agentLicenseVersion = agentLicenseInfo.version;
        int n2 = agent.getLicenseTier();
        String string = agentCredentials.getProperty("sun.arch.data.model");
        String string2 = agentCredentials.getProperty("os.arch");
        this.evaluateAgent(string, string2, (AgentProxy)agent, agentLicenseVersion);
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.AgentDM");
        AgentLicenseStatus agentLicenseStatus = new AgentLicenseStatus(agentLicenseVersion);
        switch (agentLicenseVersion) {
            case NONE: {
                agentLicenseStatus = this.getPointsLicenseStatus(agent, agentDM, n, agentLicenseInfo);
                if (n2 == agent.getLicenseTier()) break;
                agentDM.updateTier(agent.getOid(), agent.getLicenseTier());
                break;
            }
            case ONE: {
                agentLicenseStatus = this.getTierLicenseStatus(agent, agentDM, agentLicenseTier, agentLicenseInfo);
                break;
            }
            default: {
                logger.error((Object)("Unknown license version of " + agentLicenseVersion.name()));
                throw new PeerConnectException("The server was unable to determine the licensing needs for agent " + agent.getName());
            }
        }
        this.licensedAgentMap.put(peerID, agentLicenseStatus);
    }

    private AgentLicenseStatus getTierLicenseStatus(Agent agent, AgentDM agentDM, AgentLicenseTier agentLicenseTier, AgentLicenseInfo agentLicenseInfo) throws ResourceUnavailableException {
        Map<AgentLicenseTier, Integer> map = agentLicenseInfo.getTierValues();
        AgentLicenseTier agentLicenseTier2 = AgentLicenseTier.getTier((int)agent.getLicenseTier());
        if (!agentLicenseTier.equals((Object)agentLicenseTier2)) {
            agentDM.updateTier(agent.getOid(), agentLicenseTier2.integerCode().intValue());
        }
        AgentLicenseStatus agentLicenseStatus = new AgentLicenseStatus(agentLicenseInfo.version);
        agentLicenseStatus.setTierInUse(agentLicenseTier2);
        Integer n = map.get(agentLicenseTier2);
        if (n == 99999) {
            agent.setLicenseAllocated(true);
            agentDM.updateLicenseAllocation(agent.getOid(), true);
            agentLicenseStatus.setLicenseState(3);
        } else {
            if (n >= 0 && agent.getLicenseAllocated()) {
                int n2 = this.fetchTierValueInUse(agent);
                String string = agent.getName() + " requires " + agentLicenseTier2.name();
                if (!agentLicenseInfo.isTempAvailable()) {
                    string = string + " with " + n2 + " of " + n + " total licenses used.";
                }
                logger.debug((Object)string);
                if (n2 > n) {
                    agent.setLicenseAllocated(false);
                    agentDM.updateLicenseAllocation(agent.getOid(), false);
                } else {
                    agentLicenseStatus.setLicenseState(3);
                }
            }
            if (agentLicenseStatus.getLicenseState() == 0) {
                if (agentLicenseInfo.isTempAvailable()) {
                    agentLicenseStatus.setLicenseState(2);
                } else {
                    agentLicenseStatus.setLicenseState(1);
                }
            }
        }
        return agentLicenseStatus;
    }

    private AgentLicenseStatus getPointsLicenseStatus(Agent agent, AgentDM agentDM, int n, AgentLicenseInfo agentLicenseInfo) throws PeerConnectException, ResourceUnavailableException, DataException {
        int n2 = agent.getLicensePoints();
        if (n2 <= 0) {
            throw new PeerConnectException("The server was unable to determine the licensing needs for agent " + agent.getName());
        }
        if (n != n2) {
            agentDM.updatePoints(agent.getOid(), n2);
        }
        int n3 = agentLicenseInfo.getLicensePoints();
        AgentLicenseStatus agentLicenseStatus = new AgentLicenseStatus(agentLicenseInfo.version);
        agentLicenseStatus.setPointsInUse(n2);
        if (n3 == 999999) {
            agent.setLicenseAllocated(true);
            agentDM.updateLicenseAllocation(agent.getOid(), true);
            agentLicenseStatus.setLicenseState(3);
        } else {
            if (n3 > 0 && agent.getLicenseAllocated()) {
                int n4 = this.fetchPointsInUse(agent);
                if (n4 > n3) {
                    agent.setLicenseAllocated(false);
                    agentDM.updateLicenseAllocation(agent.getOid(), false);
                } else {
                    agentLicenseStatus.setLicenseState(3);
                }
            }
            if (agentLicenseStatus.getLicenseState() == 0) {
                if (agentLicenseInfo.isTempAvailable()) {
                    agentLicenseStatus.setLicenseState(2);
                } else {
                    agentLicenseStatus.setLicenseState(1);
                }
            }
        }
        return agentLicenseStatus;
    }

    private AgentLicenseInfo getAgentLicenseInfo(long l) throws ResourceUnavailableException, ActionFailedException {
        return this.getAgentLicenseInfo(l, false);
    }

    private AgentLicenseInfo getAgentLicenseInfo(long l, boolean bl) throws ResourceUnavailableException, ActionFailedException {
        if (bl && this.cachedAgentLicenseInfo != null) {
            return this.cachedAgentLicenseInfo;
        }
        this.cachedAgentLicenseInfo = this.fetchAllLicenses(l);
        return this.cachedAgentLicenseInfo;
    }

    private AgentLicenseInfo fetchAllLicenses(long l) throws ResourceUnavailableException, ActionFailedException {
        EnterpriseProductLicense enterpriseProductLicense;
        AgentLicenseVersion agentLicenseVersion = AgentLicenseVersion.getLatest();
        Map<AgentLicenseTier, Integer> map = AgentLicenseTier.getDefaultTierValues();
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        int[] nArray = new int[7477 + (int)(l % 13L)];
        Random random = new Random(l);
        boolean bl = false;
        int n = nArray.length % 449;
        int n2 = n + 1;
        int n3 = nArray.length % 1013 + 1 + n;
        int n4 = nArray.length % 104729 + 1 + n + n3;
        int n5 = n4 / 2;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = random.nextInt(n4) - n5;
        }
        EnterpriseProductLicense enterpriseProductLicense2 = null;
        EnterpriseProductLicense enterpriseProductLicense3 = null;
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated = enterpriseLicenseInfoAM.getValidatedLicenseInfo(l);
        boolean bl2 = false;
        if (enterpriseLicenseInfo_Validated.isPrimaryLicenseKeyValid(l)) {
            EnterpriseProductLicense enterpriseProductLicense4 = enterpriseLicenseInfo_Validated.getPrimaryLicense();
            if (enterpriseProductLicense4.getLicenseCode().length() > 0) {
                enterpriseProductLicense2 = enterpriseProductLicense4;
            }
            if (enterpriseProductLicense4.isValidPermanent(this.getRemotePeerID().getHardwareKey())) {
                bl = true;
                bl2 = true;
            } else if (enterpriseProductLicense4.getLicenseCode().trim().length() != 0) {
                if (enterpriseProductLicense4.getLicenseType() == 2) {
                    logger.debug((Object)"The Enterprise Server Primary License contains a temporary license.");
                } else {
                    logger.debug((Object)"The Enterprise Server Primary License contains an invalid license.");
                }
            }
        } else {
            logger.debug((Object)"The Enterprise Server Primary License contains an invalid key.");
        }
        boolean bl3 = false;
        if (enterpriseLicenseInfo_Validated.isTrialLicenseKeyValid(l)) {
            enterpriseProductLicense = enterpriseLicenseInfo_Validated.getTrialLicense();
            if (enterpriseProductLicense.getLicenseCode().length() > 0) {
                enterpriseProductLicense3 = enterpriseProductLicense;
            }
            if (enterpriseProductLicense.isValidTemporary(this.getRemotePeerID().getHardwareKey())) {
                bl3 = true;
                bl = true;
            } else if (enterpriseProductLicense.getLicenseCode().trim().length() != 0) {
                if (enterpriseProductLicense.getLicenseType() == 1) {
                    logger.debug((Object)"The Enterprise Server Temporary License contains a non-temporary license.");
                } else {
                    logger.debug((Object)"The Enterprise Server Temporary License contains an invalid license.");
                }
            }
        } else if (!bl) {
            logger.debug((Object)"The Enterprise Server Temporary License contains an invalid key.");
        }
        if (!bl) {
            logger.error((Object)"There is no valid license. All Agents will be disabled until this problem is corrected.");
        }
        enterpriseProductLicense = (SAPServerHelperAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPServerHelperAM");
        if (!bl || !enterpriseLicenseInfo_Validated.isLicensedForFeature(EnterpriseProductLicense.FEATURE.SAP, this.getRemotePeerID().getHardwareKey())) {
            enterpriseProductLicense.notifyOfLicenseChange(false);
        } else if (enterpriseLicenseInfo_Validated.isLicensedForFeature(EnterpriseProductLicense.FEATURE.SAP, this.getRemotePeerID().getHardwareKey())) {
            enterpriseProductLicense.notifyOfLicenseChange(true);
        }
        this.sendLicenseMessages(enterpriseLicenseInfo_Validated, bl2, bl3, enterpriseLicenseInfoAM);
        int n6 = 0;
        try {
            if (bl2) {
                map = this.getTierValues(enterpriseProductLicense2);
                n6 = enterpriseProductLicense2.getPoints();
            }
            if (enterpriseProductLicense3 != null) {
                if (!bl3 && enterpriseProductLicense2 != null) {
                    agentLicenseVersion = AgentLicenseVersion.getVersion((int)enterpriseProductLicense2.getLicenseKeyVersion());
                } else {
                    agentLicenseVersion = AgentLicenseVersion.getVersion((int)enterpriseProductLicense3.getLicenseKeyVersion());
                    if (!bl2) {
                        map = this.getTierValues(enterpriseProductLicense3);
                    }
                }
            } else if (enterpriseProductLicense2 != null) {
                agentLicenseVersion = AgentLicenseVersion.getVersion((int)enterpriseProductLicense2.getLicenseKeyVersion());
            }
        }
        catch (InvalidLicenseVersionException invalidLicenseVersionException) {
            logger.error((Object)invalidLicenseVersionException.getMessage());
        }
        if (n6 < 0 || n6 > 999999) {
            logger.warn((Object)"The Enterprise Server Primary License contains an invalid value, some Agents will be disabled until this problem is corrected.");
            n6 = 0;
        }
        int n7 = Math.abs(random.nextInt());
        nArray[n3] = bl3 ? n7 + 1 : -1 * n7;
        if (n6 + nArray[n2] > Integer.MAX_VALUE) {
            nArray[n2] = Integer.MAX_VALUE - n6 - n;
        }
        nArray[n] = n6 + nArray[n2];
        return new AgentLicenseInfo(agentLicenseVersion, nArray, map, bl2);
    }

    private Map<AgentLicenseTier, Integer> getTierValues(EnterpriseProductLicense enterpriseProductLicense) {
        HashMap<AgentLicenseTier, Integer> hashMap = new HashMap<AgentLicenseTier, Integer>();
        for (AgentLicenseTier agentLicenseTier : AgentLicenseTier.values()) {
            int n = enterpriseProductLicense.getTierPoints(agentLicenseTier);
            if (n < 0 || n > 99999) {
                logger.warn((Object)"The Enterprise Server Primary License contains an invalid value, some Agents will be disabled until this problem is corrected.");
                n = 0;
            }
            hashMap.put(agentLicenseTier, n);
        }
        return hashMap;
    }

    private final void sendLicenseMessages(EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated, boolean bl, boolean bl2, EnterpriseLicenseInfoAM enterpriseLicenseInfoAM) {
        long l;
        int n;
        if (enterpriseLicenseInfo_Validated == null) {
            SystemMessage systemMessage = RosettaMsg.COULDNT_FIND_VALID_LICENSE.newSystemMessage();
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.COULDNT_FIND_VALID_LICENSE.newLogEntry();
            this.sendLicenseError(systemMessage, scheduleLogEntry);
            return;
        }
        if (!bl && !bl2) {
            SystemMessage systemMessage = RosettaMsg.COULDNT_FIND_VALID_PRIMARY_OR_TEMPORARY_LICENSE.newSystemMessage();
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.COULDNT_FIND_VALID_PRIMARY_OR_TEMPORARY_LICENSE.newLogEntry();
            this.sendLicenseError(systemMessage, scheduleLogEntry);
            return;
        }
        EnterpriseProductLicense enterpriseProductLicense = enterpriseLicenseInfo_Validated.getTrialLicense();
        EnterpriseProductLicense enterpriseProductLicense2 = enterpriseLicenseInfo_Validated.getPrimaryLicense();
        if (enterpriseProductLicense == null && enterpriseProductLicense2 == null) {
            SystemMessage systemMessage = RosettaMsg.COULDNT_FIND_VALID_LICENSE.newSystemMessage();
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.COULDNT_FIND_VALID_LICENSE.newLogEntry();
            this.sendLicenseError(systemMessage, scheduleLogEntry);
            return;
        }
        if (bl2 && enterpriseProductLicense.getLicenseType() == 2 && (n = this.getNumberOfDays((l = enterpriseProductLicense.getExpirationDate().getTime()) - System.currentTimeMillis())) <= 10 && !bl) {
            String[] stringArray = new String[]{ScheduleLogger.formatTimeStamp((long)l)};
            SystemMessage systemMessage = RosettaMsg.TEMPORARY_LICENSE_EXPIRING_DAYS.newSystemMessage(stringArray);
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.TEMPORARY_LICENSE_EXPIRING_DAYS.newLogEntry(stringArray);
            this.sendLicenseWarning(2, enterpriseLicenseInfoAM, systemMessage, scheduleLogEntry);
            return;
        }
        if (enterpriseProductLicense2 != null && enterpriseProductLicense2.getLicenseType() == 1) {
            int n2 = enterpriseProductLicense2.getPoints();
            if (n2 < 0 || n2 > 999999) {
                SystemMessage systemMessage = RosettaMsg.INVALID_PRIMARY_LICENSE.newSystemMessage();
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.INVALID_PRIMARY_LICENSE.newLogEntry();
                this.sendLicenseError(systemMessage, scheduleLogEntry);
                return;
            }
            return;
        }
        if (enterpriseProductLicense2 != null && enterpriseProductLicense2.getLicenseType() == 2 && enterpriseProductLicense2.isSystemSpecificTempCode() && enterpriseProductLicense2.getExpirationDate() != null && (n = this.getNumberOfDays((l = enterpriseProductLicense2.getExpirationDate().getTime()) - System.currentTimeMillis())) <= 10) {
            String[] stringArray = new String[]{ScheduleLogger.formatTimeStamp((long)l)};
            SystemMessage systemMessage = RosettaMsg.PRIMARY_LICENSE_EXPIRING_DAYS.newSystemMessage(stringArray);
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.PRIMARY_LICENSE_EXPIRING_DAYS.newLogEntry(stringArray);
            this.sendLicenseWarning(1, enterpriseLicenseInfoAM, systemMessage, scheduleLogEntry);
            return;
        }
    }

    private void sendEmail(String[] stringArray, String string, String string2) {
        EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseEmailAM");
        try {
            enterpriseEmailAM.sendMessage(stringArray, string, string2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending an email.", (Throwable)exception);
        }
    }

    private void sendSNMPTrap(EnterpriseSNMPTrap enterpriseSNMPTrap, boolean bl) {
        EnterpriseSNMPTrapAM enterpriseSNMPTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        try {
            if (bl) {
                enterpriseSNMPTrapAM.sendSNMPTrapNow(enterpriseSNMPTrap);
            } else {
                enterpriseSNMPTrapAM.sendSNMPTrap(enterpriseSNMPTrap);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending an SNMP Trap.", (Throwable)exception);
        }
    }

    private void sendLicenseError(SystemMessage systemMessage, ScheduleLogEntry scheduleLogEntry) {
        logger.trace((Object)("License error: " + systemMessage));
        long l = 3600000L;
        long l2 = System.currentTimeMillis();
        if (this.lastErrorTime != 0L && this.lastErrorTime + l > l2) {
            long l3 = l2 - this.lastErrorTime;
            long l4 = l3 / 1000L / 60L;
            long l5 = l3 / 1000L % 60L;
            logger.trace((Object)("Skipping license error notification. The last license error was sent " + l4 + " minutes " + l5 + " seconds ago."));
            return;
        }
        this.lastErrorTime = l2;
        SystemMessage systemMessage2 = RosettaMsg.SKYBOT_SCHEDULER_DOES_NOT_HAVE_A_VALID_LICENSE.newSystemMessage();
        SystemMessageQueue.write((SystemMessage)systemMessage, (String)"AT", (SystemMessage)systemMessage2);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    private void sendLicenseWarning(int n, EnterpriseLicenseInfoAM enterpriseLicenseInfoAM, SystemMessage systemMessage, ScheduleLogEntry scheduleLogEntry) {
        String string = this.getWarningTypeText(n);
        if (this.alreadySentWarning(n, enterpriseLicenseInfoAM, string)) {
            logger.trace((Object)("Warning for expiring " + string + " license has already occurred."));
            return;
        }
        try {
            this.updateLastWarnedDate(n, enterpriseLicenseInfoAM, string);
            SystemMessageQueue.write((SystemMessage)systemMessage);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
        catch (Exception exception) {
            logger.error((Object)("Unable to perform " + string + " license warning notification."), (Throwable)exception);
        }
    }

    private boolean alreadySentWarning(int n, EnterpriseLicenseInfoAM enterpriseLicenseInfoAM, String string) {
        String string2 = null;
        try {
            switch (n) {
                case 1: 
                case 2: {
                    string2 = enterpriseLicenseInfoAM.getLastNotifiedDate(n);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("License warning type is not valid: " + n);
                }
            }
            if (string2 == null || string2.trim().length() != 10) {
                return false;
            }
            logger.trace((Object)("Last " + string + " license warning date: " + string2));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String string3 = simpleDateFormat.format(new Date(System.currentTimeMillis()));
            return string3.equals(string2);
        }
        catch (Throwable throwable) {
            logger.debug((Object)("Error checking last " + string + " license warning date."), throwable);
            return false;
        }
    }

    private String getWarningTypeText(int n) {
        switch (n) {
            case 2: {
                return "temporary";
            }
            case 1: {
                return "primary";
            }
        }
        return "<undefined:" + n + ">";
    }

    private void updateLastWarnedDate(int n, EnterpriseLicenseInfoAM enterpriseLicenseInfoAM, String string) {
        Date date = new Date(System.currentTimeMillis());
        try {
            switch (n) {
                case 1: 
                case 2: {
                    enterpriseLicenseInfoAM.saveLastNotifiedDate(n, date);
                    break;
                }
                default: {
                    logger.debug((Object)("License warning type is not valid: " + n));
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)("Error updating last " + string + " license warning date."), throwable);
            return;
        }
    }

    private int fetchTierValueInUse(Agent agent) throws ResourceUnavailableException {
        DataSet dataSet = null;
        int n = 0;
        try {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
            dataSet = agentDM.getDataSet(null, null, null);
            CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
            for (AgentProxy agentProxy : cachingDataSet) {
                AgentLicenseStatus agentLicenseStatus;
                if (!agentProxy.getLicenseAllocated()) continue;
                if (agent.getOid() == agentProxy.getOid()) {
                    ++n;
                    continue;
                }
                AgentLicenseTier agentLicenseTier = AgentLicenseTier.getTier((int)agentProxy.getLicenseTier());
                AgentLicenseTier agentLicenseTier2 = AgentLicenseTier.getTier((int)agent.getLicenseTier());
                PeerID peerID = this.searchForAgent(agentProxy);
                if (peerID != null && (agentLicenseStatus = this.licensedAgentMap.get(peerID)) != null && agentLicenseTier.equals((Object)agentLicenseTier2)) {
                    ++n;
                    continue;
                }
                if (!agentLicenseTier.equals((Object)agentLicenseTier2)) continue;
                ++n;
            }
        }
        catch (DataSetException dataSetException) {
            throw new ResourceUnavailableException("Unable to obtain a list of Agent records from the database.", (Throwable)dataSetException);
        }
        finally {
            try {
                dataSet.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    private int fetchPointsInUse(Agent agent) throws ResourceUnavailableException, DataException {
        DataSet dataSet = null;
        int n = 0;
        try {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
            dataSet = agentDM.getDataSet(null, null, null);
            CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
            for (AgentProxy agentProxy : cachingDataSet) {
                AgentLicenseStatus agentLicenseStatus;
                if (!agentProxy.getLicenseAllocated()) continue;
                if (agent.getOid() == agentProxy.getOid()) {
                    n += agent.getLicensePoints();
                    continue;
                }
                PeerID peerID = this.searchForAgent(agentProxy);
                if (peerID != null && (agentLicenseStatus = this.licensedAgentMap.get(peerID)) != null) {
                    n += agentLicenseStatus.getPointsInUse();
                    continue;
                }
                n += agentProxy.getLicensePoints();
            }
        }
        catch (DataSetException dataSetException) {
            throw new ResourceUnavailableException("Unable to obtain a list of Agent records from the database.", (Throwable)dataSetException);
        }
        finally {
            try {
                dataSet.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    private void sendEventMonitors(PeerID peerID) {
        AgentDM agentDM;
        Agent agent = null;
        try {
            agentDM = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
            agent = agentDM.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), (String)((Object)peerID.getInstanceIdentifier()));
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to look up agent " + peerID), (Throwable)exception);
            return;
        }
        if (agent == null) {
            logger.debug((Object)("Unable to send Event Monitors to agent " + peerID));
            return;
        }
        logger.debug((Object)("Checking for Event Monitors for agent " + agent.getName()));
        try {
            agentDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
            RelMod relMod = agentDM.getEventsForAgent(agent.getOid());
            if (relMod != null) {
                logger.debug((Object)("Found " + ((AgentEventMonitor[])relMod).length + " Event Monitors for agent " + agent.getName()));
            }
            AgentEventMonitorAM agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"ENTERPRISE.AgentEventMonitorAM");
            if (!this.isLicensedAndOnline((AgentProxy)agent)) {
                for (RelMod relMod2 : relMod) {
                    relMod2.setDisabled(true);
                }
            }
            RelMod relMod3 = RelMod.parse((String)agent.getVersion());
            logger.debug((Object)("Sending Event Monitors to agent " + agent.getName() + " at RelMod " + relMod3));
            int n = AgentEventMonitorAM.RELMOD0202.compareTo((Object)relMod3);
            if (n < 0) {
                for (int i = 0; i < ((RelMod)relMod).length; ++i) {
                    relMod[i].setAgentOID(agent.getOid());
                }
                agentEventMonitorAM.setMonitors((AgentEventMonitor[])relMod);
            } else {
                agentEventMonitorAM.setMonitors((AgentEventMonitor[])relMod, agent.getOid());
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to send Event Monitors to agent " + agent.getName()), (Throwable)exception);
        }
    }

    public void pollAgents(boolean bl) throws ActionFailedException, ResourceUnavailableException {
        this.lastErrorTime = 0L;
        long l = System.currentTimeMillis();
        AgentLicenseInfo agentLicenseInfo = this.getAgentLicenseInfo(l);
        if (bl && !agentLicenseInfo.validPrimaryLicense && !agentLicenseInfo.isTempAvailable()) {
            return;
        }
        final ArrayList<PeerID> arrayList = new ArrayList<PeerID>();
        switch (agentLicenseInfo.version) {
            case NONE: {
                this.pollPointKeyAgents(agentLicenseInfo, arrayList);
                break;
            }
            case ONE: {
                this.pollTierKeyAgents(agentLicenseInfo, arrayList);
                break;
            }
            default: {
                logger.error((Object)("Unknown license version of " + agentLicenseInfo.version));
                this.disableAgents();
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (PeerID peerID : arrayList) {
                    AgentPeer.this.sendEventMonitors(peerID);
                }
            }
        };
        if (bl) {
            Thread thread = new Thread(runnable);
            thread.setName("Sending Updated Event Monitors");
            thread.start();
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableAgents() {
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        AgentStatusAM agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentStatusAM");
        HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
        synchronized (hashMap) {
            DataSet dataSet = null;
            try {
                dataSet = agentStatusAM.getDataSet(true);
                CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
                AgentLicenseStatus agentLicenseStatus = new AgentLicenseStatus();
                agentLicenseStatus.setLicenseState(1);
                for (AgentProxy agentProxy : cachingDataSet) {
                    agentProxy.setLicenseAllocated(false);
                    PeerID peerID = this.searchForAgent(agentProxy);
                    this.licensedAgentMap.put(peerID, agentLicenseStatus);
                    try {
                        Agent agent = null;
                        if (agentProxy instanceof Agent) {
                            agent = (Agent)agentProxy;
                        } else {
                            agent = new Agent();
                            agent.setOid(agentProxy.getOid());
                            agent.setLicenseAllocated(agentProxy.getLicenseAllocated());
                        }
                        agentDM.saveLicenseInfo(agent);
                    }
                    catch (Exception exception) {
                        logger.debug((Object)("Unable to update license state for agent " + agentProxy.getName()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to verify agent runtime connectivity.", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollTierKeyAgents(AgentLicenseInfo agentLicenseInfo, ArrayList<PeerID> arrayList) {
        Map<AgentLicenseTier, Integer> map = agentLicenseInfo.getTierValueMap();
        TreeSet<AgentProxy> treeSet = new TreeSet<AgentProxy>(new Comparator<AgentProxy>(){

            @Override
            public int compare(AgentProxy agentProxy, AgentProxy agentProxy2) {
                int n;
                AgentLicenseStatus agentLicenseStatus = agentProxy.getLicenseStatus();
                AgentLicenseStatus agentLicenseStatus2 = agentProxy2.getLicenseStatus();
                int n2 = -1;
                int n3 = -1;
                if (agentLicenseStatus != null) {
                    n2 = agentLicenseStatus.getTierInUse().integerCode();
                }
                if (agentLicenseStatus2 != null) {
                    n3 = agentLicenseStatus2.getTierInUse().integerCode();
                }
                if ((n = n3 - n2) == 0) {
                    return agentProxy.getName().compareTo(agentProxy2.getName());
                }
                return n;
            }
        });
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        AgentStatusAM agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentStatusAM");
        HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
        synchronized (hashMap) {
            DataSet dataSet = null;
            try {
                dataSet = agentStatusAM.getDataSet(true);
                CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
                for (AgentProxy agentProxy : cachingDataSet) {
                    if (agentProxy.getRuntimeState() != 1) continue;
                    treeSet.add(agentProxy);
                }
                for (AgentProxy agentProxy : treeSet) {
                    int n;
                    int n2;
                    PeerID peerID;
                    String[] stringArray;
                    String string;
                    AgentLicenseStatus agentLicenseStatus = agentProxy.getLicenseStatus();
                    AgentLicenseStatus agentLicenseStatus2 = new AgentLicenseStatus(agentLicenseInfo.version);
                    boolean bl = !agentLicenseStatus.getAgentLicenseVersion().equals((Object)agentLicenseStatus2.getAgentLicenseVersion());
                    boolean bl2 = AgentLicenseTier.getTier((int)agentProxy.getLicenseTier()).equals((Object)AgentLicenseTier.UNDEFINED);
                    if (bl2 || bl) {
                        if (bl2) {
                            logger.warn((Object)("Agent " + agentProxy.getName() + " has an undefined tier."));
                        }
                        if (bl) {
                            logger.debug((Object)("The license version changed.  Evaluating License Tier for Agent " + agentProxy.getName()));
                        }
                        string = agentProxy.getCPUInfo();
                        stringArray = agentProxy.getCPUInfo();
                        this.evaluateAgent(string, (String)stringArray, agentProxy, agentLicenseInfo.version);
                        agentDM.updateTier(agentProxy.getOid(), agentProxy.getLicenseTier());
                    }
                    if (agentProxy.getLicenseAllocated() && !agentLicenseInfo.isTempAvailable()) {
                        Iterator iterator = AgentLicenseTier.getTier((int)agentProxy.getLicenseTier());
                        int n3 = map.get(iterator);
                        if (n3 != 99999) {
                            logger.debug((Object)(iterator.name() + " has " + map.get(iterator) + " available license(s)."));
                            logger.debug((Object)("Attempting to license Agent(" + agentProxy.getName() + ")" + " for " + iterator.name()));
                            --n3;
                        }
                        if (n3 >= 0) {
                            agentLicenseStatus2.setLicenseState(3);
                            logger.debug((Object)("Successfully licensed Agent(" + agentProxy.getName() + ")" + " for " + iterator.name()));
                        } else {
                            ++n3;
                            logger.debug((Object)("Not enough licenses.  Deallocating " + agentProxy.getName()));
                            agentProxy.setLicenseAllocated(false);
                            try {
                                string = null;
                                if (agentProxy instanceof Agent) {
                                    string = (Agent)agentProxy;
                                } else {
                                    string = new Agent();
                                    string.setOid(agentProxy.getOid());
                                    string.setLicenseAllocated(agentProxy.getLicenseAllocated());
                                }
                                agentDM.saveLicenseInfo((Agent)string);
                                stringArray = new String[]{agentProxy.getName()};
                                peerID = RosettaMsg.AGENT_LICENSE_DEALLOCATED.newLogEntry(stringArray);
                                peerID.setAgentID(string.getOid());
                                ScheduleLogger.write((ScheduleLogEntry)peerID);
                                logger.warn((Object)peerID.getMessageText());
                            }
                            catch (Exception exception) {
                                logger.error((Object)("Unable to update license state for agent " + agentProxy.getName()), (Throwable)exception);
                            }
                        }
                        map.put((AgentLicenseTier)iterator, n3);
                    }
                    if (agentLicenseStatus2.getLicenseState() == 0 && agentLicenseInfo.isTempAvailable()) {
                        agentLicenseStatus2.setLicenseState(2);
                    }
                    if (agentLicenseStatus2.getLicenseState() == 0) {
                        agentLicenseStatus2.setLicenseState(1);
                    }
                    if ((n2 = agentLicenseStatus.getLicenseState()) == (n = agentLicenseStatus2.getLicenseState()) && agentLicenseStatus.getAgentLicenseVersion().equals((Object)agentLicenseStatus2.getAgentLicenseVersion())) continue;
                    peerID = this.searchForAgent(agentProxy);
                    agentLicenseStatus2.setPointsInUse(agentLicenseStatus.getPointsInUse());
                    this.licensedAgentMap.put(peerID, agentLicenseStatus2);
                    if (n2 != 1 && n != 1) continue;
                    arrayList.add(peerID);
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to verify agent runtime connectivity.", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollPointKeyAgents(AgentLicenseInfo agentLicenseInfo, ArrayList<PeerID> arrayList) {
        int n = agentLicenseInfo.getLicensePoints();
        TreeSet<AgentProxy> treeSet = new TreeSet<AgentProxy>(new Comparator<AgentProxy>(){

            @Override
            public int compare(AgentProxy agentProxy, AgentProxy agentProxy2) {
                int n;
                AgentLicenseStatus agentLicenseStatus = agentProxy.getLicenseStatus();
                AgentLicenseStatus agentLicenseStatus2 = agentProxy2.getLicenseStatus();
                int n2 = -1;
                int n3 = -1;
                if (agentLicenseStatus != null) {
                    n2 = agentLicenseStatus.getPointsInUse();
                }
                if (agentLicenseStatus2 != null) {
                    n3 = agentLicenseStatus2.getPointsInUse();
                }
                if ((n = n3 - n2) == 0) {
                    return agentProxy.getName().compareTo(agentProxy2.getName());
                }
                return n;
            }
        });
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        AgentStatusAM agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentStatusAM");
        HashMap<PeerID, AgentLicenseStatus> hashMap = this.licensedAgentMap;
        synchronized (hashMap) {
            DataSet dataSet = null;
            try {
                dataSet = agentStatusAM.getDataSet(true);
                CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
                for (AgentProxy agentProxy : cachingDataSet) {
                    if (agentProxy.getRuntimeState() != 1) continue;
                    treeSet.add(agentProxy);
                }
                for (AgentProxy agentProxy : treeSet) {
                    int n2;
                    String[] stringArray;
                    int n3;
                    Object object;
                    Object object2;
                    if (agentProxy.getLicenseStatus().getPointsInUse() <= 0) {
                        logger.debug((Object)("Found Agent " + agentProxy.getName() + " with points in use = " + agentProxy.getLicenseStatus().getPointsInUse()));
                        if (agentProxy.getLicensePoints() <= 0) {
                            object2 = agentProxy.getCPUInfo();
                            object = agentProxy.getCPUInfo();
                            this.evaluateAgent((String)object2, (String)object, agentProxy, agentLicenseInfo.version);
                            agentDM.updatePoints(agentProxy.getOid(), agentProxy.getLicensePoints());
                        }
                        agentProxy.getLicenseStatus().setPointsInUse(agentProxy.getLicensePoints());
                        logger.debug((Object)("Points set to " + agentProxy.getLicenseStatus().getPointsInUse()));
                    }
                    object2 = agentProxy.getLicenseStatus();
                    object = new AgentLicenseStatus(agentLicenseInfo.version);
                    if (agentProxy.getLicenseAllocated() && !agentLicenseInfo.isTempAvailable()) {
                        n3 = object2.getPointsInUse();
                        logger.debug((Object)("License has " + n + " available license points."));
                        logger.debug((Object)("Attempting to license Agent(" + agentProxy.getName() + ")" + " for " + n3 + " points."));
                        if ((n -= n3) >= 0) {
                            object.setLicenseState(3);
                            logger.debug((Object)("Successfully licensed Agent(" + agentProxy.getName() + ")" + " for " + n3 + " points."));
                        } else {
                            n += n3;
                            logger.debug((Object)("*** Not enough license points.  Deallocating " + agentProxy.getName()));
                            agentProxy.setLicenseAllocated(false);
                            try {
                                Agent agent = null;
                                if (agentProxy instanceof Agent) {
                                    agent = (Agent)agentProxy;
                                } else {
                                    agent = new Agent();
                                    agent.setOid(agentProxy.getOid());
                                    agent.setLicenseAllocated(agentProxy.getLicenseAllocated());
                                }
                                agentDM.saveLicenseInfo(agent);
                                stringArray = new String[]{agentProxy.getName()};
                                ScheduleLogEntry scheduleLogEntry = RosettaMsg.AGENT_LICENSE_DEALLOCATED.newLogEntry(stringArray);
                                scheduleLogEntry.setAgentID(agent.getOid());
                                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                                logger.warn((Object)scheduleLogEntry.getMessageText());
                            }
                            catch (Exception exception) {
                                logger.debug((Object)("Unable to update license state for agent " + agentProxy.getName()), (Throwable)exception);
                            }
                        }
                    } else if (logger.isDebugEnabled()) {
                        String string = "Skipping active Agent " + agentProxy.getName() + ", ";
                        string = agentLicenseInfo.isTempAvailable() ? string + "Trial License in use." : string + "not flagged for licensing.";
                        logger.debug((Object)string);
                    }
                    if (object.getLicenseState() == 0 && agentLicenseInfo.isTempAvailable()) {
                        object.setLicenseState(2);
                    }
                    if (object.getLicenseState() == 0) {
                        object.setLicenseState(1);
                    }
                    if ((n3 = object2.getLicenseState()) == (n2 = object.getLicenseState()) && object2.getAgentLicenseVersion().equals((Object)object.getAgentLicenseVersion())) continue;
                    stringArray = this.searchForAgent(agentProxy);
                    object.setPointsInUse(object2.getPointsInUse());
                    this.licensedAgentMap.put((PeerID)stringArray, (AgentLicenseStatus)object);
                    if (n3 != 1 && n2 != 1) continue;
                    arrayList.add((PeerID)stringArray);
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to verify agent runtime connectivity.", (Throwable)exception);
            }
        }
    }

    private void toggleAllSkybotTypeRemoteServersFromActiveToFailed() {
        try {
            RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
            remoteServersDM.toggleAllActiveToFailed();
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to set the status of all Automate Schedule type Remote Servers in ACTIVE status to FAILED", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShutdownCommand() throws IOException {
        String string = this.getConfigPath() + ".passphrase";
        FileWriter fileWriter = null;
        PrintWriter printWriter = null;
        try {
            fileWriter = new FileWriter(string);
            printWriter = new PrintWriter(fileWriter);
            printWriter.println(this.shutdownCommand);
            printWriter.close();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void cancelConditionalJobs() {
        JobHistoryDM jobHistoryDM = this.getJobHistoryDM();
        ArrayList arrayList = null;
        if (jobHistoryDM != null) {
            try {
                arrayList = jobHistoryDM.getConditionalJobs();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Error while getting Job History records for conditional statuses.", (Throwable)resourceUnavailableException);
            }
            if (arrayList != null && arrayList.size() > 0) {
                JobHistory jobHistory = null;
                for (Long l : arrayList) {
                    try {
                        jobHistory = jobHistoryDM.get(l.longValue());
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error while getting Job History record for ID " + l), (Throwable)exception);
                    }
                    if (jobHistory != null) {
                        jobHistory.setStatusCode(JobStatusCode.FAILED);
                        jobHistory.setJobEndedReasonCode(JobEndedReasonCode.AGENT_ENDED);
                    }
                    try {
                        jobHistoryDM.save(jobHistory);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error while saving Job History record for ID  " + l), (Throwable)exception);
                    }
                }
            }
        }
    }

    private JobHistoryDM getJobHistoryDM() {
        return (JobHistoryDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.JobHistoryDM");
    }

    private void sendLicenseWarning(PeerID peerID) {
        String string = peerID.getHardwareKey();
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        try {
            if (!enterpriseLicenseInfoAM.hasValidLicenseForHardware(string)) {
                String string2 = peerID.getPeerDescriptor().getPeerName();
                logger.warn((Object)("There is no valid license for connected standby server " + string2));
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SKYBOT_SCHEDULER_STANBY_SERVER_NO_LICENSE.newLogEntry(string2);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                SystemMessage systemMessage = RosettaMsg.SKYBOT_SCHEDULER_STANBY_SERVER_NO_LICENSE.newSystemMessage(string2);
                SystemMessageQueue.write((SystemMessage)systemMessage);
            }
        }
        catch (NoDataException noDataException) {
            logger.warn((Object)"There is no valid license for connected standby server.", (Throwable)noDataException);
            noDataException.printStackTrace();
        }
        catch (Exception exception) {
            logger.debug((Object)"Error retrieving license information", (Throwable)exception);
        }
    }

    private void sendEmailMasterIsUnavailable(PeerDescriptor peerDescriptor, PeerDescriptor peerDescriptor2) {
        String string = "Automate Schedule Server Offline Notification";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The Automate Schedule Server ");
        stringBuffer.append(peerDescriptor2.getPeerName());
        stringBuffer.append(" appears to be offline.  The Automate Schedule Standby Server ");
        stringBuffer.append(peerDescriptor.getPeerName());
        stringBuffer.append(" was unable to contact it at ");
        stringBuffer.append(ScheduleLogger.formatTimeStamp((long)System.currentTimeMillis()));
        stringBuffer.append(".");
        this.sendStandbyEmail(string, stringBuffer.toString());
    }

    public void sendStandbyEmail(String string, String string2) {
        try {
            logger.info((Object)("Sending standby email message: " + string));
            SystemSetupDM systemSetupDM = MRHelper.getSystemSetupDM();
            String string3 = systemSetupDM.get().getHaEmailAddress();
            if (string3 == null || string3.equals("")) {
                logger.warn((Object)"Email notification was not set.  HA Email Address is null or blank.");
                return;
            }
            EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManager((String)"ENTERPRISE.EnterpriseEmailAM");
            enterpriseEmailAM.sendMessage(string3, string, string2);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error sending standby email notification.", throwable);
        }
    }

    private class AgentLicenseInfo {
        private AgentLicenseVersion version;
        private int[] array;
        private Map<AgentLicenseTier, Integer> tierValues;
        private Map<AgentLicenseTier, Integer> tierValueMap;
        private int pslot;
        private int tslot;
        private int pslotAdd;
        private boolean validPrimaryLicense;

        public boolean isTempAvailable() {
            return this.array[this.tslot] > 0;
        }

        public Map<AgentLicenseTier, Integer> getTierValueMap() {
            return this.tierValueMap;
        }

        public int getLicensePoints() {
            return this.array[this.pslot] - this.array[this.pslotAdd];
        }

        AgentLicenseInfo(AgentLicenseVersion agentLicenseVersion, int[] nArray, Map<AgentLicenseTier, Integer> map, boolean bl) {
            this.version = agentLicenseVersion;
            this.array = nArray;
            this.tierValues = map;
            this.validPrimaryLicense = bl;
            this.init();
            this.initTierValueMap();
        }

        private void init() {
            this.pslot = this.array.length % 449;
            this.pslotAdd = this.pslot + 1;
            this.tslot = this.array.length % 1013 + 1 + this.pslot;
        }

        private void initTierValueMap() {
            this.tierValueMap = new HashMap<AgentLicenseTier, Integer>();
            AgentLicenseTier[] agentLicenseTierArray = AgentLicenseTier.values();
            for (int i = 0; i < agentLicenseTierArray.length; ++i) {
                if (agentLicenseTierArray[i].integerCode() <= 0) continue;
                this.tierValueMap.put(agentLicenseTierArray[i], this.getTierValues().get(agentLicenseTierArray[i]));
            }
        }

        public Map<AgentLicenseTier, Integer> getTierValues() {
            return this.tierValues;
        }
    }

    class OfflineRemoteServerNotifier
    implements Runnable {
        OfflineRemoteServerNotifier() {
        }

        @Override
        public void run() {
            List list;
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
                list = remoteServersDM.getRemoteServersThatConnectToUs_AndAreInFailedStatus();
            }
            catch (Exception exception) {
                logger.info((Object)"Unable to retrieve the list of remote servers that have not connected to us within x minutes of startup.");
                return;
            }
            for (RemoteServer remoteServer : list) {
                try {
                    RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_HAS_NOT_YET_CONNECTED;
                    ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, remoteServer.getName());
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                    logger.warn((Object)scheduleLogEntry.getMessageText());
                }
                catch (Exception exception) {}
            }
        }
    }

    class InitialAgentNotifier
    implements Runnable {
        Set<Agent> agentSet = new HashSet<Agent>();
        boolean isRunning;

        InitialAgentNotifier() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Agent[] agentArray = null;
            try {
                Agent[] agentArray2 = AgentPeer.this.getAgentDM();
                agentArray = agentArray2.getByState(3);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to retrieve the failed Agents from the database.", (Throwable)exception);
                return;
            }
            for (Agent agent : agentArray) {
                if (this.agentSet.contains(agent)) continue;
                AgentPeer.this.doAgentDisconnectNotification(agent, 1);
            }
            this.isRunning = false;
            this.agentSet.clear();
        }
    }

    class ServerSocketListener
    extends PeerEventListener {
        ServerSocketListener() {
        }

        public void serviceEvent(GenericEvent genericEvent) {
            if (genericEvent instanceof ServerSocketClosedEvent) {
                ServerSocketClosedEvent serverSocketClosedEvent = (ServerSocketClosedEvent)genericEvent;
                PeerID peerID = serverSocketClosedEvent.getPeerID();
                if (AgentPeer.this.getRemotePeerID().equals((Object)peerID)) {
                    logger.fatal((Object)"The network socket required for this application has been closed.");
                    AgentPeer.this.shutdownAndHalt();
                }
            } else {
                super.serviceEvent(genericEvent);
            }
        }

        protected void peerConnected(PeerID peerID, PeerID peerID2) {
        }

        protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
        }
    }

    class RemoteServerStateListener
    extends PeerEventListener {
        RemoteServerStateListener() {
        }

        protected void peerConnected(PeerID peerID, PeerID peerID2) {
            try {
                if (peerID.getPeerDescriptor().getType() == 6) {
                    String string = peerID.getHardwareHash();
                    String string2 = peerID.getInstanceIdentifier().toString();
                    long[] lArray = this.remoteServersDM().getByHardwareHashAndInstanceIdentifier(string, string2);
                    if (lArray.length > 0) {
                        RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_CONNECT;
                        for (long l : lArray) {
                            String string3 = this.remoteServersDM().getServerName(l);
                            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, string3);
                            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                            logger.info((Object)scheduleLogEntry.getMessageText());
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error while processing the peer connected event for {0}.", (Object[])new Object[]{this.peerName(peerID)}), (Throwable)exception);
            }
        }

        protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
            try {
                if (peerID.getPeerDescriptor().getType() == 6) {
                    String string = peerID.getHardwareHash();
                    String string2 = peerID.getInstanceIdentifier().toString();
                    long[] lArray = this.remoteServersDM().getByHardwareHashAndInstanceIdentifier(string, string2);
                    if (lArray.length > 0) {
                        RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_DISCONNECT;
                        for (long l : lArray) {
                            this.remoteServersDM().setConnectedStateToFailed(l);
                            String string3 = this.remoteServersDM().getServerName(l);
                            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, string3);
                            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                            logger.info((Object)scheduleLogEntry.getMessageText());
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error while processing the peer disconnected event for {0}.", (Object[])new Object[]{this.peerName(peerID)}), (Throwable)exception);
            }
        }

        private String peerName(PeerID peerID) {
            String string = "";
            try {
                PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
                if (peerDescriptor != null) {
                    string = peerDescriptor.getPeerName();
                }
                string = peerID.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        private RemoteServersDM remoteServersDM() {
            RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
            if (remoteServersDM != null) {
                return remoteServersDM;
            }
            throw new IllegalStateException("The remote servers data manager was not found.");
        }
    }

    class AgentStateListener
    extends PeerEventListener {
        AgentStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void peerConnected(PeerID peerID, PeerID peerID2) {
            String string;
            String[] stringArray;
            if (peerID.getPeerDescriptor().getType() == 4) {
                AgentPeer.this.agentsThatAreEnding.remove(peerID);
            }
            HashMap hashMap = AgentPeer.this.licensedAgentMap;
            synchronized (hashMap) {
                AgentPeer.this.peerConnectList.remove(peerID);
            }
            if (peerID.getPeerDescriptor().getType() != 4) {
                return;
            }
            hashMap = AgentPeer.this.getAgentDM();
            Agent agent = null;
            try {
                agent = hashMap.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), peerID.getInstanceIdentifier().toString());
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to retrieve an agent from the database.", (Throwable)exception);
            }
            SystemSetupDM systemSetupDM = MRHelper.getSystemSetupDM();
            PeerDescriptor peerDescriptor = null;
            AgentConfigAM agentConfigAM = (AgentConfigAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentConfigAM");
            try {
                stringArray = systemSetupDM.get();
                int n = 0;
                string = "";
                if (stringArray.getStandbyServer() != null && stringArray.getStandbyServer().trim().length() > 0) {
                    string = stringArray.getStandbyServer();
                    n = stringArray.getStandbyPort();
                }
                if (agent != null && agent.getStandbyPortOverride() > 0 && agent.getStandbyServerOverride() != null && agent.getStandbyServerOverride().length() > 0) {
                    string = agent.getStandbyServerOverride();
                    n = agent.getStandbyPortOverride();
                }
                if (n > 0 && string != null) {
                    peerDescriptor = new PeerDescriptor(string, n, 9, null);
                }
            }
            catch (DataException dataException) {
                logger.error((Object)"Unable to retrieve system settings.", (Throwable)dataException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Unable to retrieve system settings.", (Throwable)resourceUnavailableException);
            }
            try {
                agentConfigAM.setStandby(peerDescriptor);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unable to set standby on agent.", throwable);
            }
            if (agent != null) {
                agent.setRuntimeState(1);
                try {
                    hashMap.updateRuntimeState(agent.getOid(), 1);
                }
                catch (Exception exception) {
                    logger.debug((Object)"Unable to update agent state in the database.", (Throwable)exception);
                }
                stringArray = new String[]{peerID.toString()};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.AGENT_CONNECTED.newLogEntry(stringArray);
                scheduleLogEntry.setAgentID(agent.getOid());
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.info((Object)("The Automate Schedule Agent " + agent.getName() + " has connected."));
                AgentPeer.this.doAgentConnectNotification(agent);
                try {
                    string = agentConfigAM.deleteWebServiceFiles(agent);
                    logger.info((Object)string);
                }
                catch (Exception exception) {
                    logger.info((Object)("Error deleting web service files on agent '" + agent.getName() + "'. " + " The installed agent may not support this function."), (Throwable)exception);
                }
                string = (AgentWorkManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentWorkManagerAM");
                string.agentConnected(agent);
            }
            AgentPeer.this.sendEventMonitors(peerID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
            AgentWorkManagerAM agentWorkManagerAM;
            if (peerID.getPeerDescriptor().getType() == 4) {
                AgentPeer.this.agentsThatAreEnding.remove(peerID);
            }
            HashMap hashMap = AgentPeer.this.licensedAgentMap;
            synchronized (hashMap) {
                if (AgentPeer.this.peerConnectList.contains(peerID) || AgentPeer.this.getPeerFromRoutingTable(peerID) != null) {
                    return;
                }
                AgentPeer.this.licensedAgentMap.remove(peerID);
            }
            if (AgentPeer.this.isShutdownStarted()) {
                return;
            }
            if (peerID.getPeerDescriptor().getType() != 4) {
                return;
            }
            hashMap = AgentPeer.this.getAgentDM();
            Agent agent = null;
            try {
                agent = hashMap.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), peerID.getInstanceIdentifier().toString());
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to retrieve an agent from the database.", (Throwable)exception);
                return;
            }
            if (agent == null) {
                return;
            }
            if (agent.getRuntimeState() == 1) {
                if (AgentPeer.this.ignoreAgentDisconnect) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring the disconnect of the Agent " + agent.getName()));
                    }
                    agent.setRuntimeState(2);
                    if (AgentPeer.this.initialAgentNotifier != null && ((AgentPeer)AgentPeer.this).initialAgentNotifier.isRunning) {
                        ((AgentPeer)AgentPeer.this).initialAgentNotifier.agentSet.add(agent);
                    }
                } else {
                    ScheduleLogEntry scheduleLogEntry;
                    agentWorkManagerAM = new AgentWorkManagerAM[]{peerID.toString()};
                    if (AgentPeer.this.endingAgentsList.contains(peerID)) {
                        agent.setRuntimeState(2);
                        AgentPeer.this.endingAgentsList.remove(peerID);
                        scheduleLogEntry = RosettaMsg.AGENT_DISCONNECTED.newLogEntry((String[])agentWorkManagerAM);
                        AgentPeer.this.doAgentDisconnectNotification(agent, 3);
                    } else {
                        agent.setRuntimeState(3);
                        scheduleLogEntry = RosettaMsg.AGENT_DISCONNECTED_WITHOUT_WARNING.newLogEntry((String[])agentWorkManagerAM);
                        AgentPeer.this.doAgentDisconnectNotification(agent, 2);
                    }
                    scheduleLogEntry.setAgentID(agent.getOid());
                    ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                }
            }
            try {
                AgentPeer.this.getAgentDM().updateRuntimeState(agent.getOid(), agent.getRuntimeState());
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to update agent state: " + agent.getName()), (Throwable)exception);
            }
            agentWorkManagerAM = (AgentWorkManagerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentWorkManagerAM");
            agentWorkManagerAM.agentDisconnected(agent);
        }
    }

    class MulticastWorker
    implements Runnable {
        boolean NAMED = false;

        MulticastWorker() {
        }

        String safelyGet(String[] stringArray, int n) {
            if (n < stringArray.length) {
                return stringArray[n];
            }
            return null;
        }

        private void handleBroadcast(MulticastMessage multicastMessage) throws IOException {
            String string = multicastMessage.getMessage();
            if (AgentPeer.QUERY.equals(string)) {
                AgentPeer.this.localAgentClientMap.clear();
                String string2 = AgentPeer.this.getRemotePeerID().getPeerDescriptor().getComputerName();
                if (string2 == null) {
                    string2 = AgentPeer.this.getRemotePeerID().getPeerDescriptor().findPrintableAddress();
                }
                String string3 = "SCHENT:" + AgentPeer.this.getConfig().getListenPort() + ":" + AgentPeer.this.getRemotePeerID().getHardwareHash() + ":" + string2;
                logger.debug((Object)("handleBroadcast response: " + string3));
                AgentPeer.this.multicastHandler.send(null, string3);
            } else if (string.startsWith("SCHENT:")) {
                String string4 = AgentPeer.this.getRemotePeerID().getHardwareHash();
                String[] stringArray = string.split(":");
                String string5 = this.safelyGet(stringArray, 1);
                String string6 = this.safelyGet(stringArray, 2);
                String string7 = this.safelyGet(stringArray, 3);
                logger.debug((Object)("Message was " + string));
                if (string5 != null && string4.equals(string6)) {
                    AgentPeer.this.localAgentClientMap.put(string5, string7);
                }
            } else {
                logger.debug((Object)("Unhandled message was: " + string));
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (!this.NAMED) {
                this.NAMED = true;
                Thread.currentThread().setName("MulticastWorker Thread");
            }
            if (AgentPeer.access$1900(AgentPeer.this) == null) {
                AgentPeer.access$200().debug((Object)"MulticastSocket is not available, MulticastWorker is exiting.");
                return;
            }
            var1_1 = 0;
            while (true) {
                try {
                    while (true) {
                        var2_2 = AgentPeer.access$1900(AgentPeer.this).receive();
                        var1_1 = 0;
                        var3_5 = var2_2.getDestination();
                        if (var3_5 == null || var3_5.length() == 0) {
                            this.handleBroadcast(var2_2);
                            continue;
                        }
                        AgentPeer.access$200().debug((Object)("Unhandled message: " + var2_2.toString()));
                    }
                }
                catch (RuntimeException var2_3) {
                    AgentPeer.access$200().warn((Object)"Error parsing request via the Multicast socket.", (Throwable)var2_3);
                    continue;
                }
                catch (IOException var2_4) {
                    AgentPeer.access$200().warn((Object)"Multicast socket I/O problem.", (Throwable)var2_4);
                    if (++var1_1 > 2) ** break;
                    continue;
                    AgentPeer.access$200().error((Object)"Due to several Multicast I/O problems,  the MulticastListener is exiting.");
                    return;
                }
                break;
            }
        }
    }

    private class AgentConnector
    implements Runnable {
        private static final String SKYBOT_SERVER = "Automate Schedule Server";
        public boolean NAMED = false;

        private AgentConnector() {
        }

        public void doConnect() throws PeerConnectException {
            PeerDescriptor peerDescriptor = AgentPeer.this.getAgentConfig().getMaster();
            if (peerDescriptor == null) {
                return;
            }
            if (peerDescriptor.getType() == 0 && (AgentPeer.this.isStandby() || AgentPeer.this.isClient())) {
                peerDescriptor.setType(6);
            }
            if (!peerDescriptor.isValid()) {
                return;
            }
            if (AgentPeer.this.getConnectedAgentServer() != null) {
                return;
            }
            AgentCredentials agentCredentials = null;
            String string = null;
            if (AgentPeer.this.isClient() || AgentPeer.this.isStandby()) {
                AgentCredentials agentCredentials2 = new AgentCredentials();
                agentCredentials2.setSchentRelMod(AgentPeer.this.getRelMod());
                agentCredentials2.loadDefaultAgentSpecifiedName();
                String string2 = AgentPeer.this.getAgentConfig().getSpecifiedAgentName();
                if (string2 != null && string2.trim().length() > 0) {
                    agentCredentials2.setAgentSpecifiedName(string2);
                }
                AgentPeer.this.fixWindowsBitDepth(agentCredentials2);
                agentCredentials = agentCredentials2;
                string = SKYBOT_SERVER;
            }
            AgentPeer.this.connectToPeer(peerDescriptor, (Serializable)((Object)agentCredentials));
            logger.info((Object)("Connected to " + string + " " + peerDescriptor));
            AgentPeer.this.firstMasterConnectFailure = true;
            AgentPeer.this.firstStandbyConnectFailure = true;
        }

        @Override
        public synchronized void run() {
            block18: {
                try {
                    if (!this.NAMED) {
                        String string = null;
                        string = SKYBOT_SERVER;
                        this.NAMED = true;
                        Thread.currentThread().setName(string + " Connection Thread");
                    } else {
                        Thread.currentThread().setName("Unnamed Connection Thread");
                    }
                    try {
                        this.doConnect();
                    }
                    catch (PeerRedirectException peerRedirectException) {
                        if (!AgentPeer.this.isClient()) break block18;
                        if (AgentPeer.this.firstMasterConnectFailure) {
                            logger.info((Object)("Unable to connect to server " + AgentPeer.this.getAgentConfig().getMaster()), (Throwable)peerRedirectException);
                        }
                        try {
                            AgentPeer.this.switchServer(peerRedirectException.getMaster(), true);
                            logger.info((Object)("Redirected to master server " + peerRedirectException.getMaster().findPrintableAddress()));
                        }
                        catch (Throwable throwable) {
                            if (AgentPeer.this.firstMasterConnectFailure) {
                                logger.warn((Object)("Unable to redirect to master Server " + peerRedirectException.getMaster().findPrintableAddress()), throwable);
                                AgentPeer.this.firstMasterConnectFailure = false;
                            }
                        }
                    }
                    catch (Exception exception) {
                        PeerDescriptor peerDescriptor;
                        PeerDescriptor peerDescriptor2 = AgentPeer.this.getAgentConfig().getMaster();
                        String string = null;
                        if (AgentPeer.this.isClient() || AgentPeer.this.isStandby()) {
                            string = SKYBOT_SERVER;
                        }
                        if (AgentPeer.this.firstMasterConnectFailure) {
                            logger.info((Object)("Unable to connect to " + string + " " + peerDescriptor2), (Throwable)exception);
                            AgentPeer.this.firstMasterConnectFailure = false;
                            if (AgentPeer.this.isStandby()) {
                                peerDescriptor = AgentPeer.this.getRemotePeerID().getPeerDescriptor();
                                AgentPeer.this.sendEmailMasterIsUnavailable(peerDescriptor, peerDescriptor2);
                            }
                        }
                        if (AgentPeer.this.isStandby()) break block18;
                        AgentConfigAM agentConfigAM = (AgentConfigAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)AgentPeer.this.getRemotePeerID(), (String)"ENTERPRISE.AgentConfigAM");
                        peerDescriptor = agentConfigAM.getStandby();
                        try {
                            if (peerDescriptor != null) {
                                AgentPeer.this.switchServer(peerDescriptor, true);
                            }
                        }
                        catch (Throwable throwable) {
                            if (AgentPeer.this.firstStandbyConnectFailure) {
                                logger.warn((Object)("Unable to connect to Standby Server " + peerDescriptor), throwable);
                                AgentPeer.this.firstStandbyConnectFailure = false;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.warn((Object)"AgentPeer.AgentConnector Connection failed.", throwable);
                }
            }
        }
    }

    public class LocalAgentAMImpl
    extends AbstractManager
    implements LocalAgentAM {
        @Override
        public String shutdown(boolean bl, boolean bl2, String string) throws ActionFailedException {
            int n = 0;
            if (bl2) {
                n = 1;
            }
            return this.shutdown(bl, n, string);
        }

        @Override
        public void loadManagers() throws ActionFailedException {
        }

        @Override
        public String shutdown(final boolean bl, final int n, String string) throws ActionFailedException {
            AgentCommandReply agentCommandReply;
            Object object;
            PeerID peerID;
            Object object2;
            if (string == null) {
                throw new ActionFailedException("Missing shutdown passphrase");
            }
            if (!string.equals(AgentPeer.this.shutdownCommand)) {
                try {
                    AgentPeer.this.writeShutdownCommand();
                }
                catch (IOException iOException) {
                    logger.debug((Object)"Unable to save passphrase file.", (Throwable)iOException);
                }
                throw new ActionFailedException("Invalid shutdown passphrase (" + string + ")");
            }
            AgentPeer.this.prepareShutdownThread(bl, n);
            try {
                object2 = AgentPeer.this.getConnectedAgentServer();
                peerID = AgentPeer.this.getRemotePeerID();
                AgentEndingCommand agentEndingCommand = new AgentEndingCommand();
                object = (AgentCommandAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)object2, (String)"ENTERPRISE.AgentCommandAM");
                agentCommandReply = object.executeCommand((AgentCommand)agentEndingCommand, peerID);
                logger.trace((Object)("Agent disconnecting reply: " + agentCommandReply.getReplyText()));
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error notifying enterprise server of pending disconnection.", throwable);
            }
            object2 = null;
            peerID = (JobExecDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobExecDM");
            int n2 = peerID.listJobs().size();
            if (n2 > 0) {
                object2 = this.getJobCountMessage(n2, bl);
            } else {
                object = AgentPeer.this.getConnectedAgentServer();
                if (object != null) {
                    try {
                        agentCommandReply = (JobCompletionDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)object, (String)"ENTERPRISE.JobCompletionDM");
                        PeerID peerID2 = AgentPeer.this.getRemotePeerID();
                        int n3 = agentCommandReply.countWaitingSockets(peerID2.getHardwareHash(), peerID2.getInstanceIdentifier().toString());
                        if (n3 > 0) {
                            object2 = this.getJobCountMessage(n3, bl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (object2 == null && bl && (object = (AgentEventMonitorAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorAM")).isTransferringData()) {
                object2 = "Shutting down, waiting for Event Monitor data transfer to finish.";
            }
            if (object2 == null) {
                object2 = "Starting shutdown.";
            }
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                System.out.println(AgentPeer.SHUTDOWN_STD_OUT + (String)object2);
                System.out.flush();
            }
            object = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AgentPeer.this.startShutdown(bl, n);
                }
            });
            ((Thread)object).start();
            return object2;
        }

        private String getJobCountMessage(int n, boolean bl) {
            String string = null;
            string = !bl ? (n == 1 ? "Shutting down, one active job will be terminated." : "Shutting down, " + n + " active jobs will be terminated.") : (n == 1 ? "Shutting down, waiting for one active job to finish." : "Shutting down, waiting for " + n + " active jobs to finish.");
            return string;
        }

        @Override
        public String fireManualEvent(String string) throws ActionFailedException {
            AgentEventMonitor[] agentEventMonitorArray;
            String[] stringArray = string.split(" ");
            AgentEventMonitor[] agentEventMonitorArray2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                agentEventMonitorArray = stringArray[i];
                if (i == 0 && "fireevent".equals(agentEventMonitorArray)) continue;
                if (agentEventMonitorArray2 == null) {
                    agentEventMonitorArray2 = agentEventMonitorArray;
                    continue;
                }
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append((String)agentEventMonitorArray);
            }
            AgentEventMonitorAM agentEventMonitorAM = (AgentEventMonitorAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorAM");
            if (agentEventMonitorAM == null) {
                throw new ActionFailedException("Unable to access event information.");
            }
            agentEventMonitorArray = agentEventMonitorAM.getMonitors();
            if (agentEventMonitorArray.length == 0) {
                throw new ActionFailedException("No event monitors present.");
            }
            if (agentEventMonitorArray2 == null || agentEventMonitorArray2.length() == 0) {
                throw new ActionFailedException("Event Name missing from request.");
            }
            for (AgentEventMonitor agentEventMonitor : agentEventMonitorArray) {
                if (!agentEventMonitorArray2.equals(agentEventMonitor.getName())) continue;
                if (agentEventMonitor.getType() != 0) {
                    throw new ActionFailedException((String)agentEventMonitorArray2 + " is not a manual event.");
                }
                if (agentEventMonitor.getDisabled()) {
                    throw new ActionFailedException((String)agentEventMonitorArray2 + " is currently disabled.");
                }
                agentEventMonitorAM.fireEvent(agentEventMonitor, '*', stringBuilder.toString());
                if (AgentPeer.this.getConnectedAgentServer() == null) {
                    return "Event " + (String)agentEventMonitorArray2 + " enqueued.";
                }
                return "Event " + (String)agentEventMonitorArray2 + " sent.";
            }
            throw new ActionFailedException("Event Monitor '" + (String)agentEventMonitorArray2 + "' not present.  Verify spelling.  Names are case-sensitive.");
        }

        @Override
        public String saveDiagnostics() throws ActionFailedException {
            FileWriter fileWriter = null;
            String string = AgentPeer.this.getRemotePeerID().getInstanceIdentifier() + "_" + System.currentTimeMillis() + "_log.html";
            string = string.replaceAll(":", "-");
            if (AgentControl.isWindows()) {
                string = DefaultConfigPath.getDefaultPath() + File.separator + string;
            }
            String string2 = null;
            try {
                fileWriter = new FileWriter(string);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                for (int i = 0; i < ALL_SECTIONS.length; ++i) {
                    printWriter.println(AgentPeer.this.getHtmlSection(ALL_SECTIONS[i]));
                }
                printWriter.close();
                string2 = "Writing diagnostic info to file " + string;
            }
            catch (Exception exception) {
                string2 = "Unable to write diagnostic info to the file " + string;
                logger.debug((Object)string2, (Throwable)exception);
                throw new ActionFailedException(string2, (Throwable)exception);
            }
            finally {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }

        @Override
        public AgentCommandReply executeAgentCommand(AgentCommand agentCommand) throws ActionFailedException {
            AgentCommandProcessor agentCommandProcessor = new AgentCommandProcessor();
            return agentCommandProcessor.execute(AgentPeer.this, agentCommand);
        }
    }

    public class LocalAgentTranslationDMImpl
    extends AbstractManager
    implements TranslationDM {
        private TranslationDM serverDM;

        public LocalAgentTranslationDMImpl() {
            this.setName("ENTERPRISE.TranslationDM");
            AgentPeer.this.addListener((SimpleEventListener)new PeerEventListener(){

                protected void peerConnected(PeerID peerID, PeerID peerID2) {
                    PeerID peerID3 = AgentPeer.this.getConnectedAgentServer();
                    LocalAgentTranslationDMImpl.this.serverDM = (TranslationDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID3, (String)"ENTERPRISE.TranslationDM");
                }

                protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
                    LocalAgentTranslationDMImpl.this.serverDM = null;
                }
            });
        }

        public String getAuditFileTranslation(String string) {
            if (this.serverDM == null) {
                throw new ManagerNotFoundException("Agent is not connected to server.");
            }
            return this.serverDM.getAuditFileTranslation(string);
        }

        public String getTranslation(String string) {
            if (this.serverDM == null) {
                throw new ManagerNotFoundException("Agent is not connected to server.");
            }
            return this.serverDM.getTranslation(string);
        }
    }

    private static enum OSType {
        OS_UNKNOWN(ArchType.access$000(ArchType.ARCH_UNKNOWN), 0, 0),
        OS_WIN(ArchType.access$000(ArchType.ARCH_86), 1, 1),
        OS_MAC(ArchType.access$000(ArchType.ARCH_86), 1, 1),
        OS_LINUX(-2735, 2, 2),
        OS_SOLARIS(ArchType.access$000(ArchType.ARCH_SPARC), 3, 3),
        OS_UNIX(-314, 3, 3),
        OS_AIX(ArchType.access$000(ArchType.ARCH_PPC), 3, 3),
        OS_HP_UX(ArchType.access$000(ArchType.ARCH_ITANIUM), 3, 3),
        OS_400(-1225, 4, 4);

        private int value;
        private int versionOneWeight;
        private int versionTwoWeight;
        private static HashMap<Integer, OSType> map;

        private OSType(int n2, int n3, int n4) {
            this.value = n2;
            this.versionOneWeight = n3;
            this.versionTwoWeight = n4;
        }

        public static OSType valueOf(int n) {
            return map.get(n);
        }

        public static int getWeightForVersion(AgentLicenseVersion agentLicenseVersion, OSType oSType) {
            switch (agentLicenseVersion) {
                case ONE: {
                    return oSType.versionOneWeight;
                }
            }
            return OSType.OS_UNKNOWN.versionOneWeight;
        }

        static {
            map = new HashMap();
            OSType[] oSTypeArray = OSType.values();
            for (int i = 0; i < oSTypeArray.length; ++i) {
                map.put(oSTypeArray[i].value, oSTypeArray[i]);
            }
        }
    }

    private static enum ArchType {
        ARCH_UNKNOWN(-325, 0, 0),
        ARCH_86(-727, 1, 1),
        ARCH_PPC(-816, 1, 1),
        ARCH_SPARC(-429, 1, 1),
        ARCH_ITANIUM(-862, 1, 1),
        ARCH_PA_RISC(-1063, 1, 1),
        ARCH_S390(-1701, 1, 1);

        private int value;
        private int versionOneWeight;
        private int versionTwoWeight;
        private static HashMap<Integer, ArchType> map;

        private ArchType(int n2, int n3, int n4) {
            this.value = n2;
            this.versionOneWeight = n3;
            this.versionTwoWeight = n4;
        }

        public static ArchType valueOf(int n) {
            return map.get(n);
        }

        public static int getWeightForVersion(AgentLicenseVersion agentLicenseVersion, ArchType archType) {
            switch (agentLicenseVersion) {
                case ONE: {
                    return archType.versionOneWeight;
                }
            }
            return ArchType.ARCH_UNKNOWN.versionOneWeight;
        }

        static {
            map = new HashMap();
            ArchType[] archTypeArray = ArchType.values();
            for (int i = 0; i < archTypeArray.length; ++i) {
                map.put(archTypeArray[i].value, archTypeArray[i]);
            }
        }
    }
}

