/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.AgentConditionHelperAM;
import com.helpsystems.enterprise.core.dm.AgentConditionsAM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import org.apache.log4j.Logger;

public class AgentConditionsAMImpl
extends AbstractManager
implements AgentConditionsAM {
    private static final Logger logger = Logger.getLogger(AgentConditionsAMImpl.class);
    private int fail_counter = 0;
    private PeerID connectedAgent = null;
    private int state = 0;
    private AgentConditionHelperAM ach = null;

    public AgentConditionsAMImpl() {
        this.setName("ENTERPRISE.AgentConditionsAM");
        this.state = 0;
    }

    public void setConnectedAgentPeerID(PeerID peerID) {
        this.connectedAgent = peerID;
        this.ach = (AgentConditionHelperAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentConditionHelperAM");
    }

    public int getCurrentState() {
        if (this.state == 0) {
            return this.state + this.fail_counter;
        }
        return this.state;
    }

    public boolean processJobConditions(long l, long l2) {
        if (this.connectedAgent == null) {
            this.writeln("Unable to process job conditions; we aren't connected to an Agent.");
            return false;
        }
        if (logger.isTraceEnabled()) {
            this.writeln("Starting Process Job Conditions...");
        }
        ScheduleJob scheduleJob = null;
        try {
            scheduleJob = this.ach.getScheduleJob(l);
        }
        catch (Exception exception) {
            this.writeln("Unable to find the ScheduleJob with the job number " + l + ".", exception);
            return false;
        }
        if (logger.isTraceEnabled()) {
            this.writeln("Processing Job Conditions for Job Name " + scheduleJob.getName() + ".");
        }
        return true;
    }

    private void writeln(String string, Throwable throwable) {
        System.out.println(string);
        throwable.printStackTrace(System.out);
        logger.debug((Object)string, throwable);
    }

    private void writeln(String string) {
        System.out.println(string);
        logger.debug((Object)string);
    }
}

