/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.server;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.UserIdentityDM;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class UserIdentityDMJdbc
extends AbstractHelpingDatabaseManager
implements UserIdentityDM {
    private static final Logger logger = Logger.getLogger(UserIdentityDMJdbc.class);
    private static final String TABLE_PLACEHOLDER = "__TABLE__";
    private static final String PREFIX_PLACEHOLDER = "__FIELD__";
    private static final String BASE_XML = "<database-mappings><association class=\"com.helpsystems.common.core.busobj.UserIdentity\" table=\"__TABLE__\"><mapping field=\"__FIELD__OID\" method=\"setOID\" type=\"int\" pk=\"true\" autoincrement=\"true\"/><mapping field=\"__FIELD__OWN\" method=\"setParentOID\" type=\"int\"/><mapping field=\"__FIELD__SYS\" method=\"setSystem\" type=\"String\"/><mapping field=\"__FIELD__XNM\" method=\"setName\" type=\"String\"/><mapping field=\"__FIELD__XPW\" method=\"setEncryptedPassword\" type=\"String\"/><mapping field=\"__FIELD__FLAG\" method=\"setFlags\" type=\"int\"/><mapping field=\"__FIELD__WHEN\" method=\"setWhenSaved\" type=\"long\"/></association></database-mappings>";
    private String library;
    private String tableName;
    private String columnPrefix;

    public UserIdentityDMJdbc(String string, String string2, String string3, String string4) throws ResourceUnavailableException {
        super(string, string2, UserIdentityDMJdbc.createHelper(string3, string4));
        this.library = string2;
        this.tableName = string3;
        this.columnPrefix = string4;
    }

    private static SQLManagerHelper createHelper(String string, String string2) throws ResourceUnavailableException {
        String string3 = BASE_XML.replaceAll(TABLE_PLACEHOLDER, string).replaceAll(PREFIX_PLACEHOLDER, string2);
        logger.trace((Object)("Generated XML is: " + string3));
        try {
            Document document = XMLUtil.stringToDocument((String)string3);
            SQLManagerHelper sQLManagerHelper = new SQLManagerHelper(document);
            return sQLManagerHelper;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to prepare a SQL Helper.", (Throwable)exception);
        }
    }

    public void delete(UserIdentity userIdentity) throws ResourceUnavailableException, DataException {
        super.delete(userIdentity);
        this.purge(userIdentity, Long.MAX_VALUE);
    }

    private void purge(UserIdentity userIdentity, long l) throws ResourceUnavailableException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.gatherOIDs(userIdentity, arrayList);
        String[] stringArray = new String[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().toString();
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        stringBuffer.append(this.library);
        stringBuffer.append(".");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" where ");
        stringBuffer.append(this.columnPrefix);
        stringBuffer.append("WHEN < ");
        stringBuffer.append(l);
        stringBuffer.append(" and ");
        stringBuffer.append(this.columnPrefix);
        stringBuffer.append("OWN in (");
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(")");
        logger.trace((Object)("Purge SQL is: " + stringBuffer.toString()));
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(stringBuffer.toString());
            for (n = 0; n < stringArray.length; ++n) {
                logger.trace((Object)("Setting parameter " + (n + 1) + " = " + stringArray[n]));
                preparedStatement.setString(n + 1, stringArray[n]);
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to purge records", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                UserIdentityDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        UserIdentityDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
    }

    private void fillIdentities(UserIdentity userIdentity) throws ResourceUnavailableException, DataException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("getParentOID", Integer.valueOf(userIdentity.getOID()));
        UserIdentity[] userIdentityArray = (UserIdentity[])super.search((Object)new UserIdentity(), hashMap);
        for (int i = 0; i < userIdentityArray.length; ++i) {
            userIdentity.addIdentity(userIdentityArray[i]);
            this.fillIdentities(userIdentityArray[i]);
        }
    }

    public UserIdentity getIdentity(String string) throws ResourceUnavailableException, DataException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("getName", (Serializable)((Object)string));
        hashMap.put("getParentOID", Integer.valueOf(-1));
        UserIdentity[] userIdentityArray = (UserIdentity[])super.search((Object)new UserIdentity(), hashMap);
        if (userIdentityArray.length == 0) {
            return null;
        }
        UserIdentity userIdentity = userIdentityArray[0];
        this.fillIdentities(userIdentity);
        return userIdentity;
    }

    public void save(UserIdentity userIdentity) throws ResourceUnavailableException, DataException {
        ValidationHelper.checkForNull((String)"UserIdentity", (Object)userIdentity);
        long l = System.currentTimeMillis();
        this.updateTimestamp(userIdentity, l);
        this.recursiveSave(userIdentity);
        this.purge(userIdentity, l);
    }

    private void recursiveSave(UserIdentity userIdentity) throws ResourceUnavailableException, DataException {
        super.save(userIdentity);
        UserIdentity[] userIdentityArray = userIdentity.getIdentities();
        for (int i = 0; i < userIdentityArray.length; ++i) {
            this.recursiveSave(userIdentityArray[i]);
        }
    }

    private void gatherOIDs(UserIdentity userIdentity, List<String> list) {
        list.add(String.valueOf(userIdentity.getOID()));
        UserIdentity[] userIdentityArray = userIdentity.getIdentities();
        for (int i = 0; i < userIdentityArray.length; ++i) {
            this.gatherOIDs(userIdentityArray[i], list);
        }
    }

    private void updateTimestamp(UserIdentity userIdentity, long l) {
        userIdentity.setWhenSaved(l);
        UserIdentity[] userIdentityArray = userIdentity.getIdentities();
        for (int i = 0; i < userIdentityArray.length; ++i) {
            this.updateTimestamp(userIdentityArray[i], l);
        }
    }
}

