/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class AbstractBusObjGenerator
implements BusinessObjectGenerator {
    private static final Logger logger = Logger.getLogger(AbstractBusObjGenerator.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)AbstractBusObjGenerator.class.getName());
    private int nbrOfPasses;
    private String busObjName;

    public AbstractBusObjGenerator(int n, String string) {
        this.nbrOfPasses = n;
        this.busObjName = string;
    }

    public Object generateObject(ResultSet resultSet) throws BadDataException, SQLException, ResourceUnavailableException {
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        if (resultSet == null) {
            throw new NullPointerException("Result set may not be null.");
        }
        Object object = this.constructObject();
        if (object == null) {
            throw new NullPointerException("Business object may not be null.");
        }
        for (int i = 1; i <= this.nbrOfPasses; ++i) {
            try {
                this.getDataFromRS(resultSet, object, i);
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Error loading business object.", (Throwable)runtimeException);
                }
                exceptionErrorList.addException((Exception)runtimeException);
                if (!(runtimeException.getCause() instanceof BadDataException)) continue;
                BadDataException badDataException = (BadDataException)runtimeException.getCause();
                exceptionErrorList.addException((Exception)badDataException);
            }
        }
        try {
            this.validate(object);
        }
        catch (RuntimeException runtimeException) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Error validating business object.", (Throwable)runtimeException);
            }
            exceptionErrorList.addException((Exception)runtimeException);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            throw new BadDataException(rbh.getMsg("error_restore", (Object)this.busObjName), object, (ErrorList)exceptionErrorList);
        }
        return object;
    }

    public Object[] generateObjectArray(ResultSet resultSet) throws BadDataArrayException, SQLException, ResourceUnavailableException {
        ErrorTable errorTable = new ErrorTable();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (resultSet.next()) {
            try {
                arrayList.add(this.generateObject(resultSet));
                ++n;
            }
            catch (BadDataException badDataException) {
                arrayList.add(badDataException.getLoadedObject());
                errorTable.addException(n, (Exception)((Object)badDataException));
            }
        }
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("Errors occurred while generating business object array: " + this.busObjName, arrayList.toArray(), errorTable);
        }
        Object[] objectArray = (Object[])Array.newInstance(this.constructObject().getClass(), 0);
        return arrayList.toArray(objectArray);
    }

    protected abstract void getDataFromRS(ResultSet var1, Object var2, int var3) throws SQLException, ResourceUnavailableException;

    protected abstract Object constructObject();

    protected void validate(Object object) {
    }
}

