"use strict";

const axios = require('axios');
/**
 * Decrements the value of a specific metric group.
 *
 * The group (optional) is useful when you need to compute a graph taking into account multiple variables.
 * For example, you could count the gender ratio by incrementing:
 *
 * Male -> `metric = gender` and `group = male`
 *
 * Female -> `metric = gender` and `group = female`
 *
 * @title Increment Metric
 * @category Analytics
 * @param {string} name The name of the metric
 * @param {string} [group=all] Optional group inside the metrics
 * @param {Number} [increment=1] The optional increment of the metric
 */


const increment = async (name, group, increment = 1) => {
  const axiosConfig = await bp.http.getAxiosConfigForBot(event.botId);
  await axios.post('/mod/analytics/custom_metrics/increment', {
    name: `${name}~${group}`,
    count: increment
  }, axiosConfig);
};

return increment(args.name, args.group, args.count);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluY3JlbWVudC5qcyJdLCJuYW1lcyI6WyJheGlvcyIsInJlcXVpcmUiLCJpbmNyZW1lbnQiLCJuYW1lIiwiZ3JvdXAiLCJheGlvc0NvbmZpZyIsImJwIiwiaHR0cCIsImdldEF4aW9zQ29uZmlnRm9yQm90IiwiZXZlbnQiLCJib3RJZCIsInBvc3QiLCJjb3VudCIsImFyZ3MiXSwibWFwcGluZ3MiOiI7O0FBQUEsTUFBTUEsS0FBSyxHQUFHQyxPQUFPLENBQUMsT0FBRCxDQUFyQjtBQUVBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFnQkEsTUFBTUMsU0FBUyxHQUFHLE9BQU9DLElBQVAsRUFBYUMsS0FBYixFQUFvQkYsU0FBUyxHQUFHLENBQWhDLEtBQXNDO0FBQ3RELFFBQU1HLFdBQVcsR0FBRyxNQUFNQyxFQUFFLENBQUNDLElBQUgsQ0FBUUMsb0JBQVIsQ0FBNkJDLEtBQUssQ0FBQ0MsS0FBbkMsQ0FBMUI7QUFDQSxRQUFNVixLQUFLLENBQUNXLElBQU4sQ0FDSix5Q0FESSxFQUVKO0FBQUVSLElBQUFBLElBQUksRUFBRyxHQUFFQSxJQUFLLElBQUdDLEtBQU0sRUFBekI7QUFBNEJRLElBQUFBLEtBQUssRUFBRVY7QUFBbkMsR0FGSSxFQUdKRyxXQUhJLENBQU47QUFLRCxDQVBEOztBQVNBLE9BQU9ILFNBQVMsQ0FBQ1csSUFBSSxDQUFDVixJQUFOLEVBQVlVLElBQUksQ0FBQ1QsS0FBakIsRUFBd0JTLElBQUksQ0FBQ0QsS0FBN0IsQ0FBaEIiLCJzb3VyY2VSb290IjoiL3Zhci9saWIvamVua2lucy93b3Jrc3BhY2UvYnVpbGQtbGludXgvbW9kdWxlcy9hbmFseXRpY3Mvc3JjL2JhY2tlbmQiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBheGlvcyA9IHJlcXVpcmUoJ2F4aW9zJylcblxuLyoqXG4gKiBEZWNyZW1lbnRzIHRoZSB2YWx1ZSBvZiBhIHNwZWNpZmljIG1ldHJpYyBncm91cC5cbiAqXG4gKiBUaGUgZ3JvdXAgKG9wdGlvbmFsKSBpcyB1c2VmdWwgd2hlbiB5b3UgbmVlZCB0byBjb21wdXRlIGEgZ3JhcGggdGFraW5nIGludG8gYWNjb3VudCBtdWx0aXBsZSB2YXJpYWJsZXMuXG4gKiBGb3IgZXhhbXBsZSwgeW91IGNvdWxkIGNvdW50IHRoZSBnZW5kZXIgcmF0aW8gYnkgaW5jcmVtZW50aW5nOlxuICpcbiAqIE1hbGUgLT4gYG1ldHJpYyA9IGdlbmRlcmAgYW5kIGBncm91cCA9IG1hbGVgXG4gKlxuICogRmVtYWxlIC0+IGBtZXRyaWMgPSBnZW5kZXJgIGFuZCBgZ3JvdXAgPSBmZW1hbGVgXG4gKlxuICogQHRpdGxlIEluY3JlbWVudCBNZXRyaWNcbiAqIEBjYXRlZ29yeSBBbmFseXRpY3NcbiAqIEBwYXJhbSB7c3RyaW5nfSBuYW1lIFRoZSBuYW1lIG9mIHRoZSBtZXRyaWNcbiAqIEBwYXJhbSB7c3RyaW5nfSBbZ3JvdXA9YWxsXSBPcHRpb25hbCBncm91cCBpbnNpZGUgdGhlIG1ldHJpY3NcbiAqIEBwYXJhbSB7TnVtYmVyfSBbaW5jcmVtZW50PTFdIFRoZSBvcHRpb25hbCBpbmNyZW1lbnQgb2YgdGhlIG1ldHJpY1xuICovXG5jb25zdCBpbmNyZW1lbnQgPSBhc3luYyAobmFtZSwgZ3JvdXAsIGluY3JlbWVudCA9IDEpID0+IHtcbiAgY29uc3QgYXhpb3NDb25maWcgPSBhd2FpdCBicC5odHRwLmdldEF4aW9zQ29uZmlnRm9yQm90KGV2ZW50LmJvdElkKVxuICBhd2FpdCBheGlvcy5wb3N0KFxuICAgICcvbW9kL2FuYWx5dGljcy9jdXN0b21fbWV0cmljcy9pbmNyZW1lbnQnLFxuICAgIHsgbmFtZTogYCR7bmFtZX1+JHtncm91cH1gLCBjb3VudDogaW5jcmVtZW50IH0sXG4gICAgYXhpb3NDb25maWdcbiAgKVxufVxuXG5yZXR1cm4gaW5jcmVtZW50KGFyZ3MubmFtZSwgYXJncy5ncm91cCwgYXJncy5jb3VudClcbiJdfQ==