"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FastTextLanguageId = void 0;

var _path = require("path");

var _fs = require("fs");

var _tmp = _interopRequireDefault(require("tmp"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const PRETRAINED_LID_176 = (0, _path.join)(__dirname, '../../tools/pretrained/lid.176.ftz');

class FastTextLanguageId {
  constructor(toolkit, logger) {
    this.toolkit = toolkit;
    this.logger = logger;
    FastTextLanguageId.toolkit = toolkit;
  }

  static async initializeModel() {
    const tmpFn = _tmp.default.tmpNameSync({
      postfix: '.ftz'
    });

    const modelBuff = (0, _fs.readFileSync)(PRETRAINED_LID_176);
    (0, _fs.writeFileSync)(tmpFn, modelBuff);
    const ft = new FastTextLanguageId.toolkit.FastText.Model();
    await ft.loadFromFile(tmpFn);
    FastTextLanguageId.model = ft;
  }

  async identify(text) {
    if (!FastTextLanguageId.model) {
      await FastTextLanguageId.initializeModel();
    }

    if (!FastTextLanguageId.model) {
      return 'n/a';
    }

    const res = await FastTextLanguageId.model.predict(text, 1);
    return res.length ? res[0].label.replace('__label__', '') : 'n/a';
  }

}

exports.FastTextLanguageId = FastTextLanguageId;

_defineProperty(FastTextLanguageId, "model", void 0);

_defineProperty(FastTextLanguageId, "toolkit", void 0);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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