"use strict";

var _utils = require("./utils");

describe('NLU intent utils', () => {
  test('findMostConfidentIntentMeanStd', () => {
    const mapSet = n => n.map((x, i) => ({
      confidence: x,
      name: i.toString(),
      context: 'global'
    }));

    const set1 = mapSet([0.8, 0.1, 0.09, 0.08]);
    const set2 = mapSet([0.8, 0.7]);
    const set3 = mapSet([]);
    const set4 = mapSet([0.45, 0.12, 0.11, 0.08, 0.0002]);
    const set5 = mapSet([0.2, 0.12, 0.11, 0.08, 0.0002]);
    const set6 = mapSet([0.2, 0.1, 0.08, 0.6]);
    const set7 = mapSet([0.28, 0.22, 0.14, 0.12]);
    const set8 = mapSet([0.8]);
    const set9 = mapSet([0.6]);
    const set10 = mapSet([0.2, 0.1]);
    const set11 = mapSet([0.45, 0.1, 0.05, 0.05, 0.0002, 0.0002, 0.0002, 0.0002, 0.0002, 0.0002, 0.0002]);
    const set12 = mapSet([0.65, 0.32, 0.01, 0.0059, 0.0007]);
    const res1 = (0, _utils.findMostConfidentIntentMeanStd)(set1, 0.8);
    const res2 = (0, _utils.findMostConfidentIntentMeanStd)(set2, 0.8);
    const res3 = (0, _utils.findMostConfidentIntentMeanStd)(set3, 0.8);
    const res4 = (0, _utils.findMostConfidentIntentMeanStd)(set4, 0.8);
    const res5 = (0, _utils.findMostConfidentIntentMeanStd)(set5, 0.8);
    const res6 = (0, _utils.findMostConfidentIntentMeanStd)(set6, 0.8);
    const res7 = (0, _utils.findMostConfidentIntentMeanStd)(set7, 0.8);
    const res8 = (0, _utils.findMostConfidentIntentMeanStd)(set8, 0.8);
    const res9 = (0, _utils.findMostConfidentIntentMeanStd)(set9, 0.8);
    const res10 = (0, _utils.findMostConfidentIntentMeanStd)(set10, 0.8);
    const res11 = (0, _utils.findMostConfidentIntentMeanStd)(set11, 0.8);
    const res12 = (0, _utils.findMostConfidentIntentMeanStd)(set12, 0.8);
    expect(res1.name).toBe('0');
    expect(res2.name).toBe('0');
    expect(res3.name).toBe('none');
    expect(res4.name).toBe('0');
    expect(res5.name).toBe('none');
    expect(res6.name).toBe('3');
    expect(res7.name).toBe('none');
    expect(res8.name).toBe('0');
    expect(res9.name).toBe('none');
    expect(res10.name).toBe('none');
    expect(res11.name).toBe('0');
    expect(res12.name).toBe('0');
  });
  describe('matches', () => {
    test('Exact match', () => {
      const matches = (0, _utils.createIntentMatcher)('faq.hello');
      expect(matches('faq.hello')).toBe(true);
      expect(matches('faq.hello2')).toBe(false);
      expect(matches('faq.hell')).toBe(false);
      expect(matches('faq_hello')).toBe(false);
    });
    test('Wildcard ending', () => {
      const matches = (0, _utils.createIntentMatcher)('faq.hello');
      expect(matches('faq.hell*')).toBe(true);
      expect(matches('faq.h*')).toBe(true);
      expect(matches('faq.q*')).toBe(false);
      expect(matches('faq.hello*')).toBe(false);
      expect(matches('*')).toBe(true);
      expect(matches('faq.faq.h*')).toBe(false);
    });
    test('Wildcard starting', () => {
      const matches = (0, _utils.createIntentMatcher)('faq.hello');
      expect(matches('*.hello')).toBe(true);
      expect(matches('*aq.hello')).toBe(true);
      expect(matches('*.nope')).toBe(false);
    });
    test('Wildcard both', () => {
      const matches = (0, _utils.createIntentMatcher)('faq.hello');
      expect(matches('*.*')).toBe(true);
      expect(matches('*aq.hell*')).toBe(true);
      expect(matches('*.nope*')).toBe(false);
    });
    test('Escaping', () => {
      const matches = (0, _utils.createIntentMatcher)('faq.hello');
      expect(matches('.+')).toBe(false);
    });
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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