"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _telegraf = _interopRequireDefault(require("telegraf"));

var _client = require("./client");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const clients = {};

const onServerReady = async bp => {};

const onServerStarted = async bp => {
  (0, _client.setupMiddleware)(bp, clients);
};

const onBotMount = async (bp, botId) => {
  const config = await bp.config.getModuleConfigForBot('channel-telegram', botId);

  if (config.enabled) {
    const bot = new _telegraf.default(config.botToken);
    clients[botId] = bot;
    bot.startPolling();
    await (0, _client.setupBot)(bp, botId, clients);
  }
};

const onBotUnmount = async (bp, botId) => {
  const client = clients[botId];

  if (!client) {
    return;
  }

  client.stop();
  delete clients[botId];
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('telegram.sendMessages');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  definition: {
    name: 'channel-telegram',
    menuIcon: 'none',
    // no interface = true
    fullName: 'Telegram',
    homepage: 'https://botpress.io',
    noInterface: true,
    plugins: []
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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